/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_ABSTRACTCOMMAND
#define __GLIB_ABSTRACTCOMMAND

#include "glib/resource/GAbstractResource.h"

/**
 * Parent class of several types of command items, such as a menu items,
 * accelerator keys, toolbar buttons, etc.
 *
 * @author  Leif Erik Larsen
 * @since   1999.09.13
 */
class GAbstractCommand : public GAbstractResource
{
   private:

      /**
       * String of program defined user data #1.
       */
      GString userData1;

   public:

      /**
       * Initiate a new abstract command object, with the specified
       * command ID string and, optionally, a user data string.
       *
       * @param  id        The ID string of the command.
       * @param  userData1 The command user data. The meaning of this string
       *                   is application dependent. For the most commands
       *                   this string is not used at all.
       */
      explicit GAbstractCommand ( const GString& id, const GString& userData1 = GString::Empty );
      virtual ~GAbstractCommand ();

   protected:

      /**
       * Initiate a new abstract command object, with an empty
       * command ID string and no initial user data.
       */
      GAbstractCommand ();

   public:

      /**
       * Get a reference to the user data string of the command.
       */
      const GString& getUserData1 () const;

      /**
       * Set the user data string of the command.
       *
       * The meaning of the user data string is application dependent.
       * For the most commands this string is not used at all.
       */
      void setUserData1 ( const GString& data );

      /**
       * Dummy method, does nothing but return.
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @param   tokenizer   The tokenizer of where to get tokens to parse.
       * @throws  GRcException in case of any error.
       */
      virtual void loadFromScript ( class GRcTokenizer& tokenizer, class GResourceTable* table ) {}
};

#endif


