/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_DIALOGMESSAGE
#define __GLIB_DIALOGMESSAGE

#include "glib/gui/event/GUserMessage.h"
#include "glib/gui/event/GDialogMessageHandler.h"

/**
 * This class is used when sending or posting a message to a user defined
 * message handler.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.26
 * @see     GDialogMessageHandler
 */
class GDialogMessage : public GUserMessage
{
   private:

      GDialogMessageHandler::MessageID id;
      class GDialogPanel& dlg;

   public:

      GDialogMessage ( class GDialogPanel& dlg, 
                       GDialogMessageHandler::MessageID id, 
                       GObject* param1 = null, 
                       GObject* param2 = null );

      GDialogMessage ( class GDialogPanel& dlg, 
                       GDialogMessageHandler::MessageID id, 
                       const GString& str1, 
                       GObject* param2 = null );

      GDialogMessage ( class GDialogPanel& dlg, 
                       GDialogMessageHandler::MessageID id, 
                       const GString& str1, 
                       const GString& str2 );

      virtual ~GDialogMessage ();

   private:

      // Prevent any attempt to copy.
      GDialogMessage ( const GDialogMessage& src ) : dlg(src.dlg) {}

      // Prevent any attempt to assign.
      GDialogMessage& operator= ( const GDialogMessage& ) { return *this; }

   public:

      GDialogMessageHandler::MessageID getID () const;
      class GDialogPanel& getDialog ();

      /**
       * Return a string representation of the user message object
       * that can be used in debug logging, etc.
       *
       * @author  Leif Erik Larsen
       * @since   2001.04.02
       */
      GString toString () const;
};

#endif

