/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/layout/GCenterLayout.h"
#include "glib/gui/GWindow.h"
#include "glib/primitives/GInsets.h"

GCenterLayout::GCenterLayout ()
{
}

GCenterLayout::~GCenterLayout ()
{
}

GDimension GCenterLayout::preferredLayoutSize ( GWindow& parent )
{
   int w = preferredLayoutWidth(parent);
   int h = preferredLayoutHeight(parent);
   return GDimension(w, h);
}

int GCenterLayout::preferredLayoutWidth ( GWindow& parent )
{
   if (parent.getChildWindowCount() <= 0)
      return 0; // There are no children to layout.
   GWindow& child = parent.getChildWindow(0);
   return child.getPreferredWidth();
}

int GCenterLayout::preferredLayoutHeight ( GWindow& parent )
{
   if (parent.getChildWindowCount() <= 0)
      return 0; // There are no children to layout.
   GWindow& child = parent.getChildWindow(0);
   return child.getPreferredHeight();
}

void GCenterLayout::layoutWindow ( GWindow& parent )
{
   if (parent.getChildWindowCount() <= 0)
      return; // There are no children to layout.
   GDimension dim = parent.getWindowSize();
   GWindow& child = parent.getChildWindow(0);
   const GInsets& ins = parent.getInsets();
   child.setWindowPos(ins.left, ins.bottom);
   child.setWindowSize(dim.width - (ins.left + ins.right), dim.height - (ins.top + ins.bottom));
}

