/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <ctype.h>
#include "glib/primitives/GCharacter.h"
#include "glib/primitives/GString.h"

GCharacter::~GCharacter ()
{
}

bool GCharacter::isUnsigned () const
{
   // Instead of fumble with different compiler options and macros
   // on different platforms, do a logical test that is safe and 
   // robust on all known compilers and platforms. Even if this 
   // means a fraction of more CPU cycles.
   char test = char(0);
   test -= 1;
   return test > 0;
}

int GCharacter::Digit ( char ch )
{
   if (ch >= '0' && ch <= '9')
      return ch - '0';
   else
      return toupper(ch) - 'A' + 10;
}

GString GCharacter::toString () const
{
   return GString(value);
}

GString GCharacter::ToString ( char chr )
{
   GString ret(1);
   ret += chr;
   return ret;
}

bool GCharacter::IsDigit ( char ch ) 
{ 
   return isdigit((unsigned char)(ch)) != 0; 
}

bool GCharacter::IsLetter ( char ch ) 
{ 
   return isalpha((unsigned char)(ch)) != 0; 
}

bool GCharacter::IsLetterOrDigit ( char ch ) 
{ 
   return isalnum((unsigned char)(ch)) != 0;
}

bool GCharacter::IsWhiteSpace ( char ch )
{
   return isspace((unsigned char)(ch));
}

char GCharacter::ToLowerCase ( char ch ) 
{ 
   return char(tolower((unsigned char)(ch))); 
}

char GCharacter::ToUpperCase ( char ch ) 
{ 
   return char(toupper((unsigned char)(ch))); 
}

int GCharacter::compareObj ( const GObject& obj ) const
{
   const GNumber* num = dynamic_cast<const GNumber*>(&obj);
   if (num == null)
      return 1; // Don't know how to compare, so return "this < obj".
   if (isUnsigned())
   {
      unsigned int v1 = uintValue();
      unsigned int v2 = num->uintValue();
      if (v1 < v2)
         return -1;
      if (v1 > v2)
         return +1;
      return 0;
   }
   else
   {
      int v1 = intValue();
      int v2 = num->intValue();
      if (v1 < v2)
         return -1;
      if (v1 > v2)
         return +1;
      return 0;
   }
}
