/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_DIMENSION
#define __GLIB_DIMENSION

#include "glib/primitives/GObject.h"

/**
 * Primitive class used to represent the size of a rectangle area, 
 * typically within a window or text area on screen.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.04
 */
class GDimension : public GObject
{
   public:

      int width;
      int height;

   public:

      GDimension ();
      GDimension ( int width, int height );
      GDimension ( const GDimension& dim );
      
      virtual ~GDimension ();

   public:

      GDimension& operator= ( const GDimension& d );

   private:

      GDimension& copyFrom ( const GDimension& dim );

   public:

      GDimension& clear ();

      GDimension& set ( int width, int height );

      /**
       * Return a string representation of the dimension, for debugging
       * purposes only.
       */
      GString toString () const;
};

#endif

