/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <float.h>
#include "glib/primitives/GFloat.h"
#include "glib/primitives/GDouble.h"
#include "glib/exceptions/GNumberFormatException.h"

const float GFloat::MIN_VALUE = FLT_MIN;
const float GFloat::MAX_VALUE = FLT_MAX;

GFloat::~GFloat ()
{
}

int GFloat::hashCode () const
{
   longlong l = longlong(value);
   return int(l ^ (l >> 32));
}

bool GFloat::equals ( const GObject& obj ) const
{
   if (&obj == this)
      return true;
   const GFloat* o = dynamic_cast<const GFloat*>(&obj);
   if (o != null)
      return value == o->value;
   return false;
}

float GFloat::ParseFloat ( const GString& str )
{
   double val = GDouble::ParseDouble(str);
   if (val < GFloat::MIN_VALUE || val > GFloat::MAX_VALUE)
      gthrow_(GNumberFormatException("Range overflow: " + str));
   float ret = float(val);
   return ret;
}

GString GFloat::toString () const
{
   return GFloat::ToString(value);
}

GString GFloat::ToString ( float val )
{
   return GDouble::ToString(val);
}

