/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "glib/primitives/GInteger.h"
#include "glib/primitives/GCharacter.h"

const int GInteger::MIN_VALUE = INT_MIN;
const int GInteger::MAX_VALUE = INT_MAX;

GInteger::GInteger () 
         :value(0) 
{
}

GInteger::GInteger ( const GInteger& val ) 
         :value(val.value) 
{
}

GInteger::GInteger ( int val ) 
         :value(val) 
{
}

GInteger::GInteger ( const char* str, short radix )
         :value(GInteger::ParseInt(str, radix))
{
}

GInteger::~GInteger ()
{
}

int GInteger::hashCode () const
{
   return value;
}

bool GInteger::equals ( const GObject& obj ) const
{
   if (&obj == this)
      return true;
   const GInteger* o = dynamic_cast<const GInteger*>(&obj);
   if (o != null)
      return value == o->value;
   return false;
}

int GInteger::ParseInt ( const GString& str, short radix )
{
   return GIntegerNumber<int>::ParseSigned(str, MIN_VALUE, MAX_VALUE, radix);
}

bool GInteger::IsInteger ( const GString& str, short radix )
{
   try {
      GInteger::ParseInt(str, radix);
      return true;
   } catch (GNumberFormatException& /*e*/) {
      return false;
   }
}

bool GInteger::IsInteger ( const GString& str )
{
   try {
      GInteger::ParseInt(str);
      return true;
   } catch (GNumberFormatException& /*e*/) {
      return false;
   }
}

GString GInteger::toString () const
{
   return GIntegerNumber<int>::ToSignedString(value);
}

GString GInteger::ToString ( int value, short radix, int width, char padChar )
{
   return GIntegerNumber<int>::ToSignedString(value, radix, width, padChar);
}
