/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <limits.h>
#include "glib/primitives/GUShort.h"

const unsigned short GUShort::MIN_VALUE = 0;
const unsigned short GUShort::MAX_VALUE = USHRT_MAX;

GUShort::GUShort () 
        :value(0) 
{
}

GUShort::GUShort ( const GUShort& val ) 
        :value(val.value) 
{
}

GUShort::GUShort ( unsigned short val ) 
        :value(val) 
{
}

GUShort::~GUShort ()
{
}

int GUShort::hashCode () const
{
   return value;
}

bool GUShort::equals ( const GObject& obj ) const
{
   if (&obj == this)
      return true;
   const GUShort* o = dynamic_cast<const GUShort*>(&obj);
   if (o != null)
      return value == o->value;
   return false;
}

unsigned short GUShort::ParseUShort ( const GString& str, short radix )
{
   return GIntegerNumber<unsigned short>::ParseUnsigned(str, MAX_VALUE, radix);
}

GString GUShort::toString () const
{
   return GIntegerNumber<unsigned short>::ToUnsignedString(value);
}

GString GUShort::ToString ( unsigned short value, short radix, int width, char padChar )
{
   return GIntegerNumber<unsigned short>::ToUnsignedString(value, radix, width, padChar);
}
