/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_ACCELITEM
#define __GLIB_ACCELITEM

#include "glib/gui/event/GAbstractCommand.h"
#include "glib/util/GKeyBag.h"

/**
 * Each ACCELERATOR item is represented with an instance of this class.
 */
class GAccelItem : public GAbstractCommand
{
   private:

      /** For example "VK_F1_C_A_S", which means "Ctrl+Alt+Shift+F1". */
      GString keyName;

      /** For example "Ctrl+Alt+Shift+F1", which means "VK_F1_C_A_S". */
      GString keyNameForHumans;

   public:

      /** True if USERDATA parameter was defined. */
      bool userDataIsDef;

   public:

      explicit GAccelItem ( const GString& id );

      GAccelItem ( const GString& id,
                   const GString& keyName,
                   bool control = false,
                   bool alt = false,
                   bool shift = false,
                   bool gray = false,
                   bool up = false );

      virtual ~GAccelItem ();

   private:

      void init ( const GString& keyName, 
                  bool control, 
                  bool alt, 
                  bool shift, 
                  bool gray,
                  bool up );

      static const GKeyBag<GString>& GetAvailAccelKeys ();

   public:

      const GString& getKeyName () const;
      const GString& getKeyNameForHumans () const;

      /**
       * Load and compile the following resource definition from the
       * specified tokenizer for the calling resource compiler.
       *
       * Since we assume that the ID-part of the resource has already been
       * parsed the next token (which is the first, from our point of view)
       * returned from the tokenizer must be "(".
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @param   tokenizer   The tokenizer of where to get tokens to parse.
       * @throws  GRcException in case of any error.
       */
      virtual void loadFromScript ( class GRcTokenizer& tokenizer, 
                                    class GResourceTable* table );
};

#endif


