/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_DIALOGRESOURCE
#define __GLIB_DIALOGRESOURCE

#include "glib/resource/GAbstractResource.h"
#include "glib/resource/GComponentParams.h"
#include "glib/util/GArray.h"
#include "glib/util/GHashtable.h"
#include "glib/gui/GComponentPos.h"
#include "glib/gui/GComponentSize.h"

/**
 * Each DIALOG resource is represented with an instance of this class.
 */
class GDialogResource : public GAbstractResource
{
   private:

      GString accelID;
      GString menuID;
      GString toolbarID;
      GString textID;
      GString iconID;
      GString layoutManagerID;
      GComponentPos pos;
      GComponentSize size;
      bool closeButton;
      bool resizable;
      GArray<GComponentParams> ctrls;

   private:

      /**
       * Used to contain the name of each and every component type that 
       * we are aware of.
       *
       * @author  Leif Erik Larsen
       * @since   2004.04.05
       */
      class ComponentTypes : public GHashtable<GString, GObject>
      {
         private:
            GObject dummyObj;
         public:
            ComponentTypes ();
         private:
            /** Disable the copy constructor. */
            ComponentTypes ( const ComponentTypes& src ) {}
            /** Disable the assignment operator. */
            ComponentTypes& operator= ( const ComponentTypes& ) { return *this; }
      };

      static ComponentTypes CompTypes;

   public:

      explicit GDialogResource ( const GString& id );
      virtual ~GDialogResource ();

   public:

      const GString& getAccelID () const;
      const GArray<GComponentParams>& getComponents () const;
      const GString& getIconID () const;
      const GString& getLayoutManagerID () const;
      const GString& getMenuID () const;
      const GComponentPos& getPos () const;
      const GComponentSize& getSize () const;
      const GString& getTextID () const;
      const GString& getToolbarID () const;
      bool isResizable () const;

   public:

      /**
       * Load and compile the following resource definition from the
       * specified tokenizer for the calling resource compiler.
       *
       * Since we assume that the ID-part of the resource has already been
       * parsed the next token (which is the first, from our point of view)
       * returned from the tokenizer must be "(".
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.08
       * @param   tokenizer   The tokenizer of where to get tokens to parse.
       * @throws  GRcException in case of any error.
       */
      virtual void loadFromScript ( class GRcTokenizer& tokenizer, class GResourceTable* table );

   private:

      /**
       * Helper method to be used by {@link #loadFromScript} only.
       * Parse the header parameters of the specified dialogbox resource.
       *
       * @author  Leif Erik Larsen
       * @since   1997.04.03
       * @throws  GRcException in case of any error.
       */
      void parseHeader ( class GRcTokenizer& tokenizer, class GResourceTable* table );
};

#endif


