/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/resource/GRcIncludeModule.h"
#include "glib/io/GFileInputStream.h"
#include "glib/GProgram.h"

GRcIncludeModule::GRcIncludeModule ( GInputStream* stream, 
                                     int ifLevel, 
                                     bool autoDelete )
                 :lineNr(0),
                  srcLinePos(0),
                  stream(stream),
                  autoDeleteStream(autoDelete),
                  path("<stream>"),
                  startIfLevel(ifLevel)
{
}

GRcIncludeModule::GRcIncludeModule ( GVfs& vfs, 
                                     const GString& fname, 
                                     int ifLevel )
                 :lineNr(0),
                  srcLinePos(0),
                  stream(null),
                  autoDeleteStream(true),
                  path(fname),
                  startIfLevel(ifLevel)
{
   stream = new GFileInputStream(vfs, path, false);
}

GRcIncludeModule::~GRcIncludeModule ()
{
   if (autoDeleteStream)
      if (stream != null)
         delete stream;
}
