/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_ABSTRACTTOKENIZER
#define __GLIB_ABSTRACTTOKENIZER

#include "glib/util/GAbstractToken.h"

/**
 * This interface forms the abstract basis declarations for any tokenizer
 * in general.
 *
 * @author  Leif Erik Larsen
 * @since   2000.07.29
 * @see     GAbstractToken
 * @see     GTokenizer
 * @see     GRcTokenizer
 * @see     GExpressionParser
 */
class GAbstractTokenizer : public GObject
{
   public:

      /**
       * Get a reference to the next token of the abstract token stream.
       *
       * If there are no more tokens in the stream (that is if EOF has
       * been reached) then we will return a token whose <i>isEmpty()</i>
       * method will return true.
       *
       * @author  Leif Erik Larsen
       * @since   2000.07.29
       */
      virtual const GAbstractToken* getNextAbstractToken () = 0;

      /**
       * The concrete tokenizer is responsible for keeping track of which
       * line number and column position is about read, and this method
       * is the one to use when you need to know which is the current
       * column position.
       *
       * The returned column position is one-based. That is, first
       * character of line is #1 and not #0.
       *
       * @author  Leif Erik Larsen
       * @since   2000.07.29
       */
      virtual int getCurModuleColumn () const = 0;

      /**
       * The concrete tokenizer is responsible for keeping track of which
       * line number and column position is about read, and this method
       * is the one to use when you need to know which is the current
       * line number.
       *
       * The returned line number is one-based. That is, line number one
       * is the first line (not line #0).
       *
       * @author  Leif Erik Larsen
       * @since   2000.07.29
       */
      virtual int getCurModuleLineNr () const = 0;
};

#endif

