/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include <time.h>
#include "glib/util/GDate.h"
#include "glib/GProgram.h"

GDate::GDate ()
      :year(0),
       month(0),
       day(0)
{
   DATETIME dt;
   DosGetDateTime(&dt);
   year = dt.year;
   month = dt.month;
   day = dt.day;
}

GDate::GDate ( int year, int month, int day )
      :year(year),
       month(month),
       day(day)
{
}

GDate::GDate ( const FDATE& date )
      :year(date.year + 1980),
       month(date.month),
       day(date.day)
{
}

GDate::~GDate ()
{
}

const GDate& GDate::operator= ( const FDATE& date )
{
   year = date.year + 1980;
   month = date.month;
   day = date.day;
   return *this;
}

FDATE GDate::getOS2FDate () const
{
   FDATE date;
   memset(&date, 0, sizeof(date));
   date.year = year - 1980;
   date.month = month;
   date.day = day;
   return date;
}

const GDate& GDate::operator= ( const GDate& d )
{
   if (&d == this)
      return *this;
   year = d.year;
   month = d.month;
   day = d.day;
   return *this;
}

bool GDate::operator< ( const GDate& d ) const
{
   if (year != d.year)
      return year < d.year;
   else
   if (month != d.month)
      return month < d.month;
   else
      return day < d.day;
}

bool GDate::operator> ( const GDate& d ) const
{
   if (year != d.year)
      return year > d.year;
   else
   if (month != d.month)
      return month > d.month;
   else
      return day > d.day;
}

bool GDate::operator== ( const GDate& d ) const
{
   return year == d.year &&
          month == d.month &&
          day == d.day;
}

bool GDate::operator<= ( const GDate& d ) const 
{ 
   return operator<(d) || operator==(d); 
}

bool GDate::operator>= ( const GDate& d ) const 
{ 
   return operator>(d) || operator==(d); 
}

bool GDate::operator!= ( const GDate& d ) const 
{ 
   return !operator==(d); 
}

int GDate::getYear () const 
{ 
   return year; 
}

int GDate::getMonth () const 
{ 
   return month; 
}

int GDate::getDay () const 
{ 
   return day; 
}

void GDate::setYear ( int val ) 
{ 
   year = val; 
}

void GDate::setMonth ( int val ) 
{ 
   month = val; 
}

void GDate::setDay ( int val ) 
{ 
   day = val; 
}

void GDate::clear ()
{
   year = 0;
   month = 0;
   day = 0;
}

void GDate::setDate ( int year, int month, int day )
{
   this->year = year;
   this->month = month;
   this->day = day;
}

GString GDate::getDateString ( const GLocaleData* locale ) const
{
   if (locale == null)
   {
      const GProgram& prg = GProgram::GetProgram();
      locale = &prg.getLocaleData();
   }

   return locale->getDateString(*this);
}

GString GDate::toString () const
{
   return getDateString(null);
}
