/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_PARAMETERLIST
#define __GLIB_PARAMETERLIST

#include "glib/primitives/GString.h"
#include "glib/util/GKeyBag.h"

/**
 * All additional arguments of a dialog component are to be contained in an
 * instance of this class. The arguments are not case significant.
 * 
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GParameterList : public GObject
{
   private:

      GKeyBag<GString> args;

   public:

      explicit GParameterList ( bool ignoreCase = false );
      GParameterList ( const GParameterList& src );
      virtual ~GParameterList ();

   public:

      GParameterList& operator= ( const GParameterList& src );

   private:

      GParameterList& copyFrom ( const GParameterList& src );

   public:

      /**
       * Set the value of the specified parameter. If it already exist then
       * we will replace the old value with the new.
       */
      void setParameter ( const GString& name, const GString& value );
      bool getBoolean ( const GString& name, bool defaultVal = false ) const;
      double getDouble ( const GString& name, double defaultVal = 0.0 ) const;
      int getInteger ( const GString& name, int defaultVal = 0 ) const;
      GString getString ( const GString& name, const GString& defaultVal = GString::Empty ) const;
      bool contains ( const GString& name ) const;
      bool remove ( const GString& name );
      void removeAll ();

      /**
       * @author  Leif Erik Larsen
       * @since   2006.03.17
       * @param   equalStr  The string to separate parameter names and their 
       *                    corresponding value.
       * @param   commaStr  The string to separate each parameter/value pair.
       * @param   quote     The quote character, or zero if we should not 
       *                    quote the values.
       */
      GString toParamListString ( const GString& equalStr, const GString& commaStr, char quote ) const;

      /**
       * Return a string representation of the parameters, for debugging
       * purposes only.
       */
      GString toString () const;
};

#endif


