/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_SEARCHPATH
#define __GLIB_SEARCHPATH

#include "glib/util/GArray.h"

/**
 * Class to wrap a path-list of an environement variable and make it
 * easy to access the array of search-directories as are separated by
 * one or more system dependent path separator character.
 *
 * @author  Leif Erik Larsen
 * @since   2001.03.07
 */
class GSearchPath : public GObject
{
   private:

      GArray<GString> dirs;

   public:

      /** The default constructor. */
      GSearchPath ();

      /** The copy constructor. */
      GSearchPath ( const GSearchPath& src );

      explicit GSearchPath ( const GString& searchPath );

      virtual ~GSearchPath ();

      /** The assignment operator. */
      GSearchPath& operator= ( const GSearchPath& src );

   public:

      /**
       * Add all the dir's in the specified search path to the already
       * contained directories.
       *
       * This method is handy for instance when building up a complete
       * search path object from OS/2's BEGINLIBPATH, LIBPATH and
       * ENDLIBPATH.
       */
      void addSearchPath ( const GString& searchPath );

      int getCount () const;

      const GString& getIndexedDir ( int index ) const;
};

#endif
