/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/util/GStringUtil.h"
#include "glib/util/GLocaleData.h"
#include "glib/primitives/GLong.h"
#include "glib/GProgram.h"

const longlong GStringUtil::KILO = 1024;
const longlong GStringUtil::MEGA = GStringUtil::KILO * 1024;
const longlong GStringUtil::GIGA = GStringUtil::MEGA * 1024;
const longlong GStringUtil::TERA = GStringUtil::GIGA * 1024;
const GString GStringUtil::STR_BYTE0 = "";
const GString GStringUtil::STR_BYTE1 = "Byte";
const GString GStringUtil::STR_BYTE2 = "Bytes";
const GString GStringUtil::STR_KILO0 = "K";
const GString GStringUtil::STR_KILO1 = "KByte";
const GString GStringUtil::STR_KILO2 = "KBytes";
const GString GStringUtil::STR_MEGA0 = "M";
const GString GStringUtil::STR_MEGA1 = "MByte";
const GString GStringUtil::STR_MEGA2 = "MBytes";
const GString GStringUtil::STR_GIGA0 = "G";
const GString GStringUtil::STR_GIGA1 = "GByte";
const GString GStringUtil::STR_GIGA2 = "GBytes";
const GString GStringUtil::STR_TERA0 = "T";
const GString GStringUtil::STR_TERA1 = "TByte";
const GString GStringUtil::STR_TERA2 = "TBytes";

GStringUtil::GStringUtil () 
{
}

GString GStringUtil::ToByteCountString ( longlong value,
                                         bool thousandSepOnly,
                                         bool longDescription,
                                         bool descrSep )
{
   GProgram& prg = GProgram::GetProgram();
   const GLocaleData& loc = prg.getLocaleData();
   if (thousandSepOnly)
   {
      GString buff = GLong::ToString(value, 10);
      for (int i=buff.length()-3; i>0; i-=3)
         buff.insert(loc.thousandsSeparator, i);
      return buff;
   }

   GString ret(32);

   if (value < 0)
   {
      ret += '-';
      value *= -1; // Convert to positive
   }

   const GString* descr;
   if (value < MEGA)
   {
      descr = (!longDescription ? &STR_BYTE0 : (value<=1 ? &STR_BYTE1 : &STR_BYTE2));
   }
   else
   if (value < GIGA)
   {
      value /= KILO;
      descr = (!longDescription ? &STR_KILO0 : (value<=1 ? &STR_KILO1 : &STR_KILO2));
   }
   else
   if (value < TERA)
   {
      value /= MEGA;
      descr = (!longDescription ? &STR_MEGA0 : (value<=1 ? &STR_MEGA1 : &STR_MEGA2));
   }
   else
   if (value < TERA * 1024)
   {
      value /= GIGA;
      descr = (!longDescription ? &STR_GIGA0 : (value<=1 ? &STR_GIGA1 : &STR_GIGA2));
   }
   else
   {
      value /= TERA;
      descr = (!longDescription ? &STR_TERA0 : (value<=1 ? &STR_TERA1 : &STR_TERA2));
   }

   ret += ToByteCountString(value, true);
   if (descrSep)
      ret += ' ';
   ret += *descr;

   return ret;
}

