/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_SYSTEMYCONVERTER
#define __GLIB_SYSTEMYCONVERTER

/**
 * This interface declares the methods needed to convert Y-coordinates 
 * between OS/2 (which has origo at bottom) and Windows (which has 
 * origo at top).
 *
 * @author  Leif Erik Larsen
 * @since   2004.06.03
 */
class GSystemYConverter
{
   public:

      /**
       * Return true if this object uses OS/2'ish y-coordinates.
       *
       * @author  Leif Erik Larsen
       * @since   2004.06.03
       */
      virtual bool isOS2Y () const = 0;

      /**
       * Convert to system dependent Y-coordinate, if needed.
       * This method should only be used if {@link #isOS2Y} does not match
       * the coordinate system of the host system.
       *
       * @author  Leif Erik Larsen
       * @since   2004.06.03
       */
      virtual int sysY (  int y  ) const = 0;
};

#endif
