/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgCreateDirectory.h"
#include "lcmd/LCmdMakeDir.h"

#include "glib/GProgram.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/event/GDialogMessage.h"

LCmdDlgCreateDirectory::LCmdDlgCreateDirectory ( LCmdMakeDir& makeDir )
                       :makeDir(makeDir)
{
}

LCmdDlgCreateDirectory::~LCmdDlgCreateDirectory ()
{
}

bool LCmdDlgCreateDirectory::execute ( GWindow& parentWin )
{
   GProgram& prg = GProgram::GetProgram();
   GString darg = prg.executeDialog(&parentWin, "DlgCreateDirectory", this);
   return darg == "DLG_OK";
}

bool LCmdDlgCreateDirectory::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG: 
      {
         dlg.setComponentValue("101", makeDir.dirStr);
         dlg.setComponentValue("103", makeDir.makeAsZip);
         return true; 
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
         {
            GString dir = dlg.getComponentValue("101");
            if (dir != "")
            {
               makeDir.dirStr = dir;
               makeDir.makeAsZip = dlg.getComponentBoolValue("103");
               dlg.dismiss(cmdID);
            }
         }
         else
         if (cmdID == "DLG_CANCEL")
         {
            dlg.dismiss(cmdID);
         }
         return true; 
      }

      default:
         return false;
   }
}

