/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdDlgDirCache.h"
#include "lcmd/LCmdDirCache.h"

#include "glib/GProgram.h"
#include "glib/gui/event/GDialogMessage.h"
#include "glib/gui/GDialogPanel.h"
#include "glib/gui/GListBox.h"

LCmdDlgDirCache::LCmdDlgDirCache ( LCmdDirCache& cache, const GString& pickFilter )
                :cache(cache),
                 pickFilter(pickFilter)
{
}

LCmdDlgDirCache::~LCmdDlgDirCache () 
{
}

GString LCmdDlgDirCache::execute ( GWindow* parentWin )
{
   GProgram& prg = GProgram::GetProgram();
   return prg.executeDialog(parentWin, "DlgDirCache", this);
}

bool LCmdDlgDirCache::handleDialogMessage ( GDialogMessage& msg )
{
   GDialogPanel& dlg = msg.getDialog();
   switch (msg.getID())
   {
      case GM_INITDIALOG: 
      {
         // Find and track every matching directory. A directory is 
         // considered to match only if the last directory element of 
         // the directory path begins with the specified pick-filter.
         GVfsLocal localVfs;
         bool fsIsCaseSensitive = localVfs.isFileNameCaseSensitive();
         GString slashesStr("\\/");
         GListBox& list = dynamic_cast<GListBox&>(dlg.getComponentByID("101"));
         const int numDirs = cache.dirs.getCount();
         for (int i=0; i<numDirs; i++)
         {
            GString dir = cache.get(i);
            int pos1 = dir.lastIndexOfAnyChar(slashesStr);
            if (pos1 <= -1)
               continue;
            dir.remove(0, pos1+1);
            if (dir.beginsWith(pickFilter, !fsIsCaseSensitive))
               list.addItem(cache.get(i));
         }
         const int numItems = list.getItemCount();
         if (numItems == 1)
         {
            // There is only one matching directory item, so assume that the
            // user wants to activate that directory immediately, without
            // having to manually select it.
            GString temp = list.getItemText(0);
            dlg.dismiss(temp);
         }
         else
         if (numItems > 0)
         {
            list.setSelectedIndex(0);
            dlg.setComponentFocus("101");
         }
         else
         {
            dlg.dismiss("?"); // "?" ==> Ask user if he want us to rescan.
         }
         return true; 
      }

      case GM_LISTBOX_DBLCLICK: 
      {
         GString id = msg.getParam1String();
         if (id == "101")
            dlg.sendDialogMessage(GM_COMMAND, "DLG_OK");
         return true; 
      }

      case GM_COMMAND: 
      {
         GString cmdID = msg.getParam1String();
         if (cmdID == "DLG_OK")
         {
            GListBox& list = dynamic_cast<GListBox&>(dlg.getComponentByID("101"));
            GString temp = list.getItemText(-1); // Current selected item.
            dlg.dismiss(temp);
         }
         else
         if (cmdID == "DLG_CANCEL")
         {
            dlg.dismiss("");
         }
         return true; 
      }

      default:
         return false;
   }
}
