/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGDIRCACHE
#define __LCMD_DLGDIRCACHE

#include "glib/gui/event/GDialogMessageHandler.h"
#include "glib/primitives/GString.h"

/**
 * This dialog is used by the "Directory cache" facility that will automatically
 * pop up if user attempts to do a "CD" command into a directory that is
 * not directly existing.
 *
 * @since   2000.09.19
 * @author  Leif Erik Larsen
 */
class LCmdDlgDirCache : public GDialogMessageHandler
{
   private:

      class LCmdDirCache& cache;
      GString pickFilter;

   public:

      LCmdDlgDirCache ( class LCmdDirCache& cache, const GString& pickFilter );
      virtual ~LCmdDlgDirCache ();

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       *
       * Part of the interface {@link GUserMessageHandler}.
       */
      virtual bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Execute the dialog as a modal dialog.
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.19
       * @return  An empty string if user selected the cancel-button,
       *          "?" if there are no matching directories (the user should be
       *          asked if he or she wants to rescan the drive for directories)
       *          or else a copy of the full selected directory.
       */
      GString execute ( class GWindow* parentWin );
};

#endif // #ifndef __LCMD_DLGDIRCACHE
