/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_DLGTEXTSEARCH
#define __LCMD_DLGTEXTSEARCH

#include "glib/gui/event/GDialogMessageHandler.h"
#include "glib/gui/GTextViewer.h"

/**
 * This dialog is used to let the user specify the which text to search for
 * in the console monitor ({@link GTextViewer}.
 *
 * @since   2000.09.18
 * @author  Leif Erik Larsen
 */
class LCmdDlgTextSearch : public GTextViewer::SearchParams, 
                          public GDialogMessageHandler
{
   private:

      /** Valid only while inside {@link #userEditSearchParams}. */
      class GTextViewer* textViewer;

      /** The name of the ini-file section of where to contain our text search options. */
      GString iniSectName;

      /** True if {@link #setFixedAutoParams} has been called and "auto params" is active. */
      bool fixedAutoParams;

   public:

      /**
       * @author  Leif Erik Larsen
       * @since   2006.01.27
       * @param   iniSectName The name of the ini-file section of where to
       *                      read and write the user configured text search 
       *                      options of this dialog. If an empty string is 
       *                      specified then we will not maintain these 
       *                      options in any ini-file at all.
       */
      LCmdDlgTextSearch ( const GString& iniSectName );

      virtual ~LCmdDlgTextSearch ();

   private:

      /**
       * This is the message handler method that is called to handle
       * messages from the dialog box window.
       */
      bool handleDialogMessage ( class GDialogMessage& msg );

   public:

      /**
       * Called by the specified text viewer object when the user
       * has requested the search dialog to be executed (as a modal dialog).
       *
       * @author  Leif Erik Larsen
       * @since   2000.09.18
       */
      virtual bool userEditSearchParams ( class GTextViewer& owner );
      
      /**
       * Called by the specified text viewer object if no matching text 
       * was found. We will make a notification to the user.
       *
       * @author  Leif Erik Larsen
       * @since   2005.02.03
       */
      virtual void onSearchStringNotFound ( GTextViewer& owner );

      /**
       * This method was initially implemented for usage by testing 
       * code only, but it is probably also usable for automatic
       * non-interactive text searching (e.g. during some macro execution)
       * if needed in the future.
       *
       * If this method has been used then {@link #userEditSearchParams}
       * will return immediately without presenting any options or 
       * dialog box to the user.
       *
       * @author  Leif Erik Larsen
       * @since   2005.02.04
       */
      void setFixedAutoParams ( const GTextViewer::SearchParams& params );
};

#endif // #ifndef __LCMD_DLGTEXTSEARCH
