/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/sys/GSystem.h"

#include "lcmd/LCmdFilePanelColorOptions.h"

LCmdFilePanelColorOptions::LCmdFilePanelColorOptions ()
{
   resetToDefault();
}

void LCmdFilePanelColorOptions::resetToDefault ()
{
   itemBck = GColor::WHITE.getDarker(24);
   itemBckMarked = itemBck.getDarker(24);
   itemDirTxt = GColor::DRED;
   itemFileTxt = GColor::BLACK;
   itemReadOnlyTxt = GColor::DCYAN;
   itemSysHiddenTxt = GColor::DGRAY;
   itemArchiveTxt = GColor::DGREEN;
   itemSelectedBckActive = GColor(128, 180, 246);
   itemSelectedBckActiveMarked = itemBck.getDarker(48);
   itemSelectedBckInactive = itemBck.getLighter(6);
   itemSelectedThinActive = GColor::BLACK;
   itemSelectedThinInactive = GColor::DGRAY;
   headerActiveBck = GColor(50, 106, 198);
   headerActiveTxt = GColor::WHITE;
   headerActiveBckWhenInsideVfs = GColor(150, 0, 0);
   headerActiveTxtWhenInsideVfs = GColor::WHITE;
   headerInactiveBck = GSystem::GetSystemColor(GSystem::SCID_DIALOGBCK).getDarker(32);
   headerInactiveTxt = GColor::WHITE;
   headerInactiveBckWhenInsideVfs = GSystem::GetSystemColor(GSystem::SCID_DIALOGBCK).getDarker(32);
   headerInactiveTxtWhenInsideVfs = GColor::WHITE;
}
