/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdPanelsParent.h"
#include "lcmd/LCmd.h"
#include "lcmd/LCmdSubClient.h"

#include "glib/gui/layout/GBorderLayout.h"

LCmdPanelsParent::LCmdPanelsParent ( LCmdSubClient& parentWin,
                                     const GString& constraints )
                 :GWindow(&parentWin,
                          "FilePanels",
                          constraints,
                          WS2_IGNORE_COLORS_AND_FONT_PROFILE | WS2_OS2Y | WS2_USE_SAME_PROFILE_SECTION_NAME_AS_PARENT),
                  FRAME1_NAME("Panel1"),
                  FRAME2_NAME("Panel2"),
                  frame1(FRAME1_NAME, GBorderLayout::WEST, *this),
                  frame2(FRAME2_NAME, GBorderLayout::EAST, *this)
{
   setLayoutManager(new GBorderLayout(), true);
}

LCmdPanelsParent::~LCmdPanelsParent ()
{
}

void LCmdPanelsParent::writeProfile ( const GString& sectName, bool force )
{
   GProgram& prg = GProgram::GetProgram();
   GSectionBag& ini = prg.getIniProperties();
   LCmdOptions& opt = LCmdOptions::GetOptions();
   LCmdFilePanel& leftPanel = LCmdFilePanel::GetLeftPanel();
   ini.putInt(sectName, "Panel1RelWidth", opt.panel1RelWidth, force || opt.saveOnExit.panelModeSort);
   ini.putBool(sectName, "Start5050", opt.panelSizesStart5050, force || opt.saveOnExit.panelModeSort);
   ini.putBool(sectName, "PanelsFullScreen", opt.panelsFullScreen, force || opt.saveOnExit.visibleState);
   ini.putBool(sectName, "PanelsVisible", opt.panelsAreVisible, force || opt.saveOnExit.visibleState);
   ini.putInt(sectName, "CurPanel", leftPanel.isCurrentPanel() ? 1 : 2, force || opt.saveOnExit.curSelFiles);
   GWindow::writeProfile(sectName, force);
}

void LCmdPanelsParent::queryProfile ( const GString& sectName )
{
   GProgram& prg = GProgram::GetProgram();
   GSectionBag& ini = prg.getIniProperties();
   LCmdOptions& opt = LCmdOptions::GetOptions();
   LCmdFilePanel& leftPanel = LCmdFilePanel::GetLeftPanel();
   LCmdFilePanel& rightPanel = LCmdFilePanel::GetRightPanel();
   lcmd->curPanel = (ini.getInt(sectName, "CurPanel", 1) == 1) ? &leftPanel : &rightPanel;
   opt.panelsFullScreen = ini.getBool(sectName, "PanelsFullScreen", opt.panelsFullScreen);
   opt.panelsAreVisible = ini.getBool(sectName, "PanelsVisible", opt.panelsAreVisible);
   opt.panel1RelWidth = ini.getInt(sectName, "Panel1RelWidth", opt.panel1RelWidth);
   opt.panelSizesStart5050 = ini.getBool(sectName, "Start5050", opt.panelSizesStart5050);

   GWindow::queryProfile(sectName);

   // ---
   if (opt.panelSizesStart5050)
   {
      opt.panel1RelWidth = 500; // 50%
      opt.consoleRelHeight = 500; // 50%
   }
}

int LCmdPanelsParent::getPreferredHeight () const
{
   GWindow* pwin = getParentWindow();
   GDimension dim = pwin->getWindowSize();
   int parentHeight = dim.height;
   int cmdcontHeight = lcmd->cmdCont.getPreferredHeight();
   return parentHeight - cmdcontHeight;
}
