{$I M_OPS.PAS}

// ADD GENDER MCI CODE

Unit BBS_IO;

Interface

Uses
  m_Types,
  m_Socket_Class,
  m_Output,
  m_Term_Ansi,
  BBS_Common;

Const
  TBBSIOBufferSize = 8 * 1024 - 1;

Type
  TScreenInfoRec = Record
    X : Byte;
    Y : Byte;
    A : Byte;
  End;

  TBBSIO = Class
    Owner      : Pointer;
    Console    : TOutput;
    Terminal   : TTermAnsi;
    PromptInfo : Array['A'..'R'] of String[90];
    ScreenInfo : Array[1..6] of TScreenInfoRec;
    OutBuffer  : Array[0..TBBSIOBufferSize] of Char;
    OutBufPos  : LongInt;
    AllowArrow : Boolean;
    AllowPause : Boolean;
    AllowMCI   : Boolean;
    IsArrow    : Boolean;
    UseInField : Boolean;
    UseInLimit : Boolean;
    UseInSize  : Boolean;
    FormatMCI  : Boolean;
    NoBufFlush : Boolean;
    InNodeMsg  : Boolean;
    InLimit    : Byte;
    InSize     : Byte;
    PausePos   : LongInt;  //got sick of range check errors
    Graphics   : Byte;
    FormatLen  : Byte;
    FormatType : Byte;
    KeyBufStr  : String;
    TimeOutIdx : LongInt;
    InputData  : Array[1..mysMaxInputHistory] of String[255];
    InputPos   : Byte;

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;

    { GENERAL FUNCTIONS }

    Function    Pipe2Ansi     (Color: Byte) : String;
    Function    Attr2Ansi     (Attr: Byte; Forced: Boolean) : String;
    Function    AnsiMoveX     (X: Byte) : String;
    Function    AnsiMoveY     (Y: Byte) : String;
    Function    AnsiGotoXY    (X, Y: Byte) : String;
    Function    Mci2Str       (Code: String) : String;
    Function    StrMci        (Str: String) : String;
    Procedure   AskGraphics   (Prompt: String);
    Procedure   ShowTemplate  (FN: String);
    Procedure   AnsiViewer    (Data: String);
    Function    OutYesNo      (Mode: Boolean) : String;
    Procedure   RemoteRestore (Var S: TConsoleImageRec; Clear: Boolean);
    Procedure   DetectGraphics;
    Function    AnsiClear     : String;
    Function    AnsiClrEOL    : String;

    { INPUT FUNCTIONS }

    Function    NewGetKey    (TimeOut: LongInt) : Char;
    Function    OneKey       (Str: String; Echo: Boolean): Char;
    Function    GetStr       (Field, Max: Byte; Mode: ShortInt; DefStr: String) : String;
    Function    GetYN        (Str: String; Def: Boolean) : Boolean;
    Procedure   PausePrompt;
    Function    MorePrompt : Char;

    { OUTPUT FUNCTIONS }

    Procedure   BufAddChar   (Ch: Char);
    Procedure   BufAddStr    (Str: String);
    Procedure   BufFlush;
    Procedure   OutRaw       (Str: String);
    Procedure   OutRawLn     (Str: String);
    Procedure   OutBS        (Num: Byte; Erase: Boolean);
    Procedure   OutPipe      (Str: String);
    Procedure   OutPipeLn    (Str: String);
    Procedure   OutFull      (Str: String);
    Procedure   OutFullLn    (Str: String);
    Function    OutFile      (Str: String) : Boolean;
  End;

Implementation

Uses
  DOS,
  Mystic_Telnet,
  m_FileIO,
  m_Strings,
  m_DateTime,
  BBS_Events,
  BBS_Core,
  BBS_MsgBase_Ansi,
  BBS_Multinode,
  BBS_NodeChat,
  MPL_Execute;

Constructor TBBSIO.Create (O: Pointer);
Begin
  Inherited Create;

  Owner      := O;
  Console    := TOutput.Create(False);
  Terminal   := TTermAnsi.Create(Console);
  AllowArrow := False;
  AllowPause := True;
  AllowMCI   := True;
  UseInField := True;
  UseInLimit := False;
  UseInSize  := False;
  FormatMCI  := False;
  NoBufFlush := False;
  InNodeMsg  := False;
  PausePos   := 1;
  OutBufPos  := 0;
  Graphics   := 0;
  KeyBufStr  := '';
  TimeOutIdx := 0;
  InputPos   := 0;

  FillChar (OutBuffer, SizeOf(OutBuffer), 0);

  If bbsConfig.TaskBar Then
    Console.SetWindow (1, 1, 80, Console.ScreenSize - 1, False);
End;

Destructor TBBSIO.Destroy;
Begin
  Terminal.Free;
  Console.Free;

  Inherited Destroy;
End;

Procedure TBBSIO.AnsiViewer (Data: String);
Var
  Buf      : Array[1..4096] of Char;
  BufLen   : LongInt;
  TopLine  : LongInt;
  WinSize  : LongInt;
  Ansi     : TMsgBaseAnsi;
  AFile    : File;
  Ch       : Char;
  FN       : String;
  Template : String;
  Str      : String;
  Sauce    : RecSauceInfo;

  Procedure Update;
  Begin
    // add percentage bar and line number here
    Ansi.DrawPage (TBBSCore(Owner).Term.ScreenInfo[1].Y, TBBSCore(Owner).Term.ScreenInfo[2].Y, TopLine);
  End;

Begin
  Template := strWordGet(1, Data, ';');
  FN       := strWordGet(2, Data, ';');

  If Pos(mysPathSep, FN) = 0 Then
    FN := TBBSCore(Owner).Theme.PathText + FN;

  If Pos('.', FN) = 0 Then
    FN := FN + '.ans';

  If Not FileExist(FN) Then Exit;

  PromptInfo['A'] := JustFile(FN);

  If ReadSauceInfo(FN, Sauce) Then Begin
    PromptInfo['B'] := strStripR(strWide2Str(Sauce.Title, 35), ' ');
    PromptInfo['C'] := strStripR(strWide2Str(Sauce.Author, 20), ' ');
    PromptInfo['D'] := strStripR(strWide2Str(Sauce.Group, 20), ' ');
    Str             := strWide2Str(Sauce.Date, 8);
    PromptInfo['E'] := Copy(Str, 5, 2) + '/' + Copy(Str, 7, 2) + '/' + Copy(Str, 1, 4);
  End Else Begin
    PromptInfo['B'] := 'Unknown';
    PromptInfo['C'] := PromptInfo['B'];
    PromptInfo['D'] := PromptInfo['B'];
    PromptInfo['E'] := '??/??/????';
  End;

  Ansi := TMsgBaseAnsi.Create(TBBSCore(Owner), False);

  Assign  (AFile, FN);
  ioReset (AFile, 1, fmReadWrite + fmDenyNone);

  While Not Eof(AFile) Do Begin
    ioBlockRead (AFile, Buf, SizeOf(Buf), BufLen);
    If Ansi.ProcessBuf (Buf, BufLen) Then Break;
  End;

  Close (AFile);

  TBBSCore(Owner).Term.AllowArrow := True;

  ShowTemplate(Template);

  WinSize := TBBSCore(Owner).Term.ScreenInfo[2].Y - TBBSCore(Owner).Term.ScreenInfo[1].Y + 1;

  If strUpper(strWordGet(3, Data, ';')) = 'END' Then Begin
    TopLine := Ansi.Lines - WinSize + 1;
    If TopLine < 1 Then TopLine := 1;
  End Else
    TopLine := 1;

  Update;

  While Not TBBSCore(Owner).ShutDown Do Begin
    Ch := UpCase(NewGetKey(0));

    If IsArrow Then Begin
      Case Ch of
        #71 : If TopLine > 1 Then Begin
                TopLine := 1;
                Update;
              End;
        #72 : If TopLine > 1 Then Begin
                Dec (TopLine);
                Update;
              End;
        #73,
        #75 : If TopLine > 1 Then Begin
                Dec (TopLine, WinSize);
                If TopLine < 1 Then TopLine := 1;
                Update;
              End;
        #79 : If TopLine + WinSize <= Ansi.Lines Then Begin
                TopLine := Ansi.Lines - WinSize + 1;
                Update;
              End;
        #80 : If TopLine + WinSize <= Ansi.Lines Then Begin
                Inc (TopLine);
                Update;
              End;
        #77,
        #81 : If TopLine < Ansi.Lines - WinSize Then Begin
                Inc (TopLine, WinSize);
                If TopLine + WinSize > Ansi.Lines Then TopLine := Ansi.Lines - WinSize + 1;
                Update;
              End;
      End;
    End Else
      If Ch = #27 Then Break;
  End;

  Ansi.Free;

  OutRaw(AnsiGotoXY(1, TBBSCore(Owner).User.ThisUser.ScreenSize));
End;

Procedure TBBSIO.ShowTemplate (FN: String);
// change this to automatically do the OutFile of the ANSI file
// and rename function to make sure we catch all its uses in the code.
Var
  TF    : Text;
  Buf   : Array[1..4096] of Char;
  Str   : String;
  Count : LongInt;
Begin
  OutFile (FN);

  Str := TBBSCore(Owner).Theme.PathTemplate + FN + '.cfg';

  If Not FileExist(Str) And TBBSCore(Owner).Theme.PathFallBack Then
    Str := BBSConfig.PathTemplate + FN + '.cfg';

  FileMode := 66;

  Assign     (TF, Str);
  SetTextBuf (TF, Buf, 4096);
  Reset      (TF);

  If IoResult <> 0 Then Begin
    TBBSCore(Owner).Event.Trigger(evt_Error, Owner, 'Unable to load template: ' + FN + '.cfg');
    Exit;
  End;

  FillChar(ScreenInfo, SizeOf(ScreenInfo), 0);

  Count := 0;

  While Not Eof (TF) Do Begin
    ReadLn (TF, Str);
    Str := strStripB(Str, ' ');

    If (Str[1] = ';') or (Str = '') Then Continue;

    Inc (Count);

    ScreenInfo[Count].X := strS2I(strWordGet(1, Str, ' '));
    ScreenInfo[Count].Y := strS2I(strWordGet(2, Str, ' '));
    ScreenInfo[Count].A := strS2I(strWordGet(3, Str, ' '));
  End;
  Close (TF);
End;

Function TBBSIO.StrMci (Str: String) : String;
Var
  Count : Byte;
  Code  : String[2];
Begin
  Result := '';
  Count  := 1;

  While Count <= Length(Str) Do Begin
    If (Str[Count] = '|') and (Count < Length(Str) - 1) Then Begin
      Code := Copy(Str, Count + 1, 2);
      Inc (Count, 2);
      Case Code[1] of
        '0' : Result := Result + '|' + Code;
        '1' : Result := Result + '|' + Code;
        'T' : If Code[2] in ['0'..'9'] Then
                Result := Result + '|' + Code
              Else
                Result := Result + Mci2Str(Code);
      Else
        Result := Result + Mci2Str(Code);
      End;
    End Else
      Result := Result + Str[Count];

    Inc(Count);
  End;
End;

Function TBBSIO.NewGetKey (TimeOut: LongInt) : Char;
Var
  Ch     : Char;
  Temp   : Char;
  Res    : LongInt;
  mNode  : Byte;
  mType  : Byte;
  mText  : String;
  mRoom  : Byte;
  Screen : TConsoleImageRec;
Begin
  Result  := #0;
  IsArrow := False;

  If TBBSCore(Owner).ShutDown Then Exit;

  If (TBBSCore(Owner).NodeMsg.Count > 0) And Not InNodeMsg Then Begin
    InNodeMsg := True;

    Console.GetScreenImage(1, 1, 80, 24, Screen);

    TBBSCore(Owner).NodeMsg.GetMsg(mNode, mType, mText, mRoom);

    PromptInfo['A'] := strI2S(mNode);
    PromptInfo['B'] := TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS.User.ThisUser.Handle;

    Case mType of
      nodeBroadcast   : Begin
                          OutFull(TBBSCore(Owner).GetPrompt(263));
                          OutFullLn(mText);
                          OutFull(TBBSCore(Owner).GetPrompt(264));
                        End;
      nodeMessage     : Begin
                          OutFull(TBBSCore(Owner).GetPrompt(261));
                          OutPipeLn(mText);
                          OutFull(TBBSCore(Owner).GetPrompt(262));

                          If OneKey('R'#13, True) = 'R' Then Begin
                            OutFull(TBBSCore(Owner).GetPrompt(260));
                            mText := GetStr(78, 255, -1, '');
                            If mText <> '' Then TBBSCore(Owner).NodeMsg.AddMsg(TBBSCore(Owner).Node, nodeMessage, mText, 0);
                          End;
                        End;
      nodeSystemMsg   : Begin
                          OutFull(TBBSCore(Owner).GetPrompt(265));
                          OutFullLn(mText);
                          OutFull(TBBSCore(Owner).GetPrompt(266));
                        End;
      nodeChatRequest : If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(269), True) Then Begin
                          TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS.NodeMsg.AddMsg(TBBSCore(Owner).Node, nodeChatOkay, '', 0);
                          User2UserChat(TBBSCore(Owner), TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS);
                        End Else
                          TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS.NodeMsg.AddMsg(TBBSCore(Owner).Node, nodeChatDecline, '', 0);
      nodeChatOkay    : User2UserChat(TBBSCore(Owner), TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS);
      nodeChatDecline : TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(270));
      nodeTelePublic,
      nodeTeleStatus,
      nodeTeleAll     : If TBBSCore(Owner).User.InNodeChat Then Begin
                          TBBSCore(Owner).Chat.ProcessChatMessage(mNode, mType, mText, mRoom);
                          KeyBufStr := KeyBufStr + #31;
                        End;
    End;

    If Not TBBSCore(Owner).User.InNodeChat Then
      RemoteRestore(Screen, True);

    InNodeMsg := False;
  End;

  If TBBSCore(Owner).User.TimeCheck And (TBBSCore(Owner).User.TimeLeft <= 0) Then Begin
    TBBSCore(Owner).SystemLog('User out of time');
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(257));
    TBBSCore(Owner).ShutDown := True;
    Exit;
  End;

  If Ord(KeyBufStr[0]) > 0 Then Begin
    Result := KeyBufStr[1];
    Delete (KeyBufStr, 1, 1);
    Exit;
  End;

  If Not TBBSCore(Owner).Client.DataWaiting Then Begin
    If (bbsConfig.Inactivity = 0) or (TBBSCore(Owner).User.ThisUser.Flags And UserNoInactive <> 0) Then
      Res := -1
    Else
      Res := bbsConfig.Inactivity * 1000;

    If TimeOut > 0 Then Res := TimeOut;

    If TBBSCore(Owner).Client.WaitForData(Res) = 0 Then Begin
      Inc (TimeOutIdx, Res);

//      TBBSCore(Owner).systemlog('time: ' + stri2s(timeoutidx));

      If (bbsConfig.Inactivity > 0) And (TBBSCore(Owner).User.ThisUser.Flags And UserNoInactive = 0) And (TimeOutIdx DIV 1000 >= bbsConfig.Inactivity) Then Begin
        TBBSCore(Owner).Event.Trigger(evt_Inactive, Owner, '');
        Exit;
      End;

      Exit;
    End;
  End;

  Repeat
    Res := TBBSCore(Owner).Client.ReadBuf(Ch, 1);

    If Res < 0 Then Begin
      TBBSCore(Owner).Event.Trigger(evt_ConnectionLost, Owner, '');
      Exit;
    End;

    TimeOutIdx := 0;
  Until Res <> 0;

  If AllowArrow Then Begin
    IsArrow := True;

    Case Ch of
      #03 : Ch := #81; { CTRL-C / PgDn  }
      #04 : Ch := #77; { CTRL-D / Right }
      #05 : Ch := #72; { CTRL-E / Up    }
      #18 : Ch := #73; { CTRL-R / PgUp  }
      #19 : Ch := #75; { CTRL-S / Left  } // Not allowed in WinNT
      #24 : Ch := #80; { CTRL-X / Down  }
      #27 : If TBBSCore(Owner).Client.DataWaiting Then Begin
              TBBSCore(Owner).Client.ReadBuf(Temp, 1);
              If Temp = '[' Then Begin
                TBBSCore(Owner).Client.ReadBuf(Temp, 1);

                Case Temp of
                  'A' : Ch := #72; { up    }
                  'B' : Ch := #80; { down  }
                  'C' : Ch := #77; { right }
                  'D' : Ch := #75; { left  }
                  'H' : Ch := #71; { home  }
                  'K' : Ch := #79; { end   }
                  '1' : Ch := #71;
                  '3' : Ch := #83;
                  '4' : Ch := #79;
                  '5' : Ch := #73;
                  '6' : Ch := #31;
                End;

                If (Temp in ['1'..'6']) And (TBBSCore(Owner).Client.DataWaiting) Then
                  TBBSCore(Owner).Client.ReadBuf(Temp, 1);
              End Else
                IsArrow := False;
            End Else
              IsArrow := False;
      #127: Ch := #83; { delete }
    Else
      IsArrow := False;
    End;
  End;

  Result := Ch;
End;

(*
Function TBBSIO.GetKey (TimeOut: LongInt) : Char;
Var
  Ch     : Char;
  Temp   : Char;
  Res    : LongInt;
  mNode  : Byte;
  mType  : Byte;
  mText  : String;
  mRoom  : Byte;
  Screen : TConsoleImageRec;
Begin
  Result  := #0;
  IsArrow := False;

  If TBBSCore(Owner).ShutDown Then Exit;

// add this check inside of some type of loop if possible similar to the
// menu timer loop so messages are ALWAYS checked while idle, not just  at
// a menu

  If (TBBSCore(Owner).NodeMsg.Count > 0) And Not InNodeMsg Then Begin
    InNodeMsg := True;

    Console.GetScreenImage(1, 1, 80, 24, Screen);

    TBBSCore(Owner).NodeMsg.GetMsg(mNode, mType, mText, mRoom);

    PromptInfo['A'] := strI2S(mNode);
    PromptInfo['B'] := TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS.User.ThisUser.Handle;

    Case mType of
      nodeBroadcast   : Begin
                          OutFull(TBBSCore(Owner).GetPrompt(263));
                          OutFullLn(mText);
                          OutFull(TBBSCore(Owner).GetPrompt(264));
                        End;
      nodeMessage     : Begin
                          OutFull(TBBSCore(Owner).GetPrompt(261));
                          OutPipeLn(mText);
                          OutFull(TBBSCore(Owner).GetPrompt(262));

                          If OneKey('R'#13, True) = 'R' Then Begin
                            OutFull(TBBSCore(Owner).GetPrompt(260));
                            mText := GetStr(78, 255, -1, '');
                            If mText <> '' Then TBBSCore(Owner).NodeMsg.AddMsg(TBBSCore(Owner).Node, nodeMessage, mText, 0);
                          End;
                        End;
      nodeSystemMsg   : Begin
                          OutFull(TBBSCore(Owner).GetPrompt(265));
                          OutFullLn(mText);
                          OutFull(TBBSCore(Owner).GetPrompt(266));
                        End;
      nodeChatRequest : If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(269), True) Then Begin
                          TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS.NodeMsg.AddMsg(TBBSCore(Owner).Node, nodeChatOkay, '', 0);
                          User2UserChat(TBBSCore(Owner), TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS);
                        End Else
                          TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS.NodeMsg.AddMsg(TBBSCore(Owner).Node, nodeChatDecline, '', 0);
      nodeChatOkay    : User2UserChat(TBBSCore(Owner), TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mNode - 1]).BBS);
      nodeChatDecline : TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(270));
      nodeTelePublic,
      nodeTeleStatus,
      nodeTeleAll     : If TBBSCore(Owner).User.InNodeChat Then Begin
                          TBBSCore(Owner).Chat.ProcessChatMessage(mNode, mType, mText, mRoom);
                          KeyBufStr := KeyBufStr + #31;
                          // stuff this into buffer so input prompt redraws
                        End;
    End;

    If Not TBBSCore(Owner).User.InNodeChat Then
      RemoteRestore(Screen, True);

    InNodeMsg := False;
  End;

  If TBBSCore(Owner).User.TimeCheck And (TBBSCore(Owner).User.TimeLeft <= 0) Then Begin
    TBBSCore(Owner).SystemLog('User out of time');
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(257));
    TBBSCore(Owner).ShutDown := True;
    Exit;
  End;

  If Ord(KeyBufStr[0]) > 0 Then Begin
    Result := KeyBufStr[1];
    Delete (KeyBufStr, 1, 1);
    Exit;
  End;

  If Not TBBSCore(Owner).Client.DataWaiting Then Begin
    If (bbsConfig.Inactivity = 0) or (TBBSCore(Owner).User.ThisUser.Flags And UserNoInactive <> 0) Then
      Res := -1
    Else
      Res := bbsConfig.Inactivity * 1000;

    If TimeOut > 0 Then Res := TimeOut;

    Res := TBBSCore(Owner).Client.WaitForData(Res);

    If Res = 0 Then
      If TimeOut = 0 Then Begin
        TBBSCore(Owner).Event.Trigger(evt_Inactive, Owner, '');
        Exit;
      End Else
        Exit;
  End;

  Repeat
    Res := TBBSCore(Owner).Client.ReadBuf(Ch, 1);

    If Res < 0 Then Begin
      TBBSCore(Owner).Event.Trigger(evt_ConnectionLost, Owner, '');
      Exit;
    End;
  Until Res <> 0;

  If AllowArrow Then Begin
    IsArrow := True;

    Case Ch of
      #03 : Ch := #81; { CTRL-C / PgDn  }
      #04 : Ch := #77; { CTRL-D / Right }
      #05 : Ch := #72; { CTRL-E / Up    }
      #18 : Ch := #73; { CTRL-R / PgUp  }
      #19 : Ch := #75; { CTRL-S / Left  } // Not allowed in WinNT
      #24 : Ch := #80; { CTRL-X / Down  }
      #27 : If TBBSCore(Owner).Client.DataWaiting Then Begin
              TBBSCore(Owner).Client.ReadBuf(Temp, 1);
              If Temp = '[' Then Begin
                TBBSCore(Owner).Client.ReadBuf(Temp, 1);

                Case Temp of
                  'A' : Ch := #72; { up    }
                  'B' : Ch := #80; { down  }
                  'C' : Ch := #77; { right }
                  'D' : Ch := #75; { left  }
                  'H' : Ch := #71; { home  }
                  'K' : Ch := #79; { end   }
                  '1' : Ch := #71;
                  '3' : Ch := #83;
                  '4' : Ch := #79;
                  '5' : Ch := #73;
                  '6' : Ch := #31;
                End;

                If (Temp in ['1'..'6']) And (TBBSCore(Owner).Client.DataWaiting) Then
                  TBBSCore(Owner).Client.ReadBuf(Temp, 1);
              End Else
                IsArrow := False;
            End Else
              IsArrow := False;
      #127: Ch := #83; { delete }
    Else
      IsArrow := False;
    End;
  End;

  Result := Ch;
End;
*)
Function TBBSIO.OneKey (Str: String; Echo: Boolean): Char;
Var
  Ch : Char;
Begin
//  BufFlush;

  Repeat
    Ch := UpCase(Char(NewGetKey(0)));
  Until (Pos(Ch, Str) > 0) or TBBSCore(Owner).ShutDown;

  If Echo Then OutRawLn (Ch);

  Result := Ch;
End;

Procedure TBBSIO.PausePrompt;
Var
  Attr  : Byte;
  Saved : Boolean;
Begin
  Saved      := NoBufFlush;
  NoBufFlush := False;

  BufFlush;

  Attr := Console.TextAttr;
  OutFull (TBBSCore(Owner).GetPrompt(58));

  Repeat
  Until (NewGetKey(0) <> #0) or (TBBSCore(Owner).ShutDown);

  OutFullLn(Attr2Ansi(Attr, False));

  NoBufFlush := Saved;
End;

Function TBBSIO.MorePrompt : Char;
Var
  Attr    : Byte;
  Save    : Boolean;
  BufSave : Boolean;
  Keys    : String[3];
  Prompt  : String;
Begin
  BufSave    := NoBufFlush;
  NoBufFlush := False;
  Save       := AllowMCI;
  AllowMCI   := True;
  Attr       := Console.TextAttr;
  Prompt     := TBBSCore(Owner).GetPrompt(20);
  Keys       := strWordGet(1, Prompt, ' ');

  Delete (Prompt, 1, 4);

  BufFlush;

  OutFull (Prompt);

  Case Pos(OneKey(Keys + #13, False), Keys + #13) of
    1,
    4  : Result := 'Y';
    2  : Result := 'N';
    3  : Result := 'C';
  End;

  OutBS   (Console.CursorX, True);
  OutPipe (Attr2Ansi(Attr, False));

  PausePos   := 1;
  AllowMCI   := Save;
  NoBufFlush := BufSave;
End;

Function TBBSIO.GetStr (Field, Max: Byte; Mode: ShortInt; DefStr: String) : String;
// 1=standard input 2=upper case   3=proper           10=elite
// 4=usa phone num  5=date         6=password         11=num only
// 7=lower cased    8=user defined 9=std input, no CR
Var
  FieldCh   : Char;
  Ch        : Char;
  Str       : String;
  StrPos    : Integer;
  XPos      : Byte;
  Junk      : Integer;
  CurPos    : Integer;
  ArrowSave : Boolean;
  BackPos   : Byte;
  BackSaved : String;

  Procedure WritePart (Str : String);
  Begin
    If (Mode = 6) and (Str <> '') Then
      OutRaw (strRep(TBBSCore(Owner).Theme.PasswordEcho, Length(Str)))
    Else
      OutRaw (Str);
  End;

  Procedure ReDraw;
  Begin
    OutRaw (AnsiMoveX(xPos));

    WritePart (Copy(Str, Junk, Field));
    If UseInField Then OutRaw(Attr2Ansi(TBBSCore(Owner).Theme.InputField2, False));
    WritePart (strRep(FieldCh, Field - Length(Copy(Str, Junk, Field))));
    If UseInField Then OutRaw(Attr2Ansi(TBBSCore(Owner).Theme.InputField1, False));

    OutRaw(AnsiMoveX(xPos + CurPos - 1));
  End;

  Procedure ReDrawPart;
  Begin
    WritePart (Copy(Str, StrPos, Field - CurPos + 1));
    If UseInField Then OutRaw(Attr2Ansi(TBBSCore(Owner).Theme.InputField2, False));
    WritePart (strRep(FieldCh, (Field - CurPos + 1) - Length(Copy(Str, StrPos, Field - CurPos + 1))));
    If UseInField Then OutRaw(Attr2Ansi(TBBSCore(Owner).Theme.InputField1, False));

    OutRaw(AnsiMoveX(xPos + CurPos - 1));
  End;

  Procedure ScrollRight;
  Begin
    Inc (Junk, Field DIV 2); {scroll size}
    If Junk > Length(Str) Then Junk := Length(Str);
    If Junk > Max Then Junk := Max;
    CurPos := StrPos - Junk + 1;
    ReDraw;
  End;

  Procedure ScrollLeft;
  Begin
    Dec (Junk, Field DIV 2); {scroll size}
    If Junk < 1 Then Junk := 1;
    CurPos := StrPos - Junk + 1;
    ReDraw;
  End;

  Procedure Add_Char (Ch : Char);
  Begin
    If CurPos > Field then ScrollRight;

    Insert (Ch, Str, StrPos);
    If StrPos < Length(Str) Then ReDrawPart;

    Inc (StrPos);
    Inc (CurPos);

    WritePart (Ch);
  End;

Begin
  Result := '';

  If TBBSCore(Owner).Shutdown Then Exit;

  If UseInLimit Then Begin
    Field      := InLimit;
    UseInLimit := False;
  End;

  If UseInSize Then Begin
    UseInSize := False;
    If InSize <= Max Then Max := InSize;
  End;

  xPos    := Console.CursorX;
  FieldCh := ' ';

  If Mode < 0 Then Begin
    Mode := Abs(Mode);
    If UseInField and (Graphics = 1) Then Begin
      FieldCh := TBBSCore(Owner).Theme.InputChar;

      OutRaw (Attr2Ansi(TBBSCore(Owner).Theme.InputField2, False) + strRep(FieldCh, Field));
      OutRaw (Attr2Ansi(TBBSCore(Owner).Theme.InputField1, False) + AnsiMoveX(xPos));
    End Else
      UseInField := False;
  End Else
    UseInField := False;

  If Mode = 8 Then
    Case TBBSCore(Owner).Theme.UserInputFmt of
      0 : Mode := 1;
      1 : Mode := 2;
      2 : Mode := 7;
      3 : Mode := 3;
      4 : Mode := 10;
    End;

  ArrowSave  := AllowArrow;
  AllowArrow := (Mode in [1..3, 7..11]) and (Graphics > 0);

  BackPos := 0;
  Str     := DefStr;
  StrPos  := Length(Str) + 1;
  Junk    := StrPos - Field;
  If Junk < 1 Then Junk := 1;
  CurPos  := StrPos - Junk + 1;
  WritePart (Copy(Str, Junk, Field));

  While Not TBBSCore(Owner).ShutDown Do Begin
    Ch := NewGetKey(1000);

    If TBBSCore(Owner).ShutDown Then Exit;

    If Ch = #0 Then Continue;

    If IsArrow Then Begin
      Case Ch of
        #71 : If StrPos > 1 Then Begin
                StrPos := 1;
                Junk   := 1;
                CurPos := 1;
                ReDraw;
              End;
        #72 : If (BackPos < mysMaxInputHistory) And (BackPos < InputPos) Then Begin
                Inc (BackPos);

                If BackPos = 1 Then BackSaved := Str;

                Str := InputData[BackPos];
                StrPos := Length(Str) + 1;
                Junk   := StrPos - Field;
                If Junk < 1 Then Junk := 1;
                CurPos := StrPos - Junk + 1;
                ReDraw;
              End;
        #75 : If StrPos > 1 Then Begin
                If CurPos = 1 Then ScrollLeft;
                Dec (StrPos);
                Dec (CurPos);
                If CurPos < 1 then CurPos := 1;
                OutRaw(AnsiMoveX(Console.CursorX - 1));
              End;
        #77 : If StrPos < Length(Str) + 1 Then Begin
                If (CurPos = Field) and (StrPos < Length(Str)) Then ScrollRight;
                Inc (CurPos);
                Inc (StrPos);
                OutRaw(AnsiMoveX(Console.CursorX + 1));
              End;
        #79 : Begin
                StrPos := Length(Str) + 1;
                Junk   := StrPos - Field;
                If Junk < 1 Then Junk := 1;
                CurPos := StrPos - Junk + 1;
                ReDraw;
              End;
        #80 : If (BackPos > 0) Then Begin
                Dec (BackPos);

                If BackPos = 0 Then
                  Str := BackSaved
                Else
                  Str := InputData[BackPos];

                StrPos := Length(Str) + 1;
                Junk   := StrPos - Field;
                If Junk < 1 Then Junk := 1;
                CurPos := StrPos - Junk + 1;
                ReDraw;
              End;
        #83 : If (StrPos <= Length(Str)) and (Length(Str) > 0) Then Begin
                Delete(Str, StrPos, 1);
                ReDrawPart;
              End;
      End;
    End Else
      Case Ch of
        #02 : ReDraw;
        #08 : If StrPos > 1 Then Begin
                Dec (StrPos);
                Delete (Str, StrPos, 1);
                If CurPos = 1 Then
                  ScrollLeft
                Else
                If StrPos = Length(Str) + 1 Then Begin
                  If UseInField Then OutRaw(Attr2Ansi(TBBSCore(Owner).Theme.InputField2, False));
                  OutRaw (#8 + FieldCh + #8);
                  If UseInField Then OutRaw(Attr2Ansi(TBBSCore(Owner).Theme.InputField1, False));
                  Dec (CurPos);
                End Else Begin
                  OutRaw (#8);
                  Dec (CurPos);
                  ReDrawPart;
                End;
              End;
        #13 : Break;
        ^Y  : Begin
                Str    := '';
                StrPos := 1;
                Junk   := 1;
                CurPos := 1;
                ReDraw;
              End;
        #31 : ReDraw;
        #32..
        #254: If Length(Str) < Max Then
              Case Mode of
                1 : Add_Char (Ch);
                2 : Add_Char (UpCase(Ch));
                3 : Begin
                      If (CurPos = 1) or (Str[StrPos-1] in [' ', '.']) Then
                        Ch := UpCase(Ch)
                      Else
                        Ch := LoCase(Ch);
                      Add_Char(Ch);
                    End;
                4 : If (Ord(Ch) > 47) and (Ord(Ch) < 58) Then
                      Case StrPos of
                        4,8 : Begin
                                Add_Char ('-');
                                Add_Char (Ch);
                              End;
                        3,7 : Begin
                                Add_Char (Ch);
                                Add_Char ('-');
                              End;
                      Else
                        Add_Char(Ch);
                      End;
                5 : If (Ord(Ch) > 47) and (Ord(Ch) < 58) Then
                      Case StrPos of
                        2,5 : Begin
                                Add_Char (Ch);
                                Add_Char ('/');
                              End;
                        3,6 : Begin
                                Add_Char ('/');
                                Add_Char (Ch);
                              End;
                      Else
                        Add_Char (Ch);
                      End;
                6 : Add_Char(UpCase(Ch));
                7 : Add_Char(LoCase(Ch));
                9 : Add_Char(Ch);
                10: If Pos(UpCase(Ch), 'AEIOUY') > 0 Then
                      Add_Char(LoCase(Ch))
                    Else
                      Add_Char(UpCase(Ch));
                11: If Ch in ['0'..'9', '+', '-', '.'] Then
                      Add_Char(Ch);
              End;
      End;
  End;

  For Junk := 4 DownTo 2 Do
    InputData[Junk] := InputData[Junk - 1];

  InputData[1] := Str;

  If InputPos < mysMaxInputHistory Then Inc(InputPos);

  If Mode = 9 Then
    OutFull ('|16')
  Else
    OutFullLn ('|16');

  If Mode = 5 Then
    Case TBBSCore(Owner).User.ThisUser.DateType of
      2 : Str := Copy(Str, 4, 2) + '/' + Copy(Str, 1, 2) + '/' + Copy(Str, 7, 2);
      3 : Str := Copy(Str, 4, 2) + '/' + Copy(Str, 7, 2) + '/' + Copy(Str, 1, 2);
    End;

  UseInField := True;
  AllowArrow := ArrowSave;
  Result     := Str;
End;

Procedure TBBSIO.BufAddChar (Ch: Char);
Begin
  OutBuffer[OutBufPos] := Ch;
  Terminal.Process(Ch);

  If OutBufPos = TBBSIOBufferSize Then Begin
    TBBSCore(Owner).Client.WriteBuf(OutBuffer, TBBSIOBufferSize + 1);
    OutBufPos := 0;
  End Else
    Inc (OutBufPos);
End;

Procedure TBBSIO.BufAddStr (Str: String);
Var
  Count : LongInt;
Begin
  For Count := 1 to Length(Str) Do
    BufAddChar(Str[Count]);
End;

Procedure TBBSIO.BufFlush;
Begin
  If OutBufPos > 0 Then Begin
    TBBSCore(Owner).Client.WriteBuf(OutBuffer, OutBufPos);
    OutBufPos := 0;
  End;
End;

Procedure TBBSIO.OutRaw (Str: String);
Begin
  TBBSCore(Owner).Client.WriteStr(Str);
  Terminal.ProcessBuf(Str[1], Length(Str));
End;

Procedure TBBSIO.OutRawLn (Str: String);
Begin
  OutRaw (Str + #13#10);
  Inc (PausePos);
End;

Function TBBSIO.OutYesNo (Mode: Boolean) : String;
Var
  Str : String;
Begin
  Str := TBBSCore(Owner).GetPrompt(190);

  If Mode Then
    Result := strWordGet(1, Str, ' ')
  Else
    Result := strWordGet(2, Str, ' ');
End;

Procedure TBBSIO.OutBS (Num: Byte; Erase: Boolean);
Var
  Count : LongInt;
Begin
  For Count := 1 to Num Do
    If Erase Then
      BufAddStr(#08#32#08)
    Else
      BufAddChar(#8);

  BufFlush;
End;

Procedure TBBSIO.OutPipe (Str: String);
Var
  Count : LongInt;
  Code  : String[2];
Begin
  Count := 1;

  While Count <= Length(Str) Do Begin
    If (Str[Count] = '|') and (Count < Length(Str) - 1) Then Begin
      Code := Copy(Str, Count + 1, 2);

      If Code = '00' Then BufAddStr(Pipe2Ansi(0)) Else
      If Code = '01' Then BufAddStr(Pipe2Ansi(1)) Else
      If Code = '02' Then BufAddStr(Pipe2Ansi(2)) Else
      If Code = '03' Then BufAddStr(Pipe2Ansi(3)) Else
      If Code = '04' Then BufAddStr(Pipe2Ansi(4)) Else
      If Code = '05' Then BufAddStr(Pipe2Ansi(5)) Else
      If Code = '06' Then BufAddStr(Pipe2Ansi(6)) Else
      If Code = '07' Then BufAddStr(Pipe2Ansi(7)) Else
      If Code = '08' Then BufAddStr(Pipe2Ansi(8)) Else
      If Code = '09' Then BufAddStr(Pipe2Ansi(9)) Else
      If Code = '10' Then BufAddStr(Pipe2Ansi(10)) Else
      If Code = '11' Then BufAddStr(Pipe2Ansi(11)) Else
      If Code = '12' Then BufAddStr(Pipe2Ansi(12)) Else
      If Code = '13' Then BufAddStr(Pipe2Ansi(13)) Else
      If Code = '14' Then BufAddStr(Pipe2Ansi(14)) Else
      If Code = '15' Then BufAddStr(Pipe2Ansi(15)) Else
      If Code = '16' Then BufAddStr(Pipe2Ansi(16)) Else
      If Code = '17' Then BufAddStr(Pipe2Ansi(17)) Else
      If Code = '18' Then BufAddStr(Pipe2Ansi(18)) Else
      If Code = '19' Then BufAddStr(Pipe2Ansi(19)) Else
      If Code = '20' Then BufAddStr(Pipe2Ansi(20)) Else
      If Code = '21' Then BufAddStr(Pipe2Ansi(21)) Else
      If Code = '22' Then BufAddStr(Pipe2Ansi(22)) Else
      If Code = '23' Then BufAddStr(Pipe2Ansi(23)) Else
      If Code = 'T0' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[0], False)) Else
      If Code = 'T1' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[1], False)) Else
      If Code = 'T2' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[2], False)) Else
      If Code = 'T3' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[3], False)) Else
      If Code = 'T4' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[4], False)) Else
      If Code = 'T5' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[5], False)) Else
      If Code = 'T6' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[6], False)) Else
      If Code = 'T7' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[7], False)) Else
      If Code = 'T8' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[8], False)) Else
      If Code = 'T9' Then BufAddStr(Attr2Ansi(TBBSCore(Owner).Theme.Colors[9], False)) Else
        BufAddStr(Str[Count] + Code);

      Inc (Count, 2);
    End Else
      BufAddChar(Str[Count]);

    Inc (Count);
  End;

  If Not NoBufFlush Then BufFlush;
End;

Procedure TBBSIO.OutPipeLn (Str: String);
Begin
  OutPipe (Str + #13#10);
  Inc (PausePos);
End;

Procedure TBBSIO.OutFull (Str: String);
Var
  Count : LongInt;
  Temp  : LongInt;
  Saved : Boolean;
  D : DirStr;
  N : NameStr;
  E : ExtStr;
Begin
  Saved      := NoBufFlush;
  NoBufFlush := True;
  Count      := 1;

  While Count <= Length(Str) Do Begin
    If (Str[Count] = '|') and (Count < Length(Str) - 1) Then Begin
      OutPipe(Mci2Str(Copy(Str, Count + 1, 2)));
      Inc (Count, 2);

      If FormatMCI Then Begin
        If (FormatType = 5) or (FormatType = 15) Then Begin
          FormatMCI := False;

          Temp := Count + 1;
          While (Str[Temp] <> '|') and (Temp <= Length(Str)) Do
            Inc (Temp);

          FSplit (strStripLow(Copy(Str, Count + 1, Temp - Count - 1)), D, N, E);

          If FormatType = 5 Then
            OutFile (TBBSCore(Owner).Theme.PathText + N + E)
          Else
            ExecuteMPE(Owner, {TBBSCore(Owner).Theme.PathScripts} D + N + E);

          Count := Temp + 1;

          Continue;
        End;

        FormatLen := strS2I(Copy(Str, Count + 1, 2));
        Inc (Count, 2);

        Case FormatType of
          4 : Begin
                Inc (Count);
                FormatMCI := False;
                OutPipe (strRep(Str[Count], FormatLen));
              End;
          6 : Begin
                OutPipe(AnsiMoveX(FormatLen));
                FormatMCI := False;
              End;
          7 : Begin
                OutPipe(AnsiMoveY(FormatLen));
                FormatMCI := False;
              End;
          8 : Begin
                OutPipe(AnsiMoveY(Console.CursorY - FormatLen));
                FormatMCI := False;
              End;
          9 : Begin
                OutPipe(AnsiMoveY(Console.CursorY + FormatLen));
                FormatMCI := False;
              End;
          10: Begin
                OutPipe(AnsiMoveX(Console.CursorX + FormatLen));
                FormatMCI := False;
              End;
          11: Begin
                OutPipe(AnsiMoveX(Console.CursorX - FormatLen));
                FormatMCI := False;
              End;
          12: Begin
                UseInLimit := True;
                InLimit    := FormatLen;
                FormatMCI  := False;
              End;
          13: Begin
                PausePos  := FormatLen;
                FormatMCI := False;
              End;
          14: Begin
                UseInSize := True;
                InSize    := FormatLen;
                FormatMCI := False;
              End;
        End;
      End;
    End Else
      BufAddChar(Str[Count]);

    Inc (Count);
  End;

  If Not Saved Then Begin
    NoBufFlush := False;
    BufFlush;
  End;
End;

Procedure TBBSIO.OutFullLn (Str: String);
Begin
  OutFull (Str + #13#10);
  Inc (PausePos);
End;

Function TBBSIO.OutFile (Str: String) : Boolean;
Var
  Ext      : String[4];
  Buffer   : Array[1..4096] of Char;
  BufPos   : LongInt;
  BufEnd   : LongInt;
  DispFile : File;
  Done     : Boolean;

  Function CheckFileInPath (Path: String) : Boolean;
  Var
    Temp : String;
  Begin
    Result := False;
    Temp   := Path + Str;

    If (Graphics = 1) and (FileExist(Temp + '.ans')) Then Begin
      Ext    := '.ans';
      Str    := Temp;
      Result := True;
    End Else
    If FileExist(Temp + '.asc') Then Begin
      Ext    := '.asc';
      Str    := Temp;
      Result := True;
    End;
  End;

  Function GetChar : Char;
  Begin
    If BufPos = BufEnd Then Begin
      ioBlockRead (DispFile, Buffer, SizeOf(Buffer), BufEnd);
      BufPos := 0;

      If BufEnd = 0 Then Begin
        Buffer[1] := #26;
        Done      := True;
      End;
    End;

    Inc (BufPos);
    Result := Buffer[BufPos];
  End;

Var
  RandChar : Char;
  OldPause : Boolean;
  OldFlush : Boolean;
  Ch       : Char;
  Code     : String[2];
Begin
  Result := False;
  Ext    := '';

  If Str = '' Then Exit;

  If (Pos(PathSep, Str) > 0) or (Pos('.', Str) > 0) Then Begin
    If Not FileExist(Str) Then
      If Not CheckFileInPath('') Then Exit;
  End Else Begin
    If Not CheckFileInPath(TBBSCore(Owner).Theme.PathText) Then
      If TBBSCore(Owner).Theme.PathFallBack Then Begin
        If Not CheckFileInPath(bbsConfig.PathText) Then Exit;
      End Else
        Exit;

    If FileExist(Str + Copy(Ext, 1, 3) + 'a') Then Begin
      Repeat
        RandChar := Chr(Random(25) + 97);
      Until FileExist(Str + Copy(Ext, 1, 3) + RandChar);
      Ext[4] := RandChar;
    End;
  End;

  Result     := True;
  Done       := False;
  OldPause   := AllowPause;
  OldFlush   := NoBufFlush;
  NoBufFlush := True;
  AllowPause := True;
  PausePos   := 1;
  BufPos     := 0;
  BufEnd     := 0;

  Assign  (DispFile, Str + Ext);
  ioReset (DispFile, 1, fmReadWrite + fmDenyNone);

  Repeat
    Ch := GetChar;

    Case Ch of
      #10 : Begin
              BufAddChar(#10);

              If PausePos < 255 Then
                Inc (PausePos);

              If (PausePos >= TBBSCore(Owner).User.ThisUser.ScreenSize) and (AllowPause) Then
                Case MorePrompt of
                  'N' : Break;
                  'C' : AllowPause := False;
                End;
            End;
      #26 : Break;
      '|' : Begin
              Code := GetChar + GetChar;
              OutPipe(Mci2Str(Code));
              //BufAddStr(Mci2Str(Code));

              If FormatMCI Then Begin
                If (FormatType = 5) or (FormatType = 15) Then Begin
                  FormatMCI := False;
                  Str       := '';

                  While Not Done Do Begin
                    Ch := GetChar;
                    If Ch in [#10, '|'] Then Break;
                    Str := Str + Ch;
                  End;

                  If FormatType = 5 Then
                    Self.OutFile (TBBSCore(Owner).Theme.PathText + strStripLow(Str))
                  Else
                    ExecuteMPE(Owner, {TBBSCore(Owner).Theme.PathScripts +} strStripLow(Str));

                  Continue;
                End;

                FormatLen := strS2I(GetChar + GetChar);

                Case FormatType of
                  4 : Begin
                        BufAddStr(strRep(GetChar, FormatLen));
                        FormatMCI := False; //^^^^ should be added to buffer
                      End;
                  6 : Begin
                        BufAddStr(AnsiMoveX(FormatLen));
                        FormatMCI := False;
                      End;
                  7 : Begin
                        BufAddStr(AnsiMoveY(FormatLen));
                        FormatMCI := False;
                      End;
                  8 : Begin
                        BufAddStr(AnsiMoveY(Console.CursorY - FormatLen));
                        FormatMCI := False;
                      End;
                  9 : Begin
                        BufAddStr(AnsiMoveY(Console.CursorY + FormatLen));
                        FormatMCI := False;
                      End;
                  10: Begin
                        BufAddStr(AnsiMoveX(Console.CursorX + FormatLen));
                        FormatMCI := False;
                      End;
                  11: Begin
                        BufAddStr(AnsiMoveX(Console.CursorX - FormatLen));
                        FormatMCI := False;
                      End;
                  12: Begin
                        UseInLimit := True;
                        InLimit    := FormatLen;
                        FormatMCI  := False;
                      End;
                  13: Begin
                        PausePos  := FormatLen;
                        FormatMCI := True;
                      End;
                  14: Begin
                        UseInSize := True;
                        InSize    := FormatLen;
                        FormatMCI := False;
                      End;
                End;
              End;
            End;
    Else
      BufAddChar(Ch);
    End;

(*
    If TBBSCore(Owner).Client.DataWaiting Then Begin
      TBBSCore(Owner).Client.ReadBuf(Ch, 1);
      If Ch = ' ' Then Break;
    End;
*)
  Until Done or TBBSCore(Owner).Shutdown;

  Close (DispFile);

  BufFlush;

  AllowPause := OldPause;
  NoBufFlush := OldFlush;
End;

Function TBBSIO.Pipe2Ansi (Color: Byte): String;
Begin
//  BufFlush;

  Result := '';

  If Graphics = 0 Then Exit;

  Case Color of
    00: Result := #27 + '[0;30m';
    01: Result := #27 + '[0;34m';
    02: Result := #27 + '[0;32m';
    03: Result := #27 + '[0;36m';
    04: Result := #27 + '[0;31m';
    05: Result := #27 + '[0;35m';
    06: Result := #27 + '[0;33m';
    07: Result := #27 + '[0;37m';
    08: Result := #27 + '[1;30m';
    09: Result := #27 + '[1;34m';
    10: Result := #27 + '[1;32m';
    11: Result := #27 + '[1;36m';
    12: Result := #27 + '[1;31m';
    13: Result := #27 + '[1;35m';
    14: Result := #27 + '[1;33m';
    15: Result := #27 + '[1;37m';
  End;

  If Color in [00..07] Then Color := (Console.TextAttr SHR 4) and 7 + 16;

  Case Color of
    16: Result := Result + #27 + '[40m';
    17: Result := Result + #27 + '[44m';
    18: Result := Result + #27 + '[42m';
    19: Result := Result + #27 + '[46m';
    20: Result := Result + #27 + '[41m';
    21: Result := Result + #27 + '[45m';
    22: Result := Result + #27 + '[43m';
    23: Result := Result + #27 + '[47m';
  End;
End;

Function TBBSIO.Attr2Ansi (Attr: Byte; Forced: Boolean) : String;
Begin
  Result := '';

  If Graphics = 0 Then Exit;

  If Forced or ((Console.TextAttr and $F) <> (Attr and $F)) Then
    Result := Pipe2Ansi(Attr and $F);

  If Forced or (((Console.TextAttr shr 4) and 7) <> ((Attr shr 4) and 7)) Then
    Result := Result + Pipe2Ansi(((Attr shr 4) and 7) + 16);
End;

Function TBBSIO.AnsiClear : String;
Begin
  If Graphics = 0 Then
    Result := #12
  Else
    Result := #27 + '[2J' + #27 + '[H';

  PausePos := 1;
End;

Function TBBSIO.AnsiClrEOL : String;
Begin
  Result := #27 + '[K';
End;

Function TBBSIO.AnsiMoveY (Y: Byte) : String;
Var
  Temp : Byte;
Begin
  Result := '';

  If Graphics = 0 Then Exit;

  Temp := Console.CursorY;

  If Y > Temp Then Result := #27 + '[' + strI2S(Y - Temp) + 'B' Else
  If Y < Temp Then Result := #27 + '[' + strI2S(Temp - Y) + 'A';
End;

Function TBBSIO.AnsiGotoXY (X, Y: Byte) : String;
Begin
  If Graphics = 0 Then Exit;

  If X = 0 Then X := Console.CursorX;
  If Y = 0 Then Y := Console.CursorY;

  Result := #27 + '[' + strI2S(Y) + ';' + strI2S(X) + 'H';
End;

Function TBBSIO.AnsiMoveX (X: Byte) : String;
Var
  Temp : Byte;
Begin
  Result := '';

  If Graphics = 0 Then Exit;

  Temp := Console.CursorX;

  If X > Temp Then Result := #27 + '[' + strI2S(X - Temp) + 'C' Else
  If X < Temp Then Result := #27 + '[' + strI2S(Temp - X) + 'D';
End;

Function TBBSIO.Mci2Str (Code: String) : String;
Var
  CodeVal : Byte;
Begin
  Result := '|' + Code;

  If Not AllowMCI Then Exit;

  CodeVal := strS2I(Code);

  Case Code[1] of
    '$'  : Case Code[2] of
             'C' : Begin
                     FormatMCI  := True;
                     FormatType := 3;
                     Result     := '';
                     Exit;
                   End;
             'D' : Begin
                     FormatMCI  := True;
                     FormatType := 4;
                     Result     := '';
                     Exit;
                   End;
             'L' : Begin
                     FormatMCI  := True;
                     FormatType := 2;
                     Result     := '';
                     Exit;
                   End;
             'R' : Begin
                     FormatMCI  := True;
                     FormatType := 1;
                     Result     := '';
                     Exit;
                   End;
           End;
    '&'  : If Code[2] in ['A'..'Z'] Then Result := PromptInfo[Code[2]];
    '0',
    '1',
    '2'  : If (Code[2] = '0') or (CodeVal > 0) and (CodeVal < 24) Then
             Result := Pipe2Ansi(CodeVal);
    'A'  : Case Code[2] of
             'G' : Result := strI2S(DaysAgo(TBBSCore(Owner).User.ThisUser.Birthdate) DIV 365);
             'S' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.AutoSig);
             'V' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.Available);
           End;
    'B'  : Case Code[2] of
             'E' : Result := ^G;
             'I' : Result := DateJulian2Str(TBBSCore(Owner).User.ThisUser.Birthdate, TBBSCore(Owner).User.ThisUser.DateType);
             'N' : Result := bbsConfig.BBSName;
             'S' : Result := #08#32#08;
             'T' : Result := #08;
           End;
    'C'  : Case Code[2] of
             'L' : Result := AnsiClear;
             'M' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.FSNodeChat);
             'R' : Begin
                     Result := #13#10;
                     Inc (PausePos);
                   End;
             'S' : Result := strI2S(TBBSCore(Owner).User.ThisUser.Calls);
             'T' : Result := strI2S(TBBSCore(Owner).User.ThisUser.CallsToday);
           End;
    'D'  : Case Code[2] of
             'A' : Result := DateDos2Str(CurDateDos, TBBSCore(Owner).User.ThisUser.DateType);
             'E' : Begin
                     BufFlush;
                     WaitMS(500);
                     Result := '';
                     Exit;
                   End;
             'F' : Begin
                     FormatMCI  := True;
                     FormatType := 5;
                     Result     := '';
                     Exit;
                   End;
             'H' : Begin
                     BufFlush;
                     WaitMS(250);
                     Result := '';
                     Exit;
                   End;
             'K' : Result := strI2S(TBBSCore(Owner).User.ThisUser.DownloadKB);
             'L' : Result := strI2S(TBBSCore(Owner).User.ThisUser.Downloads);
             'T' : Result := strI2S(TBBSCore(Owner).User.ThisUser.DlsToday);
             'X' : Begin
                     FormatMCI  := True;
                     FormatType := 15;
                     Result     := '';
                     Exit;
                   End;
           End;
    'F'  : Case Code[2] of
             'B' : Result := TBBSCore(Owner).Files.FBase.Name;
             'G' : Result := TBBSCore(Owner).Files.FGroup.Desc;
             'K' : Result := strI2S(TBBSCore(Owner).User.ThisUser.UploadKB);
             'O' : Result := DateDos2Str(TBBSCore(Owner).User.ThisUser.FirstCall, TBBSCore(Owner).User.ThisUser.DateType);
             'U' : Result := strI2S(TBBSCore(Owner).User.ThisUser.Uploads);
           End;
    'H'  : Case Code[2] of
             'K' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.HotKeys);
           End;
    'I'  : Case Code[2] of
             'F' : Begin
                     UseInField := False;
                     Result     := '';
                   End;
             'L' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.Invisible);
             'N' : Begin
                     FormatMCI  := True;
                     FormatType := 12;
                     Result     := '';
                     Exit;
                   End;
             'S' : Begin
                     FormatMCI  := True;
                     FormatType := 14;
                     Result     := '';
                     Exit;
                   End;
           End;
    'K'  : Case Code[2] of
             'T' : Result := strI2S(TBBSCore(Owner).User.ThisUser.DLkbToday);
           End;
    'L'  : Case Code[2] of
             'O' : Result := DateDos2Str(TBBSCore(Owner).User.ThisUser.LastCall, TBBSCore(Owner).User.ThisUser.DateType);
           End;
    'M'  : Case Code[2] of
             'B' : Result := TBBSCore(Owner).Msgs.MBase.Name;
             'E' : Result := strI2S(TBBSCore(Owner).User.ThisUser.Emails);
             'G' : Result := TBBSCore(Owner).Msgs.MGroup.Desc;
             'N' : Result := bbsConfig.NetDesc[TBBSCore(Owner).Msgs.MBase.NetAddr];
             'P' : Result := strI2S(TBBSCore(Owner).User.ThisUser.MsgPosts);
             'U' : Begin
                     If TBBSCore(Owner).Menu.Data <> NIL Then
                       Result := TBBSCore(Owner).Menu.Data.Info.Description
                     Else
                       Result := '';
                   End;
           End;
    'N'  : Case Code[2] of
             'A' : Result := strI2S(TBBSCore(Owner).Owner.Manager.ClientActive);
             'D' : Result := strI2S(TBBSCore(Owner).Node);
             'P' : Result := strI2S(Round(TBBSCore(Owner).Owner.Manager.ClientActive * 100 / BbsConfig.InetTNMax));
             'T' : Result := strI2S(BbsConfig.InetTNMax);
           End;
    'O'  : Case Code[2] of
             'S' : Result := mysOSID;
           End;
    'P'  : Case Code[2] of
             'A' : Begin
                     PausePrompt;
                     Result := '';
                   End;
             'C' : Begin
                     Result := '0';
                     If TBBSCore(Owner).User.ThisUser.Calls > 0 Then
                       Result := strI2S(Round(TBBSCore(Owner).User.ThisUser.MsgPosts / TBBSCore(Owner).User.ThisUser.Calls * 100));
                   End;
             'I' : Result := '|';
             'N' : Begin
                     BufFlush;
                     NewGetKey(0);
                     Result := '';
                     Exit;
                   End;
             'O' : Begin
                     AllowPause := False;
                     Result     := '';
                   End;
             'W' : Result := strI2S(bbsConfig.PWChange);
           End;
    'R'  : Case Code[2] of
             'D' : Result := strI2S(TBBSCore(Owner).User.Security.DLRatio);
             'K' : Result := strI2S(TBBSCore(Owner).User.Security.DLkRatio);
             'P' : Begin
                     FormatMCI  := True;
                     FormatType := 13;
                     Result     := '';
                     Exit;
                   End;
           End;
    'S'  : Case Code[2] of
             'B' : Result := strI2S(TBBSCore(Owner).User.Security.MaxTB);
             'C' : Result := strI2S(TBBSCore(Owner).User.Security.MaxCalls);
             'D' : Result := TBBSCore(Owner).User.Security.Desc;
             'K' : Result := strI2S(TBBSCore(Owner).User.Security.MaxDLk);
             'L' : Result := strI2S(TBBSCore(Owner).User.ThisUser.Security);
             'N' : Result := bbsConfig.SysopName;
             'P' : Begin
                     Result := '0';
                     If TBBSCore(Owner).User.Security.PCRatio > 0 Then
                       Result := strI2S(Round(TBBSCore(Owner).User.Security.PCRatio / 100 * 100));
                   End;
             'T' : Result := strI2S(TBBSCore(Owner).User.Security.Time);
             'X' : Result := strI2S(TBBSCore(Owner).User.Security.MaxDLs);
           End;
    'T'  : Case Code[2] of
             '0' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[0], False);
             '1' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[1], False);
             '2' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[2], False);
             '3' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[3], False);
             '4' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[4], False);
             '5' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[5], False);
             '6' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[6], False);
             '7' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[7], False);
             '8' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[8], False);
             '9' : Result := Attr2Ansi(TBBSCore(Owner).Theme.Colors[9], False);
             'B' : Result := strI2S(TBBSCore(Owner).User.ThisUser.TimeBank);
             'I' : Result := TimeDos2Str(CurDateDos, True);
             'L' : Result := strI2S(TBBSCore(Owner).User.TimeLeft);
             'O' : Result := strI2S(TBBSCore(Owner).User.TimeOn);
           End;
    'U'  : Case Code[2] of
             '1'..
             '9' : Result := TBBSCore(Owner).User.ThisUser.Optional[strS2I(Code[2])];
             '0' : Result := TBBSCore(Owner).User.ThisUser.Optional[10];
             '#' : Result := strI2S(TBBSCore(Owner).User.ThisUser.UserID);
             'A' : Result := TBBSCore(Owner).User.ThisUser.Street;
             'B' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.FSFileList);
             'C' : Result := TBBSCore(Owner).User.ThisUser.CityState;
             'D' : Result := TBBSCore(Owner).User.ThisUser.DataPhone;
             'E' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.FSEditor);
             'F' : Result := strWordGet(TBBSCore(Owner).User.ThisUser.DateType, TBBSCore(Owner).GetPrompt(32), ' ');
             'H' : Result := TBBSCore(Owner).User.ThisUser.Handle;
             'I' : Result := TBBSCore(Owner).User.ThisUser.UserInfo;
             'J' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.FSMsgReader);
             'K' : Result := TBBSCore(Owner).User.ThisUser.Email;
             'M' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.FSMsgIndex);
             'N' : Result := TBBSCore(Owner).User.ThisUser.RealName;
             'O' : Result := TBBSCore(Owner).User.ThisUser.ChatName;
             'P' : Result := TBBSCore(Owner).User.ThisUser.HomePhone;
             'Q' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.QuoteWindow);
             'S' : Result := strI2S(TBBSCore(Owner).User.ThisUser.ScreenSize);
             'T' : Result := TBBSCore(Owner).Theme.Description;
             'W' : Result := OutYesNo(TBBSCore(Owner).User.ThisUser.FSMsgEIndex);
             'X' : Result := TBBSCore(Owner).Client.PeerIP;
             'Y' : Result := TBBSCore(Owner).Client.PeerName;
             'Z' : Result := TBBSCore(Owner).User.ThisUser.ZipCode;
           End;
    'V'  : Case Code[2] of
             'R' : Result := mysVersionText;
           End;
    'X'  : Case Code[2] of
             'D' : If DateValid(TBBSCore(Owner).User.ThisUser.Expires) Then
                     Result := strI2S(Abs(CurDateJulian - DateStr2Julian(TBBSCore(Owner).User.ThisUser.Expires)))
                   Else
                     Result := '0';
             'S' : Result := strI2S(TBBSCore(Owner).User.ThisUser.ExpiresTo);
             'X' : Result := '';
           End;
    '['  : Case Code[2] of
             'A' : Begin
                     FormatMCI  := True;
                     FormatType := 8;
                     Result     := '';
                     Exit;
                   End;
             'B' : Begin
                     FormatMCI  := True;
                     FormatType := 9;
                     Result     := '';
                     Exit;
                   End;
             'C' : Begin
                     FormatMCI  := True;
                     FormatType := 10;
                     Result     := '';
                     Exit;
                   End;
             'D' : Begin
                     FormatMCI  := True;
                     FormatType := 11;
                     Result     := '';
                     Exit;
                   End;
             'K' : Result := AnsiClrEOL;
             'X' : Begin
                     FormatMCI  := True;
                     FormatType := 6;
                     Result     := '';
                     Exit;
                   End;
             'Y' : Begin
                     FormatMCI  := True;
                     FormatType := 7;
                     Result     := '';
                     Exit;
                   End;
           End;
  End;

  If FormatMCI Then Begin
    FormatMCI := False;
    Case FormatType of
      1 : Result := strPadR(Result, FormatLen + Length(Result) - strMCILen(Result), ' ');
      2 : Result := strPadL(Result, FormatLen + Length(Result) - strMCILen(Result), ' ');
      3 : Result := strPadC(Result, FormatLen + Length(Result) - strMCILen(Result), ' ');
    End;
  End;
End;

Procedure TBBSIO.AskGraphics (Prompt: String);
Var
  Ch   : Char;
  Keys : String;
Begin
  Keys := strWordGet(1, Prompt, ' ');

  Delete (Prompt, 1, Pos(' ', Prompt));

  OutFull(Prompt);

  Ch := OneKey(Keys, True);

  If Ch = Keys[1] Then Graphics := 0 Else
  If Ch = Keys[2] Then Graphics := 1;
End;

Procedure TBBSIO.DetectGraphics;

  Procedure Detect;
  Var
    Str   : String[2];
    Count : Byte;
  Begin
    OutFull(TBBSCore(Owner).GetPrompt(2));
    OutRaw (#27 + '[6n');

    For Count := 1 to 5 Do
      If TBBSCore(Owner).Client.WaitForData(1000) > 0 Then Begin
        TBBSCore(Owner).Client.ReadBuf(Str[1], 2);
        If (Str[1] = #27) and (Str[2] = '[') Then Begin
          Graphics := 1;
          OutFullLn (TBBSCore(Owner).GetPrompt(4));
          TBBSCore(Owner).Client.FInBufPos := 0;
          TBBSCore(Owner).Client.FInBufEnd := 0;
          Exit;
        End;
      End;

    Graphics := 0;
    OutFullLn (TBBSCore(Owner).GetPrompt(3));
  End;

Begin
  If Not TBBSCore(Owner).Theme.AllowANSI Then Begin
    Graphics := 0;
    Exit;
  End;

  Case bbsConfig.DefTermMode of
    0 : Detect;
    1 : Begin
          Detect;
          If Graphics = 0 Then AskGraphics(TBBSCore(Owner).GetPrompt(5));
        End;
    2 : AskGraphics(TBBSCore(Owner).GetPrompt(5));
    3 : Graphics := 1;
    4 : Graphics := 0;
  End;
End;

Function TBBSIO.GetYN (Str: String; Def: Boolean) : Boolean;
Var
  Ch        : Char;
  Keys      : String[2];
  YesText   : Array[False..True] of String;
  ArrowSave : Boolean;
  PosX      : Byte;

  Procedure ShowBar;
  Begin
    OutRaw(AnsiMoveX(PosX));

    If Def Then
      OutFull(TBBSCore(Owner).GetPrompt(11))
    Else
      OutFull(TBBSCore(Owner).GetPrompt(12));
  End;

Begin
  OutFull (Str);

  Result         := False;
  Str            := TBBSCore(Owner).GetPrompt(10);
  Keys           := strUpper(strWordGet(1, Str, ' '));
  YesText[True]  := strWordGet(2, Str, ' ');
  YesText[False] := strWordGet(3, Str, ' ');

  If TBBSCore(Owner).Theme.LightBarYN And (Graphics > 0) Then Begin
    ArrowSave  := AllowArrow;
    AllowArrow := True;
    PosX       := Console.CursorX;

    While Not TBBSCore(Owner).ShutDown Do Begin
      ShowBar;

      Ch := UpCase(NewGetKey(0));

      If IsArrow Then Begin
        If Ch = #77 Then Def := False;
        If Ch = #75 Then Def := True;
      End Else Begin
        If Ch = #13 Then Break Else
        If Ch = #32 Then Def := Not Def Else
        If Pos(Ch, Keys) > 0 Then Begin
          Def := Ch = Keys[1];
          ShowBar;
          Break;
        End;
      End;
    End;

    OutRawLn('');

    AllowArrow := ArrowSave;
  End Else Begin
    OutFull (YesText[Def]);

    Ch := OneKey(#13 + Keys, False);

    OutBS(Length(YesText[Def]), True);

    If Ch = Keys[1] Then Def := True;
    If Ch = Keys[2] Then Def := False;

    OutFullLn(YesText[Def]);
  End;

  Result := Def;
End;

Procedure TBBSIO.RemoteRestore (Var S: TConsoleImageRec; Clear: Boolean);
Var
  Saved : Boolean;
  X, Y  : Byte;
Begin
  Saved      := NoBufFlush;
  NoBufFlush := True;

  If Clear Then BufAddStr(AnsiClear);

  For Y := S.Y1 to S.Y2 Do Begin
    BufAddStr(AnsiGotoXY(S.X1, Y));
    For X := S.X1 to S.X2 Do Begin
      If (X = S.X2) And (Y = S.Y2) Then Break;
      BufAddStr(Attr2Ansi(S.Data[Y][X].Attributes, False));
      BufAddStr(Char(S.Data[Y][X].UnicodeChar));
    End;
  End;

  BufAddStr (AnsiGotoXY(S.CursorX, S.CursorY));
  BufAddStr (Attr2Ansi(S.CursorA, False));
  BufFlush;

  NoBufFlush := Saved;
End;

End.
