{$I M_OPS.PAS}

Unit BBS_MenuRun;

Interface

Uses
  BBS_Common,
  BBS_MenuData,
  MPL_Execute;

Type
  TMenuEngine = Class
    Owner      : Pointer;
    Data       : TMenuData;
    Stack      : Array[1..mysMaxMenuStack] of String[20];
    StackPos   : Byte;
    MenuName   : String[20];
    MenuOld    : String[20];
    ExtKeys    : String;
    UseHotKeys : Boolean;
    ReDraw     : Boolean;
    UseTimer   : Boolean;
    NextReDraw : Boolean;
    SetAction  : Boolean;
    UseLongKey : Boolean;

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;
    Procedure   ToggleAccessFlags (Cmd: String; Var Flags: RecAccessFlags);
    Function    MenuGetKey : Char;
    Function    LoadMenu (Forced: Boolean) : Boolean;
    Procedure   ExecuteMenu (Load, Forced, Action: Boolean);
    Function    ExecuteCommandList (Num, JumpID: LongInt) : Byte;
    Function    ExecuteByHotkey (Key: String) : Boolean;
    Function    ExecuteCommand (Cmd, CmdData: String) : Boolean;
    Function    ShowMenu : Boolean;
    Procedure   GenerateMenu;
    Procedure   DoStandardMenu;
    Procedure   DoLightBarMenu;
  End;

Implementation

Uses
  m_Strings,
  BBS_Core,
  BBS_Events,
  BBS_Multinode,
  BBS_NodeChat,
  BBS_Telnet,
  BBS_General;

Constructor TMenuEngine.Create (O: Pointer);
Begin
  Inherited Create;

  StackPos   := 0;
  MenuName   := '';
  MenuOld    := '';
  Owner      := O;
  Data       := TMenuData.Create;
  NextRedraw := True;
End;

Destructor TMenuEngine.Destroy;
Begin
  Data.Free;

  Inherited Destroy;
End;

Procedure TMenuEngine.ToggleAccessFlags (Cmd: String; Var Flags: RecAccessFlags);
Var
  Count : Byte;
Begin
  Count := 1;

  While Count <= Length(Cmd) Do Begin
    If (Cmd[Count] in ['+','-','!']) and (Cmd[Count + 1] in ['A'..'Z']) Then Begin
      Case Cmd[Count] of
        '+' : Flags := Flags + [Ord(Cmd[Count + 1]) - 64];
        '-' : Flags := Flags - [Ord(Cmd[Count + 1]) - 64];
        '!' : If Ord(Cmd[2]) - 64 in Flags Then
                Flags := Flags - [Ord(Cmd[Count + 1]) - 64]
              Else
                Flags := Flags + [Ord(Cmd[Count + 1]) - 64];

      End;
      Inc (Count);
    End;

    Inc (Count);
  End;
End;

Function TMenuEngine.ExecuteCommand (Cmd, CmdData: String) : Boolean;
Var
  Count : LongInt;
  Str1  : String;
  Str2  : String;
Begin
  Result := False;

  If Cmd[0] <> #2 Then Exit;

  Case Cmd[1] of
    '!' : Case Cmd[2] of
            'T' : TelnetClient(TBBSCore(Owner), CmdData);
          End;
    '-' : Case Cmd[2] of
            'D' : ToggleAccessFlags(strUpper(CmdData), TBBSCore(Owner).User.ThisUser.AF2);
            'F' : ToggleAccessFlags(strUpper(CmdData), TBBSCore(Owner).User.ThisUser.AF1);
            'K' : TBBSCore(Owner).Term.KeyBufStr := TBBSCore(Owner).Term.KeyBufStr + CmdData;
            'N' : TBBSCore(Owner).User.AcsOkFlag := TBBSCore(Owner).Term.GetYN(CmdData, False);
            'P' : Begin
                    Str1 := Copy(CmdData, 1, Pos(';', CmdData) - 1);
                    Str2 := strUpper(Copy(CmdData, Pos(';', CmdData) + 1, Length(CmdData)));
                    TBBSCore(Owner).Term.OutFull(Str1);
                    TBBSCore(Owner).User.AcsOkFlag := (TBBSCore(Owner).Term.GetStr(20, 20, -6, '') = Str2);
                  End;
            'S' : TBBSCore(Owner).SystemLog(CmdData);
            'Y' : TBBSCore(Owner).User.AcsOkFlag := TBBSCore(Owner).Term.GetYN(CmdData, True);
          End;
    'D' : Case Cmd[2] of
            'C' : TBBSCore(Owner).ShowLastCallers(strS2I(CmdData));
          End;
    'F' : Case Cmd[2] of
            'A' : TBBSCore(Owner).Files.ChangeArea(CmdData);
            'G' : TBBSCore(Owner).Files.ChangeGroup(CmdData, True, True);
          End;
    'G' : Case Cmd[2] of
            'A' : TBBSCore(Owner).Term.AnsiViewer(CmdData);
            'D' : TBBSCore(Owner).Term.OutFile(CmdData);
            'E' : TBBSCore(Owner).User.EditUserSettings(strS2I(CmdData));
            'H' : Begin
                    // ask to send batch if it exists..
                    TBBSCore(Owner).Term.OutFile('logoff');
                    TBBSCore(Owner).ShutDown := True;
                    Exit;
                  End;
            'I' : Begin
                    TBBSCore(Owner).Shutdown := True;
                    Exit;
                  End;
            'O' : Begin
                    MenuOld    := MenuName;
                    MenuName   := strWordGet(1, CmdData, ';');
                    NextReDraw := Not (strUpper(strWordGet(2, CmdData, ';')) = 'NODRAW');
                    Result     := True;
                  End;
            'R' : If StackPos > 0 Then Begin
                    MenuOld  := MenuName;
                    MenuName := Stack[StackPos];
                    Result   := True;

                    Dec (StackPos);
                  End;
            'S' : Begin
                    MenuOld := MenuName;

                    If StackPos = 8 Then Begin
                      For Count := 1 to 7 Do
                        Stack[Count + 1] := Stack[Count];

                      Dec (StackPos);
                    End;

                    Inc (StackPos);

                    Stack[StackPos] := MenuName;
                    MenuName        := strWordGet(1, CmdData, ';');
                    NextReDraw      := Not (strUpper(strWordGet(2, CmdData, ';')) = 'NODRAW');
                    Result          := True;
                  End;
            'T' : TBBSCore(Owner).Term.OutFull(CmdData);
            'U' : UserListing(TBBSCore(Owner), CmdData);
            'X' : Result := ExecuteMPE(Owner, CmdData) = 2;
            'Z' : TBBSCore(Owner).Door.Execute(CmdData);
          End;
    'I' : If TBBSCore(Owner).Msgs.Reading Then Begin
            Case Cmd[2] of
              '1' : Begin
                      TBBSCore(Owner).Msgs.IndexUpdateBar(False);
                      If TBBSCore(Owner).Msgs.ReadIndexPos < TBBSCore(Owner).Msgs.ReadIndexTotal Then
                        Inc (TBBSCore(Owner).Msgs.ReadIndexPos)
                      Else Begin
                        TBBSCore(Owner).Msgs.ReadBase^.SeekFirst(TBBSCore(Owner).Msgs.ReadIndexInfo[TBBSCore(Owner).Msgs.ReadIndexTotal].Num);
                        If TBBSCore(Owner).Msgs.IndexReadPage(False, False) Then TBBSCore(Owner).Msgs.ReadIndexPos := 1;
                      End;
                      TBBSCore(Owner).Msgs.IndexUpdateBar(True);
                    End;
              '2' : Begin
                      TBBSCore(Owner).Msgs.IndexUpdateBar(False);
                      If TBBSCore(Owner).Msgs.ReadIndexPos > 1 Then
                        Dec (TBBSCore(Owner).Msgs.ReadIndexPos)
                      Else
                      If TBBSCore(Owner).Msgs.ReadIndexPage > 1 Then Begin
                        TBBSCore(Owner).Msgs.ReadBase^.SeekFirst(TBBSCore(Owner).Msgs.ReadIndexInfo[1].Num);
                        If TBBSCore(Owner).Msgs.IndexReadPage(False, True) Then TBBSCore(Owner).Msgs.ReadIndexPos := TBBSCore(Owner).Msgs.ReadIndexTotal;
                      End;
                      TBBSCore(Owner).Msgs.IndexUpdateBar(True);
                    End;
              '3' : Begin
                      TBBSCore(Owner).Msgs.ReadBase^.SeekFirst(TBBSCore(Owner).Msgs.ReadIndexInfo[TBBSCore(Owner).Msgs.ReadIndexTotal].Num);
                      If TBBSCore(Owner).Msgs.IndexReadPage(False, False) Then Begin
                        If TBBSCore(Owner).Msgs.ReadIndexPos > TBBSCore(Owner).Msgs.ReadIndexTotal Then TBBSCore(Owner).Msgs.ReadIndexPos := TBBSCore(Owner).Msgs.ReadIndexTotal;
                      End Else Begin
                        TBBSCore(Owner).Msgs.IndexUpdateBar(False);
                        TBBSCore(Owner).Msgs.ReadIndexPos := TBBSCore(Owner).Msgs.ReadIndexTotal;
                      End;

                      TBBSCore(Owner).Msgs.IndexUpdateBar(True);
                    End;
              '4' : Begin
                      If TBBSCore(Owner).Msgs.ReadIndexPage > 1 Then Begin
                        TBBSCore(Owner).Msgs.ReadBase^.SeekFirst(TBBSCore(Owner).Msgs.ReadIndexInfo[1].Num);
                        If TBBSCore(Owner).Msgs.IndexReadPage(False, True) Then
                          If TBBSCore(Owner).Msgs.ReadIndexPos > TBBSCore(Owner).Msgs.ReadIndexTotal Then TBBSCore(Owner).Msgs.ReadIndexPos := TBBSCore(Owner).Msgs.ReadIndexTotal;
                      End Else Begin
                        TBBSCore(Owner).Msgs.IndexUpdateBar(False);
                        TBBSCore(Owner).Msgs.ReadIndexPos := 1;
                      End;
                      TBBSCore(Owner).Msgs.IndexUpdateBar(True);
                    End;
              'G' : Begin
                      TBBSCore(Owner).Msgs.ReadQuit := True;
                      Result := True;
                    End;
              'I' : Begin
                      TBBSCore(Owner).Msgs.ReadLastRead := TBBSCore(Owner).Msgs.ReadBase^.GetHighMsgNum;
                      TBBSCore(Owner).Msgs.ReadQuit     := True;
                      Result := True;
                    End;
              'Q' : If TBBSCore(Owner).Msgs.GetMessageScan(TBBSCore(Owner).Msgs.MBase) = 2 Then
                      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(122))
                    Else Begin
                      TBBSCore(Owner).Msgs.ReadRes  := False;
                      TBBSCore(Owner).Msgs.ReadQuit := True;
                      Result := True;
                    End;
              'S' : Begin
                      TBBSCore(Owner).Msgs.ReadBase^.SeekFirst(TBBSCore(Owner).Msgs.ReadIndexInfo[TBBSCore(Owner).Msgs.ReadIndexPos].Num);
                      TBBSCore(Owner).Msgs.ReaderSeekNextMsg (True, False);
                      TBBSCore(Owner).Msgs.AnsiViewMessage;
                      TBBSCore(Owner).Msgs.ReadQuit := Not TBBSCore(Owner).Msgs.ReadGotoIndex;
                      If TBBSCore(Owner).Msgs.ReadQuit Then Begin
                        Result := True;
                        Exit;
                      End;
                      TBBSCore(Owner).Msgs.ReadBase^.SeekFirst(TBBSCore(Owner).Msgs.ReadIndexInfo[1].Num);
                      If Not TBBSCore(Owner).Msgs.IndexReadPage(True, False) Then Begin
                        TBBSCore(Owner).Msgs.ReadIndexTotal := 0;
                        TBBSCore(Owner).Msgs.IndexReDraw;
                        TBBSCore(Owner).Msgs.IndexDrawPage;
                      End;

                      TBBSCore(Owner).Msgs.IndexUpdateBar(True);
                      Result := True;
                    End;
            End;
          End;
    'M' : Case Cmd[2] of
            'A' : TBBSCore(Owner).Msgs.ChangeArea(CmdData);
            'C' : TBBSCore(Owner).Msgs.CheckEmail(Pos('NOLIST', strUpper(CmdData)) > 0);
            'D' : TBBSCore(Owner).Msgs.SetMessagePointers;
            'E' : TBBSCore(Owner).Msgs.AutoSignatureEdit;
            'F' : TBBSCore(Owner).Msgs.AutoSignatureView;
            'G' : TBBSCore(Owner).Msgs.ChangeGroup(CmdData, True, True);
            'M' : TBBSCore(Owner).Msgs.MassEmail;
            'N' : TBBSCore(Owner).Msgs.MessageNewScan(strUpper(CmdData));
            'P' : TBBSCore(Owner).Msgs.PostMessage(False, '');
            'R' : Begin
                    If CmdData = '' Then CmdData := ' ';
                    TBBSCore(Owner).Msgs.ReadMessages(UpCase(CmdData[1]), '');
                    Result := True;
                  End;
            'W' : TBBSCore(Owner).Msgs.PostMessage(True, CmdData);
            'X' : TBBSCore(Owner).Msgs.PostTextFile(CmdData, False);
            'Z' : TBBSCore(Owner).Msgs.ToggleMessageScan;
          End;
    'N' : Case Cmd[2] of
            'A' : TBBSCore(Owner).User.SetUserAction(CmdData);
            'C' : Begin
                    TBBSCore(Owner).Chat := TBBSNodeChat.Create(Owner);
                    TBBSCore(Owner).Chat.NodeChat;
                    TBBSCore(Owner).Chat.Free;
                  End;
            'P' : PageUserForChat(TBBSCore(Owner));
            'S' : SendNodeMessage(TBBSCore(Owner), CmdData);
            'W' : WhosOnline(TBBSCore(Owner), CmdData);
          End;
    'R' : If TBBSCore(Owner).Msgs.Reading Then Begin
            Result := True;

            // Still needs: X@F

            Case Cmd[2] of
              '+' : TBBSCore(Owner).Msgs.ReaderMessageNext (Pos('EXIT', strUpper(CmdData)) > 0, Pos('PAGE', strUpper(CmdData)) > 0);
              '-' : TBBSCore(Owner).Msgs.ReaderMessagePrevious;
              '1' : If TBBSCore(Owner).Msgs.ReadType = 1 Then
                      If TBBSCore(Owner).Msgs.ReadPageEnd < TBBSCore(Owner).Msgs.ReadData.Lines Then Begin
                        Inc (TBBSCore(Owner).Msgs.ReadPageStart);
                        TBBSCore(Owner).Msgs.ReaderDrawText;
                      End;
              '2' : If TBBSCore(Owner).Msgs.ReadType = 1 Then
                      If TBBSCore(Owner).Msgs.ReadPageStart > 1 Then Begin
                        Dec (TBBSCore(Owner).Msgs.ReadPageStart);
                        TBBSCore(Owner).Msgs.ReaderDrawText;
                      End;
              '3' : If TBBSCore(Owner).Msgs.ReadType = 1 Then
                      If (TBBSCore(Owner).Msgs.ReadData.Lines > TBBSCore(Owner).Msgs.ReadPageSize) and (TBBSCore(Owner).Msgs.ReadPageEnd <= TBBSCore(Owner).Msgs.ReadData.Lines) Then Begin
                        If TBBSCore(Owner).Msgs.ReadPageStart + TBBSCore(Owner).Msgs.ReadPageSize <= TBBSCore(Owner).Msgs.ReadData.Lines - TBBSCore(Owner).Msgs.ReadPageSize Then
                          Inc (TBBSCore(Owner).Msgs.ReadPageStart, TBBSCore(Owner).Msgs.ReadPageSize)
                        Else
                          TBBSCore(Owner).Msgs.ReadPageStart := TBBSCore(Owner).Msgs.ReadData.Lines - TBBSCore(Owner).Msgs.ReadPageSize + 1;

                        TBBSCore(Owner).Msgs.ReaderDrawText;
                      End;
              '4' : If TBBSCore(Owner).Msgs.ReadType = 1 Then
                      If TBBSCore(Owner).Msgs.ReadPageStart > 1 Then Begin
                        If TBBSCore(Owner).Msgs.ReadPageStart - TBBSCore(Owner).Msgs.ReadPageSize > 0 Then
                          Dec (TBBSCore(Owner).Msgs.ReadPageStart, TBBSCore(Owner).Msgs.ReadPageSize)
                        Else
                          TBBSCore(Owner).Msgs.ReadPageStart := 1;

                        TBBSCore(Owner).Msgs.ReaderDrawText;
                      End;
              '5' : If TBBSCore(Owner).Msgs.ReadType = 1 Then
                      If TBBSCore(Owner).Msgs.ReadPageStart > 1 Then Begin
                        TBBSCore(Owner).Msgs.ReadPageStart := 1;
                        TBBSCore(Owner).Msgs.ReaderDrawText;
                      End;
              '6' : If TBBSCore(Owner).Msgs.ReadType = 1 Then
                      If TBBSCore(Owner).Msgs.ReadPageStart + TBBSCore(Owner).Msgs.ReadPageSize <= TBBSCore(Owner).Msgs.ReadData.Lines Then Begin
                        TBBSCore(Owner).Msgs.ReadPageStart := TBBSCore(Owner).Msgs.ReadData.Lines - TBBSCore(Owner).Msgs.ReadPageSize + 1;
                        TBBSCore(Owner).Msgs.ReaderDrawText;
                      End;
              'A' : TBBSCore(Owner).Msgs.ReadReDraw := True;
              'C',
              'M' : Begin
                      If TBBSCore(Owner).Msgs.ReaderMoveMessage(Cmd[2] = 'C') Then
                        If Cmd[2] = 'M' Then
                          If Not TBBSCore(Owner).Msgs.ReaderSeekNextMsg(False, False) Then
                            TBBSCore(Owner).Msgs.ReadQuit := True;
                      TBBSCore(Owner).Msgs.ReadReDraw := True;
                    End;
              'D' : TBBSCore(Owner).Msgs.ReaderDeleteMessage;
              'E' : TBBSCore(Owner).Msgs.ReaderEditMessage;
              'G' : TBBSCore(Owner).Msgs.ReadQuit := True;
              'H' : Begin
                      TBBSCore(Owner).Msgs.ReadLastRead := TBBSCore(Owner).Msgs.ReadBase^.GetMsgNum - 1;
                      TBBSCore(Owner).Msgs.ReadReDraw   := TBBSCore(Owner).Msgs.ReadType = 1;
                    End;
              'I' : Begin
                      TBBSCore(Owner).Msgs.ReadLastRead := TBBSCore(Owner).Msgs.ReadBase^.GetHighMsgNum;
                      TBBSCore(Owner).Msgs.ReadQuit     := True;
                     End;
              'J' : TBBSCore(Owner).Msgs.ReaderJumpMessage;
              'L' : TBBSCore(Owner).Msgs.ReaderListMessages;
              'P' : Begin
                      TBBSCore(Owner).Msgs.PostMessage(TBBSCore(Owner).Msgs.ReadModeChar = 'E', '');
                      TBBSCore(Owner).Msgs.ReadReDraw := True;
                    End;
              'Q' : If TBBSCore(Owner).Msgs.MBase.Flags AND RecMessageForced <> 0 Then Begin
                      Case TBBSCore(Owner).Msgs.ReadType of
                        0 : TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(135));
                        1 : TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(122));
                      End;
                      TBBSCore(Owner).Msgs.ReadReDraw := True;
                    End Else Begin
                      TBBSCore(Owner).Msgs.ReadRes  := False;
                      TBBSCore(Owner).Msgs.ReadQuit := True;
                    End;
              'R' : Begin
                      TBBSCore(Owner).Msgs.ReplyMessage(TBBSCore(Owner).Msgs.ReadBase, TBBSCore(Owner).Msgs.ReadModeChar = 'E', TBBSCore(Owner).Msgs.ReadType, TBBSCore(Owner).Msgs.ReadReplyID);
                      TBBSCore(Owner).Msgs.ReadReDraw := True;
                    End;
              'T' : TBBSCore(Owner).Msgs.ReaderToggleScan;
              '[' : TBBSCore(Owner).Msgs.ReaderThreadPrevious;
              ']' : TBBSCore(Owner).Msgs.ReaderThreadNext;
            End;
          End;
    'X' : Case Cmd[2] of
            'A' : Begin
                    TBBSCore(Owner).Term.OutFile('newuser');
                    If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(169), False) Then Begin
                      If Not TBBSCore(Owner).User.CreateNewUser('') Then Exit;
//TBBSCore(Owner).user.createnewuser('');
                      MenuName := BbsConfig.MatrixMenu;
                      Result   := True;
//                      ExecuteCommand := True;
                    End;
                  End;
            'L' : If TBBSCore(Owner).User.GetMatrixUser Then
                    If TBBSCore(Owner).User.Access(bbsConfig.MatrixAccess) Then Begin
                      TBBSCore(Owner).User.MatrixOK := True;
                      ExecuteCommand                := True;
                    End Else
                      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(173));
          End;
  End;
End;

Function TMenuEngine.ExecuteCommandList (Num, JumpID: LongInt) : Byte;
// 0 = no commands ran, 1 = commands ran, 2 = load new menu
Var
  Count : LongInt;
Begin
  Result := 0;

  If Not TBBSCore(Owner).User.Access(Data.Item[Num]^.Access) Then Exit;

  Redraw := Data.Item[Num]^.Redraw;

  For Count := 1 to Data.Item[Num]^.Commands Do Begin
    If JumpID <> -1 Then
      If JumpID <> Data.Item[Num]^.CmdData[Count]^.JumpID Then Continue;

    If TBBSCore(Owner).User.Access(Data.Item[Num]^.CmdData[Count]^.Access) Then Begin
      Result := 1;
      If ExecuteCommand(Data.Item[Num]^.CmdData[Count]^.MenuCmd, Data.Item[Num]^.CmdData[Count]^.Data) Then Begin
        Result := 2;
        Exit;
      End;
    End;
  End;
End;

Function TMenuEngine.ExecuteByHotkey (Key: String) : Boolean;
Var
  Count : LongInt;
Begin
  Result := False;
  Key    := strUpper(Key);

  For Count := 1 to Data.NumItems Do Begin

    If Data.Item[Count] = Nil Then Begin
      Result := True;
      Exit;
    End;

    If Data.Item[Count]^.HotKey = Key Then
      If ExecuteCommandList(Count, -1) = 2 Then Begin
        Result := True;
        Exit;
      End;
  End;
End;

Function TMenuEngine.ShowMenu : Boolean;
Begin
  With TBBSCore(Owner) Do Begin
    Result := Not Term.OutFile (Replace_Security(Data.Info.DispFile, User.ThisUser.Security));

    If Result And (Pos('@S', Data.Info.DispFile) > 0) Then
      Result := Not Term.OutFile(Strip_Security(Data.Info.DispFile));
  End;
End;

Procedure TMenuEngine.GenerateMenu;
Var
  Format : Byte;
  Listed : Word;
  Count  : LongInt;
Begin
  If ShowMenu Then Begin
    Case Data.Info.DispCols of
      1 : Format := 79;
      2 : Format := 39;
      3 : Format := 26;
      4 : Format := 19;
    End;

    TBBSCore(Owner).Term.NoBufFlush := True;

    If Data.Info.Header <> '' Then
      TBBSCore(Owner).Term.OutFullLn (Data.Info.Header);

    Listed := 0;

    For Count := 1 to Data.NumItems Do Begin
      If (Data.Item[Count]^.ShowType = 2) or
         (Data.Item[Count]^.Text = '') or
         (Data.Item[Count]^.HotKey = 'EVERY') or
         (Data.Item[Count]^.HotKey = 'AFTER') or
         (Data.Item[Count]^.HotKey = 'FIRSTCMD') or
         ((Data.Item[Count]^.ShowType = 0) And (Not TBBSCore(Owner).User.Access(Data.Item[Count]^.Access)))
      Then Continue;

      If Data.Item[Count]^.HotKey = 'LINEFEED' Then Begin
        TBBSCore(Owner).Term.OutFullLn('');
        TBBSCore(Owner).Term.OutFull(Data.Item[Count]^.Text);
        While Listed MOD Data.Info.DispCols <> 0 Do Inc(Listed);
      End Else Begin
        Inc (Listed);

        If Format = 79 Then
          TBBSCore(Owner).Term.OutFull(Data.Item[Count]^.Text)
        Else
          TBBSCore(Owner).Term.OutFull(strPadR(Data.Item[Count]^.Text, Format + Length(Data.Item[Count]^.Text) - strMCILen(Data.Item[Count]^.Text), ' '));

        If Listed MOD Data.Info.DispCols = 0 Then
          TBBSCore(Owner).Term.OutFullLn ('');
      End;
    End;

    If Listed MOD Data.Info.DispCols <> 0 Then
      TBBSCore(Owner).Term.OutFullLn ('');

    TBBSCore(Owner).Term.NoBufFlush := False;
    TBBSCore(Owner).Term.BufFlush;
  End;

  If ExecuteByHotKey('AFTER') Then Exit;

  If Data.Info.Footer <> '' Then
    TBBSCore(Owner).Term.OutFull(Data.Info.Footer);

  TBBSCore(Owner).Term.BufFlush;
  // this above isnt needed i dont think
End;

Function TMenuEngine.MenuGetKey : Char;
Var
//  Count   : LongInt;
  Current : LongInt;
Begin
  Result  := #0;
//  Count   := 0;
  Current := 0;

// at some point remove this function and make the main getkey function
// loop every second in order to check for node messages.

//  looks like what mentioned above might have been completed... its been 2
//  years lol i cant remember

//  If (Data.Info.CmdTimer = 0) Or Not UseTimer Then
//    Result := TBBSCore(Owner).Term.GetKey(0)
//  Else
    While Not TBBSCore(Owner).ShutDown Do Begin
      Result := TBBSCore(Owner).Term.NewGetKey(1000);

      If TBBSCore(Owner).ShutDown Then Exit;

      If Result = #0 Then Begin
//        Inc (Count);
        Inc (Current);

        If UseTimer And (Current >= Data.Info.CmdTimer) Then Begin
          ExecuteByHotKey('TIMER');
          Current := 0;
        End;

//        If (bbsConfig.Inactivity > 0) and (Count >= bbsConfig.Inactivity) Then Begin
//          TBBSCore(Owner).Event.Trigger(evt_Inactive, Owner, '');
//          Exit;
//        End;
      End Else
        Break;
    End;
End;

Procedure TMenuEngine.DoStandardMenu;
Var
  Ch     : Char;
  Temp   : String[mysMaxMenuInput];
  Count  : LongInt;
  Found  : Boolean;
//  ReDraw : Boolean;

  Procedure Translate;
  Begin
    Case Ch of
      #09 : Temp := 'TAB';
      #27 : Temp := 'ESCAPE';
      #71 : Temp := 'HOME';
      #72 : Temp := 'UP';
      #73 : Temp := 'PAGEUP';
      #75 : Temp := 'LEFT';
      #77 : Temp := 'RIGHT';
      #79 : Temp := 'END';
      #80 : Temp := 'DOWN';
      #81 : Temp := 'PAGEDOWN'
    End;
  End;

  Procedure AddChar;
  Begin
    Temp := Temp + UpCase(Ch);

    Case Data.Info.CharType of
      0 : TBBSCore(Owner).Term.OutRaw(UpCase(Ch));
      1 : TBBSCore(Owner).Term.OutRaw(LoCase(Ch));
      2 : {hidden};
    End;
  End;

Begin
//  Redraw := True;

  While Not TBBSCore(Owner).ShutDown Do Begin
    If ExecuteByHotKey('EVERY') Then Exit;

    If ReDraw Then GenerateMenu;

    TBBSCore(Owner).Term.AllowArrow := True;

    If SetAction Then
      If Data.Info.NodeStatus <> '' Then
        TBBSCore(Owner).User.SetUserAction(Data.Info.NodeStatus)
      Else
        TBBSCore(Owner).User.SetUserAction(TBBSCore(Owner).GetPrompt(228));

    Temp := '';

    While Not TBBSCore(Owner).ShutDown Do Begin
      Ch := MenuGetKey;

      If TBBSCore(Owner).ShutDown Then Exit;

      Case Ch of
        #08 : If Length(Temp) > 0 Then Begin
                Dec (Temp[0]);
                TBBSCore(Owner).Term.OutBS(1, True);
              End;
        #09,
        #27 : If Pos(Ch, ExtKeys) > 0 Then Begin
                Translate;
                Break;
              End;
        #13 : Begin
                If Temp = '' Then Temp := 'ENTER';
                Break;
              End;
        #32..
        #126: If Length(Temp) < mysMaxMenuInput Then Begin
                If TBBSCore(Owner).Term.IsArrow And (Pos(Ch, ExtKeys) > 0) Then Begin
                  Translate;
                  Break;
                End;

                If UseHotKeys Then Begin
                  Count := 0;

                  Repeat
                    Inc (Count);
                    Found := Data.Item[Count]^.HotKey = Temp + UpCase(Ch);
                  Until Found or (Count >= Data.NumItems);

                  If Found And (TBBSCore(Owner).User.Access(Data.Item[Count]^.Access)) Then Begin
                    AddChar;
                    Break;
                  End Else
                    If UseLongKey Then
                      If ((Temp[1] = '/') And (Temp[0] > #0)) or ((Temp[0] = #0) And (Ch = '/')) Then
                        AddChar;
                End Else
                  AddChar;
              End;
      End;
    End;

    If Data.Info.CharType <> 2 Then
      TBBSCore(Owner).Term.OutRawLn('');

    If Not TBBSCore(Owner).ShutDown Then
      If ExecuteByHotKey(Temp) Then
        Exit;
  End;
End;

Procedure TMenuEngine.DoLightBarMenu;
Var
  TempStr : String;
  PromptX : Byte;
  PromptY : Byte;
  PromptA : Byte;

  Function ValidLightBar (BarPos: Word) : Boolean;
  Begin
    Result := False;

    If BarPos = 0 Then Exit;

    Result := (Data.Item[BarPos]^.HotKey <> 'EVERY') And
              (Data.Item[BarPos]^.HotKey <> 'AFTER') And
              (Data.Item[BarPos]^.HotKey <> 'FIRSTCMD') And
              (Data.Item[BarPos]^.TextLo <> '') And
              (Data.Item[BarPos]^.TextHi <> '') And
              (Data.Item[BarPos]^.ShowType <> 2) And
              ( (((Data.Item[BarPos]^.ShowType = 0) And (TBBSCore(Owner).User.Access(Data.Item[BarPos]^.Access)) Or (Data.Item[BarPos]^.ShowType = 1)))
              );
  End;

  Procedure DrawBar (Num: Word; High: Boolean);
  Var
    Str : String;
  Begin
    If Num = 0 Then Exit;

    If High Then
      Str := Data.Item[Num]^.TextHi
    Else
      Str := Data.Item[Num]^.TextLo;

    If Str = '' Then Exit;

    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).Term.AnsiGotoXY(Data.Item[Num]^.X, Data.Item[Num]^.Y) + Str);
  End;

  Procedure AddChar (Ch: Char);
  Var
    SavedAttr : Byte;
    Str       : String;
    Offset    : Byte;
  Begin
    If Data.Info.CharType = 2 Then Begin  // hidden
      TempStr := TempStr + UpCase(Ch);
      Exit;
    End;

    SavedAttr := TBBSCore(Owner).Term.Console.TextAttr;

    If Ch = #08 Then
      Offset := Length(TempStr) + 1
    Else
      Offset := Length(TempStr);

    Str := #27 + '[s' +
           TBBSCore(Owner).Term.AnsiGotoXY(PromptX + Offset, PromptY) +
           TBBSCore(Owner).Term.Attr2Ansi(PromptA, False);

    If Ch = #08 Then
      Str := Str + #8#32#8
    Else Begin
      Case Data.Info.CharType of
        0 : Ch := UpCase(Ch);
        1 : Ch := LoCase(Ch);
      End;

      Str     := Str + Ch;
      TempStr := TempStr + UpCase(Ch);
    End;

    Str := Str + TBBSCore(Owner).Term.Attr2Ansi(SavedAttr, False) + #27 + '[u';

    TBBSCore(Owner).Term.OutRaw(Str);
  End;

Var
  Count     : Word;
  CursorPos : Word;
  TempPos   : Word;
  Ch        : Char;
  Found     : Boolean;
Begin
  CursorPos := 0;

  While Not TBBSCore(Owner).ShutDown Do Begin
    ExecuteByHotKey('EVERY');

    If SetAction Then
      If Data.Info.NodeStatus <> '' Then
        TBBSCore(Owner).User.SetUserAction(Data.Info.NodeStatus)
      Else
        TBBSCore(Owner).User.SetUserAction(TBBSCore(Owner).GetPrompt(228));

    If ReDraw Then Begin
      ShowMenu;

      If Data.Info.Header <> '' Then
        TBBSCore(Owner).Term.OutFullLn(Data.Info.Header);

      If Data.Info.Footer <> '' Then
        TBBSCore(Owner).Term.OutFull(Data.Info.Footer);

      PromptX := TBBSCore(Owner).Term.Console.CursorX;
      PromptY := TBBSCore(Owner).Term.Console.CursorY;
      PromptA := TBBSCore(Owner).Term.Console.TextAttr;
    End;

    For Count := 1 to Data.NumItems Do
      If ValidLightBar(Count) Then Begin
        If CursorPos = 0 Then CursorPos := Count;
        DrawBar (Count, False);
      End;

    TBBSCore(Owner).Term.AllowArrow := True;

    ExecuteByHotKey('AFTER');

    DrawBar (CursorPos, True);

    TempStr := '';

    While Not TBBSCore(Owner).ShutDown Do Begin
      Ch := MenuGetKey;

      If TBBSCore(Owner).ShutDown Then Exit;

      If TBBSCore(Owner).Term.IsArrow Then Begin
        Case Ch of
          #72,
          #75 : Case Data.Info.MenuType of
                  1 : Begin
                        TempPos := CursorPos;

                        While TempPos > 1 Do Begin
                          Dec (TempPos);
                          If ValidLightBar(TempPos) Then Begin
                            DrawBar (CursorPos, False);
                            DrawBar (TempPos, True);
                            CursorPos := TempPos;
                            Break;
                          End;
                        End;
                      End;
                  2 : Case Ch of
                        #72 : If ValidLightBar(Data.Item[CursorPos]^.JumpUp) Then Begin
                                ExecuteCommandList(CursorPos, 1);
                                DrawBar (CursorPos, False);
                                CursorPos := Data.Item[CursorPos]^.JumpUp;
                                DrawBar (CursorPos, True);
                              End;
                        #75 : If ValidLightBar(Data.Item[CursorPos]^.JumpLeft) Then Begin
                                ExecuteCommandList(CursorPos, 3);
                                DrawBar (CursorPos, False);
                                CursorPos := Data.Item[CursorPos]^.JumpLeft;
                                DrawBar (CursorPos, True);
                              End;
                      End;
                End;
          #77,
          #80 : Case Data.Info.MenuType of
                  1 : Begin
                        TempPos := CursorPos;

                        While TempPos < Data.NumItems Do Begin
                          Inc (TempPos);
                          If ValidLightBar(TempPos) Then Begin
                            DrawBar (CursorPos, False);
                            DrawBar (TempPos, True);
                            CursorPos := TempPos;
                            Break;
                          End;
                        End;
                      End;
                  2 : Case Ch of
                        #77 : If ValidLightBar(Data.Item[CursorPos]^.JumpRight) Then Begin
                                ExecuteCommandList (CursorPos, 4);
                                DrawBar (CursorPos, False);
                                CursorPos := Data.Item[CursorPos]^.JumpRight;
                                DrawBar (CursorPos, True);
                              End;
                        #80 : If ValidLightBar(Data.Item[CursorPos]^.JumpDown) Then Begin
                                ExecuteCommandList (CursorPos, 2);
                                DrawBar (CursorPos, False);
                                CursorPos := Data.Item[CursorPos]^.JumpDown;
                                DrawBar (CursorPos, True);
                              End;
                      End;
                End;
          #73 : If Data.Info.MenuType = 2 Then
                  Case ExecuteCommandList(CursorPos, 7) of
                    0 : ;
                    1 : Break;
                    2 : Exit;
                  End;
          #81 : If Data.Info.MenuType = 2 Then
                  Case ExecuteCommandList(CursorPos, 8) of
                    0 : ;
                    1 : Break;
                    2 : Exit;
                  End;
        End;
      End Else
        Case Ch of
          #08 : If Length(TempStr) > 0 Then Begin
                  Dec (TempStr[0]);
                  AddChar(#8);
                End;
          #09 : If Data.Info.MenuType = 2 Then
                  Case ExecuteCommandList(CursorPos, 5) of
                    0 : ;
                    1 : Break;
                    2 : Exit;
                  End;
          #13 : Begin
                  TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.AnsiGotoXY(Data.Info.DoneX, Data.Info.DoneY));
                  If Data.Info.MenuType = 1 Then
                    Found := ExecuteCommandList(CursorPos, -1) = 2
                  Else
                    Found := ExecuteCommandList(CursorPos, 0) = 2;

                  If Found Then Exit Else Break;
                End;
          #27 : If Data.Info.MenuType = 2 Then
                  Case ExecuteCommandList(CursorPos, 6) of
                    0 : ;
                    1 : Break;
                    2 : Exit;
                  End;
        Else
          If Length(TempStr) < mysMaxMenuInput Then Begin
            Found := False;
            Count := 0;

            Repeat
              Inc (Count);
              Found := Data.Item[Count]^.HotKey = TempStr + UpCase(Ch);
            Until Found or (Count >= Data.NumItems);

            If Found And (TBBSCore(Owner).User.Access(Data.Item[Count]^.Access)) Then Begin
              If Length(TempStr) > 0 Then AddChar (Ch);
              If ValidLightBar(Count) Then Begin
                DrawBar(CursorPos, False);
                CursorPos := Count;
                DrawBar(CursorPos, True);
              End;

              TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.AnsiGotoXY(Data.Info.DoneX, Data.Info.DoneY));

              If Data.Info.MenuType = 1 Then
                Found := ExecuteCommandList(CursorPos, -1) = 2
              Else
                Found := ExecuteCommandList(CursorPos, 0) = 2;

              If Found Then Exit Else Break;
            End Else
              If ((TempStr[1] = '/') And (TempStr[0] > #0)) or ((TempStr[0] = #0) And (Ch = '/')) Then
                AddChar(Ch);
          End;
        End;
    End;
  End;
End;

Function TMenuEngine.LoadMenu (Forced: Boolean) : Boolean;
Begin
  Result := True;

  If Not Data.Load (False, TBBSCore(Owner).Theme.PathMenu + MenuName + '.mnu') Then Begin
    Result := False;

    If TBBSCore(Owner).Theme.PathFallback Then
      Result := Data.Load (False, bbsConfig.PathMenu + MenuName + '.mnu');

    If Not Result Then Begin
      If Forced Then
        TBBSCore(Owner).Event.Trigger(evt_Error, Owner, 'Unable to load: ' + MenuName + '.mnu');
      Exit;
    End;
  End;
End;

Procedure TMenuEngine.ExecuteMenu (Load, Forced, Action: Boolean);
Var
  Count : LongInt;
Begin
  SetAction := Action;

  If Load Then If Not LoadMenu(Forced) Then Exit;

  If Not TBBSCore(Owner).User.Access(Data.Info.Access) Then Begin
    MenuName := MenuOld;
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(63));
    Exit;
  End;

  If Data.Info.Global Then
    If Not Data.Load (True, TBBSCore(Owner).Theme.PathMenu + 'global.mnu') Then
      If TBBSCore(Owner).Theme.PathFallback Then
        Data.Load (True, bbsConfig.PathMenu + 'global.mnu');

  If Data.Info.InputType = 0 Then
    UseHotKeys := TBBSCore(Owner).User.ThisUser.HotKeys
  Else
    UseHotKeys := Not Boolean(Data.Info.InputType - 1);

  // Run FIRSTCMD commands and setup valid extended keys

  ExtKeys    := '';
  UseTimer   := False;
  ReDraw     := NextReDraw;
  NextReDraw := True;
  UseLongKey := False;

  For Count := 1 to Data.NumItems Do Begin
    If (Data.Item[Count]^.HotKey = 'EVERY') or
        Not TBBSCore(Owner).User.Access(Data.Item[Count]^.Access)
    Then Continue;

    If Data.Item[Count]^.HotKey = 'FIRSTCMD' Then Begin
      If ExecuteCommandList(Count, -1) = 2 Then Exit;
    End Else
    If Data.Item[Count]^.HotKey = 'TAB'      Then ExtKeys := ExtKeys + #09 Else
    If Data.Item[Count]^.HotKey = 'ESCAPE'   Then ExtKeys := ExtKeys + #27 Else
    If Data.Item[Count]^.HotKey = 'UP'       Then ExtKeys := ExtKeys + #72 Else
    If Data.Item[Count]^.HotKey = 'PAGEUP'   Then ExtKeys := ExtKeys + #73 Else
    If Data.Item[Count]^.HotKey = 'LEFT'     Then ExtKeys := ExtKeys + #75 Else
    If Data.Item[Count]^.HotKey = 'RIGHT'    Then ExtKeys := ExtKeys + #77 Else
    If Data.Item[Count]^.HotKey = 'DOWN'     Then ExtKeys := ExtKeys + #80 Else
    If Data.Item[Count]^.HotKey = 'PAGEDOWN' Then ExtKeys := ExtKeys + #81 Else
    If Data.Item[Count]^.HotKey = 'HOME'     Then ExtKeys := ExtKeys + #71 Else
    If Data.Item[Count]^.HotKey = 'END'      Then ExtKeys := ExtKeys + #79 Else
    If Data.Item[Count]^.HotKey = 'TIMER'    Then UseTimer := True Else
    If Byte(Data.Item[Count]^.HotKey[0]) > 1 Then UseLongKey := True;
  End;

  Case Data.Info.MenuType of
    0 : DoStandardMenu;
    1,
    2 : If TBBSCore(Owner).Term.Graphics > 0 Then
          DoLightBarMenu
        Else
          DoStandardMenu;
  End;
End;

End.
