{$I M_OPS.PAS}

Unit Class_Threads;

// Thread class for Virtual Pascal only.  Free Pascal has its own
// implementation within its Classes unit.  For some reason, Virtual Pascal
// does not, so here it is!

Interface

Type
  TThread = Class
  Private
    FThreadID        : LongInt;
    FTerminated      : Boolean;
    FSuspended       : Boolean;
    FFreeOnTerminate : Boolean;
    FFinished        : Boolean;
    FReturnValue     : Integer;

    Procedure SetSuspended (Value: Boolean);
  Protected
    Procedure DoTerminate; Virtual;
    Procedure Execute;     Virtual; Abstract;

    Property  ReturnValue : Integer  Read FReturnValue Write FReturnValue;
    Property  Terminated  : Boolean  Read FTerminated;
  Public
    Constructor Create (IsSuspended: Boolean);
    Destructor  Destroy; Override;
    Procedure   Resume;
    Procedure   Suspend;
    Procedure   Terminate;
    Function    WaitFor: LongInt;

    Property    Suspended       : Boolean Read FSuspended       Write SetSuspended;
    Property    FreeOnTerminate : Boolean Read FFreeOnTerminate Write FFreeOnTerminate;
    Property    ThreadID        : LongInt Read FThreadID;
  End;

Implementation

Uses
  Windows;
//  VPUtils;

Function ThreadFunc (P: Pointer) : LongInt;
Begin
  TThread(P).Execute;

  Result := TThread(P).FReturnValue;

  TThread(P).DoTerminate;
  TThread(P).FFinished := True;

  If TThread(P).FFreeOnTerminate Then TThread(P).Free;

  EndThread(Result);
End;

Constructor TThread.Create (IsSuspended: Boolean);
Begin
  Inherited Create;

  FTerminated      := False;
  FSuspended       := False;
  FFreeOnTerminate := False;
  FFinished        := False;
  FReturnValue     := 0;

  BeginThread(NIL, 32 * 1024, ThreadFunc, Pointer(Self), 0, FThreadID);

//  FThreadID        := VPBeginThread(ThreadFunc, 32 * 1024, Pointer(Self));

  // Suspend is not tested...

  If IsSuspended Then Suspend;
End;

Destructor TThread.Destroy;
Begin
  If Not Suspended And Not FFinished Then Begin
    Terminate;
    WaitFor;
  End;

  Inherited Destroy;
End;

Procedure TThread.DoTerminate;
Begin
End;

Procedure TThread.SetSuspended (Value: Boolean);
Begin
  If Value <> FSuspended Then
    If Value Then Suspend Else Resume;
End;

Procedure TThread.Suspend;
Begin
  FSuspended := True;
  SuspendThread(FThreadID);
End;

Procedure TThread.Resume;
Begin
  If ResumeThread(FThreadID) = 0 Then FSuspended := False;
End;

Procedure TThread.Terminate;
Begin
  FTerminated := True;
//  KillThread(FThreadID);
End;

Function TThread.WaitFor: LongInt;
Begin
  While Not FFinished Do
    Sleep(1000);

  WaitFor := 0;
End;

End.
