{$I M_OPS.PAS}

Unit MCFG_Doors;

Interface

Procedure DoorEditor;

Implementation

Uses
  m_FileIO,
  m_MenuBox,
  m_MenuForm,
  m_Strings,
  m_DateTime,
  MCFG_Common;

Procedure EditDoor (Var Door: RecDoors);
Var
  Box      : TMenuBox;
  Form     : TMenuForm;
  Topic    : String;
  LastDate : String[8];
Begin
  Topic    := '|03(|09Door Editor|03) |01-|09> |15';
  Box      := TMenuBox.Create(Console);
  Form     := TMenuForm.Create(Console);
  LastDate := DateDos2Str(Door.LastRan, 1);

  Box.Header := ' Door Editor: ' + Door.Name + ' ';

  Box.Open (9, 5, 72, 21);

  VerticalLine (28,  7, 15);
  VerticalLine (28, 17, 19);

  Form.AddStr  ('N', ' Door Name '      , 17,  7, 30,  7, 11, 30, 30, @Door.Name, Topic + 'Description of door');
  Form.AddCaps ('I', ' Door ID '        , 19,  8, 30,  8,  9, 12, 12, @Door.DoorID, Topic + 'Door ID name, used when executing doors');
  Form.AddPath ('S', ' Start Directory ', 11,  9, 30,  9, 17, 40, 60, @Door.StartPath, Topic + 'Directory where door is located');
  Form.AddStr  ('C', ' Command Line '   , 14, 10, 30, 10, 14, 40, 160, @Door.Command, Topic + 'Command line to execute door');
  Form.AddBits ('P', ' Create In Path ' , 12, 11, 30, 11, 16, RecDoorDropPath, @Door.Flags, Topic + 'Create drop files in start directory?');
  Form.AddBits ('R', ' Use Real Name '  , 13, 12, 30, 12, 15, RecDoorRealName, @Door.Flags, Topic + 'Use real names in drop file');
  Form.AddBits ('3', ' Set User Action ', 11, 13, 30, 13, 17, RecDoorAction, @Door.Flags, Topic + 'Set user''s node action?');
  Form.AddBits ('H', ' Show Loading '   , 14, 14, 30, 14, 14, RecDoorLoading, @Door.Flags, Topic + 'Show loading prompt on execute?');
  Form.AddBits ('K', ' Keep Statistics ', 11, 15, 30, 15, 17, RecDoorStats, @Door.Flags, Topic + 'Keep door statistics?');
  Form.AddDate ('L', ' Last Ran '       , 18, 17, 30, 17, 10, @LastDate, Topic + 'Date this door was last ran');
  Form.AddLong ('D', ' Ran Today '      , 17, 18, 30, 18, 11, 9, 0, 999999999, @Door.RanToday, Topic + 'Times door was executed today');
  Form.AddLong ('T', ' Ran Total '      , 17, 19, 30, 19, 11, 9, 0, 999999999, @Door.RanTotal, Topic + 'Number of times door was executed total');
  Form.Execute;
  Box.Close;

  Form.Free;
  Box.Free;

  Door.LastRan := DateStr2Dos(LastDate);
End;

Procedure DoorEditor;
Var
  Box  : TMenuBox;
  List : TMenuList;
  F    : TBufFile;
  Door : RecDoors;

  Procedure MakeList;
  Begin
    List.Clear;

    F.Reset;
    While Not F.Eof Do Begin
      F.Read (Door);
      List.Add (strPadR(strI2S(F.FilePos), 5, ' ') + '  ' + strPadR(Door.DoorID, 14, ' ') + Door.Name, 0);
    End;

    List.Add ('', 2);
  End;

Begin
  F := TBufFile.Create(SizeOf(RecDoors));

  F.Open (BbsConfig.PathData + 'doors.dat', fmOpenCreate, fmReadWrite + fmDenyNone, SizeOf(RecDoors));

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  Box.Header    := ' Door Editor ';
  List.NoWindow := True;
  List.LoChars  := #01#04#13#27;

  Box.Open (13, 5, 67, 20);

  Console.WriteXY (15,  6, 112, '#####  DoorID        Description');
  Console.WriteXY (15,  7, 112, strRep('', 51));
  Console.WriteXY (15, 18, 112, strRep('', 51));
  Console.WriteXY (18, 19, 112, '(CTRL/A) Add   (CTRL/D) Delete   (ENTER) Edit');

  Repeat
    MakeList;

    List.Open (13, 7, 67, 18);
    List.Close;

    Case List.ExitCode of
      #04 : If List.Picked < List.ListMax Then
              If ShowMsgBox(1, 'Delete this entry?') Then Begin
                F.RecordDelete (List.Picked);
                MakeList;
              End;
      #01 : Begin
              F.RecordInsert (List.Picked);

              Door.Name      := 'New door';
              Door.DoorID    := 'NEWDOOR';
              Door.StartPath := '';
              Door.Command   := '';
              Door.Flags     := 0;
              Door.LastRan   := CurDateDos;
              Door.RanToday  := 0;
              Door.RanTotal  := 0;

              F.Write (Door);

              MakeList;
            End;
      #13 : If List.Picked <> List.ListMax Then Begin
              F.Seek (List.Picked - 1);
              F.Read (Door);

              EditDoor(Door);

              F.Seek  (List.Picked - 1);
              F.Write (Door);
            End;
      #27 : Break;
    End;
  Until False;

  F.Close;
  F.Free;

  Box.Close;
  List.Free;
  Box.Free;
End;

End.
