// ABOUT MPL 2.0:
//
// The MPL language in Mystic 1.0 was designed initially as a real time script interpreter.
// It was not designed to turn into what it did, and because of this it had many limitations.

// At some point during 1.0 development, I started hacking away at Iniquity's IPL language
// with the intention that a unified programming language for mods could be implemented.
// The idea of Mystic and Iniquity being able to run the same mods would have been pretty
// cool.  However, Iniquity died eventually and I stopped working on this.

// When I started on Mystic 2.0 I decided to pull this code back out and start hacking away
// at it again rather than start a fresh tokenized compiler/interpreter.  I had already put
// a ton of time into this so it seemed like a logical idea.

// It doesn't look all that much like IPL anymore.  I rewrote a lot of it, fixed a ton of 
// bugs, converted it to OOP, added case statements, preliminary record support, definable
// syntax for the parser, and the list goes on.

// Its too bad the whole IPL/MPL fusion never happened.  It would have been really good for the
// underground mod scene back then to have two major software packages able to execute the same
// compiled mods!

// remove the predefined procedure/vars in executable mode

Type
  TIdentTypes = (
    iNone,
    iString,
    iByte,
    iShort,
    iWord,
    iInteger,
    iLongInt,
    iReal,
    iBool,
    iFile,
    iRecord
  );

  TTokenOpsRec  = (
    opBlockOpen,                 // 1
    opBlockClose,                // 2
    opVarDeclare,                // 3
    opStr,                       // 4
    opChar,                      // 5
    opByte,                      // 6
    opShort,                     // 7
    opWord,                      // 8
    opInt,                       // 9
    opLong,                      // 10
    opReal,                      // 11
    opBool,                      // 12
    opSetVar,                    // 13
    opLeftParan,                 // 14
    opRightParan,                // 15
    opVariable,                  // 16
    opOpenString,                // 17
    opCloseString,               // 18
    opProcDef,                   // 19
    opProcExec,                  // 20
    opParamSep,                  // 21
    opFor,                       // 22
    opTo,                        // 23
    opDownTo,                    // 24
    opTrue,                      // 25
    opFalse,                     // 26
    opEqual,                     // 27
    opNotEqual,                  // 28
    opGreater,                   // 29
    opLess,                      // 30
    opEqGreat,                   // 31
    opEqLess,                    // 32
    opStrAdd,                    // 33
    opProcType,                  // 34
    opIf,                        // 35
    opElse,                      // 36
    opWhile,                     // 37
    opOpenNum,                   // 38
    opCloseNum,                  // 39
    opRepeat,                    // 40
    opNot,                       // 41
    opAnd,                       // 42
    opOr,                        // 43
    opStrArray,                  // 44
    opArrDef,                    // 45
    opStrSize,                   // 46
    opVarNormal,                 // 47
    opGoto,                      // 48
    opHalt,                      // 49
    opCase,                      // 50
    opNumRange,                  // 51
    opTypeRec,                   // 52
    opBreak,                     // 53
    opContinue,                  // 54
    opUses,                      // 55
    opExit,                      // 56
    opNone                       // 57
  );

Const
  mplVer           = '200';
  mplVersion       = '[MPX ' + mplVer +']' + #26;
  mplVerLength     = 10;
  mplExtSource     = '.mps';
  mplExtExecute    = '.mpx';
  mplMaxInclude    = 10;
  mplMaxFiles      = 20;
  mplMaxIdentLen   = 20;
  mplMaxVars       = 2500;
  mplMaxGotos      = 100;
  mplMaxCaseNums   = 20;
  mplMaxVarDeclare = 20;
  mplMaxArrayDem   = 3;
  mplMaxProcParams = 8;
  mplMaxRecords    = 20;
  mplMaxRecFields  = 40;
  mplMaxDataSize   = 65535;
  mplMaxConsts     = 100;

Const
   chNumber           = ['0'..'9','.'];
   chIdent1           = ['a'..'z','A'..'Z','_'];
   chIdent2           = ['a'..'z','A'..'Z','0'..'9','_'];
   chDigit            = ['0'..'9'];

{$IFNDEF MPLPARSER}
   xrrUeEndOfFile     = 1;
   xrrInvalidFile     = 2;
   xrrVerMismatch     = 3;
   xrrUnknownOp       = 4;
   xrrMultiInit       = 5;
   xrrDivisionByZero  = 6;
   xrrMathematical    = 7;
{$ELSE}
   errUeEndOfFile     = 1;
   errFileNotfound    = 2;
   errFileRecurse     = 3;
   errOutputFile      = 4;
   errExpected        = 5;
   errUnknownIdent    = 6;
   errInStatement     = 7;
   errIdentTooLong    = 8;
   errExpIdentifier   = 9;
   errTooManyVars     = 10;
   errDupIdent        = 11;
   errOverMaxDec      = 12;
   errTypeMismatch    = 13;
   errSyntaxError     = 14;
   errStringNotClosed = 15;
   errStringTooLong   = 16;
   errTooManyParams   = 17;
   errBadProcRef      = 18;
   errNumExpected     = 19;
   errToOrDowntoExp   = 20;
   errExpOperator     = 21;
   errOverArrayDim    = 22;
   errNoInitArray     = 23;
   errTooManyGotos    = 24;
   errDupLabel        = 25;
   errLabelNotFound   = 26;
   errFileParamVar    = 27;
   errBadFunction     = 28;
   errOperation       = 29;
   errOverMaxCase     = 30;
   errTooManyFields   = 31;
   errDataTooBig      = 32;
   errMaxConsts       = 33;
{$ENDIF}

// ==========================================================================

  {$IFDEF MPLPARSER}
Type
  TTokenWordRec = (wBlockOpen,    wBlockClose,  wVarDeclare,  wVarSep,
                   wSetVar,       wLeftParan,   wRightParan,  wOpenString,
                   wCloseString,  wStrAdd,      wCharPrefix,  wProcDef,
                   wOpenParam,    wCloseParam,  wParamVar,    wParamSpec,
                   wFuncSpec,     wParamSep,    wFor,         wTo,
                   wDownTo,       wDo,          wTrue,        wFalse,
                   wOpEqual,      wOpNotEqual,  wOpGreater,   wOpLess,
                   wOpEqGreat,    wOpEqLess,    wIf,          wThen,
                   wElse,         wWhile,       wRepeat,      wUntil,
                   wNot,          wAnd,         wOr,          wOpenArray,
                   wCloseArray,   wArrSep,      wVarDef,      wOpenStrSize,
                   wCloseStrSize, wGoto,        wLabel,       wHalt,
                   wVarSep2,      wFuncDef,     wArray,       wCaseStart,
                   wCaseOf,       wNumRange,    wType,        wConst,
                   wBreak,        wContinue,    wUses,        wExit);
  {$ENDIF}


Const
  {$IFDEF MPLPARSER}
     tkv : Array[TIdentTypes] of String[mplMaxIdentLen] = (
             'none',            'string',       {  'char',   }    'byte',
             'short',           'word',           'integer',    'longint',
             'real',            'boolean',        'file',       'record');
             // add dword and char...
Type
     TTokenWordType = Array[TTokenWordRec] of String[mplMaxIdentLen];

Const
     wTokensPascal : TTokenWordType = (
             'begin',           'end',            'var',        ',',
             ':=',              '(',              ')',          '''',
             '''',              '+',              '#',          'procedure',
             '(',               ')',              '+',          ';',
             ':',               ',',              'for',        'to',
             'downto',          'do',             'true',       'false',
             '=',               '<>',             '>',          '<',
             '>=',              '<=',             'if',         'then',
             'else',            'while',          'repeat',     'until',
             'not',             'and',            'or',         '[',
             ']',               ',',              '=',          '[',
             ']',               'goto',           ':',          'halt',
             ':',               'function',       'array',      'case',
             'of',              '..',             'type',       'const',
             'break',           'continue',       'uses',       'exit'
           );

     wTokensIPLC : TTokenWordType = (
             '{',               '}',              '@',          ',',
             '=',               '(',              ')',          '"',
             '"',               '+',              '#',          'proc',
             '(',               ')',              '+',          ';',
             ':',               ',',              'for',        'to',
             'downto',          'do',             'true',       'false',
             '==',              '<>',             '>',          '<',
             '>=',              '<=',             'if',         'then',
             'else',            'while',          'repeat',     'until',
             '!',               '&&',             '||',         '(',
             ')',               ',',              '=',          '[',
             ']',               'goto',           ':',          'halt',
             ':',               'func',           'array',      'switch',
             'of',              '..',             'type',       'const',
             'break',           'continue',       'uses',       'exit'
           );

  {$ENDIF}

  vNums  : Set of TIdentTypes = [iByte, iShort, iWord, iInteger, iLongInt, iReal];

Type
  {$IFNDEF MPLPARSER}
    PStack     = ^TStack;
    TStack     = Array[1..mplMaxDataSize] of Byte;
    TArrayInfo = Array[1..mplMaxArrayDem] of Word;

(*
// MEMORY SAVING... could be 28 bytes per var?!?!
// could at least make a procrec that tvarrec links to via a pointer.  would
// save us about 25 bytes per var... which is about half the memory.  we
// could also remove IsProc var in TVar because we could just check to see
// if Proc : Pointer is assigned...
    PProcInfoRec = ^TProcInfoRec;
    TProcInfoRec = Record
      Params    : Array[1..mplMaxProcParams] of Char;
      ParamID   : Array[1..mplMaxProcParams] of Word;
      NumParams : Byte;
      Position  : LongInt;
    End;
*)

    PVarRec = ^TVarRec;
    TVarRec = Record
       VarID     : Word;
       vType     : TIdentTypes;
       Params    : Array[1..mplMaxProcParams] of Char;
       NumParams : Byte;
       pID       : Array[1..mplMaxProcParams] of Word;
       pPos      : LongInt;
       DataSize  : Word;
       VarSize   : Word;
       Data      : PStack;
       Kill      : Boolean;
       ArrPos    : Byte;
       ArrDim    : TArrayInfo;
    End;

    PRecordRec = ^TRecordRec;
    TRecordRec = Record
//      RecID     : Word; needed when Record variable type is added
      RecStart  : Word;
      NumFields : Word;
    End;

    VarDataRec = Array[1..mplMaxVars] of PVarRec;
    RecDataRec = Array[1..mplMaxRecords] of PRecordRec;
  {$ELSE}
    PVarRec = ^TVarRec;
    TVarRec = Record
       VarID     : Word;
       Ident     : String[mplMaxIdentLen];
       VType     : TIdentTypes;
       Params    : Array[1..mplMaxProcParams] of Char;
       NumParams : Byte;
       InProc    : Boolean;
       Proc      : Boolean;
       ArrPos    : Byte;
    End;

    PGotoRec = ^TGotoRec;
    TGotoRec = Record
      Ident : String[mplMaxIdentLen];
      xPos  : LongInt;
      Stat  : Byte;
    End;

    VarDataRec = Array[1..mplMaxVars] of PVarRec;
{$ENDIF}

