/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.event.SocketListener;
import de.mud.jta.event.SocketRequest;
import de.mud.jta.plugin.Timeout$1;
import de.mud.jta.plugin.Timeout$2;
import java.io.IOException;

public class Timeout
extends Plugin
implements FilterPlugin,
SocketListener,
Runnable {
    protected int timeout = 0;
    protected String timeoutCommand = null;
    protected String timeoutWarning = null;
    protected Thread timeoutThread = null;
    private PluginBus f1;
    FilterPlugin source;

    public Timeout(PluginBus pluginBus, String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(this);
        pluginBus.registerPluginListener(new Timeout$1(this, string));
        this.f1 = pluginBus;
    }

    public void run() {
        while (this.timeoutThread != null) {
            boolean bl;
            try {
                bl = false;
                Thread.sleep(1000 * this.timeout);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            if (bl) continue;
            this.error("data connection timeout, shutting down");
            if (this.timeoutCommand != null) {
                this.error("sending graceful exit command ...");
                try {
                    Timeout timeout = this;
                    timeout.write(timeout.timeoutCommand.getBytes());
                }
                catch (IOException iOException) {
                    this.error("could not send exit command");
                }
                this.timeoutThread = null;
                new Thread(new Timeout$2(this)).start();
                continue;
            }
            this.bus.broadcast(new SocketRequest());
        }
    }

    public void connect(String string, int n) throws IOException {
        if (this.timeout > 0) {
            this.timeoutThread = new Thread(this);
            this.timeoutThread.start();
        }
    }

    public void disconnect() throws IOException {
        if (this.timeoutThread != null) {
            Thread thread = this.timeoutThread;
            this.timeoutThread = null;
            thread.interrupt();
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.source.read(byArray);
        if (n > 0 && this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.source.write(byArray);
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
    }

    static PluginBus access$000(Timeout timeout) {
        return timeout.f1;
    }
}

