/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.SocketListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Menu;
import java.awt.Panel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;

public class Status
extends Plugin
implements VisualPlugin,
Runnable {
    private static final int debug = 1;
    private Label status;
    private Label host;
    private Panel sPanel;
    private String address;
    private String port;
    private String infoURL;
    private int interval;
    private Thread infoThread;
    private Hashtable ports = new Hashtable();

    public Status(PluginBus bus, final String id) {
        super(bus, id);
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                String tmp;
                Status.this.infoURL = config.getProperty("Status", id, "info");
                if (Status.this.infoURL != null) {
                    Status.this.host.setAlignment(1);
                }
                if ((tmp = config.getProperty("Status", id, "font")) != null) {
                    String fontStyle;
                    String font = tmp;
                    int style = 0;
                    int fsize = 12;
                    tmp = config.getProperty("Status", id, "fontSize");
                    if (tmp != null) {
                        fsize = Integer.parseInt(tmp);
                    }
                    if ((fontStyle = config.getProperty("Status", id, "fontStyle")) == null || fontStyle.equals("plain")) {
                        style = 0;
                    } else if (fontStyle.equals("bold")) {
                        style = 1;
                    } else if (fontStyle.equals("italic")) {
                        style = 2;
                    } else if (fontStyle.equals("bold+italic")) {
                        style = 3;
                    }
                    Status.this.host.setFont(new Font(font, style, fsize));
                }
                if ((tmp = config.getProperty("Status", id, "foreground")) != null) {
                    Status.this.host.setForeground(Color.decode(tmp));
                }
                if ((tmp = config.getProperty("Status", id, "background")) != null) {
                    Status.this.host.setBackground(Color.decode(tmp));
                }
                if (config.getProperty("Status", id, "interval") != null) {
                    try {
                        Status.this.interval = Integer.parseInt(config.getProperty("Status", id, "interval"));
                        Status.this.infoThread = new Thread(Status.this);
                        Status.this.infoThread.start();
                    }
                    catch (NumberFormatException e) {
                        Status.this.error("interval is not a number");
                    }
                }
            }
        });
        this.ports.put("22", "ssh");
        this.ports.put("23", "telnet");
        this.ports.put("25", "smtp");
        this.sPanel = new Panel(new BorderLayout());
        this.host = new Label("Not connected.", 0);
        bus.registerPluginListener(new SocketListener(){

            public void connect(String addr, int p) {
                Status.this.address = addr;
                if (Status.this.address == null || Status.this.address.length() == 0) {
                    Status.this.address = "<unknown host>";
                }
                if (Status.this.ports.get("" + p) != null) {
                    Status.this.port = (String)Status.this.ports.get("" + p);
                } else {
                    Status.this.port = "" + p;
                }
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Trying " + Status.this.address + " " + Status.this.port + " ...");
                }
            }

            public void disconnect() {
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Not connected.");
                }
            }
        });
        this.sPanel.add("Center", this.host);
        this.status = new Label("offline", 1);
        bus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                Status.this.status.setText("online");
                Status.this.status.setBackground(Color.green);
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Connected to " + Status.this.address + " " + Status.this.port);
                }
            }

            public void offline() {
                Status.this.status.setText("offline");
                Status.this.status.setBackground(Color.red);
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Not connected.");
                }
            }
        });
        this.sPanel.add("East", this.status);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        url = null;
        try {
            url = new URL(this.infoURL);
            if (true) ** GOTO lbl36
        }
        catch (Exception e) {
            this.error("infoURL is not valid: " + e);
            this.infoURL = null;
            return;
        }
        do {
            try {
                content = new BufferedReader(new InputStreamReader(url.openStream()));
                try {
                    while ((line = content.readLine()) != null) {
                        if (var3_5.startsWith("#")) {
                            color = var3_5.substring(1, 7);
                            line = var3_5.substring(8);
                            this.host.setForeground(Color.decode("#" + color));
                        }
                        this.host.setText(line);
                        Thread.sleep(10 * this.interval);
                    }
                }
                catch (IOException e) {
                    this.error("error while loading info ...");
                }
                Thread.sleep(100 * this.interval);
            }
            catch (Exception e) {
                this.error("error retrieving info content: " + e);
                e.printStackTrace();
                this.host.setForeground(Color.red);
                this.host.setText("error retrieving info content");
                this.infoURL = null;
                return;
            }
lbl36:
            // 2 sources

        } while (url != null && this.infoThread != null);
    }

    public Component getPluginVisual() {
        return this.sPanel;
    }

    public Menu getPluginMenu() {
        return null;
    }
}

