UNIT tpzunix;
{file date and time functions}

INTERFACE
  USES DOS;

  FUNCTION z_tounixdate(fdate : longint) : string;
  FUNCTION z_fromunixdate(s : string) : longint;

IMPLEMENTATION

   CONST
    c1970          = 2440588;
    d0             = 1461;
    d1             = 146097;
    d2             = 1721119;

  (* 1---------------1 *)

  PROCEDURE gregoriantojuliandn(year, month, day : integer;
                                VAR juliandn : longint);

    VAR
      century, xyear : longint;

    BEGIN  {gregoriantojuliandn}
    IF month <= 2 THEN BEGIN
      year := pred(year); month := month + 12; END;
    month := month - 3; century := year DIV 100;
    xyear := year MOD 100;
    century := (century * d1) shr 2;
    xyear := (xyear * d0) shr 2;
    juliandn := ((((month * 153) + 2) DIV 5) + day) + d2 +
                 xyear + century;
    END; {gregoriantojuliandn}

  (* 1---------------1 *)

  PROCEDURE juliandntogregorian(juliandn : longint;
                                VAR year, month, day : integer);
    VAR
      temp, xyear    : longint;
      yyear,
      ymonth, yday   : integer;

    BEGIN  {juliandntogregorian}
    temp := (((juliandn - d2) shl 2) - 1);
    xyear := (temp MOD d1) OR 3;
    juliandn := temp DIV d1;
    yyear := (xyear DIV d0);
    temp := ((((xyear MOD d0) + 4) shr 2) * 5) - 3;
    ymonth := temp DIV 153;
    IF ymonth >= 10 THEN BEGIN
      yyear := yyear + 1; ymonth := ymonth - 12; END;
    ymonth := ymonth + 3; yday := temp MOD 153;
    yday := (yday + 5) DIV 5;
    year := yyear + (juliandn * 100);
    month := ymonth; day := yday;
    END; {juliandntogregorian}

  (* 1---------------1 *)

  FUNCTION z_tounixdate(fdate : longint) : string;

    VAR
      dt             : datetime;
      secspast,
      datenum,
      dayspast       : longint;
      s              : string;

    BEGIN (* z_tounixdate *)
    unpacktime(fdate, dt);
    gregoriantojuliandn(dt.year, dt.month, dt.day, datenum);
    dayspast := datenum - c1970;
    secspast := dayspast * 86400;
    secspast := secspast + dt.hour * 3600 + dt.min * 60 + dt.sec;
    s := '';
    WHILE (secspast <> 0) AND (length(s) < 255) DO BEGIN
      s := chr((secspast AND 7) + $30) + s;
      secspast := (secspast shr 3); END;
    s := '0' + s; z_tounixdate := s
    END; (* z_tounixdate *)

  (* 1---------------1 *)

  FUNCTION z_fromunixdate(s : string) : longint;

    VAR
      dt             : datetime;
      secspast,
      datenum        : longint;
      n              : word;

    BEGIN (* z_fromunixdate *)
    secspast := longint(0);
    FOR n := 1 TO length(s) DO
      secspast := (secspast shl 3) + ord(s[n]) - $30;
    datenum := (secspast DIV 86400) + c1970;
    juliandntogregorian(datenum, integer(dt.year), integer(dt.month),
          integer(dt.day));
    secspast := secspast MOD 86400;
    dt.hour := secspast DIV 3600; secspast := secspast MOD 3600;
    dt.min := secspast DIV 60; dt.sec := secspast MOD 60;
    packtime(dt, secspast);
    z_fromunixdate := secspast
    END; (* z_fromunixdate *)

  (* 1---------------1 *)

  END.
v