{$A+,B-,D-,E-,F+,I-,L-,N-,O+,R-,S+,V-}

unit Mail1;

interface

uses Crt, Dos, Overlay, Common, Timefunc;

function Inputmessage (Pub, Uti: boolean; const Ftit: Astr; var Mheader: Mheaderrec; const Readinmsg: Astr): boolean;
procedure Inputline (var I: Astr);
procedure Anonymous (Offline: boolean; var Mheader: Mheaderrec);

implementation

uses File8, File0, Mail0;

const
    Topscreen = 3;       {first screen line for text entry}
    Scrollsize = 5;      {number of lines to scroll by}
    Msgmaxlen = 78;
var
    Importfile: text;
    Importfileopen: boolean;
    Lastline: Astr;
    Screenlines: byte;
    Escp: boolean;

{anonymouse post: displaied when postting / bluewolf}
procedure Anonymous(Offline: boolean; var Mheader: Mheaderrec);
  var
      An: Anontyp;
      C: char;
      B: byte;
      S: string [36];
  begin
      if (Readboard<>-1) then
      begin
          An:= Memboard.Anonymous;
          if (An= Atno) and (Aacs (General.Anonpubpost) and (not Offline) ) then
              An:= Atyes;
          if (Rpostan in Thisuser.flags) then
              An:= Atno;
      end { if }
      else
          if (Aacs(General.Anonprivpost) ) then
              An:= Atyes
          else
              An:= Atno;

      if Offline then
      begin
          Abort:= false; Next:= false;
          if An = Atno then
              for B := 1 to 5 do begin
                  S := Headerline(Mheader, filesize (Msghdrf), filesize (Msghdrf), B);
                  if S <> '' then Printacr(S);
              end { for }
          else
          begin
              Readmsg (filesize (Msghdrf), filesize (Msghdrf), filesize (Msghdrf) );
              reset (Msghdrf);
              if (ioresult = 2) then
                  rewrite (Msghdrf);
              reset (Msgtxtf);
              if (ioresult = 2) then
                  rewrite (Msgtxtf);
              if (ioresult <> 0) then
                  Sysoplog ('Anon: error opening message bases.');
          end; { if else }
      end; { if }

      case An of
          Atno      :;
          Atforced  : if (Cosysop) then
                          Mheader.From.Anon:= 2
                      else
                          Mheader.From.Anon:= 1;
          Atyes     : begin
                          Nl;
                          if Pynq (Aonoff (Readboard<>-1, 'Post anonymously? ',
                                 'Send anonymously? ') ) then
                              if (Cosysop) then
                                  Mheader.From.Anon:= 2
                              else
                                  Mheader.From.Anon:= 1;
                      end; { case label }
          Atdearabby: begin
                          Print (^M^J + Aonoff (Readboard<>-1, 'Post as:', 'Send as:') + ^M^J);

                          Print ('1. Abby');
                          Print ('2. Problemed Person');
                          Print ('3. '+ Caps (Thisuser.name) );

                          Prt (^M^J'Which? '); Onek (C, '123N'^M);
                          case C of
                              '1': Mheader.From.Anon:= 3;
                              '2': Mheader.From.Anon:= 4;
                          end; { case }
                      end; { case label }
          Atanyname : begin
                          Print (^M^J'You can post under any name in this base.'^M^J);

                          Prt ('Name: ');
                          Inputdefault (S, Mheader.From.A1S, 36, 'l', true);
                          if (S<> Mheader.From.A1S) then
                          begin
                              Mheader.From.Anon:= 5;
                              Mheader.From.A1S:= Caps (S);
                          end; { if }
                      end; { case label }
      end; { case }
  end; { ? }

function Inputmessage (Pub, Uti: boolean; const Ftit: Astr; var Mheader: Mheaderrec; const Readinmsg: Astr): boolean;
type
    Linepointer = ^Linearray;
    Linearray = array [1..200] of string [100];

var Lineptr : Linepointer;
    Mftit, Fto, S, S1, S2: Astr;
    I, J, K, Maxli, Quoteli, Lastquoteline, Maxquotelines, Currentline: integer;
    Nodesave: byte;
    Linetotal: 1..200;
    C: char;
    Cantabort, Saveline, Exited, Save,
    Abortit: boolean;
    Topline,
    Ccol: integer;
    Insert_Mode: boolean;
    Oldtimewarn: boolean;
    Phyline: array [1..20] of string [79];

procedure Fileattach;
var
    Dok, Kabort, Addbatch: boolean;
    Tooktime: longint;
begin
    Nl;
    if Pynq ('Attach a file to this message? ') then
    begin
        Prt (^M^J'File name: ');
        input (S, 40);
        Nl;
        if (not Cosysop) or (not Isul (S) ) then
            S:= General.Fileattachpath+ Stripname (S);
        if not Exist (S) and not Incom and not Exist (S) and (S<> '') then
        begin
            Print ('That file does not exist.');
            exit;
        end; { if }
        if Exist (S) and not Cosysop then
            Print ('You cannot use that file name.')
        else
        begin
            if not Exist (S) and Incom then
            begin
                Receive (S, Tempdir + '\UP', false, Dok, Kabort, Addbatch, Tooktime);
                Mheader.Fileattached := 1;
            end { if }
            else
                if Exist (S) then
                begin
                    Dok := true;
                    Mheader.Fileattached := 2;
                end; { if }
            if Dok then
            begin
                Mftit:= S;
                if Cosysop and not (Netmail in Mheader.Status) then
                    if Pynq ('Delete file upon receipt? ') then
                        Mheader.Fileattached := 1
                    else
                        Mheader.Fileattached := 2
                else
                    Mheader.Fileattached := 1;
            end { if }
            else
                Mheader.Fileattached := 0;
        end; { if else }
    end; { if }
end; { ? }

procedure Ansig (x, y: integer);
begin
    if (Speed > 0) then
        if Okavatar then Serialout (^V^H+chr(y)+chr(x))
        else Serialout (#27+'['+Cstr(y)+';'+Cstr(x)+'H');
    if (Wantout) then gotoxy (x, y);
end; { ? }


procedure Dolines;
begin
    if (Okansi or Okavatar) then Print ('^4::::::::::::::Ŀ^1')
    else Print ('[---:----:----:----:----:----:----:----|----:----:----:----:----:----:----:---]');
end; { ? }

procedure Count_Lines;
begin
    Linetotal := Maxli;
    while (Linetotal>0) and (length (Lineptr^[Linetotal])=0) do dec(Linetotal);
end; { ? }

procedure Append_Space;
begin
    Lineptr^[Currentline] := Lineptr^[Currentline] + ' ';
end; { ? }

function Curlength: byte;
begin
    Curlength:= length (Lineptr^[Currentline] );
end; { ? }

function Line_Boundry: boolean;
   {is the cursor at either the start of the end of a line?}
begin
    Line_Boundry:= (Ccol= 1) or (Ccol> Curlength);
end; { ? }

function Curchar: char;
   {return the character under the cursor}
begin
    if Ccol<= Curlength then
        Curchar:= Lineptr^[Currentline] [Ccol]
    else
        Curchar:= ' ';
end; { ? }

function Lastchar: char;
   {return the last character on the current line}
begin
    if Curlength= 0 then
        Lastchar:= ' '
    else
        Lastchar:= Lineptr^[Currentline] [Curlength];
end; { ? }

procedure Remove_Trailing;
begin
    while (length (Lineptr^[Currentline] ) > 0) and
           (Lineptr^[Currentline] [length (Lineptr^[Currentline] ) ] <= ' ')
    do
        dec (Lineptr^[Currentline] [0] );
end; { ? }

function Delimiter: boolean;
   {return true if the current character is a delimiter for words}
begin
    case Curchar of
        '0'..'9', 'a'..'z', 'A'..'Z', '_':
                                              Delimiter:= false;
        else
            Delimiter:= true;
    end; { case }
end; { ? }

procedure Reposition (x: boolean);
var Eol: byte;
begin
    if x then begin
        Eol:= Curlength+ 1;
        if Ccol> Eol then
            Ccol:= Eol;
    end; { if }
    Count_Lines;
    Ansig (Ccol, Currentline-Topline+ Topscreen);
    if pos ('>', copy (Lineptr^[Currentline], 1, 4) ) > 0 then
        Usercolor (3)
    else
        Usercolor (1);
end; { ? }

procedure Set_Phyline;
   {set physical line to match logical line (indicates display update)}
begin
    Phyline[Currentline-Topline+1] := Lineptr^[Currentline];
end; { ? }

procedure Clear_Eol;
begin
    if not Okavatar then Serialout (#27'[K')
    else Serialout (^V^G);
    if (Wantout) then clreol;
end; { ? }

procedure Truncate_Line;
   {update screen after changing end-of-line}
begin
    if Ccol > 0 then Lineptr^[Currentline][0] := chr(Ccol-1);
    Reposition (true);
    Clear_Eol;
    {set_phyline;  don't understand this}
end; { ? }

procedure Refresh_Screen;
var Pline, Pcol, Phline, Junk: byte;

begin
    if (Currentline >= Maxli) then Currentline:=Maxli;
    Pline:= Currentline;
    Currentline:= Topline;
    Pcol:= Ccol;
    Ccol:= 1;

    for Junk:= Topline to Topline+Screenlines-1 do begin
        Currentline:= Junk;
        Phline:= Currentline-Topline+1;

        if Currentline> Maxli then begin
            Reposition (true);
            Prompt ('^9--');
            Phyline [Phline] := '--';
            Clear_Eol;
        end { if } else begin
            if Lineptr^[Currentline] <> Phyline [Phline] then begin
                Reposition (true);
                Mciallowed:= false;
                Colorallowed:= false;
                Allowabort:= false;
                Printmain (copy (Lineptr^[Currentline], 1, 79) );
                Mciallowed:= true;
                Colorallowed:= true;
                Allowabort:= true;
                if Curlength < length (Phyline [Phline] ) then
                    Clear_Eol;
                Set_Phyline;
            end; { if }
        end; { if else }
    end; { for }

    Tleft;

    Ccol:= Pcol;
    Currentline:= Pline;
    Reposition (true);
end; { ? }


procedure Scroll_Screen (Lines: integer);
begin
    inc (Topline, Lines);

    if (Currentline< Topline) or (Currentline>= Topline+ Screenlines) then
        Topline:= Currentline-Screenlines div 2;

    if Topline< 1 then
        Topline:= 1
    else
        if Topline>= Maxli then
            dec (Topline, Scrollsize div 2);

    Refresh_Screen;
end; { ? }


procedure Cursor_Up;
begin
    if Currentline> 1 then
        dec (Currentline);

    if Currentline< Topline then Scroll_Screen(-Scrollsize)
    else Reposition (false);
end; { ? }


procedure Cursor_Down;
begin
    inc (Currentline);
    if (Currentline>= Maxli) then begin
        Currentline:= Maxli;
        if (Importfileopen) then begin
            Importfileopen:= false;
            close (Importfile);
        end; { if }
    end; { if }

    if (Currentline-Topline>= Screenlines) then
        Scroll_Screen(Scrollsize)
    else
        Reposition(false);
end; { ? }

procedure Cursor_Endline;
begin
    Ccol:= 79;
    Reposition (true);
end; { ? }

procedure Cursor_Startline;
begin
    Ccol:= 1;
    Reposition (true);
end; { ? }

procedure Cursor_Left;
begin
    if Ccol= 1 then
    begin
        Cursor_Up;
        Cursor_Endline;
    end { if }
    else begin
        dec (Ccol);
        if not Okavatar then Serialout (#27'[D')
        else Serialout (^V^E);
        gotoxy (wherex-1, wherey);
    end; { if else }
end; { ? }

procedure Cursor_Right;
begin
    if Ccol> Curlength then begin
        Ccol:= 1;
        Cursor_Down;
    end { if } else begin
        Outkey (Curchar); { prompt }
        inc (Ccol);
    end; { if else }
end; { ? }

procedure Cursor_Wordright;
begin
    if Delimiter then begin
        {skip blanks right}
        repeat
            Cursor_Right;
            if Line_Boundry then exit;
        until not Delimiter;
    end { if }
    else begin
        {find next blank right}
        repeat
            Cursor_Right;
            if Line_Boundry then exit;
        until Delimiter;

        {then move to a word start (recursive)}
        Cursor_Wordright;
    end; { if else }
end; { ? }


procedure Cursor_Wordleft;
begin
    if Delimiter then begin
        {skip blanks left}
        repeat
            Cursor_Left;
            if Line_Boundry then exit;
        until not Delimiter;

        {find next blank left}
        repeat
            Cursor_Left;
            if Line_Boundry then exit;
        until Delimiter;

        {move to start of the word}
        Cursor_Right;
    end { if }
    else begin
        {find next blank left}
        repeat
            Cursor_Left;
            if Line_Boundry then exit;
        until Delimiter;

        {and then move a word left (recursive)}
        Cursor_Wordleft;
    end; { if else }
end; { ? }

procedure Delete_Line;
   {delete the line at the cursor}
var I: byte;
begin
    for I := Currentline to Maxli-1 do
        Lineptr^[I] := Lineptr^[I+ 1];
    Lineptr^[Maxli] := '';

    if (Currentline <= Linetotal) and (Linetotal > 1) then dec(Linetotal);
end; { ? }

procedure Insert_Line (const Contents: Astr);
   {open a new line at the cursor}
var
    I: byte;
begin
    for I:= Maxli downto Currentline+ 1 do
        Lineptr^[I] := Lineptr^[I-1];
    Lineptr^[Currentline] := Contents;

    if Currentline< Linetotal then inc (Linetotal);
    if Currentline> Linetotal then Linetotal:= Currentline;
end; { ? }

procedure Reformat_Paragraph;
begin
    Remove_Trailing;
    Ccol:= Curlength;

    {for each line of the paragraph}
    while Curchar <> ' ' do
    begin

        {for each word of the current line}
        repeat
            {determine length of first word on the following line}
            inc (Currentline);
            Remove_Trailing;
            Ccol := 1;
            while Curchar<> ' ' do
                inc (Ccol);
            dec (Currentline);

            {hoist a word from the following line if it will fit}
            if (Ccol > 1) and (Ccol + Curlength < Msgmaxlen) then begin
                if Curlength > 0 then begin
                    {add a second space after sentences}
                    case Lastchar of
                        '.', '?', '!':
                                          Append_Space;
                    end; { case }
                    Append_Space;
                end; { if }
                Lineptr^[Currentline] := Lineptr^[Currentline] + copy (Lineptr^[Currentline+ 1], 1, Ccol-1);

                {remove the hoisted word}
                inc (Currentline);
                while (Curchar = ' ') and (Ccol <= Curlength) do
                    inc (Ccol);
                delete (Lineptr^[Currentline], 1, Ccol-1);
                if Curlength = 0 then
                    Delete_Line;
                dec (Currentline);
            end { if }
            else
                Ccol := 0;  {end of line}
        until Ccol = 0;

        {no more lines will fit - either time for next line, or end of paragraph}
        inc (Currentline);
        Ccol := 1;
        Remove_Trailing;
    end; { while }

end; { ? }
procedure word_wrap;
   {line is full and a character must be inserted.  perform word-wrap,
    updating screen and leave ready for the insertion}
var
   pcol,
   pline:byte;

begin
   remove_trailing;
   pline := CurrentLine;
   pcol := ccol;

   {find start of word to wrap}
   ccol:=curlength;


   while (ccol > 0) and (curchar <> ' ') do
      dec(ccol);

   {cancel wrap if no spaces in whole line}
   if ccol=0 then begin
      ccol:=1;
      cursor_down;
      exit;
   end;

   {get the portion to be moved down}
   inc(ccol);
   s := copy(LinePtr^[CurrentLine],ccol,MsgMaxLen);

   {remove it from current line and refresh screen}
   truncate_line;

   {place text on open a new line following the cursor}
   inc(CurrentLine);
   insert_line(s);

   {join the wrapped text with the following lines of text}
   reformat_paragraph;

   {restore cursor to proper position after the wrap}
   CurrentLine := pline;
   if pcol > curlength then begin
      ccol := pcol-curlength{-1};   {position cursor after wrapped word}
      inc(CurrentLine); {cursor_down;}
   end
   else
      ccol := pcol;               {restore original cursor position}

   if (CurrentLine-topline >= ScreenLines) then
      scroll_screen(ScrollSize)
   else
      refresh_screen;
end;

procedure join_lines;
   {join the current line with the following line, if possible}
begin
   inc(CurrentLine);
   remove_trailing;
   dec(CurrentLine);
   remove_trailing;
   if (curlength+length(LinePtr^[CurrentLine+1]))>=MsgMaxLen then exit;

   if (lastchar<>' ') then
      append_space;
   LinePtr^[CurrentLine]:=LinePtr^[CurrentLine]+LinePtr^[CurrentLine+1];

   inc(CurrentLine);
   delete_line;
   dec(CurrentLine);

   refresh_screen;
end;

procedure split_line;
   {splits the current line at the cursor, leaves cursor in original position}
var
   pcol:byte;

begin
   pcol:=ccol;
   remove_trailing;                      {get the portion for the next line}
   s:=copy(LinePtr^[CurrentLine],ccol,MsgMaxLen);

   truncate_line;

   ccol:=1;                             {open a blank line}
   inc(CurrentLine);
   insert_line(s);

   if CurrentLine-topline > ScreenLines-2 then scroll_screen(ScrollSize)
      else refresh_screen;

   dec(CurrentLine);
   ccol := pcol;
end;


procedure cursor_newline;
begin
   if (insert_mode) then split_line;
   ccol := 1;
   cursor_down;
end;

procedure fs_reformat;
   {reformat paragraph, update display}
var
   pline:byte;

begin
   pline:=CurrentLine;
   reformat_paragraph;

   {find start of next paragraph}
   while (curlength = 0) and (CurrentLine <= LineTotal) do
      inc(CurrentLine);

   {find top of screen for redisplay}
   while CurrentLine-topline > ScreenLines-2 do
   begin
      inc(topline,ScrollSize);
      pline := topline;
   end;

   refresh_screen;
end;



procedure insert_char(c: char);
begin

   if ccol < curlength then begin
      remove_trailing;
      if ccol > curlength then
         reposition(TRUE);
   end;

   if (insert_mode and (curlength >= MsgMaxLen)) or (ccol > MsgMaxLen) then begin
      if (ccol <= MsgMaxLen) then word_wrap
      else if c = ' ' then begin
         cursor_newline;
         exit;
      end else
          if lastchar = ' ' then cursor_newline   {nonspace w/space at end-line is newline}
             else word_wrap;                      {otherwise wrap word down and continue}
   end;

   {insert character into the middle of a line}

   if insert_mode and (ccol <= curlength) then begin

      insert(c,LinePtr^[CurrentLine],ccol);

      {update display line following cursor}
      mciallowed:=FALSE;
      colorallowed:=FALSE;
      allowabort:=FALSE;
      printmain(copy(LinePtr^[CurrentLine],ccol,MsgMaxLen));
      mciallowed:=TRUE;
      colorallowed:=TRUE;
      allowabort:=TRUE;

      {position cursor for next insertion}
      inc(ccol);
      reposition(TRUE);
   end else begin {append a character to the end of a line}
      while curlength < ccol do
         append_space;

      LinePtr^[CurrentLine][ccol] := c;

      {advance the cursor, updating the display}
      cursor_right;
   end;

   set_phyline;
end;

procedure delete_char;
begin
   {delete whole line if it is empty}
   if (ccol>curlength) and (curlength>0) then
      join_lines
   else if ccol<=curlength then begin {delete in the middle of a line}
      delete(LinePtr^[CurrentLine],ccol,1);
      mciallowed:=FALSE;
      colorallowed:=FALSE;
      allowabort:=FALSE;
      printmain(copy(LinePtr^[CurrentLine],ccol,MsgMaxLen)+' ');
      mciallowed:=TRUE;
      colorallowed:=TRUE;
      allowabort:=TRUE;
      reposition(TRUE);
      set_phyline;
   end;
end;

procedure delete_wordright;
begin
   if curchar=' ' then
      repeat   {skip blanks right}
         delete_char;
      until (curchar<>' ') or (ccol>curlength)
   else
     begin
       repeat   {find next blank right}
         delete_char;
       until delimiter;
       delete_char;
     end;
end;

procedure page_down;
begin
   if topline+ScreenLines<MaxLi then begin
      inc(CurrentLine,ScrollSize);
      scroll_screen(ScrollSize);
   end;
end;

procedure page_up;
begin
   if topline>1 then begin
      dec(CurrentLine,ScrollSize);
      if CurrentLine<1 then
         CurrentLine:=1;
      scroll_screen(-ScrollSize);
   end else begin
      CurrentLine:=1;
      ccol:=1;
      scroll_screen(0);
   end;
end;

procedure fs_insert_line;
   {open a blank line, update display}
begin
   insert_line('');
   if CurrentLine-topline > ScreenLines-2 then
      scroll_screen(ScrollSize)
   else
      refresh_screen;
end;

procedure fs_delete_line;
   {delete the line at the cursor, update display}
begin
   delete_line;
   refresh_screen;
end;

procedure display_insert_status;
begin
   ansig(69,1);
   prompt('^1(Mode: ');
   if insert_mode then prompt('INS)')
      else prompt('OVR)');
end;

procedure prepare_screen;
var i:byte;
begin
   cls;

   ansig(1,1);
   if (timewarn) then
      prompt(^G^G'          |12Warning: |10You have less than '+cstr(nsl div 60 + 1)+' minute'+
             Plural(nsl div 60 + 1)+' remaining online!')
   else
     begin
       prompt('^1(Ctrl-Z = Help)  ^5To:^1 '+mln(fto,20)+ ' ^5Subj: ^1');

       if (mheader.fileattached = 0) then
         print(mln(mftit,20))
       else
         print(mln(stripname(mftit),20));

       display_insert_status;
     end;

   ansig(1,2);
   dolines;

   for i:=1 to ScreenLines do  {physical lines are now invalid}
      phyline[i]:='';

   scroll_screen(0); {causes redisplay}
end;


procedure Redisplay;
begin
    Topline:= Currentline-Screenlines div 2;
    Prepare_Screen;
end; { ? }

procedure Fs_Help;
begin
    Cls;
    Printf ('fshelp');
    Pausescr (false);
    Prepare_Screen;
end; { ? }

procedure Doquote (Redrawscreen : boolean);
var Fline, Nline: word;
    Qf: text;
    done: boolean;

procedure Getout (x: boolean);
   begin
       if x then close (Qf);
       if Invisedit and Redrawscreen then Prepare_Screen;
       Mciallowed:= true;
   end; { ? }

begin
    assign (Qf, 'TEMPQ'+ Cstr (Node) );
    reset (Qf);
    if ioresult<> 0 then exit;

    if (Maxquotelines = 0) then
    begin
        while not eof (Qf) do
        begin
            readln (Qf, S);
            inc (Maxquotelines);
        end; { while }
        close (Qf);
        reset (Qf);
    end; { if }
    Mciallowed:= false;

    done:= false;

    repeat
        Abort:= false;
        Quoteli:= 0;
        Cls;

        if Lastquoteline> 0 then
            while not eof (Qf) and (Quoteli< Lastquoteline) do begin
                readln (Qf, S);
                inc (Quoteli);
            end; { while }

        if eof (Qf) then
        begin
            Lastquoteline:= 0;
            Quoteli:= 0;
            reset (Qf);
        end; { if }

        while (not eof (Qf) ) and (Quoteli-Lastquoteline < Pagelength-4) do
        begin
            readln (Qf, S);
            inc (Quoteli);
            if (Quoteli < 10) then
                S := ' ' + Cstr (Quoteli) + ':' + S
            else
                S := Cstr (Quoteli) + ':' + S;
            S:= copy (S, 1, 79);
            Printacr ('^3'+ S);
        end; { while }

        close (Qf);
        reset (Qf);

        repeat
            Prt (^M^J'First line to quote [?=Help] : ');
            Scaninput (S, 'HQ?'^M);
            if S= '?' then
                Print (^M^J'^1<^3Q^1>uit, <^3H^1>eader, <^3?^1>Help, or first line to quote.');
            if (S = 'H') then begin
                while (S<> '') and (not eof (Qf) ) and (Currentline <= Maxli) do begin
                    readln (Qf, S);
                    if Invisedit then
                        Insert_Line (S)
                    else
                    begin
                        Lineptr^[Linetotal] := S;
                        inc (Linetotal);
                    end; { if else }
                    inc (Currentline);
                end; { while }
                close (Qf); reset (Qf);
                S:= 'H';
            end; { if }
        until (Hangup) or ( (S<> '?') and (S<> 'H') );

        Fline:= Value (S);
        if Fline<= 0 then Lastquoteline:= Quoteli;
        if S= 'Q' then done:= true;
        if (Fline> Maxquotelines) or (Hangup) then begin Getout (true); exit; end; { if }

        if (Fline> 0) then begin
            Prt ('Last line to quote : ');
            Scaninput (S, 'Q'^M);

            if S<> #13 then Nline:= Value (S) else Nline:= Fline;

            if (Nline< Fline) or (Nline> Maxquotelines) then begin Getout (true); exit; end; { if }

            Nline:= Nline-Fline+1;

            while (not eof (Qf) ) and (Fline> 1) do begin
                dec (Fline);
                readln (Qf, S);
            end; { while }

            if not Invisedit then Currentline:= Linetotal;

            while (not eof (Qf) ) and (Nline> 0) and (Currentline<= Maxli) do begin
                dec (Nline);
                readln (Qf, S);
                if Invisedit then
                    Insert_Line (S)
                else
                begin
                    Lineptr^[Linetotal] := S;
                    inc (Linetotal);
                end; { if else }
                inc (Currentline);
            end; { while }
            done:= true;
        end; { if }
    until (done) or Hangup;
    Getout (true);
    Lasterror := ioresult;
end; { ? }

procedure fs_editor;

var
  c:word;
begin
   insert_mode:=TRUE;
   invisedit:=TRUE;
   oldtimewarn := timewarn;
   quoteli:=1;
   count_lines;
   if LineTotal>0 then CurrentLine:=LineTotal+1 else CurrentLine:=1;
   ccol:=1;
   topline:=1;
   ScreenLines := pagelength-4;
   if ScreenLines > 20 then
     ScreenLines := 20;

   while (CurrentLine-topline) > (ScrollSize + 3) do
      inc(topline,ScrollSize);

   prepare_screen;

   repeat
     if ((ImportFileOpen) and (buf='')) then
       if (not eof(ImportFile)) then
         begin
           readln(ImportFile,buf);
           buf:=buf+^M
         end
       else
         begin
           close(ImportFile);
           ImportFileOpen:=FALSE;
         end;

       if (timewarn) and (not oldtimewarn) then
         begin
          ansig(1,1);
          prompt(^G^G'               |12Warning: |10You have  '+cstr(nsl div 60)+' minute(s) remaining online!');
          ansig(ccol,CurrentLine-topline+TopScreen);
          oldtimewarn := TRUE;
         end;

       c := getkey;

       case c of
          47:if (ccol = 1) and (not ImportFileOpen) then
                c := 27
              else
                insert_char(char(c));
         127:delete_char;
     32..254:insert_char(char(c));
           8:begin
                if ccol=1 then begin
                   cursor_left;
                   join_lines;
                 end else begin
                   cursor_left;
                   delete_char;
                 end;
              end;
 F_CTRLLEFT,1:cursor_wordleft;  { ^A }
            2:fs_reformat;      { ^B }
     F_PGDN,3:page_down;        { ^C }
    F_RIGHT,4:cursor_right;     { ^D }
       F_UP,5:cursor_up;        { ^E }
F_CTRLRIGHT,6:cursor_wordright; { ^F }
      F_DEL,7:delete_char;      { ^G }
            9:repeat insert_char(' '); until (ccol mod 5)=0;  { ^I }
           10:join_lines;       { ^J }
     F_END,11:cursor_endline;   { ^K }
           12:redisplay;        { ^L }
           13:cursor_newline;   { ^M }
           14:begin
                split_line;
                reposition(TRUE);
              end;              { ^N }
           16:begin             { ^P }
                c := getkey;
                if (c in [0..9,ord('0')..ord('9')]) then
                  begin
                    insert_char('^');
                    insert_char(char(c));
                  end
                else
                  buf := char(c);
              end;
           17:doquote(TRUE);   { ^Q }
    F_PGUP,18:page_up;         { ^R }
    F_LEFT,19:cursor_left;     { ^S }
           20:delete_wordright;{ ^T }

     F_INS,22:begin            { ^V }
                insert_mode:=not insert_mode;
                display_insert_status;
                reposition(TRUE);
              end;

    F_HOME,23:cursor_startline; { ^W }
    F_DOWN,24:cursor_down;      { ^X }
           25:fs_delete_line;   { ^Y }
           26:fs_help;          { ^Z }
       end;
   until ((c = 27) and not (ImportFileOpen)) or hangup;

   if ImportFileOpen then
     begin
       close(ImportFile);
       ImportFileOpen := FALSE;
     end;
   count_lines;
   invisedit:=FALSE;
end;

  procedure listit(stline:integer; linenum,disptotal:boolean);
  var lasts:astr;
      l:integer;
  begin
    mciallowed:=FALSE;
    if (disptotal) then nl;
    l:=stline;
    abort:=FALSE;
    next:=FALSE;
    dosansion:=FALSE;
    lasts:='';

    while ((l<LineTotal) and (not abort)) do begin
      if (linenum) then print(cstr(l)+':');
      {if ((pos(^[,LinePtr^[l])=0) and (pos(^[,lasts)=0)) then dosansion:=FALSE;}

      reading_a_msg:=TRUE;
      if not dosansion then
        if pos('>',copy(s,1,4))>0 then
          UserColor(3)
        else
          UserColor(1);
      printacr(LinePtr^[l]);
      reading_a_msg:=FALSE;

      lasts:=LinePtr^[l];
      inc(l);
    end;

    dosansion:=FALSE;
    if (disptotal) then
      print('  ^7** ^3'+cstr(LineTotal-1)+' lines ^7**');
    saveline:=FALSE;
    UserColor(1);
    mciallowed:=TRUE;
  end;

  procedure AddressMessage;
  var u:userrec;
      s1:string[50];
      i:integer;
  begin

    print(fstring.default + ^M^J);

    if pub and not (mbinternet in memboard.mbstat) then begin
      prt('To: ');
      if fto<>'' then
        inputdefault(s,fto,50,'lp',FALSE)
       else
         begin
           mpl(50);
           inputmain(s,50,'lp');
         end;

      UserColor(6);
      fto:=s;
      for i:=1 to lennmci(fto) do
        backspace;

      i:=value(fto);

      if (i>0) and (i<=maxusers-1) and not (netmail in mheader.status) then
        begin
          loadurec(u,i);
          fto:=caps(u.name);
          mheader.mto.usernum:=i;
          mheader.mto.real:=u.realname;
          if (pub) and (mbrealname in memboard.mbstat) then
            fto:=caps(u.realname)
          else
            fto:=caps(u.name);
        end;

      if (sqoutsp(fto)='') then
         fto:='All';

      if (fto <> '') then
        begin
          prompt(fto);
          UserColor(1);
          nl;
        end;

      nl;

    end else
      if not (mbinternet in memboard.mbstat) then
        print(mln('^4To: ^6'+caps(fto),49) + ^M^J);

    if (mheader.fileattached = 0) and (not cantabort) then
      begin
        prt('Subject: ');

        if (mftit<>'') then
          inputdefault(s,mftit,40,'L',FALSE)
        else
          begin
            mpl(40);
            inputmain(s,40,'l');
            nl;
          end;
        if s<>'' then
          begin
            UserColor(1);
            nl;
            mftit:=s;
          end
        else
          begin
            if mftit<>'' then
              print('^6'+mftit+'^1')
            else
              exit;
        end;
      end
    else
      mftit := mheader.subject;
  end;


  procedure Replace;
  begin
    if (LineTotal<=1) then print('^7Nothing to replace!') else begin
      print('^5Replace string -'^M^J);

      prt('On which line (1-'+cstr(LineTotal-1)+') ? ');
      input(s,4);
      if (value(s)<1) or (value(s)>LineTotal-1) then
        print('^7Invalid line number.')
      else begin
        print(^M^J'^3Original line:');
        abort:=FALSE; next:=FALSE;
        mciallowed:=FALSE;
        printacr(LinePtr^[value(s)]);
        mciallowed:=TRUE;
        print(^M^J'^4Enter string to replace:');
        prt(':');
        inputl(s1,78);
        if (s1<>'') then
          if (pos(s1,LinePtr^[value(s)])=0) then
            print('^7String not found.')
          else begin
            print('^4Enter replacement string:');
            prt(':');
            inputl(s2,78);
            if (s2<>'') then begin
              if pos(s1,LinePtr^[value(s)])>0 then begin
                 insert(s2,LinePtr^[value(s)],(pos(s1,LinePtr^[value(s)])+length(s1)));
                 delete(LinePtr^[value(s)],pos(s1,LinePtr^[value(s)]),length(s1));
              end;
              print(^M^J'^3Edited line:');
              abort:=FALSE;
              next:=FALSE;
              mciallowed:=FALSE;
              printacr(LinePtr^[value(s)]);
              mciallowed:=TRUE;
            end;
          end;
        end;
        nl;
    end;
  end;

  procedure printmsgtitle;
  begin
    print(fstring.entermsg1);
    print(fstring.entermsg2);
    dolines;
  end;

  procedure inputthemessage;
  var
    t1:integer;

    procedure uploadfile;
    var
      dok,kabort,addbatch:boolean;
      tooktime:longint;
    begin
      nl;
      s:='';
      if CoSysOp then begin
        prt('Enter file to import [Enter=Upload]: ');
        mpl(40);
        inputl(s,40);
      end;
      if s='' then begin
         s:='TEMPMSG.'+cstr(node);
         if exist(s) then
           kill(s);
      end;
      if (not exist(s)) and (incom) then
        begin
          receive(s,tempdir + 'UP\', FALSE,dok,kabort,addbatch,tooktime);
          s := tempdir + 'UP\' + s;
        end;
      UserColor(1);
      if ((s<>'') and (not hangup)) then begin
         assign(ImportFile, s);
         reset(ImportFile);
         if ioresult=0 then
           ImportFileOpen:=TRUE;
      end;
    end;

  begin
    fillchar(LinePtr^[1], 121 * MaxLi, 0);
    abort:=FALSE;
    next:=FALSE;
    quoteli:=1;
(*    if (diskfree(ExtractDriveNumber(general.msgpath) div 1024)<general.minspaceforpost) then*)
    if (diskKBfree(ExtractDriveNumber(general.msgpath))<general.minspaceforpost) then
      begin
        mftit:='';
        print(^M^J'Not enough disk space to save a message.');
        c:=chr(ExtractDriveNumber(general.msgpath)+64);
        if (c='@') then
          sysoplog('^8--->^3 Message save failure: Drive full.')
        else
          sysoplog('^8--->^3 Message save failure: '+c+' Drive full.');
      end
    else
      begin
        LineTotal:=1;
        LastLine:='';
        if (ReadInMsg <> '') then
          begin
            assign(ImportFile,ReadInMsg);
            reset(ImportFile);
            if (IOResult = 0) then
              begin
                while (not eof(ImportFile)) and (LineTotal <= MaxLi) do
                  begin
                    readln(ImportFile, LinePtr^[LineTotal]);
                    inc(LineTotal);
                  end;
                close(ImportFile);
              end;
          end
        else
          AddressMessage;
      end;

    if (mftit='') then
      if (not cantabort) then begin
        save:=FALSE;
        exit;
      end;

    if (fseditor in thisuser.sflags) then begin
       repeat
         fs_editor;
         repeat
           {***ansig(1,x);}
           prt(^M^J'Command (^5?^4=^5Help^4) : ');
           onekcr:=TRUE;
           onek(c,'SARITC?MUQ');
           case c of
              '?':begin
                    nl;
                    lcmds(16,3,'Abort message','Continue message');
                    lcmds(16,3,'Title change','Include file');
                    lcmds(16,3,'Restart message','Save message');
                    lcmds(16,3,'Quote message','Upload message');
                    lcmds(16,3,'MCI Codes Yes/No','');
                  end;
              'M':begin
                   nl;
                   if DisableMCI then DisableMCIStr := 'Yes'
                   else DisableMCIStr := 'No';
                   if pynq('Disable MCI Codes for this message (y,n)/['+DisableMCISTr+']: ') then DisableMCI := True
                   else DisableMCI := False;
                  end;
              'T':begin
                    nl;
                    AddressMessage;
                    print('^0Continue message...');
                  end;
              'I':if aacs(general.fileattachacs) then
                     fileattach;
              'Q':begin invisedit:=TRUE; doquote(FALSE); invisedit:=FALSE; end;
              'U':uploadfile;
              'R':if pynq('Are you sure? ') then
                    for t1:=1 to LineTotal do LinePtr^[t1][0]:=#0;
          'A','S':if cantabort and ((LineTotal = 0) or (c = 'A')) then
                    begin
                      c := #0;
                      print(^M^J'You cannot abort this message.');
                    end
                  else
                    if (c='A') and pynq('Are you sure? ') then
                      begin
                        save := FALSE;
                        abortit := TRUE;
                        exit;
                      end
                    else
                      if (c = 'A') then
                        c := #0;
           end;
         until (pos(c,'USACRQ')>0) or (hangup);
       until (hangup) or (pos(c,'SA')>0);
       nl;
       inc(LineTotal);
       if (LineTotal>1) and (not hangup) then save:=TRUE
         else begin
           abortit:=TRUE;
         end;
       exit;
    end;
    printmsgtitle;
    repeat
      repeat
        saveline:=TRUE;
        exited:=FALSE;
        save:=FALSE;
        abortit:=FALSE;
        write_msg:=TRUE;
        InputLine(s);
        write_msg:=FALSE;
        if (s='/'^H) then begin
          saveline:=FALSE;
          if (LineTotal<>1) then begin
            dec(LineTotal);
            LastLine:=LinePtr^[LineTotal];
            if LastLine[length(LastLine)] = #1 then
              LastLine:=copy(LastLine,1,length(LastLine)-1);
            print('^0Backed up to line '+cstr(LineTotal)+':^1');
          end;
        end;
        if (s='/') and not (ImportFileOpen) then begin
          prompt('^3Command (^0?^3=^0help^3) : ^3');
          c := char(getkey);
          BackErase(19);
          saveline:=FALSE;
          case upcase(c) of
            'U':uploadfile;
            '?','H':printf('prhelp');
            'A':if (not cantabort) then
                  if pynq(^M^J'^7Abort message? ') then begin
                    exited:=TRUE;
                    abortit:=TRUE;
                  end else
                    print('^0Nothing done.'^M^J);
            'C':if pynq(^M^J'^7Clear message? ') then begin
                  print('^0Message cleared.... Start over...');
                  LineTotal:=1;
                  escp:=FALSE;
                end else
                  print('^0Nothing done.'^M^J);
            'E':exited:=TRUE;
            'I':if aacs(general.fileattachacs) then
                  fileattach;
            'L':listit(1,pynq(^M^J'^7List message with line numbers? '),TRUE);
            'O':printf('color');
            'P':Replace;
            'Q':if (not exist('TEMPQ'+cstr(node))) then
                  print('^0You are not replying to a message.'^M^J)
                else
                  begin
                    doquote(FALSE);
                    cls;
                    print('^0Quoting complete.  Continue:');
                    printmsgtitle;
                    if (LineTotal>1) then
                      if (LineTotal>10) then listit(LineTotal-10,FALSE,FALSE)
                        else listit(1,FALSE,FALSE);
                  end;
              'M':begin
                   nl;
                   if DisableMCI then DisableMCIStr := 'Yes'
                   else DisableMCIStr := 'No';
                   if pynq('Disable MCI Codes for this message (y,n)/['+DisableMCISTr+']: ') then DisableMCI := True
                   else DisableMCI := False;
                  end;
            'R':if (LineTotal>1) then begin
                  print('^0Last line deleted.  Continue:^1');
                  dec(LineTotal);
                end;
            'S':begin
                if ((not cantabort) or (LineTotal > 1)) then
                  begin
                    while ((LineTotal > 1) and ((LinePtr^[LineTotal-1] = '') or (LinePtr^[LineTotal-1] = ^J))) do
                      dec(LineTotal);
                    if (LineTotal > 1) then
                      Save := TRUE
                    else
                      if (not cantabort) then
                        abortit := TRUE
                      else
                        print(^M^J'You cannot abort this message.');
                    exited := (Save or Abortit);
                  end;
                end;
            'T':AddressMessage;
          end;
        end;


        if (saveline) then begin
          LinePtr^[LineTotal]:=s;
          inc(LineTotal);
          if (LineTotal>MaxLi) then begin
            print('You have used up your maximum amount of lines.');
            if (ImportFileOpen) then begin
              ImportFileOpen:=FALSE;
              close(ImportFile);
            end;
            exited:=TRUE;
          end;
        end;
      until ((exited) or (hangup));
      if (hangup) then abortit:=TRUE;
      if ((not abortit) and (not save)) then
        repeat
          prt('^3Message editor (^0?^3=^0help^3) : ');
          onek(c,'SACDILRTUM?'); nl;
          case c of
            '?':begin
                  lcmds(15,3,'List message','Continue message');
                  lcmds(15,3,'Save message','Abort message');
                  lcmds(15,3,'Delete line','Insert line');
                  lcmds(15,3,'Replace line','Update line');
                  lcmds(15,3,'Title re-do','MCI Codes On/Off');
                end;
            'A':if (not cantabort) then
                  if pynq('Abort message? ') then abortit:=TRUE
                    else c:=' ';
            'C':if (LineTotal>MaxLi) then begin
                  print('^7Too many lines!');
                  c:=' ';
                end else
                  prompt('^0Continue...');
            'D':begin
                  prt('Delete which line (1-'+cstr(LineTotal-1)+') ? ');
                  input(s,4);
                  i:=value(s);
                  if (i>0) and (i<LineTotal) then begin
                    for t1:=i to LineTotal-2 do
                      LinePtr^[t1]:=LinePtr^[t1+1];
                    dec(LineTotal);
                  end;
                end;
            'I':if (LineTotal<MaxLi) then begin
                  prt('Insert before which line (1-'+cstr(LineTotal-1)+') ? ');
                  input(s,4);
                  i:=value(s);
                  if (i>0) and (i<LineTotal) then begin
                    for t1:=LineTotal downto i+1 do LinePtr^[t1]:=LinePtr^[t1-1];
                    inc(LineTotal);
                    print('^3New line:');
                    InputLine(s1);
                    LinePtr^[i]:=s1;
                  end;
                end else
                  print('^7Too many lines!');
            'L':listit(1,pynq('With line numbers? '),TRUE);
            'M':begin
                   nl;
                   if DisableMCI then DisableMCIStr := 'Yes'
                   else DisableMCIStr := 'No';
                   if pynq('Disable MCI Codes for this message (y,n)/['+DisableMCISTr+']: ') then DisableMCI := True
                   else DisableMCI := True;
                end;

            'R':begin
                  prt('Line number to replace (1-'+cstr(LineTotal-1)+') ? ');
                  input(s,4);
                  i:=value(s);
                  if ((i>0) and (i<LineTotal)) then begin
                    abort:=FALSE;
                    print(^M^J'^3Old line:');
                    mciallowed:=FALSE;
                    printacr(LinePtr^[i]);
                    mciallowed:=TRUE;
                    print('^3Enter new line:');
                    InputLine(s);
                    if (LinePtr^[i][length(LinePtr^[i])]=#1) and
                       (s[length(s)]<>#1) then LinePtr^[i]:=s+#1 else LinePtr^[i]:=s;
                  end;
                end;
            'S':begin
                if ((not cantabort) or (LineTotal > 1)) then
                  begin
                    while ((LineTotal>1) and ((LinePtr^[LineTotal-1]='') or (LinePtr^[LineTotal-1]=^J))) do
                      dec(LineTotal);
                    if LineTotal>1 then save:=TRUE
                      else abortit:=TRUE;
                  end;
                end;
            'T':AddressMessage;
            'U':Replace;
          end;
          nl;
        until (c in ['A','C','S']) or (hangup);
    until ((abortit) or (save) or (hangup));
    if (LineTotal=1) then begin
      abortit:=TRUE;
      save:=FALSE;
    end;
  end;

  procedure saveit;
  var i,j:integer;
      c:char;
      s:astr;

  begin
    Lasterror := IOResult;
    Lasterror := 0;
    reset(msgtxtf,1);
    if (IOResult = 2) then
      rewrite(msgtxtf,1);
    mheader.textsize:=0;
    mheader.pointer:=filesize(msgtxtf)+1;
    seek(msgtxtf,filesize(msgtxtf));
    if (netmail in mheader.status) and (pos('@', mheader.mto.a1s) > 0) then
      begin
        for i := 1 to length(mheader.mto.a1s) do
          if (mheader.mto.a1s[i] in ['A'..'Z']) then
            inc(mheader.mto.a1s[i], 32);
        s := 'To: ' + fto;
        blockwrite(msgtxtf, s, length(s) + 1);
        inc(mheader.textsize, length(s) + 1);
        mheader.mto.a1s := 'UUCP';
      end;
    with memboard do begin
      if ((pub) and (mbfilter in mbstat)) then begin
        for i:=1 to LineTotal-1 do
          if length(LinePtr^[i])>0 then begin
            LinePtr^[i]:=stripcolor(LinePtr^[i]);
            for j:=1 to length(LinePtr^[i]) do begin
              c:=LinePtr^[i][j];
              if (c in [#0..#1,#3..#31,#127..#255]) then c:='*';
              LinePtr^[i][j]:=c;
            end;
          end;
      end;
      for i:=1 to LineTotal-1 do begin
        s:=LinePtr^[i];
        inc(mheader.textsize,length(s)+1);
        blockwrite(msgtxtf,s,length(s) + 1);
      end;
      if (mbtype in [1,2]) and (mbaddtear in mbstat) then begin
        s := '';
        inc(mheader.textsize,length(s) + 1);
        blockwrite(msgtxtf,s,1);
        s:=decode(';hl?kf', 183)+ver;
        inc(mheader.textsize,length(s)+1);
        blockwrite(msgtxtf,s,length(s)+1);
        s:=' * Origin: ';
        if (memboard.origin<>'') then
          s := s + memboard.origin
        else
          s := s + general.origin;
        s := s + ' (';
        if (aka > 19) then aka := 0;
        s := s + cstr(general.aka[aka].zone) + ':' +
                 cstr(general.aka[aka].net)  + '/' +
                 cstr(general.aka[aka].node);
        if (General.aka[aka].point > 0) then
          s := s + '.' + cstr(General.aka[aka].point);
        s := s + ')';
        inc(mheader.textsize,length(s) + 1);
        blockwrite(msgtxtf,s,length(s) + 1);
      end;
    end;
    close(msgtxtf);
    Lasterror := IOResult;
    if (Lasterror <> 0) then
      sysoplog('error saving message.');
    DisableMCI := False;
  end;


begin
  MaxLi := (MaxAvail div 120)-20;  { save 2400 bytes }
  if (MaxLi > 200) then
    MaxLi := 200;
  GetMem (LinePtr, MaxLi * 120);
  MaxQuoteLines := 0;
  loadnode(node);
  nodesave:=noder.activity;
  update_node(4);
  InputMessage:=FALSE;
  ImportFileOpen:=FALSE;
  Escp := FALSE;
  lastquoteline:=0;
  cls;
  if (uti) then
    begin
      if (mbrealname in memboard.mbstat) then
        fto:=caps(mheader.mto.real)
      else
        fto:=caps(mheader.mto.a1s)
    end
  else
    fto:='';
  if (irt <> '') then
    mftit := irt
  else
    mftit := ftit;

  if (copy(mftit,1,1) = '\') then
    begin
      mftit:=copy(mftit,2,length(mftit)-1);
      mheader.subject := mftit;
      cantabort:=TRUE;
    end
  else
    cantabort:=FALSE;

  if mftit[1]=#1 then
    begin
      mftit:=copy(mftit,2,length(mftit)-1);
      if mheader.subject[1] = #1 then
        mheader.subject:=copy(mheader.subject,2,length(mheader.subject)-1);
    end
  else
    if (mftit<>'') and (copy(mftit,1,3)<>'Re:') then
      mftit:='Re: '+copy(mftit,1,64);

  mheader.fileattached := 0;

  inputthemessage;

  if (ReadInMsg <> '') and (save) then
    begin
      assign(ImportFile, ReadInMsg);   { Just incase Importfile was used }
      rewrite(ImportFile);
      if (IOResult = 0) then
        begin
          for i := 1 to LineTotal-1 do
            writeln(ImportFile, LinePtr^[i]);
          close(ImportFile);
        end;
      InputMessage := TRUE;
      FreeMem(LinePtr,Maxli * 120);
      update_node(nodesave);
      exit;
    end;

  dosansion:=FALSE;
  kill('TEMPQ'+cstr(node));

  if (not save) or (hangup) then
    begin
      print('Aborted.');
      update_node(nodesave);
    end
  else
    begin
      with mheader do begin
        subject:=mftit;
        origindate:='';
        from.anon:=0;
        mto.anon:=0;
        replies:=0;
        replyto:=0;
        date := getpackdatetime;
        getdayofweek(dayofweek);
        if (pub and (memboard.mbtype in [1, 2])) or (not pub and (netmail in mheader.status)) then
          begin
            newechomail:=TRUE;
            if not (mbscanout in memboard.mbstat) then
              UpdateBoard;
          end;
        with from do begin
          usernum:=common.usernum;
          s:=allcaps(thisuser.name);
          if (not pub) and (netmail in mheader.status) and (thisuser.name<>allcaps(thisuser.realname)) then
            begin
              dyny:=TRUE;
              if (general.allowalias) and pynq('Send this with your real name? ') then
                s:=allcaps(thisuser.realname);
            end;
          a1s:=s;
          real:=allcaps(thisuser.realname);
          name:=allcaps(thisuser.name);
        end;
        status:=[] + (status * [netmail]);
        if (pub) and (rvalidate in thisuser.flags) then
            status:=status+[unvalidated];

        if (aacs(memboard.mciacs)) then begin
           status:=status+[allowmci];
           If DisableMCI then status:=status-[allowmci];
        end;

        if pub then
           with mto do
             begin
               name:=fto;
               real:=fto;
               a1s:=fto;
             end;
        if not (netmail in mheader.status) then
          anonymous(FALSE, mheader);
      end;

      prompt(^M^J'^7Saving...');

      saveit;

      update_node(nodesave);

      UserColor(5);
      BackErase(9);
      InputMessage := TRUE;
    end;

    FreeMem(LinePtr,Maxli * 120);
end;

procedure inputline(var i:astr);
var s:astr;
    cp,rp,cv,cc,j:integer;
    c,c1,ccc:char;
    hitcmdkey,hitbkspc,dothischar:boolean;

  procedure bkspc;
  begin
    if (cp>1) then begin
      if (i[cp-2]='^') and (i[cp-1] in [#0..#9]) then
        begin
          dec(cp);
          UserColor(1);
        end
      else
        begin
          backspace;
          dec(rp);
        end;
      dec(cp);
    end;
  end;

begin
  write_msg:=TRUE;
  hitcmdkey:=FALSE;
  hitbkspc:=FALSE;
  ccc:='1';
  rp:=1; cp:=1;
  i:='';
  if (LastLine<>'') then begin
    abort:=FALSE; next:=FALSE;
    allowabort := FALSE;
    reading_a_msg:=TRUE;
    printmain(LastLine);
    reading_a_msg:=FALSE;
    allowabort := TRUE;
    i:=LastLine; LastLine:='';
    if (pos(^[,i) > 0) then
      escp := TRUE;
    cp:=length(i)+1;
    rp:=cp;
  end;
  repeat
    if ((ImportFileOpen) and (buf='')) then
      if (not eof(ImportFile)) then begin
        j := 0;
        repeat
          inc(j);
          read(Importfile, buf[j]);
          if (buf[j] = ^J) then
            dec(j);
        until (j >= 255) or (buf[j] = ^M) or (eof(ImportFile));
        buf[0] := chr(j);
        {if (buf[j] <> ^M) then buf:=buf+^M;}
      end else begin
        close(ImportFile);
        ImportFileOpen:=FALSE;
        dosansion:=FALSE;
        buf:=^P+'1';
      end;
    c := char(getkey);

    dothischar:=FALSE;

      if ((c>=#32) and (c<=#255)) then begin
        if (c='/') and (cp=1) then hitcmdkey:=TRUE else dothischar:=TRUE;
      end else
        case c of
          ^[ : dothischar:=TRUE;
          ^H : if (cp=1) then begin
               hitcmdkey:=TRUE;
               hitbkspc:=TRUE;
             end else
               bkspc;
          ^I:begin
               cv:=5-(cp mod 5);
               if (cp+cv<strlen) and (rp+cv<thisuser.linelen) then
                 for cc:=1 to cv do begin
                   outkey(' '); if (trapping) then write(trapfile,' ');
                   i[cp]:=' ';
                   inc(rp); inc(cp);
                 end;
             end;
          ^J:begin
               outkey(c); i[cp]:=c;
               if (trapping) then write(trapfile,^J);
               inc(cp);
             end;
          ^N:begin
               outkey(^H); i[cp]:=^H;
               if (trapping) then write(trapfile,^H);
               inc(cp); dec(rp);
             end;
          ^P:if (okansi or okavatar) and (cp<strlen-1) then begin
               c1 := char(getkey);
               if (c1 in ['0'..'9']) then begin
                 ccc:=c1; i[cp]:='^';
                 inc(cp); i[cp]:=c1;
                 inc(cp); UserColor(ord(c1)-ord('0'));
               end;
             end;
          ^W:if (cp=1) then begin
               hitcmdkey:=TRUE;
               hitbkspc:=TRUE;
             end else
               repeat bkspc until (cp=1) or (i[cp]=' ') or
                                  ((i[cp]=^H) and (i[cp-1]<>'^'));
          ^X,^Y:begin
               cp:=1;
               for cv:=1 to rp-1 do backspace;
               rp:=1;
               if (ccc<>'1') then begin
                 c1:=ccc; i[cp]:='^';
                 inc(cp); i[cp]:=c1;
                 inc(cp); UserColor(ord(c1)-ord('0'));
               end;
             end;
        end;

    if (dothischar) and ((c<>^G) and (c<>^M)) then
      if ((cp<strlen) and (escp)) or
         ((rp<thisuser.linelen{-5}) and (not escp)) then begin
        if (c=^[) then escp:=TRUE;
        i[cp]:=c; inc(cp); inc(rp);
        outkey(c);
        if (trapping) then write(trapfile,c);
      end;
  until ((rp = 78) and (not escp)) or (cp = strlen) or
        (c = ^M) or (hitcmdkey) or (hangup);

  if (hitcmdkey) then begin
    if (hitbkspc) then i:='/'^H else i:='/';
  end else begin
    i[0]:=chr(cp-1);
    if (c<>^M) and (cp<>strlen) and (not escp) then begin
      cv:=cp-1;
      while (cv>1) and (i[cv]<>' ') and ((i[cv]<>^H) or (i[cv-1]='^')) do dec(cv);
      if (cv>rp div 2) and (cv<>cp-1) then begin
        LastLine:=copy(i,cv+1,cp-cv);
        for cc:=cp-2 downto cv do backspace;
        i[0]:=chr(cv-1);
      end;
    end;

    if (escp) and (rp=thisuser.linelen) then cp:=strlen;

    if (cp<>strlen) then
      nl
    else begin
      rp:=1; cp:=1;
      i:=i+#29;
    end;
  end;

  write_msg:=FALSE;
end;

end.
