Newuserrec=                            { USERS.DAT : User records }
    record
      name,                             { system name        }
      realname:string[36];              { real name          }
      street,                           { street address     }
      citystate:string[30];             { city, state        }
      callerid:string[20];              { caller ID string   }
      zipcode:string[10];               { zipcode            }
      ph:string[12];                    { phone #            }
      pw:longint;                       { password           }
      usrdefstr:array[1..3] of
          string[35];                   { definable strings  }
      Birthdate,                        { Birth date         }
      FirstOn,                          { First On Date      }
      LastOn:unixtime;                  { Last On Date       }
      note:string[35];                  { SysOp note         }
      userstartmenu:string[8];          { menu to start at   }
      lockedfile:string[8];             { print lockout msg  }
      flags:set of uflags;              { flags              }
      sflags:set of suflags;            { status flags       }
      ar:set of acrq;                   { AR flags           }
      vote:array[1..25] of byte;        { voting data        }

      res8:byte;                        { reserved for later }
      sex:char;                         { gender             }
      ttimeon,                          { total time on      }
      uk,                               { UL k               }
      dk,                               { DL k               }
      lastqwk,                          { last qwk packet    }
      credit,                           { Amount of credit   }
      debit,                            { Amount of debit    }
      expiration,                       { Expiration date    }
      passwordchanged:unixtime;         { date pw changed    }

      tltoday,                          { # min left today   }
      forusr:integer;                   { forward mail to    }

      uploads,                          { # of DLs           }
      downloads,                        { # of DLs           }
      loggedon,                         { # times on         }
      msgpost,                          { # message posts    }
      emailsent,                        { # email sent       }
      feedback,                         { # feedback sent    }
      timebank,                         { # mins in bank     }
      timebankadd,                      { # added today      }
      dlktoday,                         { # kbytes dl today  }
      dltoday,                          { # files dl today   }
      timebankwith,                     { Time withdrawn     }
      lastmbase,                        { # last msg base    }
      lastfbase:word;                   { # last file base   }

      waiting,                          { mail waiting       }
      linelen,                          { line length        }
      pagelen,                          { page length        }
      ontoday,                          { # times on today   }
      illegal,                          { # illegal logons   }
      defarctype,                       { QWK archive type   }
      ColorScheme,                      { Color scheme #     }
      sl,dsl:byte;                      { SL / DSL           }

      Subscription,                     { their subscription }
      expireto,                         { level to expire to }
      lastconf:char;                    { last conference in }

      TeleConfEcho,                     { Teleconf echo?     }
      TeleConfInt,                      { Teleconf interrupt }
      getownqwk,                        { Get own messages   }
      scanfilesqwk,                     { new files in qwk   }
      privateqwk:boolean;               { private mail qwk   }
      UserID:longint;                   { Permanent userid   }
      reserved:array[479..512] of byte;
    end;

Newgeneralrec=
  record
    datapath:string[40];              { DATA path }
    miscpath:string[40];              { MISC path }
    menupath:string[40];              { MENU path }
    logspath:string[40];              { LOGS path }
    msgpath:string[40];               { MSGS path }
    nodepath:string[40];              { NODE list path }
    temppath:string[40];              { TEMP path }
    protpath:string[40];              { PROT path }
    arcspath:string[40];              { ARCS path }

    bbsname:string[40];               { BBS name }
    bbsphone:string[12];              { BBS phone number }
    sysopname:string[30];             { SysOp's name }

    lowtime,                          { SysOp begin minute (in minutes) }
    hitime,                           { SysOp end time }
    dllowtime,                        { normal downloading hours begin.. }
    dlhitime,                         { ..and end }
    minbaudlowtime,                   { minimum baud calling hours begin.. }
    minbaudhitime,                    { ..and end }
    minbauddllowtime,                 { minimum baud downloading hours begin.. }
    minbauddlhitime:integer;          { ..and end }

    minimumbaud,                      { minimum baud rate to logon }
    minimumdlbaud:longint;            { minimum baud rate to download }

    shuttlelog,                       { Use Shuttle Logon? }
    closedsystem,                     { Allow new users? }
    swapshell:boolean;                { Swap on shell? }

    sysoppw,                          { SysOp password }
    newuserpw,                        { newuser password }
    minbaudoverride,                  { override minimum baud rate }
    qwknetworkACS:ACString;           { QWK network REP ACS }

    crapola2:string[8];               { }

    sop,                              { SysOp }
    csop,                             { Co-SysOp }
    msop,                             { Message SysOp }
    fsop,                             { File SysOp }
    spw,                              { SysOp PW at logon }
    addchoice,                        { Add voting choices acs }
    normpubpost,                      { make normal public posts }
    normprivpost,                     { send normal e-mail }
    anonpubread,                      { see who posted public anon }
    anonprivread,                     { see who sent anon e-mail }
    anonpubpost,                      { make anon posts }
    anonprivpost,                     { send anon e-mail }
    seeunval,                         { see unvalidated files }
    dlunval,                          { DL unvalidated files }
    nodlratio,                        { no UL/DL ratio }
    nopostratio,                      { no post/call ratio }
    nofilecredits,                    { no file credits checking }
    ulvalreq,                         { uploads require validation }
    TeleConfMCI,                      { ACS access for MCI codes while teleconfin' }
    overridechat:ACString;            { override chat hours }

    maxprivpost,                      { max email can send per call }
    maxfback,                         { max feedback per call }
    maxpubpost,                       { max posts per call }
    maxchat,                          { max sysop pages per call }
    maxwaiting,                       { max mail waiting }
    csmaxwaiting,                     { max mail waiting for Co-SysOp + }
    junk1,                            { ------------------------------- }
    junk2,                            { ------------------------------- }
    maxlogontries,                    { tries allowed for PW's at logon }
    sysopcolor,                       { SysOp color in chat mode }
    usercolor:byte;                   { user color in chat mode }
    minspaceforpost,                  { minimum drive space left to post }
    minspaceforupload:integer;        { minimum drive space left to upload }

    backsysoplogs,                    { days to keep SYSOP##.LOG }
    eventwarningtime,                 { minutes before event to warn user }
    wfcblanktime:byte;                { minutes before blanking WFC menu }

    allowalias,                       { allow handles? }
    phonepw,                          { phone number password in logon? }
    localsec,                         { use local security? }
    globaltrap,                       { trap everyone's activity? }
    autochatopen,                     { automatically open chat buffer? }
    autominlogon,                     { Auto-Message at logon? }
    bullinlogon,                      { bulletins at logon? }
    lcallinlogon,                     { "Last Few Callers" list at logon? }
    yourinfoinlogon,                  { "Your Info" at logon? }
    offhooklocallogon,                { phone off-hook for local logons? }
    forcevoting,                      { manditory voting? }
    compressbases,                    { "compress" file/msg base numbers? }
    searchdup:boolean;                { search for dupes files when UL? }
    slogtype:byte;                    { log type: File/Printer/Both }
    stripclog:boolean;                { strip colors from SysOp log? }
    newapp,                           { send new user application to # }
    timeoutbell,                      { minutes before timeout beep }
    timeout:integer;                  { minutes before timeout }
    useems:boolean;                   { use EMS for overlay }
    usebios:boolean;                  { use BIOS for video output }
    useIEMSI:boolean;                 { use IEMSI }
    alertbeep:integer;                { time between alert beeps }

    filearcinfo:
        array[1..maxarcs] of filearcinforec;           { archive specs }
    filearccomment:
        array[1..3] of string[40];    { BBS comment files for archives }
    uldlratio,                        { use UL/DL ratios? }
    filecreditratio:boolean;          { use auto file-credit compensation? }
    filecreditcomp,                   { file credit compensation ratio }
    filecreditcompbasesize,           { file credit base compensation size }
    ulrefund,                         { percent of time to refund on ULs }
    tosysopdir:byte;                  { SysOp file base }
    validateallfiles:boolean;         { validate files automatically? }
    maxintemp,                        { max K allowed in TEMP }
    minresume:integer;                { min K to allow resume-later }

    filediz:boolean;                  { Search/Import file_id.diz }

    maxqwktotal,                      { max msgs in a packet, period }
    maxqwkbase:word;                  { max msgs in a base }

    CreditMinute,                     { Credits per minute }
    CreditPost,                       { Credits per post }
    CreditEmail:integer;              { Credits per Email sent }

    sysoppword:boolean;               { check for sysop password? }

    CreditFreeTime:integer;           { Amount of "Free" time given to user at logon }

    TrapTeleConf:boolean;             { Trap teleconferencing to ROOMx.TRP? }

    RES98:array[1..6] of byte;

    allstartmenu:string[8];           { logon menu to start users on }
    bulletprefix:string[8];           { default bulletins filename }

    timeallow,                        { time allowance }
    callallow,                        { call allowance }
    dlratio,                          { # ULs/# DLs ratios }
    dlkratio,                         { DLk/ULk ratios }
    postratio,                        { posts per call ratio }
    dloneday,                         { Max number of dload files in one day}
    dlkoneday:secrange;               { Max k downloaded in one day}

    lastdate:string[10];               { last system date }
    curwindow:byte;                   { type of SysOp window in use }
    istopwindow:boolean;              { is window at top of screen? }
    callernum:longint;                { system caller number }
    numusers:integer;                 { number of users }

    multpath:string[40];              { MULT path }

    junkola:array[1..3] of byte;     { -= NOT USED =- }

    recompress:boolean;               { recompress like archives? }

    rewardsystem:boolean;             { use file rewarding system? }

    passwordchange:word;              { change password at least every x days }

    netmailpath:string[40];           { path to netmail }
    netmailACS:ACString;              { do they have access to netmail? }

    rewardratio:integer;              { % of file points to reward back }

    birthdatecheck:byte;              { check user's birthdate every xx logons }

    Invisible:ACString;                 { Invisible mode? }

    fileattachpath:string[40];        { directory for file attaches }

    fileattachACS:ACString;           { ACS to attach files to messages }
    changevote:ACString;              { ACS to change their vote }

    trapgroup:boolean;                { record group chats? }

    qwktimeignore:boolean;            { ignore time remaining for qwk download? }

    networkmode:boolean;              { Network mode ? }

    SwapTo:byte;                      { Swap where?    }

    res:array[1..23] of byte;         { bleah }

    windowon:boolean;                 { is the sysop window on? }
    regnumber:longint;                { registration number }

    chatcall:boolean;                 { Whether system keeps beeping after chat}

    packetname:string[8];             { QWK packet name }
    qwkwelcome:string[50];            { QWK welcome file name }
    qwknews:string[50];               { QWK news file name }
    qwkgoodbye:string[50];            { QWK goodbye file name }
    qwklocalpath:string[40];          { QWK path for local usage }

    dailylimits:boolean;              { Daily file limits on/off }
    multinode:boolean;                { enable multinode support }
    daysonline:word;                  { days online }
    totalcalls:longint;               { incase different from callernum }
    totalusage:longint;               { total usage in minutes }
    totalposts:longint;               { total number of posts }
    totaldloads:longint;              { total number of dloads }
    totaluloads:longint;              { total number of uloads }

    percall:boolean;                  { time limits are per call or per day?}
    testuploads:boolean;              { perform integrity tests on uploads? }
    Origin:string[50];                { Default Origin line }
    Text_Color,                       { color of standard text }
    Quote_Color,                      { color of quoted text }
    Tear_Color,                       { color of tear line }
    Origin_Color:byte;                { color of origin line }
    SKludge,                          { show kludge lines? }
    SSeenby,                          { show SEEN-BY lines? }
    SOrigin,                          { show origin line? }
    AddTear:boolean;                  { show tear line? }
    Netattribute:NetAttribs;          { default netmail attribute }
    Aka:array[0..20] of record        { 20 Addresses }
      zone,                           { 21st is for UUCP address }
      net,
      node,
      point:word;
    end;
    DefEchoPath:string[40];           { default echomail path }
    CreditInternetMail:integer;       { cost for Internet mail }
    crap5:array[1..372] of byte;
    validation:array['A'..'Z'] of
               validationrec;         { Validation records A - Z }

    macro:array[0..9] of string[100]; { sysop macros }
  end;

Newhistoryrec=                     { HISTORY.DAT : Summary logs }
  record
    date:string[10];
    userbaud:array[0..4] of word;
    active,callers,newusers,posts,email,feedback,
    errors,uploads,downloads,uk,dk:longint; 
  end;

Newulrec=                          { FBASES.DAT  : File base records }
  record
    name:string[40];              { area description  }
    filename:string[12];          { filename + ".DIR" }
    dlpath,                       { download path     }
    ulpath:string[40];            { upload path       }
    maxfiles:word;                { max files allowed }
    password:string[20];          { password required }
    arctype,                      { wanted archive type (1..max,0=inactive) }
    cmttype:byte;                 { wanted comment type (1..3,0=inactive) }
    res1:integer;                 { not used }
    fbstat:set of fbflags;        { file base status vars }
    ACS,                          { access requirements }
    ulACS,                        { upload requirements }
    dlACS:ACString;               { download requirements }
    res:array[1..10] of byte;     { RESERVED }
  end;

Newulfrec=                         { *.DIR : File records }
  record
    filename:string[12];          { Filename }
    description:string[60];       { File description }
    credits:integer;              { File points }
    downloaded:word;              { Number DLs }
    sizemod:byte;                 { # chars over last 128 byte block }
    blocks:word;                  { # 128 byte blks }
    owner:word;                   { ULer of file }
    stowner:string[36];           { ULer's name }
    date:string[10];               { Date ULed }
    daten:word;                   { Numeric date ULed }
    vpointer:longint;             { Pointer to verbose descr, -1 if none }
    filestat:set of filstat;      { File status }
    res:array[1..10] of byte;     { RESERVED }
  end;

NewLastCallerRec =                  { LASTON.DAT : Last few callers records }
  record
    Node:byte;                     { Node number }
    UserName:string[36];           { User name of caller }
    Location:string[30];           { Location of caller }
    Caller,                        { system caller number }
    UserID,                        { User ID # }
    Speed:longint;                 { Speed of caller 0=Local }
    LogonTime,                     { time user logged on }
    LogoffTime:unixtime;           { time user logged off }
    NewUser,                       { was it a new user? }
    Invisible:boolean;             { Invisible user? }
    Uploads,                       { Uploads/Downloads during call }
    Downloads,
    MsgRead,                       { Messages Read }
    MsgPost,                       { Messages Posted }
    EmailSent,                     { Email sent }
    FeedbackSent:word;             { Feedback sent }
    UK,                            { Upload/Download kbytes during call }
    DK:longint;
    Reserved:array [1..17] of byte; { Reserved }
  end;

