(* 

    FASTWWIN - Win32 Video Interface Routines for console mode apps. 

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


uses
  SysUtils, Windows, Crt, MStrings;


procedure WriteFast(x,y:Byte; s:String; Attr:Byte);
begin
  if Length(s) > 0 then
    begin
{      TextAttr := Attr;}
      WriteStringNoWindow(s,x,y,Attr);
    end;
end;


PROCEDURE WriteScreen(VAR s:ScreenType);
VAR  CharInfo       : Array[1..25,1..80] OF
                      RECORD
                         AsciiChar  : Char;
                         Junk       : Byte;
                         Attributes : Word;
                      END;
     xpos,ypos      : Byte;
     BufferSize     : TCoord;
     BufferPos      : TCoord;
     Result         : TSmallRect;
BEGIN
   FillChar(CharInfo,SizeOf(CharInfo),0);
   FOR ypos := 1 TO 25 DO
      FOR xpos := 1 TO 80 DO
         BEGIN
            CharInfo[ypos,xpos].AsciiChar := s.Pos[ypos,xpos].Ch;
            CharInfo[ypos,xpos].Attributes := s.Pos[ypos,xpos].Attr;
         END;

   BufferSize.x := 80;  BufferPos.x := 0;
   BufferSize.y := 25;  BufferPos.y := 0;

   Result.Top := 0;
   Result.Left := 0;
   Result.Bottom := 24;
   Result.Right := 79;

   WriteConsoleOutputA(Handle_Output,@CharInfo,BufferSize,BufferPos,Result);
END;


PROCEDURE ReadScreen(VAR s:ScreenType);
VAR  CharInfo    : Array[1..25,1..80] OF
                   RECORD
                      AsciiChar  : Char;
                      Junk       : Char;
                      Attributes : Word;
                   END;
     xpos,ypos  : Byte;
     BufferSize : TCoord;
     BufferPos  : TCoord;
     Result     : TSmallRect;
BEGIN
   BufferSize.x := 80;  BufferPos.x := 0;
   BufferSize.y := 25;  BufferPos.y := 0;

   Result.Top := 0;
   Result.Left := 0;
   Result.Bottom := 24;
   Result.Right := 79;

   ReadConsoleOutputA(Handle_Output,@CharInfo,BufferSize,BufferPos,Result);

   FOR ypos := 1 TO 25 DO
      FOR xpos := 1 TO 80 DO
         BEGIN
            s.Pos[ypos,xpos].Ch := CharInfo[ypos,xpos].AsciiChar;
            s.Pos[ypos,xpos].Attr:= CharInfo[ypos,xpos].Attributes;
         END;
END;


PROCEDURE FastClr(ch:Char; x1,y1,x2,y2,Attr:Byte);
{ This is a lazy way of doing this, since the Windows API provides       }
{ routines specifically for clearing parts of the screen in console mode }
VAR s:String; lnum:Byte;
BEGIN
   IF x2 < x1 THEN Exit;
   IF Y2 < y1 THEN Exit;
   s := '';
   FOR LNum := x1 TO x2 DO s := s+ch;
   FOR LNum := y1 TO y2 DO WriteFast(x1,LNum,s,Attr);
END;


PROCEDURE HighIntensity(State:Boolean);
BEGIN
END;


PROCEDURE ScreenScroll(Direction:ScrollType; Lines,Top,Bot,SCol,FCol,FillAttr: Byte);
VAR FillInfo:TCharInfo; ScrollRect:TSmallRect; Dest:TCoord;
BEGIN
   ScrollRect.Left := SCol-1;
   ScrollRect.Top := Top-1;
   ScrollRect.Right := FCol-1;
   ScrollRect.Bottom := Bot-1;

   Dest.x := (SCol)-1;
   IF (Direction=Up)
      THEN Dest.y := (Top-Lines)-1
      ELSE Dest.y := (Top+Lines)-1;

   FillInfo.AsciiChar := ' ';
   FillInfo.Attributes := FillAttr;

   ScrollConsoleScreenBufferA(Handle_Output,ScrollRect,NIL,Dest,FillInfo);
END;
