{$O+}
UNIT MSBWGEN;

(* 

    MSBWGEN - MatrixSoft Blue Wave Door Generic Structures. 

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

CONST

   MaxStrings     = 512;
   MaxMciVars     = 20;

TYPE

   SwapMethodType = (EMS,Disk,None);

   PostType       = (NameAlias,NameReal,NameEither);

   MsStrTableType = Array[1..MaxStrings] OF RECORD
      Ofs : Word;
      Len : Byte;
   END;

   MsStrBuffType = Array[1..1] OF Char;

   ScanInfoType = SET OF
      (scn_Selected,      { Is this message area selected for download? }
       scn_PersonalOnly,  { Bundle only personal messages in this area? }
       scn_PersonalAll,   { Bundle only personal+all in this area? }
       scn_Keywords,      { Apply keywords to this area? }
       scn_Filters,       { Apply filters to this area? }
       scn_HasAccess,     { Internal - has access to this conference }
       scn_Override);     { Internal - override exists for this base }

   ScanInfoPtr = Array[0..0] OF ScanInfoType;

   MsNetworkAttr = SET OF
      (MsLocal,
       MsPrivate,
       MsKillSent,
       MsHold,
       MsCrash,
       MsImmediate,
       MsDirect);

   ScanTableMessageFlags = SET OF
      (stm_IsNew,        { Is this message past the lastread pointer? }
       stm_IsPersonal,   { Is this message a personal message? }
       stm_IsAll,        { Is this message to "All"? }
       stm_IsKeyword,    { Is this message a keyword match? }
       stm_IsFilter,     { Is this message a filter match? }
       stm_IsOwn,        { Is this message users own? }
       stm_ShouldDL,     { This message should be bundled in the packet }
       stm_NoBundle);    { Don't bundle -- used if email not netmail or v.v. }

   ScanTableBaseFlags = SET OF
      (stb_BundleNew,       { Bundle ONLY new, or ignore lastread }
       stb_BundleFirst,     { Bundle first XX new in this area    }
       stb_BundleLast,      { Bundle last XX in this area         }
       stb_UpdatePointers,  { Update pointers for this area       }
       stb_NukeMessages,    { Nuke private messages in this area? }
       stb_SkipBase);       { Skip this base                      }

   ScanTableRec = RECORD
      BaseStat        : ScanTableBaseFlags;
      MsgsNew,                     { # of messages past lastread pointer }
      MsgsTotal,                   { # of total messages in this base    }
      MsgsDownload,                { # of new (to download) messages     }
      MsgsPersonal,                { # of personal messages              }
      MsgsAll,                     { # of messages to "All"              }
      MsgsKeywords,                { # of messages with keywords         }
      MsgsFilters,                 { # of messages with filters          }
      MsgsFirst,                   { # of messages for #B## command      }
      MsgsLast,                    { # of messages for #L## command      }
      AreaNum         : Word;      { QWK Index number for this base      }
      AreaTotalSize,
      STablePtr       : LongInt;
      STableNum       : Word;
      MaxReached      : Boolean;
      PtrMsg          : Word;
   END;

   DupeRec = RECORD
      Crc : LongInt;
   END;

   PAttachList = ^TAttachList;
   TAttachList = RECORD
      RealFile : String[45];
      FileName : String[12];
      FileSize : LongInt;
      Include  : Boolean;
      Next     : PAttachList;
   END;

   MciVarsType     = Array[0..MaxMciVars] OF String[64];
   MciVarsPtr      = ^MciVarsType;

VAR

   MciVars         : MciVarsPtr;

   FAttachRoot     : PAttachList;
   FAttach         : PAttachList;
   FAttachNum      : Word;
   FAttachSize     : LongInt;
   FAttachNumI     : Word;
   FAttachSizeI    : LongInt;

   MSBW_GetString  : FUNCTION(n:Word):String;
   MSBW_WriteColor : PROCEDURE(s:String);

   MaxMBase        : Boolean; { Has maximum msgs/area been reached?       }
   MaxMTotal       : Boolean; { Has maximum msgs/packet been reached?     }
   MaxUTotal       : Boolean; { Has USER-defined maximum msgs " "         }
   WorkTotal       : LongInt;

   GTotal,                    { Total messages                            }
   GNew,                      { Total new messages                        }
   GKeyword,                  { Total messages with keyword(s)            }
   GFilter,                   { Total filtered messages                   }
   GPersonal,                 { Total personal messages                   }
   GDL             : LongInt; { Total # to DL                             }

   ScanTableMsg    : ScanTableMessageFlags;

   MsgTo,
   MsgFrom,
   MsgSubj         : String[127];

   CheckKeywords,
   CheckFilters    : Boolean;

   UserNameUpper,
   UserAliasUpper  : String[36];
   UserKeywords    : Array[1..10] OF String[20];
   UserFilters     : Array[1..10] OF String[20];


IMPLEMENTATION


END.
