UNIT MYSHARE;

(* 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES DOS;

VAR  ShareInstalled:Boolean;

{$IFDEF DOS}
FUNCTION  LockRec(VAR Untyped; Pos,Size:LongInt):Boolean;
FUNCTION  UnLockRec(VAR Untyped; Pos,Size:LongInt):Boolean;
FUNCTION  Share:Boolean;
{$ENDIF}
PROCEDURE FMode(Mode:Byte);

IMPLEMENTATION

{$IFDEF DOS}

FUNCTION LockRec(VAR Untyped; Pos,Size:LongInt):Boolean;
VAR Regs : Registers;
    f    : FILE ABSOLUTE Untyped;
BEGIN
   pos := pos * FileRec(f).RecSize;
   size := size * FileRec(f).RecSize;
   Regs.AH := $5C;
   Regs.AL := $00;
   Regs.BX := FileRec(f).Handle;
   Regs.CX := Hi(pos);
   Regs.DX := Lo(pos);
   Regs.SI := Hi(size);
   Regs.DI := Lo(size);
   Intr($21,Regs);
   LockRec := (Regs.Flags AND FCarry) = 0;
END; { LockRec }


FUNCTION UnLockRec(VAR Untyped; Pos,Size:LongInt):Boolean;
VAR Regs : Registers;
    f    : FILE ABSOLUTE Untyped;
BEGIN
   pos := pos * FileRec(f).RecSize;
   size := size * FileRec(f).RecSize;
   Regs.AH := $5C;
   Regs.AL := $01;
   Regs.BX := FileRec(f).Handle;
   Regs.CX := Hi(pos);
   Regs.DX := Lo(pos);
   Regs.SI := Hi(size);
   Regs.DI := Lo(size);
   Intr($21,Regs);
   UnlockRec := (Regs.Flags AND FCarry) = 0;
END; { UnLockRec }


FUNCTION Share:boolean;
VAR regs:registers;
BEGIN
    WITH Regs DO
       BEGIN
          AH := 16;
          AL := 0;
          Intr($2F,Regs);
          Share := AL = 255;
       END;
END; { IsShare }


{$ENDIF}

PROCEDURE FMode(Mode:Byte);
BEGIN
   IF ShareInstalled THEN
      IF (Mode IN [0..2,23..24,48..50,64..66]) THEN
         FileMode := Mode;
END;



BEGIN
   {$IFDEF DOS}
   ShareInstalled := Share;
   {$ELSE}
   ShareInstalled := TRUE;
   {$ENDIF}
END. { MyShare }
