{$I-,O+}
UNIT MSZ_MAIN;

(* 

    MSZ_MAIN - X/Y/Zmodem main interface code

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


TYPE  tMszProtType =
         (Nothing,

          Recv_X,    Send_X,
          Recv_X1K,  Send_X1K,
          Recv_X1KG, Send_X1KG,
          Recv_Y,    Send_Y,
          Recv_Y1K,  Send_Y1K,
          Recv_YG,   Send_YG,
          Recv_Z,    Send_Z,
          Recv_Zap,  Send_Zap

         );

VAR   Msz_FileSpec : String;
      Msz_ProtType : tMszProtType;
CONST Msz_LogFile  : String = '';
      StartLine    : Byte = 8;
      DispName     : String[78] = '';


FUNCTION MSZ_SendList(ListFile:String; Prot:tMszProtType):Boolean;
FUNCTION MSZ_RunMsz:Boolean;


IMPLEMENTATION


USES  {$I c:\oldstuff\source\MSZ\FOSSTYPE.INC }

      DOS,      CRT,      MISC1,    MSTRINGS, UNIXDATE, CURSOR,
      MSZ_MISC, MSZ_XMOD, MSZ_ZMOD, MSZ_VID,  FASTW;


PROCEDURE MSZ_DummyProc; FAR;
BEGIN
END;


FUNCTION MSZ_LocalInput(ch:Char):Char; FAR;
BEGIN
   MSZ_LocalInput := #0;
END;


FUNCTION MSZ_SendList(ListFile:String; Prot:tMszProtType):Boolean;
VAR f:Text; FileName:String; Res:Boolean;
BEGIN
   Assign(f,ListFile);
   Reset(f);
   Res := TRUE;
   WHILE NOT Eof(f) AND Res DO
      BEGIN
         ReadLn(f,FileName);
         FileName := StripLeadingCh(StripTrailingCh(UpcaseStr(FileName),' '),' ');
         IF Length(FileName) > 0 THEN
            BEGIN
               FileName := GetWord(FileName,1);
               IF FExists(FileName) THEN
                  CASE Prot OF
                     Send_Z,
                     Send_Zap  : Res := Zmodem_Send(FileName);
                     Send_Y    : Res := Ymodem_Send(FileName,128);
                     Send_Y1K,
                     Send_YG   : Res := Ymodem_Send(FileName,1024);
                  END;
            END;
      END;
   Close(f);
   MSZ_SendList := Res;
END;


FUNCTION MSZ_RunMsz:Boolean;
VAR i             : Byte;
    FileName      : String;
    Res           : Boolean;

    OldHost       : Pointer;
    OldLocalInput : FUNCTION(ch:Char):Char;
    OldTimeOut    : PROCEDURE;

    PROCEDURE InitComm;
    BEGIN
       GetMem(OldHost,SizeOf(fk_Host));
       Move(fk_Host,OldHost^,SizeOf(fk_Host));
       OldLocalInput := fk_LocalInput;
       OldTimeOut := fk_TimeOut;

       fk_LocalInput := MSZ_LocalInput;
       fk_TimeOut := MSZ_DummyProc;
       fk_Host.CurrentInput := '';
       fk_Host.HostScreen := FALSE;
       fk_Host.HostKey := FALSE;
       fk_Host.WaitForChar := TRUE;
       fk_Host.TimeSlice := FALSE;
    END;

    PROCEDURE RestoreComm;
    VAR ExitCode:Byte;
    BEGIN
       fk_LocalInput := OldLocalInput;
       fk_TimeOut := OldTimeOut;
       ExitCode := fk_Host.ExitCode;
       Move(OldHost^,fk_Host,SizeOf(fk_Host));
       FreeMem(OldHost,SizeOf(fk_Host));
       fk_Host.ExitCode := ExitCode;
    END;

BEGIN
   InitComm;
   BatchStart := CurrentSecsFunc;
   Res := TRUE;
   SetCursor(cmOff);
   Msz_FileSpec := DowncaseStr(StripLeadingCh(StripTrailingCh(Msz_FileSpec,' '),' '));
   Zmodem_OpenWindow;
   fk_PurgeInputBuffer;
   MSZ_GetBatchTotals(Msz_FileSpec);
   IF (Msz_ProtType IN [Recv_Zap,Recv_Z,Send_Zap]) THEN ZBUFSIZE := 8192;
   Zmodem_InitBuffers;

   CASE Msz_ProtType OF
      Recv_X,
      Recv_X1K  : Res := Xmodem_Receive(GetWord(Msz_FileSpec,1),'C');
      Send_X    : BEGIN
                     FileName := GetWord(Msz_FileSpec,1);
                     IF FExists(FileName) THEN Res := Xmodem_Send(FileName,128);
                  END;
      Send_X1K,
      Send_X1KG : BEGIN
                     FileName := GetWord(Msz_FileSpec,1);
                     IF FExists(FileName) THEN Res := Xmodem_Send(FileName,1024);
                  END;
      Recv_X1KG : Res := Xmodem_Receive(GetWord(Msz_FileSpec,1),'G');
      Recv_Y,
      Recv_Y1K  : IF (GetWordCount(Msz_FileSpec)=0)
                     THEN Res := Ymodem_Receive('','C')
                     ELSE Res := Ymodem_Receive(GetWord(Msz_FileSpec,1),'C');
      Send_Y    : IF GetWordCount(Msz_FileSpec) > 0 THEN
                     BEGIN
                        i := 1;
                        WHILE (i <= GetWordCount(Msz_FileSpec)) AND Res DO
                           BEGIN
                              FileName := GetWord(Msz_FileSpec,i);
                              IF FileName[1] = '@'
                                 THEN BEGIN
                                       FileName := Copy(FileName,2,Length(FileName)-1);
                                       IF FExists(FileName) THEN Res := MSZ_SendList(FileName,Send_Y);
                                    END
                                 ELSE IF FExists(FileName) THEN Res := Ymodem_Send(FileName,128);
                              Inc(i);
                           END;
                        IF Res THEN Ymodem_SendEOT;
                     END;
      Recv_YG   : IF (GetWordCount(Msz_FileSpec)=0)
                     THEN Res := Ymodem_Receive('','G')
                     ELSE Res := Ymodem_Receive(GetWord(Msz_FileSpec,1),'G');
      Send_Y1K,
      Send_YG   : IF GetWordCount(Msz_FileSpec) > 0 THEN
                     BEGIN
                        i := 1;
                        WHILE (i <= GetWordCount(Msz_FileSpec)) AND Res DO
                           BEGIN
                              FileName := GetWord(Msz_FileSpec,i);
                              IF FileName[1] = '@'
                                 THEN BEGIN
                                       FileName := Copy(FileName,2,Length(FileName)-1);
                                       IF FExists(FileName) THEN Res := MSZ_SendList(FileName,Send_YG);
                                    END
                                 ELSE IF FExists(FileName) THEN Res := Ymodem_Send(FileName,1024);
                              Inc(i);
                           END;
                        IF Res THEN Ymodem_SendEOT;
                     END;
      Recv_Zap,
      Recv_Z    : IF GetWordCount(Msz_FileSpec) = 0
                     THEN Zmodem_Receive('')
                     ELSE Zmodem_Receive(GetWord(Msz_FileSpec,1));
      Send_Zap,
      Send_Z    : IF Length(Msz_FileSpec) > 0 THEN
                     BEGIN
                        i := 1;
                        WHILE (i <= GetWordCount(Msz_FileSpec)) AND Res DO
                           BEGIN
                              FileName := GetWord(Msz_FileSpec,i);
                              IF FileName[1] = '@'
                                 THEN BEGIN
                                       FileName := Copy(FileName,2,Length(FileName)-1);
                                       IF FExists(FileName) THEN Res := MSZ_SendList(FileName,Send_Z);
                                    END
                                 ELSE IF FExists(FileName) THEN Res := Zmodem_Send(FileName);
                              Inc(i);
                           END;
                        IF Res THEN Zmodem_EndSend;
                     END;
   END;
   Zmodem_DeInitBuffers;
   Zmodem_CloseWindow;
   SetCursor(cmOn);
   SetCursor(cmUnderline);
   fk_PurgeInputBuffer;
   fk_FlushOutputBuffer;
   RestoreComm;
   MSZ_RunMsz := Res;
END;


END.
