{$O-,F+,I-}
UNIT RWLOGS;

(* 

    RWLOGS - ReneWave log unit

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE

VAR TempLog:Text;


PROCEDURE RWL_WriteLog(LogCategory:Char; LogText:String);
FUNCTION  RWL_LogTime:String;


IMPLEMENTATION


USES DOS,      RWMAIN, MISC1,    MSTRINGS, UNIXDATE, RWSTRUCT;


PROCEDURE RWL_WriteLog(LogCategory:Char; LogText:String);
BEGIN
   CASE LogCategory OF
      ':' : IF RwConfig.LogOpts.ScanningInfo   THEN WriteLn(TempLog,': ',LogText);
      '#' : IF RwConfig.LogOpts.BundlingInfo   THEN WriteLn(TempLog,'# ',LogText);
      '-' : IF RwConfig.LogOpts.TransferInfo   THEN WriteLn(TempLog,'- ',LogText);
      '!' : IF RwConfig.LogOpts.ErrorInfo      THEN WriteLn(TempLog,'! ',LogText);
      '=' : IF RwConfig.LogOpts.GeneralInfo    THEN WriteLn(TempLog,'= ',LogText);
      '?' : IF RwConfig.LogOpts.UserErrorsInfo THEN WriteLn(TempLog,'? ',LogText);
      '+' : IF RwConfig.LogOpts.ReplyInfo      THEN WriteLn(TempLog,'+ ',LogText);
      '~' : WriteLn(TempLog,'~ ',LogText);
      ELSE WriteLn(TempLog,LogText);
   END;
END;


FUNCTION RWL_LogTime:String;
VAR TempRes:String; Hour,Min,Sec,Sec100:Word;
BEGIN
    GetTime(Hour,Min,Sec,Sec100);
    IF Hour < 10
       THEN TempRes := '0'+StrFunc(Hour)+':'
       ELSE TempRes := StrFunc(Hour)+':';
    IF Min < 10
       THEN TempRes := TempRes+'0'+StrFunc(Min)+':'
       ELSE TempRes := TempREs+StrFunc(Min)+':';
    IF Sec < 10
       THEN TempRes := TempRes+'0'+StrFunc(Sec)
       ELSE TempRes := TempRes+StrFunc(Sec);
    RWL_LogTime := TempRes;
END;


END.


