PROGRAM RWMAINT;

(* 

    RWMAINT - ReneWave maintenance utility.

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


USES DOS,
     CRT,
     MISC1,
     MSTRINGS,
     MSBWGEN,
     MYSHARE,
     RWSTRUCT,
     RECORDS,
     UNIXDATE;


CONST RwmVer = '2.00';

TYPE  ConfigType = RECORD
         Nuke      : Boolean;
         NukeDays  : Word;
         PackDupes : Boolean;
      END;

VAR   ThisBase     : Word;

      Config       : ConfigType;
      SetupRW      : ConfigRec;
      SetupRWF     : FILE OF ConfigRec;
      UserRW       : RwUserRec;
      UserRWF      : FILE OF RwUserRec;
      ScanInfo     : ^ScanInfoPtr;
      ScanInfoF    : FILE;
      General      : GeneralRec;
      GeneralFile  : FILE OF GeneralRec;


PROCEDURE IntroScreen;
BEGIN
    ClrScr;
    WritePipe('|16|09|09|01|16');
    WritePipe('|17|09|15 RWMAINT - RENEWAVE v2.00 Maintenance Utility                                 |08|16');
    WritePipe('|17|09|09 Copyright (C) 1994-1996 by Lars Hellsten and MatrixSoft, All Rights Reserved |08|16');
    WritePipe('|17|09|07 Future Shock - The MatrixSoft Support BBS (416)LONGDEAD / 1:259/412          |08|16');
    WritePipe('|16|01|08|08|16');
    WritePipe(#13#10);
    Window(1,7,80,25);
END;


PROCEDURE HelpScreen;
BEGIN
    IntroScreen;
    WritePipe('|09 |11Syntax  : |03RWMAINT.EXE <option(s)>'+#13#10);
    WritePipe('|09 |11Options : |03'+#13#10#13#10);
    WritePipe('|15  NUKE=<days>    |07Nukes users who haven''t entered ReneWave in <days>'+#13#10);
    WritePipe('|15  PACKDUPES      |07Packs DUPES.RW to the size defined in RWSETUP'+#13#10);
    WriteLn;
    Halt;
END;


PROCEDURE ProcessParams;
VAR ParamS,TempS:String; ThisParam:Byte; TempI:Integer;
BEGIN
   FillChar(Config,SizeOf(Config),FALSE);
   IF ParamCount < 1 THEN HelpScreen;
   FOR ThisParam := 1 TO ParamCount DO
      BEGIN
         ParamS := ParamStr(ThisParam);
         ParamS := UpcaseStr(ParamS);
         IF ParamS = 'PACKDUPES' THEN Config.PackDupes := TRUE
         ELSE IF Copy(ParamS,1,5) = 'NUKE=' THEN
            BEGIN
               TempS := Copy(ParamS,6,Length(ParamS)-5);
               Val(TempS,Config.NukeDays,TempI);
               Config.Nuke := TempI = 0;
            END
         ELSE HelpScreen;
      END;
END;


PROCEDURE InitDataFiles;
BEGIN
   IntroScreen;
   IF MyShare.ShareInstalled THEN FileMode := 66;

   Assign(SetupRWF,'SETUP.RW');
   Reset(SetupRWF);
   Seek(SetupRWF,0);
   Read(SetupRWF,SetupRW);

   Assign(UserRWF,'USERS.RW');
   Reset(UserRWF);

   Assign(ScanInfoF,'SCANINFO.RW');
   IF FExists('SCANINFO.RW') THEN Reset(ScanInfoF,4096) ELSE Rewrite(ScanInfoF,4096);

   Assign(GeneralFile,SetupRW.RGMainDir+'RENEGADE.DAT');
   Reset(GeneralFile);
   Seek(GeneralFile,0);
   Read(GeneralFile,General);

   GetMem(ScanInfo,4096);
END;


PROCEDURE DeInitDataFiles;
BEGIN
   ClrScr;
   WritePipe('|10Done!');
   Close(SetupRWF);
   Close(UserRWF);
   Close(GeneralFile);
   Close(ScanInfoF);
   FreeMem(ScanInfo,4096);
END;


PROCEDURE NukeUsers;
VAR ThisUser,NumNuked:Word; ScnFile:File;
BEGIN
   IF Config.NukeDays = 0 THEN Exit;
   ClrScr;
   WritePipe('|03Nuking users in USERS.RW:'+#13#10#13#10);
   WritePipe('|07Progress            |08[   |07%|08]'+#13#10);
   WritePipe('|07Current user name   |08[                                    |08]'+#13#10);
   WritePipe('|07Current user number |08[    |07/    |08]'+#13#10);
   WritePipe('|07Number nuked        |08[    |08]');
   NumNuked := 0;
   FOR ThisUser := 0 TO (FileSize(UserRWF)-1) DO
      BEGIN
         Seek(UserRWF,ThisUser);
         Read(UserRWF,UserRW);
         WritePipeXY(22,3,'|15'+PadLeft(StrFunc(Round((ThisUser+1)/FileSize(UserRWF)*100)),' ',3));
         WritePipeXY(22,4,'|15'+PadRight(UserRW.Alias,' ',36));
         WritePipeXY(22,5,'|15'+PadLeft(StrFunc(ThisUser+1),' ',4)+'|07/|15'+StrFunc(FileSize(UserRWF)));
         WritePipeXY(22,6,'|15'+StrFunc(NumNuked));
         IF (CurrentSecsFunc-UserRW.LastOn) >= (Config.NukeDays * 86400)
            THEN BEGIN
                  Inc(NumNuked);
               END
            ELSE BEGIN
                  Seek(UserRwF,ThisUser-NumNuked);
                  Write(UserRwF,UserRw);

                  IF ThisUser < FileSize(ScanInfoF) THEN
                     BEGIN
                        Seek(ScanInfoF,ThisUser);
                        BlockRead(ScanInfoF,ScanInfo^,1);
                        Seek(ScanInfoF,ThisUser-NumNuked);
                        BlockWrite(ScanInfoF,ScanInfo^,1);
                     END;
               END;
      END;
   Truncate(UserRWF);
   Truncate(ScanInfoF);
END;


PROCEDURE PackDupes;
VAR DupeFile : FILE OF DupeRec;
    Dupe     : DupeRec;
    ThisDupe : Word;
BEGIN
   ClrScr;
   WritePipe('|07Packing DUPES.RW |08[   |07%|08]');
   Assign(DupeFile,'DUPES.RW');
   {$I-} Reset(DupeFile); {$I+}
   IF IOResult <> 0 THEN Exit;
   IF FileSize(DupeFile) <= SetupRW.MaxDupes THEN Exit;

   FOR ThisDupe := 1 TO SetupRW.MaxDupes DO
      BEGIN
         Seek(DupeFile,FileSize(DupeFile)-ThisDupe);
         Read(DupeFile,Dupe);
         Seek(DupeFile,ThisDupe-1);
         Write(DupeFile,Dupe);
         WritePipeXY(19,1,'|15'+PadLeft(StrFunc(Round(ThisDupe/SetupRW.MaxDupes*100)),' ',3));
      END;

   Truncate(DupeFile);
   Close(DupeFile);
END;


BEGIN
   ProcessParams;
   InitDataFiles;

   IF Config.Nuke      THEN NukeUsers;
   IF Config.PackDupes THEN PackDupes;

   DeInitDataFiles;
END.
