{$O+,F+,I-}
UNIT RWMENUS;

(* 

    RWMENUS - ReneWave menu processing routines 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


VAR   Ext           : String[4];
      GlobalQuit    : Boolean;


FUNCTION  RWM_GetCmd(Hotkeys:Boolean):String;
PROCEDURE RWM_ToggleVars(b:Boolean);

PROCEDURE RWM_UpdatePointers;
PROCEDURE RWM_ResetPtrArea(Date:LongInt);
PROCEDURE RWM_ResetLastreadPointers(Days:LongInt);
PROCEDURE RWM_ResetPointers;

{ Toggles and settings from the configuration menu }
PROCEDURE RWM_ToggleFileList;
PROCEDURE RWM_ToggleFormat;
PROCEDURE RWM_ToggleExpert;
PROCEDURE RWM_ToggleBundleOwn;
PROCEDURE RWM_ToggleHotkeys;
PROCEDURE RWM_ToggleDelEmail;
PROCEDURE RWM_ToggleNumericPkt;
PROCEDURE RWM_ToggleFAttach;
PROCEDURE RWM_SetPacketNumber;
PROCEDURE RWM_ChooseArchiver;
PROCEDURE RWM_ChooseProtocol;
PROCEDURE RWM_DefineKeywords;
PROCEDURE RWM_DefineFilters;
PROCEDURE RWM_DefineMacros;
PROCEDURE RWM_DefineSizeLimit;
PROCEDURE RWM_DefinePassword;

PROCEDURE RWM_CheckPassword;

{ Download/upload stuff }
PROCEDURE RWM_InitBundle;
PROCEDURE RWM_GetExt;
PROCEDURE RWM_DownloadQWK;
PROCEDURE RWM_DownloadPacket;
PROCEDURE RWM_UploadPacket;

{ Menu processing stuff }

PROCEDURE RWM_ProcMenu(MenuFile:String);
PROCEDURE RWM_RunMain;


IMPLEMENTATION


USES  DOS,      CRT,      MSTRINGS, MISC1,    RWBB,     RWBD,
      RWBT,     UNIXDATE, MYSHARE,  RWQWK,    RWMAIN,   RWUP,
      RWLOGS,   RWACS,    RWINIT,   MSFOSDOS, RWERROR,  
      RECORDS,  RWSTRUCT, BWSTRUCT, RWAREAS,  MSRGGEN,  RWFL,
      RWPS,     RWVARS,   MSBWGEN,  MSBWOVR;

TYPE  RwMenuRec    = RECORD
                        MenuScreen : String[64];
                        MenuPrompt : String[127];
                     END;

      RwMenuCmdRec = RECORD
                        CmdKeys    : String[12];
                        CmdAcs     : String[40];
                        CmdCmd     : String[2];
                        CmdOptions : String[64];
                     END;


FUNCTION RWM_GetCmd(Hotkeys:Boolean):String;
VAR Ch:Char; s:string;
BEGIN
   IF Hotkeys
      THEN BEGIN
            REPEAT
               ch := Upcase(fk_Read);
            UNTIL Pos(ch,fk_Host.ValidInput) > 0;
            fk_WriteLn('',1);
            s := Ch;
         END
      ELSE s := fk_ReadLn(1,TRUE);
   RWM_GetCmd := s;
END;


PROCEDURE RWM_UpdatePointers;
BEGIN
   IF FileSize(UPointerFile) = 0 THEN Exit;

   RWM_KeyPressOff;
   RWM_WriteColor(RWM_GetString(32));
   RWL_WriteLog('=',RWL_LogTime+' Updating lastread pointers');

   FOR ThisBase := 0 TO (FileSize(UPointerFile)-1) DO
      BEGIN
         Seek(UPointerFile,ThisBase);
         Read(UPointerFile,UPointerData);
         IF UPointerData.Update AND (UPointerData.BaseNum > 1) THEN
            BEGIN
               MsRg_MAreaRead(UPointerData.BaseNum);
               MsRg_ScnOpen;
               MsRg_ScnRead(RgUserNum-1);
               MsRg_Scn.LastRead := UPointerData.LastDate;
               MsRg_ScnWrite(RgUserNum-1);
               MsRg_ScnClose;
            END;
      END; { FOR }
   RWM_KeyPressOn;
END;


PROCEDURE RWM_ResetPtrArea(Date:LongInt);
VAR ThisMsg:LongInt;
BEGIN
   ThisMsg := FileSize(MsgHdrFile);
   IF ThisMsg = 0 THEN Exit;
   REPEAT
      Dec(ThisMsg);
      Seek(MsgHdrFile,ThisMsg);
      Read(MsgHdrFile,MsgHdr);
   UNTIL (ThisMsg = 0) OR (Date > MsgHdr.Date);
   MsRg_ScnOpen;
   MsRg_ScnRead(RgUserNum-1);
   MsRg_Scn.LastRead := MsgHdr.Date;
   IF ThisMsg = 0 THEN MsRg_Scn.LastRead := 0;
   MsRg_ScnWrite(RgUserNum-1);
   MsRg_ScnClose;
END;


PROCEDURE RWM_ResetLastreadPointers(Days:LongInt);
VAR NewDate:LongInt;
BEGIN
   RWM_KeyPressOff;
   NewDate := CurrentSecsFunc-(CurrentSecsFunc MOD SecsPerDay)-(Days*SecsPerDay);
   RWM_WriteColor(RWM_GetString(32));

   FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
      IF (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) AND
         (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            MsRg_MAreaRead(ThisBase);
            Assign(MsgHdrFile,MsRg_General.MsgPath+MsRg_MArea.Filename+'.HDR');
            IF FExists(MsRg_General.MsgPath+MsRg_MArea.FileName+'.HDR') THEN Reset(MsgHdrfile) ELSE Rewrite(MsgHdrFile);
            RWM_ResetPtrArea(NewDate);
            Close(MsgHdrFile);
         END;
   fk_WriteLn('',1);
   RWM_KeyPressOn;
END;


PROCEDURE RWM_ResetPointers;
VAR StrIn:String;
BEGIN
   RWM_WriteColor(RWM_GetString(50));
   RWM_WriteColor(RWM_GetString(51));
   RWM_WriteColor(RWM_GetString(52));

   IF RWM_GetYesOrNo(TRUE) = RWM_GetCh(4,1) THEN
      BEGIN
         RWM_WriteColor(#13#10#13#10+RWM_GetString(28));
         Exit;
      END;

   RWM_WriteColor(#13#10+RWM_GetString(53));

   fk_Host.ValidInput := '1234567890';
   StrIn := fk_ReadLn(3,TRUE);
   fk_Host.ValidInput := fk_StandardInput;
   fk_WriteLn('',2);

   IF ValFunc(StrIn) < 0 THEN
      BEGIN
         RWM_WriteColor(#13#10+RWM_GetString(29));
         Exit;
      END;

   RWM_ResetLastreadPointers(ValFunc(StrIn));
END;


PROCEDURE RWM_CheckPassword;
VAR TryNum:Byte; TempPW,s:String;

    PROCEDURE FailPassword;
    BEGIN
       RWM_WriteColor(RWM_GetString(110));
       RWM_WriteColor(RWM_GetString(111));
       RWM_WriteColor(RWM_GetString(112));
       RWL_WriteLog('?',RWL_LogTime+' Maximum password attempts reached - kicked user out of door.');
       RWM_EraseTemp;
       fk_DeInitFossil;
    END;

BEGIN
   TryNum := 0;
   IF (RwUser.RwPass = '') OR ((RwUser.PassUsage AND $01) = 0) THEN Exit;
   RWL_WriteLog('=',RWL_LogTime+' Prompting user for password ("'+RwUser.RwPass+'")');

   RWM_WriteColor(RWM_GetString(113));
   RWM_WriteColor(RWM_GetString(114));
   REPEAT
      RWM_WriteColor(RWM_GetString(115));
      fk_PurgeInputBuffer;
      s := RWM_GetString(14);
      fk_Host.OutputChar := s[1];
      TempPW := fk_ReadLn(20,TRUE);
      fk_Host.OutputChar := Chr(0);
      Inc(TryNum);
      IF TempPW <> RwUser.RWPass
         THEN BEGIN
               RWL_WriteLog('?',RWL_LogTime+' Invalid password "'+TempPW+'".');
               IF (RwConfig.MaxPWTries > 0) AND (TryNum >= RwConfig.MaxPwTries) THEN FailPassword;
               RWM_WriteColor(RWM_GetString(116));
            END;
   UNTIL (TempPW = RwUser.RwPass);
   fk_WriteLn('',2);
END;


PROCEDURE RWM_ToggleVars(b:Boolean);
BEGIN
   IF b THEN BEGIN
            RwVariables^[1] := RWM_GetString(5);
            RwVariables^[2] := RWM_GetString(7);
            RwVariables^[3] := RWM_GetString(9);
         END
      ELSE BEGIN
            RwVariables^[1] := RWM_GetString(6);
            RwVariables^[2] := RWM_GetString(8);
            RwVariables^[3] := RWM_GetString(10);
         END;
END;


PROCEDURE RWM_ToggleFileList;
BEGIN
   fk_WriteLn('',2);
   IF (RwFileList IN RwUser.BWaveFlags)
      THEN RwUser.BWaveFlags := RwUser.BWaveFlags-[RwFileList]
      ELSE RwUser.BWaveFlags := RwUser.BWaveFlags+[RwFileList];
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
   RWM_ToggleVars(RwFileList IN RwUser.BWaveFlags);
   RWM_WriteColor(RWM_GetString(69));
END;


PROCEDURE RWM_ToggleFormat;
BEGIN
   fk_WriteLn('',2);
   IF (RwPacketQwk IN RwUser.RwFlags)
      THEN RwUser.RwFlags := RwUser.RwFlags-[RwPacketQwk]
      ELSE RwUser.RwFlags := RwUser.RwFlags+[RwPacketQwk];
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
   RWM_ToggleVars(NOT (RwPacketQwk IN RwUser.RwFlags));
   IF NOT (RwPacketQwk IN RwUser.RwFlags)
      THEN RWM_WriteColor(RWM_GetString(57))
      ELSE RWM_WriteColor(RWM_GetString(56));
END;


PROCEDURE RWM_ToggleExpert;
BEGIN
   fk_WriteLn('',2);
   IF (RwXpert IN RwUser.BWaveFlags)
      THEN RwUser.BWaveFlags := RwUser.BWaveFlags-[RwXpert]
      ELSE RwUser.BWaveFlags := RwUser.BWaveFlags+[RwXpert];
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
   RWM_ToggleVars(RwXpert IN RwUser.BWaveFlags);
   RWM_WriteColor(RWM_GetString(62));
END;


PROCEDURE RWM_ToggleBundleOwn;
BEGIN
   fk_WriteLn('',2);
   IF (RwNotMyMail IN RwUser.BWaveFlags)
      THEN RwUser.BWaveFlags := RwUser.BWaveFlags-[RwNotMyMail]
      ELSE RwUser.BWaveFlags := RwUser.BWaveFlags+[RwNotMyMail];
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
   RWM_ToggleVars(NOT (RwNotMyMail IN RwUser.BWaveFlags));
   RWM_WriteColor(RWM_GetString(54));
END;


PROCEDURE RWM_ToggleDelEmail;
BEGIN
   fk_WriteLn('',2);
   IF (RwNukeEmail IN RwUser.RwFlags)
      THEN RwUser.RwFlags := RwUser.RwFlags-[RwNukeEmail]
      ELSE RwUser.RwFlags := RwUser.RwFlags+[RwNukeEmail];
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
   RWM_ToggleVars(RwNukeEmail IN RwUser.RwFlags);
   RWM_WriteColor(RWM_GetString(61));
END;


PROCEDURE RWM_ToggleNumericPkt;
BEGIN
   fk_WriteLn('',2);
   IF (RwNumericPkt IN RwUser.BWaveFlags)
      THEN RwUser.BWaveFlags := RwUser.BWaveFlags-[RwNumericPkt]
      ELSE RwUSer.BWaveFlags := RwUser.BWaveFlags+[RwNumericPkt];
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
   RWM_ToggleVars(RwNumericPkt IN RwUser.BWaveFlags);
   IF (RwNumericPkt IN RwUser.BWaveFlags)
      THEN RWM_WriteColor(RWM_GetString(64))
      ELSE RWM_WriteColor(RWM_GetString(63));
END;


PROCEDURE RWM_SetPacketNumber;
VAR s:String;
BEGIN
   fk_WriteLn('',2);
   RwVariables^[4] := LeadingZero(RwUser.PktNumber,3);

   RWM_WriteColor(RWM_GetString(350));
   fk_Host.CurrentInput := LeadingZero(RwUser.PktNumber,3);
   fk_Host.ValidInput := '0123456789';
   s := fk_ReadLn(3,TRUE);

   IF (ValFunc(s) > 0) AND (ValFunc(s) < 1000) THEN RwUser.PktNumber := ValFunc(s);

   fk_Host.CurrentInput := '';
   fk_Host.ValidInput := fk_HighBitInput;
END;


PROCEDURE RWM_ToggleHotkeys;
BEGIN
   fk_WriteLn('',2);
   IF (RwHotkeys IN RwUser.BWaveFlags)
      THEN RwUser.BWaveFlags := RwUser.BWaveFlags-[RwHotkeys]
      ELSE RwUser.BWaveFlags := RwUser.BWaveFlags+[RwHotkeys];
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
   RWM_ToggleVars(RwHotkeys IN RwUser.BWaveFlags);
   RWM_WriteColor(RWM_GetString(55));
END;


PROCEDURE RWM_ChooseArchiver;
VAR i:Word; s:String;
BEGIN
   REPEAT
      RWM_WriteColor(RWM_GetString(120));
      RWM_WriteColor(RWM_GetString(121));
      FOR i := 1 TO MaxArcs DO IF MsRg_General.FileArcInfo[i].Active THEN
         BEGIN
            RwVariables^[1] := MsRg_General.FileArcInfo[i].Ext;
            IF MsRg_User.DefArcType = i
               THEN BEGIN
                     RwVariables^[3] := RWM_GetString(1);
                     RwVariables^[4] := RWM_GetString(11);
                     fk_Host.CurrentInput := MsRg_General.FileArcInfo[i].Ext;
                  END
               ELSE BEGIN
                     RwVariables^[3] := RWM_GetString(2);
                     RwVariables^[4] := RWM_GetString(12);
                  END;
            RWM_WriteColor(RWM_GetString(122));
         END;
      RWM_WriteColor(RWM_GetString(123));
      RWM_WriteColor(RWM_GetString(124));
      fk_Write(fk_Host.CurrentInput);
      s := fk_ReadLn(3,TRUE);
   UNTIL (MsRg_ArcSearch(s) > 0);
   fk_Host.CurrentInput := '';

   MsRg_UserFileOpen;
   MsRg_UserFileRead(RgUserNum);
   MsRg_User.DefArcType := MsRg_ArcSearch(s);
   MsRg_UserFileWrite(RgUserNum);
   MsRg_UserFileClose;
END;


PROCEDURE RWM_ChooseProtocol;
VAR i:Word; ch:char; ValidHotkeys:SET OF Char;
BEGIN
   REPEAT
      RWM_WriteColor(RWM_GetString(125));
      RWM_WriteColor(RWM_GetString(126));
      ValidHotkeys := [#13];

      FOR i := 1 TO 10 DO IF RwConfig.RwProtocols[i].Letter <> #0 THEN
         BEGIN
            RwVariables^[1] := RwConfig.RwProtocols[i].Letter;
            RwVariables^[2] := RwConfig.RwProtocols[i].Desc;
            ValidHotkeys := ValidHotkeys+[RwConfig.RwProtocols[i].Letter];
            IF (RwUser.RwProtocol = RwConfig.RwProtocols[i].Letter)
               THEN BEGIN
                     RwVariables^[3] := RWM_GetString(1);
                     RwVariables^[4] := RWM_GetString(11);
                  END
               ELSE BEGIN
                     RwVariables^[3] := RWM_GetString(2);
                     RwVariables^[4] := RWM_GetString(12);
                  END;
            RWM_WriteColor(RWM_GetString(127));
         END;

      RWM_WriteColor(RWM_GetString(128));
      RWM_WriteColor(RWM_GetString(129));
      REPEAT
         ch := Upcase(fk_Read);
      UNTIL (ch IN ValidHotkeys);
   UNTIL (ch IN ValidHotkeys);

   IF ch <> #13 THEN
      BEGIN
         RwUser.RwProtocol := Ch;
         Seek(RwUserFile,RwUserNum);
         Write(RwUserFile,RwUser);
      END;
END;


PROCEDURE RWM_DefineKeywords;
VAR Choice,Ch:Char; ThisNum,Found:Byte;

    FUNCTION GetChoice:Char;
    VAR ThisNum:Byte;
    BEGIN
       RWM_WriteColor(RWM_GetString(180));
       RWM_WriteColor(RWM_GetString(181));
       RWM_WriteColor(RWM_GetString(182));
       RWM_WriteColor(RWM_GetString(183));

       FOR ThisNum := 1 TO 10 DO
          BEGIN
             RwVariables^[1] := StrFunc(ThisNum-1);
             RwVariables^[2] := RwUser.Keywords[ThisNum];
             RWM_WriteColor(RWM_GetString(184));
          END;

       RWM_WriteColor(RWM_GetString(185));
       RWM_WriteColor(RWM_GetString(186));
       RWM_WriteColor(RWM_GetString(187));
       REPEAT ch := Upcase(fk_Read);
       UNTIL (ch IN ['0'..'9',RWM_GetCh(189,1)]);
       fk_WriteLn(ch,2);
       GetChoice := ch;
    END;

    PROCEDURE EditKeyword;
    VAR EditNum:Byte;
    BEGIN
       EditNum := Ord(Choice) - 48;
       RwVariables^[1] := StrFunc(EditNum);
       RWM_WriteColor(RWM_GetString(188)+RwUser.Keywords[EditNum+1]);
       fk_Host.CurrentInput := RwUser.Keywords[EditNum+1];
       fk_Host.ValidInput := fk_StandardInput;
       RwUser.Keywords[EditNum+1] := fk_ReadLn(20,TRUE);
       fk_Host.CurrentInput := '';
       fk_WriteLn('',2);
       Seek(RwUserFile,RwUserNum);
       Write(RwUserFile,RwUser);
    END;

BEGIN
   REPEAT
      Choice := GetChoice;
      IF (Choice IN ['0'..'9']) THEN EditKeyword;
   UNTIL (Choice IN [#13,RWM_GetCh(189,1)]);
END;



PROCEDURE RWM_DefineFilters;
VAR Choice,ch:Char; ThisNum,Found:Byte;

    FUNCTION GetChoice:Char;
    VAR ThisNum:Byte;
    BEGIN
       RWM_WriteColor(RWM_GetString(190));
       RWM_WriteColor(RWM_GetString(191));
       RWM_WriteColor(RWM_GetString(192));
       RWM_WriteColor(RWM_GetString(193));

       FOR ThisNum := 1 TO 10 DO
          BEGIN
             RwVariables^[1] := StrFunc(ThisNum-1);
             RwVariables^[2] := RwUser.Filters[ThisNum];
             RWM_WriteColor(RWM_GetString(194));
          END;

       RWM_WriteColor(RWM_GetString(195));
       RWM_WriteColor(RWM_GetString(196));
       RWM_WriteColor(RWM_GetString(197));
       REPEAT ch := Upcase(fk_Read);
       UNTIL (ch IN ['0'..'9',RWM_GetCh(199,1)]);
       fk_WriteLn(ch,2);
       GetChoice := ch;
    END;

    PROCEDURE EditFilter;
    VAR EditNum:Byte;
    BEGIN
       EditNum := Ord(Choice) - 48;
       RwVariables^[1] := StrFunc(EditNum);
       RWM_WriteColor(RWM_GetString(198)+RwUser.Filters[EditNum+1]);
       fk_Host.CurrentInput := RwUser.Filters[EditNum+1];
       fk_Host.ValidInput := fk_StandardInput;
       RwUser.Filters[EditNum+1] := fk_ReadLn(20,TRUE);
       fk_Host.CurrentInput := '';
       fk_WriteLn('',2);
       Seek(RwUserFile,RwUserNum);
       Write(RwUserFile,RwUser);
    END;

BEGIN
   REPEAT
      Choice := GetChoice;
      IF (Choice IN ['0'..'9']) THEN EditFilter;
   UNTIL (Choice IN [#13,RWM_GetCh(199,1)]);
END;



PROCEDURE RWM_DefineMacros;
VAR Choice:Char; s:String;

    FUNCTION GetChoice:Char;
    VAR Ch:Char;
    BEGIN
       RWM_WriteColor(RWM_GetString(200));
       RWM_WriteColor(RWM_GetString(201));
       RWM_WriteColor(RWM_GetString(202));
       RWM_WriteColor(RWM_GetString(203));

       RwVariables^[1] := RwUser.BundlMacros[1];
       RwVariables^[2] := RwUser.BundlMacros[2];
       RwVariables^[3] := RwUser.BUndlMacros[3];

       RWM_WriteColor(RWM_GetString(204));
       RWM_WriteColor(RWM_GetString(205));
       RWM_WriteColor(RWM_GetString(206));
       RWM_WriteColor(RWM_GetString(207));
       RWM_WriteColor(RWM_GetString(208));
       RWM_WriteColor(RWM_GetString(209));
       RWM_WriteColor(RWM_GetString(210));
       RWM_WriteColor(RWM_GetString(211));

       REPEAT ch := Upcase(fk_Read);
       UNTIL Pos(ch,'123'+s) > 0;
       fk_WriteLn(ch,2);
       GetChoice := ch;
    END;

    PROCEDURE EditMacro;
    VAR EditNum : Byte;
    BEGIN
       EditNum := Ord(Choice) - 48;
       RwVariables^[1] := StrFunc(EditNum);
       RWM_WriteColor(RWM_GetString(212));
       fk_Host.ValidInput := fk_StandardInput;
       RwUser.BundlMacros[EditNum] := fk_ReadLn(76,TRUE);
       fk_WriteLn('',2);
       Seek(RwUserFile,RwUserNum);
       Write(RwUserFile,RwUser);
    END;

BEGIN
   s := RWM_GetStringR(213,3);
   REPEAT
      Choice := GetChoice;
      IF Choice IN ['1'..'3'] THEN EditMacro ELSE
      IF Choice = s[1]        THEN RWM_DispFile(RwHlp_BundleS,TRUE,MsRg_User.PageLen) ELSE
      IF Choice = s[2]        THEN RWM_DispFile(RwHlp_Bundle,TRUE,MsRg_User.PageLen);
   UNTIL Pos(Choice,#13+s[3]) > 0
END;


PROCEDURE RWM_DefineSizeLimit;
VAR SizeIn:LongInt; Err:Integer; Str:String;
BEGIN
   fk_WriteLn('',2);

   IF RwUser.MsgsLimit = 0
      THEN RwVariables^[1] := RWM_GetString(6)
      ELSE RwVariables^[1] := StrFunc(RwUser.MsgsLimit);

   RWM_WriteColor(RWM_GetString(58));
   RWM_WriteColor(RWM_GetString(59));
   RWM_WriteColor(RWM_GetString(60));

   fk_Host.ValidInput := '1234567890';
   Str := fk_ReadLn(5,TRUE);
   Val(Str,SizeIn,Err);
   fk_WriteLn('',2);
   IF Err <> 0 THEN
      BEGIN
         RWM_WriteColor(RWM_GetString(29));
         Exit;
      END;
   RwUser.MsgsLimit := SizeIn;
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
END;


PROCEDURE RWM_DefinePassword;
VAR newpw,temps:String; ch:Char;
BEGIN
   RWM_WriteColor(RWM_GetString(35));
   fk_Host.OutputChar := RWM_GetCh(14,1);
   NewPW := fk_ReadLn(20,TRUE);

   RWM_WriteColor(RWM_GetString(36));
   temps := fk_ReadLn(20,TRUE);
   fk_Host.OutputChar := Chr(0);

   IF (NewPW <> TempS) OR (NewPW = '')
      THEN BEGIN
            RWM_WriteColor(RWM_GetString(37));
            Exit;
         END;
   RwUser.RwPass := NewPW;

   RWM_WriteColor(RWM_GetString(38));
   RWM_WriteColor(RWM_GetString(39));
   RWM_WriteColor(RWM_GetString(40));
   RWM_WriteColor(RWM_GetString(41));

   REPEAT ch := Upcase(fk_Read);
   UNTIL (ch IN [RWM_GetCh(44,1),RWM_GetCh(44,2),RWM_GetCh(44,3),RWM_GetCh(44,4)]);
   fk_WriteLn(ch,2);

   IF ch = RWM_GetCh(44,1) THEN RwUser.PassUsage := 1 ELSE
   IF ch = RWM_GetCh(44,2) THEN RwUser.PassUsage := 2 ELSE
   IF ch = RWM_GetCh(44,3) THEN RwUser.PassUsage := 3 ELSE
   IF ch = RWM_GetCh(44,4) THEN RwUser.PassUsage := 0;

   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
END;


PROCEDURE RWM_ToggleFAttach;
VAR s:String; Choice:Char;
BEGIN
   IF RwUser.AttachMethod > 2 THEN RwUser.AttachMethod := 0;
   fk_WriteLn('',2);
   CASE RwUser.AttachMethod OF
      0 : RwVariables^[1] := RWM_GetString(300);
      1 : RwVariables^[1] := RWM_GetString(301);
      2 : RwVariables^[1] := RWM_GetString(302);
   END;
   RWM_WriteColor(RWM_GetString(303));
   RWM_WriteColor(RWM_GetString(304));
   RWM_WriteColor(RWM_GetString(305));
   RWM_WriteColor(RWM_GetString(306));
   RWM_WriteColor(RWM_GetString(307));
   RWM_WriteColor(RWM_GetString(308));
   s := RWM_GetStringR(309,3);
   REPEAT
      Choice := fk_Read;
      IF      Choice=s[1] THEN RwUser.AttachMethod := 0
      ELSE IF Choice=s[2] THEN RwUser.AttachMethod := 1
      ELSE IF Choice=s[3] THEN RwUser.AttachMethod := 2;
   UNTIL Pos(Choice,#13+s) > 0;
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
END;


PROCEDURE RWM_InitBundle;
VAR NewsNum:Byte;
BEGIN
   Assign(bwDatFile,RwWorkDir+RwConfig.BBSID+'.DAT'); Rewrite(bwDatFile,1);
   Assign(bwFtiFile,RwWorkDir+RwConfig.BBSID+'.FTI'); Rewrite(bwFtiFile);
   {...}
   FOR NewsNum := 1 to 5 DO WITH RwConfig.NewsFiles[NewsNum] DO
      IF (TheFile <> '') AND FExists(TheFile) THEN
         CopyFile(TheFile,RwWorkDir+ExtractFName(TheFile),TRUE);

   Rwfl_Aborted := FALSE;
   CASE RwConfig.FileListType OF
      1 : BEGIN
             IF (RwConfig.FileListOptional=FALSE) OR (RwFileList IN RwUser.BWaveFlags)
                THEN
                   RWF_CreateFileList(RwWorkDir+'NEWFILES.BBS');
          END;
      2 : IF (RwConfig.FilesList <> '') AND FExists(RwConfig.FilesList) AND
             ((PrescanMode=FALSE) OR (RwFileList IN RwUser.BWaveFlags)) THEN
                CopyFile(RwConfig.FilesList,RwWorkDir+'NEWFILES.BBS',TRUE);
   END;
END;


PROCEDURE RWM_GetExt;
VAR CurrDate:LongInt; DayOfWEek:Byte;
BEGIN
   IF (RwNumericPkt IN RwUser.BWaveFlags) THEN
      BEGIN
         IF (RwUser.PktNumber >= 1000) OR (RwUser.PktNumber <= 0) THEN
            BEGIN
               RwUser.PktNumber := 1;
               Seek(RwUserFile,RwUserNum);
               Write(RwUserFile,RwUser);
            END;
         Ext := '.'+LeadingZero(RwUser.PktNumber,3);
         Inc(RwUser.PktNumber);
         Seek(RwUserFile,RwUserNum);
         Write(RwUserFile,RwUser);
         Exit;
      END;
   CurrentSecs(CurrDate,DayOfWeek);
   IF (CurrDate DIV 86400) = (RwUser.LastDL DIV 86400)
      THEN Inc(RwUser.TodaysPackets)
      ELSE RwUser.TodaysPackets := 0;
   RwUser.LastDL := CurrentSecsFunc;
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);
   Seek(RwUserFile,RwUserNum);
   CASE DayOfWeek OF
      0 : Ext := '.SU' + StrFunc(RwUser.TodaysPackets MOD 10);
      1 : Ext := '.MO' + StrFunc(RwUser.TodaysPackets MOD 10);
      2 : Ext := '.TU' + StrFunc(RwUser.TodaysPackets MOD 10);
      3 : Ext := '.WE' + StrFunc(RwUser.TodaysPackets MOD 10);
      4 : Ext := '.TH' + StrFunc(RwUser.TodaysPackets MOD 10);
      5 : Ext := '.FR' + StrFunc(RwUser.TodaysPackets MOD 10);
      6 : Ext := '.SA' + StrFunc(RwUser.TodaysPackets MOD 10);
   END;
END;


PROCEDURE RWM_DownloadQWK;
VAR PktFileName,PktFileDir:String;
BEGIN
   RWM_KeyPressOff;
   RWM_EraseTemp;
   RWM_KeyPressOff;
   RWQ_InitQWK;

   IF Rwfl_Aborted THEN
      BEGIN
         Rwfl_Aborted := FALSE;
         RWQ_DeInitQWK;
         MSBW_DeInitAttachList;
         Exit;
      END;

   IF RWB_ProcAllBases(TRUE) THEN
      BEGIN
         RWM_KeyPressOff;
         RWQ_DeInitQWK;
         PktFileName := MsRg_General.PacketName+'.QWK';
         IF (fk_Fossil.Baud = 0)
            THEN BEGIN
                  PktFileDir := RwConfig.LocalDLDir;
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '1';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '2';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '3';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '4';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '5';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '6';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '7';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '8';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := '9';
                  IF FExists(PktFileDir+PktFileName) THEN PktFileName[Length(PktFileName)] := 'K';
               END
            ELSE PktFileDir := RwWorkDir;
         IF NOT RWB_CompressPacket(PktFileDir+PktFileName,RwWorkDir+'*.*') THEN Exit;

         NukeFiles(RwWorkDir+'*.DAT');
         NukeFiles(RwWorkDir+'*.MSG');
         NukeFiles(RwWorkDir+'*.NDX');
         NukeFiles(RwWorkDir+'*.ID');

         IF RWB_ShowPacketInfo(PktFileDir,PktFileName) THEN
            BEGIN
               RWM_KeyPressOff;
               RWM_UpdatePointers;
               RWD_NukeEmail;
               RWB_CheckLogoff;
               fk_WriteLn('',2);
            END;
       END
   ELSE RWQ_DeInitQWK;
   RWD_DeInitPointerData;
   RWM_KeyPressOn;
END;


PROCEDURE RWM_DownloadPacket;
VAR PktFileName,PktFileDir:String;
BEGIN
{   IF RWP_CheckForWaiting THEN Exit;}

   RWM_EraseTemp;
   RWM_InitBundle;
   RWD_WriteInf;
   RWM_KeyPressOff;

   IF Rwfl_Aborted THEN
      BEGIN
         Rwfl_Aborted := FALSE;
         MSBW_DeInitAttachList;
         RWD_DeInitBundleFiles;
         Exit;
      END;

   IF RWB_ProcAllBases(FALSE) THEN
      BEGIN
         RWM_KeyPressOff;
         RWD_DeInitBundleFiles;
         RWM_GetExt;
         PktFileName := RwConfig.BBSID+Ext;
         IF (fk_Fossil.Baud > 0)
            THEN PktFileDir := RwWorkDir
            ELSE PktFileDir := RwConfig.LocalDLDir;

         IF NOT RWB_CompressPacket(PktFileDir+PktFileName,RwWorkDir+'*.*') THEN Exit;

         NukeFiles(RwWorkDir+RwConfig.BBSID+'.MIX');
         NukeFiles(RwWorkDir+RwConfig.BBSID+'.DAT');
         NukeFiles(RwWorkDir+RwConfig.BBSID+'.INF');
         NukeFiles(RwWorkDir+RwConfig.BBSID+'.FTI');

         IF RWB_ShowPacketInfo(PktFileDir,PktFileName) THEN
            BEGIN
               RWM_KeyPressOff;
               RWM_UpdatePointers;
               RWD_NukeEmail;
               RWB_CheckLogoff;
               fk_WriteLn('',2);
            END;
       END
   ELSE RWD_DeInitBundleFiles;
   RWD_DeInitPointerData;
   RWM_KeyPressOn;
END;


procedure RWM_UploadPacket;
var
  DelF            : File;
  BasePacketPath,
  PacketName      : String;
  Ext             : String[3];
  Qwk             : Boolean;

  procedure DoUpload; { nested }
  begin
    ChDir(RwWorkDir);
    RWM_KeyPressOff;
    if not RWB_UnCompressPacket(PacketName)
      then
        Exit;
    ChDir(StripSlash(RwConfig.RwMainDir));
    if not QWK
      then
        RWU_ProcPacket
      else
        RWQU_PRocPacket;
    if (fk_Fossil.Baud = 0) and (RwConfig.NukeLocalRep)
      then
        begin
          Assign(DelF,PacketName);
          Erase(DelF);
          if IOResult <> 0 then ;
        end;
    RWM_KeyPressOn;
  end;

begin
  RWM_KeyPressOff;
  RWM_EraseTemp;
  RWB_ShowULInfo;

  if (fk_Fossil.Baud = 0)
    then
      BasePacketPath := RwConfig.LocalULDir
    else
      BasePacketPath := RwWorkDir;

  if not (RwPacketQwk in RwUser.RwFlags)
    then
      Ext := 'NEW'
    else
      Ext := 'QWK';

  if (fk_Fossil.Baud > 0)
     then
       begin
         ChDir(RwConfig.RwWorkDir+StrFunc(fk_Host.Node));
         if not RWB_ReceiveFile(BasePacketPath+RwConfig.BBSID+'.'+Ext)
           then
             Exit;
       end
     else
       if not FExists(RwConfig.LocalULDir+RwConfig.BBSID+'.NEW') and
          not FExists(RwConfig.LocalULDir+MsRg_General.PacketName+'.REP')
         then
           begin
             RWM_KeyPressOn;
             RWM_WriteColor('|12'+RwConfig.LocalULDir+RwConfig.BBSID+'.'+Ext+' does not exist!'+#13#10);
             if not WarpUL then RWM_Pause;
             Exit;
           end;

  if FExists(BasePacketPath+RwConfig.BBSID+'.NEW')
    then
      begin
        Qwk := FALSE;
        PacketName := BasePacketPath+RwConfig.BBSID+'.NEW';
        DoUpload;
        RWM_EraseTemp;
      end;

  if FExists(BasePacketPath+MsRg_General.PacketName+'.REP')
    then
      begin
        Qwk := TRUE;
        PacketName := BasePacketPath+MsRg_General.PAcketName+'.REP';
        DoUpload;
        RWM_EraseTemp;
      end;
end;


PROCEDURE RWM_ProcMenu(MenuFile:String);
VAR Menu   : ^RwMenuRec;
    Cmd    : ^RwMenuCmdRec;
    CmdNum : Word;
    MenuF  : Text;
    Line   : String;

    FUNCTION NextSegment(VAR s:String):String;
    VAR CPos:Byte; ts:String;
    BEGIN
       CPos := Pos(',',s);
       IF CPos > 0
          THEN BEGIN
                ts := Copy(s,1,CPos-1);
                ts := StripTrailingCh(ts,' ');
                Delete(s,1,CPos);
                s := StripLeadingCh(s,' ');
             END
          ELSE ts := s;
       IF Length(ts) >= 2 THEN
          BEGIN
             IF (ts[1] = '"') THEN Delete(ts,1,1);
             IF (ts[Length(ts)] = '"') THEN Dec(ts[0]);
          END;
       NextSegment := ts;
    END;

    PROCEDURE ProcCommands;
    VAR Quit:Boolean; UserCmd,CmdLine:String; i,LineNum:Word;
    BEGIN
       Quit := FALSE;
       REPEAT
          IF NOT (RwXpert IN RwUser.BWaveFlags) THEN RWM_DispFile(Menu^.MenuScreen,TRUE,0);
          RWM_WriteColor(Menu^.MenuPrompt);
          fk_Host.ValidInput := fk_HighBitInput+#13;
          UserCmd := RWM_GetCmd(RwHotkeys IN RwUser.BWaveFlags);

          Reset(MenuF);
          LineNum := 0;

          WHILE NOT Eof(MenuF) DO
             BEGIN
                Inc(LineNum);
                ReadLn(MenuF,CmdLine);
                CmdLine := StripLeadingCh(CmdLine,' ');
                CmdLine := StripTrailingCh(CmdLine,' ');
                CmdLine := MsRg_MciString(CmdLine);

                IF UpcaseStr(Copy(CmdLine,1,4)) = 'CMD ' THEN
                   BEGIN
                      Delete(CmdLine,1,4);
                      CmdLine := StripLeadingCh(CmdLine,' ');

                      Cmd^.CmdKeys    := UpcaseStr(NextSegment(CmdLine));
                      Cmd^.CmdAcs     := UpcaseStr(NextSegment(CmdLine));
                      Cmd^.CmdCmd     := UpcaseStr(NextSegment(CmdLine));
                      Cmd^.CmdOptions := CmdLine;

                      IF (Cmd^.CmdKeys = UserCmd) AND EvalAcs(Cmd^.CmdAcs) THEN
                         BEGIN
                            Close(MenuF);
                            CASE Cmd^.CmdCmd[1] OF
                               '&' : CASE Cmd^.CmdCmd[2] OF
                                        'D' : IF (NOT (RwPacketQwk IN RwUser.RwFlags)) OR
                                                 (Cmd^.CmdOptions = 'BLUE WAVE')
                                                 THEN RWM_DownloadPacket
                                                 ELSE RWM_DownloadQWK;
                                        'U' : RWM_UploadPacket;
                                        'Q' : BEGIN
                                                 GlobalQuit := TRUE;
                                                 Quit := TRUE;
                                              END;
                                        'T' : CASE ValFunc(Cmd^.CmdOptions) OF
                                                 00 : RWM_ToggleFormat;
                                                 01 : RWM_ResetPointers;
                                                 02 : RWM_ChooseArchiver;
                                                 03 : RWM_ChooseProtocol;
                                                 04 : RWM_DefinePassword;
                                                 05 : RWM_ToggleBundleOwn;
                                                 06 : RWM_ToggleHotkeys;
                                                 07 : RWM_ToggleDelEmail;
                                                 08 : RWM_ToggleExpert;
                                                 09 : RWM_ToggleNumericPkt;
                                                 10 : RWM_DefineSizeLimit;
                                                 11 : RWM_DefineKeywords;
                                                 12 : RWM_DefineFilters;
                                                 13 : RWM_DefineMacros;
                                                 14 : RWA_ChooseAreas;
                                                 15 : RWM_ToggleFileList;
                                                 16 : RWM_SetPacketNumber;
                                                 17 : RWM_ToggleFAttach;
                                              END;
                                     END;
                               '-' : CASE Cmd^.CmdCmd[2] OF
                                        '^' : RWM_ProcMenu(Cmd^.CmdOptions);
                                        '/' : RWM_ProcMenu(Cmd^.CmdOptions);
                                        '\' : Quit := TRUE;
                                        'F' : WITH RwConfig,MsRg_User,Cmd^ DO
                                                 BEGIN
                                                    CmdOptions := ExtractFName(CmdOptions);
                                                    IF FExists(RwTextDir+CmdOptions)
                                                       THEN RWM_DispFile(RwTextDir+CmdOptions,TRUE,PageLen) ELSE
                                                    IF FExists(RwHelpDir+CmdOptions)
                                                       THEN RWM_DispFile(RwHelpDir+CmdOptions,TRUE,PageLen) ELSE
                                                    IF FExists(MsRg_General.MiscPath+CmdOptions)
                                                       THEN RWM_DispFile(MsRg_General.MiscPath+CmdOptions,TRUE,PageLen)
                                                       ELSE RWM_DispFile(RwTextDir+CmdOptions,TRUE,PageLen);
                                                 END;
                                        'L' : RWM_WriteColor(Cmd^.CmdOptions);
                                     END;
                               'H' : CASE Cmd^.CmdCmd[2] OF
                                        'I' : IF RwConfig.AllowGoodbye THEN BEGIN
                                                 CountDownSecs := 255;
                                                 RWB_CheckLogoff;
                                              END;
                                     END;
                            END; { CASE }
                            Assign(MenuF,RwConfig.RwMenuDir+MenuFile+'.MNU');
                            Reset(MenuF);
                            FOR i := 1 TO LineNum DO ReadLn(MenuF,CmdLine);
                         END; { IF }
                   END; { IF }
             END;
       UNTIL Quit;
       Close(MenuF);
    END;

    PROCEDURE ParseLine(VAR Line:String);
    VAR PromptID:Integer;
    BEGIN
       Line := StripLeadingCh(Line,' ');
       Line := StripTrailingCh(Line,' ');
       Line := MsRg_MciString(Line);

       IF UpcaseStr(Copy(Line,1,7))='PROMPT ' THEN
          BEGIN
             Delete(Line,1,7);
             Line := StripLeadingCh(Line,' ');
             Menu^.MenuPrompt := Copy(Line,2,Length(Line)-2);
             Exit;
          END;

       Line := UpcaseStr(Line);
       WHILE Pos('  ',Line) > 0 DO Delete(Line,Pos('  ',Line),1);

       IF Copy(Line,1,11)='MENUSCREEN ' THEN Menu^.MenuScreen := Copy(Line,12,Length(Line)-11);
    END;

BEGIN
   IF NOT FExists(RwConfig.RwMenuDir+MenuFile+'.MNU') THEN Exit;

   GlobalQuit := FALSE;
   Assign(MenuF,RwConfig.RwMenuDir+MenuFile+'.MNU');
   Reset(MenuF);

   New(Menu);
   New(Cmd);

   WHILE NOT Eof(MenuF) DO
      BEGIN
         ReadLn(MenuF,Line);
         ParseLine(Line);
      END;

   ProcCommands;

   Dispose(Menu);  Menu := NIL;
   Dispose(Cmd);   Cmd  := NIL;
END;


PROCEDURE RWM_RunMain;
BEGIN
   IF RWI_CheckNewUser THEN RWI_InitNewUser;

   RWM_KeyPressOff;
   RWI_ReadPrompts;
   RWI_ProductInfo;
   RWI_InitBases;

   RwUser.LastOn := CurrentSecsFunc;
   Seek(RwUserFile,RwUserNum);
   Write(RwUserFile,RwUser);

   RWM_KeyPressOn;

   IF WarpUL OR WarpDL THEN
      BEGIN
         IF WarpUL THEN RWM_UploadPacket;
         IF WarpDL THEN IF NOT (RwPacketQwk IN RwUser.RwFlags)
            THEN RWM_DownloadPacket
            ELSE RWM_DownloadQWK;
         MsRg_MAreaClose;
         Close(RwUserFile);
         Exit;
      END;

   RWM_Pause;
   RWM_CheckPassword;

   RWM_ProcMenu('RW_MAIN');

   MsRg_MAreaClose;
   Close(RwUserFile);
END;


END.
