{$O+}
UNIT RWHelp;

(* 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES  CRT,
      FASTW,
      SCREENS,
      MSOBJ,
      MISC1,
      MSTRINGS;

CONST MaxLines    = 100;
      BackColor   = 0;
      ColorTitle  = 0+(16*15);
      ColorArrow  = 15+(16*BackColor);
      ColorArrow2 = 0+(16*BackColor);

      HelpBoxInfo : BoxInfoType =
        (TopLeft     : (Ch:''; Attr:$0B);  TopRight     : (Ch:''; Attr:$0B);
         BotLeft     : (Ch:''; Attr:$0B);  BotRight     : (Ch:''; Attr:$0B);
         Top         : (Ch:''; Attr:$0B);  Bot          : (Ch:''; Attr:$0B);
         Left        : (Ch:''; Attr:$0B);  Right        : (Ch:''; Attr:$0B);
         LeftTitle   : (Ch:' '; Attr:$0B);  RightTitle   : (Ch:' '; Attr:$0B);
         AttrTitle   : $B0;                 AttrMiddle   : $07;
         AttrOption  : $07;                 AttrOptionH  : $71;
         AttrOptCh   : $07;                 AttrOptChH   : $71;
         AttrOption2 : $03;                 AttrOptionH2 : $71;
         AttrOptCh2  : $03;                 AttrOptChH2  : $71;
         AttrSetting : $03);


{$F+}
PROCEDURE DoHelp(IdxNum:Word);
{$F-}


VAR HelpScreen : ^ScreenType;


IMPLEMENTATION

USES  RWSMAIN;

TYPE  RWIdxRec = RECORD
         ShortDesc : String[60];
         RWPtr     : LongInt;
         TextSize  : Word;
      END;

      THelpArray = Array[1..MaxLines] OF String[90];


VAR
   RWIdx     : FILE OF RWIdxRec;
   Idx       : RWIdxRec;
   RWDat     : File;
   Dat       : String;
   HelpArray : ^THelpArray;
   Problem   : Boolean;
   TopPos,
   BotPos,
   I,
   C         : Integer;


PROCEDURE ShowProblem;
BEGIN
   RWS_DispErrorMsg('Error: Couldn''t open help files RWHELP.IDX/RWHELP.DAT');
   Problem := TRUE;
END;


PROCEDURE OpenHelpFiles;
BEGIN
   Assign(RWIdx,'RWHELP.IDX');
   {$I-} Reset(RWIdx); {$I+}
   IF IOResult <> 0 THEN ShowProblem;
   IF NOT Problem THEN
    BEGIN
       Assign(RWDat,'RWHELP.DAT');
       {$I-} Reset(RWDat,1); {$I+}
       IF IOResult <> 0 THEN ShowProblem;
    END;
END;


PROCEDURE ReadRWIdx(Rec:Integer);
BEGIN
   Seek(RWIdx,Rec);
   Read(RWIdx,Idx);
END;


PROCEDURE Dat2Array;
VAR B: Byte;
BEGIN
   C := 0;
   Seek(RWDat,Idx.RWPtr);
   REPEAT
      Inc(C);
      Dat := '';
      BlockRead(RWDat,B,1);
      BlockRead(RWDat,Dat[1],B);
      Dat[0] := CHR(B);
      HelpArray^[C] := Dat;
   UNTIL (FilePos(RWDat) >= (Idx.RWPtr+Idx.TextSize));
END;


{$F+}
PROCEDURE DoHelp(IdxNum:Word);
VAR Ch:Char; b:BoxInfoType;
BEGIN
   Problem := FALSE;
   OpenHelpFiles;
   IF Problem THEN Exit;
   New(HelpArray);
   ReadRWIdx(IdxNum);
   IF Idx.RwPtr < 0 THEN Exit;
   Dat2Array;

   b := BoxInfo;
   BoxInfo := HelpBoxInfo;

   TopPos := 1;
   IF C < 17
      THEN BEGIN
            MakeBox(Idx.ShortDesc,3,14-(C DIV 2),77,16+(C DIV 2)+(C MOD 2),TRUE);
            BotPos := C;
         END
      ELSE BEGIN
            MakeBox(Idx.ShortDesc,3,6,77,24,TRUE);
            BotPos := 16;
         END;

   TextAttr := BoxInfo.AttrMiddle;

   FOR I := TopPos TO BotPos DO
      IF C < 17
         THEN WritePipeXY(5,15-(C DIV 2)+i,HelpArray^[I]+#13#10)
         ELSE WritePipeXY(5,7+i,HelpArray^[I]+#13#10);

   REPEAT
      IF c >= 17 THEN
         BEGIN
            WriteFast(77,07,'',ColorArrow);
            WriteFast(77,23,'',ColorArrow);
            IF TopPos = 1 THEN WriteFast(77,07,'',ColorArrow2);
            IF BotPos = C THEN WriteFast(77,23,'',ColorArrow2);
         END;
      Ch := UpCase(ReadKey);
      CASE Ch OF
         #0 : BEGIN
                 Ch := UpCase(ReadKey);
                 CASE Ch OF
                    #72: IF TopPos > 1 THEN BEGIN { UP }
                            ScreenScroll(Down,1,7,22,4,75,BackColor*16);
                            Dec(TopPos);
                            Dec(BotPos);
                            TextAttr := BoxInfo.AttrMiddle;
                            WritePipeXY(5,8,HelpArray^[TopPos]);
                            GotoXY(4,WhereY);
                         END;
                    #80: IF BotPos < C THEN BEGIN { DOWN }
                            ScreenScroll(Up,1,7,22,4,75,BackColor*16);
                            Inc(TopPos);
                            Inc(BotPos);
                            TextAttr := BoxInfo.AttrMiddle;
                            WritePipeXY(5,23,HelpArray^[BotPos]);
                            GotoXY(4,WhereY);
                         END;
                    #71: IF (TopPos > 1) AND (c > 16) THEN BEGIN { HOME }
                            FastClr(' ',4,7,75,23,BackColor*16);
                            TopPos := 1;
                            BotPos := 16;
                            TextAttr := BoxInfo.AttrMiddle;
                            FOR i := TopPos TO BotPos DO WritePipeXY(5,7+i,HelpArray^[i]);
                          END;
                    #79: IF (BotPos < C) AND (c > 16) THEN BEGIN { END }
                            FastClr(' ',4,7,75,23,BackColor*16);
                            BotPos := C;
                            TopPos := BotPos-15;
                            TextAttr := BoxInfo.AttrMiddle;
                            FOR i := TopPos TO BotPos DO WritePipeXY(5,8+(i-TopPos),HelpArray^[i]);
                         END;
                    #73: IF (TopPos > 1) AND (c > 16) THEN BEGIN { PGUP }
                            FastClr(' ',4,7,75,23,BackColor*16);
                            IF TopPos <= 16 THEN TopPos := 1 ELSE TopPos := TopPos-16;
                            BotPos := TopPos+15;
                            TextAttr := BoxInfo.AttrMiddle;
                            FOR i := TopPos TO BotPos DO WritePipeXY(5,8+(i-TopPos),HelpArray^[i]);
                         END;
                    #81: IF (BotPos < C) AND (c > 16) THEN BEGIN { PGDN }
                            FastClr(' ',4,7,75,23,BackColor*16);
                            IF BotPos > (C-16) THEN BotPos := C ELSE BotPos := BotPos+16;
                            TopPos := BotPos-15;
                            TextAttr := BoxInfo.AttrMiddle;
                            FOR i := TopPos TO BotPos DO WritePipeXY(5,8+(i-TopPos),HelpArray^[i]+#13#10);
                         END;
                 END;
              END;
      END;
   UNTIL (Ch IN [#27]);
   BoxInfo := b;
   Dispose(HelpArray);
   Close(RWIdx);
   Close(RWDat);
END;
{$F-}


BEGIN
END.
