/**********************************************************************
  Copyright (c) 2000-2003,2009 Michael Dillon
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions 
  are met:

       Redistributions of source code must retain the above copyright 
       notice, this list of conditions and the following disclaimer. 

       Redistributions in binary form must reproduce the above 
       copyright notice, this list of conditions and the following 
       disclaimer in the documentation and/or other materials provided 
       with the distribution. 

       Neither the name of Crystalline Realms, Midnight's Hour BBS
       nor the names of their contributors may be used to endorse or
	   promote products derived from this software without specific
	   prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/
/*********************************************************************
 filecopy.cpp - File copying functions
 *********************************************************************/
#include "tinytic.h"
#include "filecopy.h"


// Function-Program constants 
#define COPY_BUFFER_SIZE 4096
void FileCopyProgress(unsigned long int FileSize, unsigned long int Copied);

bool FileCopy(const char *Source, const char *Dest)
{
        bool                    RValue = true; // Return Value
        char                    Buffer[COPY_BUFFER_SIZE];
        ifstream                SFile;
        ofstream                OFile;
        unsigned long int       SFileSize;
        unsigned long int       Copied;

        if (Source == NULL || Dest == NULL)
        {
                // One of the files specified isn't allowed to be used
                return (false);
        }

        // Attempt to open the file
        if (!FOpen( Source, SFile, ios::in|ios::binary))
                RValue = false;
        if (!FOpen( Dest, OFile, ios::out|ios::binary|ios::trunc))
                RValue = false;

        // Copy the data
        memset(Buffer, '\x0', COPY_BUFFER_SIZE * sizeof(char));

        if (RValue == true)
		{
                SFile.seekg(0L, ios::end);
                SFileSize = SFile.tellg();
                SFile.seekg(0L, ios::beg);
                cout << "Copy Progress: [" << setw(10)
                        << SFileSize << "/";
                Copied = 0;
		do {
                        SFile.read(Buffer, COPY_BUFFER_SIZE);
                        OFile.write(Buffer, SFile.gcount());
                        Copied += SFile.gcount();
                        FileCopyProgress(SFileSize, Copied);
                        memset(Buffer, '\x0', COPY_BUFFER_SIZE * sizeof(char));
                } while ((SFile.eof() == 0) && (SFile.gcount() == COPY_BUFFER_SIZE));
                FileCopyProgress(SFileSize, SFileSize);
                cout << endl;
		}

        // Close any open files
        if (FIsOpen(SFile) == true)
		SFile.close();
        if (FIsOpen(OFile) == true)
		OFile.close();
        // Return 
        return ( RValue );
}

// Originally FOpen() was a template, some compilers however did not
// appropriately handle the template.
bool FOpen(const char *FileName, ifstream &File, ios::openmode Flags)
{
  bool RValue = true;
  File.open(FileName, Flags);
  if (!File)
  {
    cerr << "Unable to open " << FileName << "." << endl;
    RValue = false;
  }
  return (RValue);
}

bool FOpen(const char *FileName, ofstream &File, ios::openmode Flags)
{
  bool RValue = true;
  File.open(FileName, Flags);
  if (!File)
  {
    cerr << "Unable to open " << FileName << "." << endl;
    RValue = false;
  }
  return (RValue);
}

void FileCopyProgress(unsigned long int FileSize, unsigned long int Copied)
{
        cout << setw(10) << Copied << "]";
        cout << "\x8\x8\x8\x8\x8\x8\x8\x8\x8\x8\x8";
        cout.flush();
        UNUSED_PARAM(FileSize);
}
