{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT DupeChk;

{ History:

RvdW 26-02-93 Deze unit gemaakt.
     27-02-93 DupeCheckExist routine met FOR loop is veeeel te traag.
              Omgezet in assembly.

}

INTERFACE

CONST MAXDUPECHECKS = ((65536-8) DIV 4)-1;      { -1 ivm de aantal counter }

PROCEDURE DupeCheckInit;
PROCEDURE DupeCheckEnd;
PROCEDURE DupeCheckAdd (CRC : LONGINT);
FUNCTION  DupeCheckExist (CRC : LONGINT) : BOOLEAN;


IMPLEMENTATION

USES Dos,
     Ramon,
     Cfg,
     Logs,
     Globals;

CONST DupeCheckFilename = 'DUPEFILE.TDB';

TYPE DupeMemoryType    = ARRAY[0..MAXDUPECHECKS] OF LONGINT;
     DupeMemoryTypePtr = ^DupeMemoryType;

VAR DupeMemoryPtr : DupeMemoryTypePtr;


{--------------------------------------------------------------------------}
{ DupeCheckInit                                                            }
{                                                                          }
{ Deze routine laadt een externe file met dupe informatie in het geheugen  }
{ en initialiseerd het geheugen. DupeInfo wordt in LongInt in een rij in   }
{ het geheugen bewaard.                                                    }
{                                                                          }
PROCEDURE DupeCheckInit;

VAR DupeFile : FILE;
    IORes    : BYTE;
    DupeMem  : WORD;

BEGIN
     IF (NOT Config.DoDupeChk) THEN
        Exit;

     { Reserveer geheugen voor de Dupe Data }
     DupeMem:=Config.DupeChecks*4+4;
     IF (MaxAvail > DupeMem) THEN
     BEGIN
          GetMem (DupeMemoryPtr,DupeMem);
          PeekMem;

          FillChar (DupeMemoryPtr^,DupeMem,0);
          IF DebugMem THEN
             LogExtraMessage (MEMUSEFOR+'Dupes = '+Word2String (DupeMem));
     END ELSE
     BEGIN
          LogMessage ('[DupeCheckInit] Low on memory, turning dupe checking OFF');
          Config.DoDupeChk:=FALSE; { uitschakelen }
          Exit;
     END;

     { Lees de dupe file in, als ie bestaat en }
     { het juiste aantal records bevat         }
     Assign (DupeFile,Config.SystemDir+DupeCheckFilename);
     {$I-} Reset (DupeFile,1); {$I+} IORes:=IOResult;

     IF (IORes = 2) THEN { file not found }
     BEGIN
          LogMessage ('Dupe File not found and not loaded');
          Exit;
     END;

     IF (IORes <> 0) THEN { other error }
     BEGIN
          LogDiskIOError (IORes,'[DupeCheckInit] Error opening Dupe File');
          Exit;
     END;

     { inlezen }
     {$I-} BlockRead (DupeFile,DupeMemoryPtr^,Config.DupeChecks*4+4); {$I+}
     IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[DupeCheckInit] Error reading Dupe File');

     Close (DupeFile);
END;


{--------------------------------------------------------------------------}
{ DupeCheckEnd                                                             }
{                                                                          }
{ Schrijft de buffer met dupeinfo naar disk, en geeft het aangevraagde     }
{ geheugen weer vrij.                                                      }
{                                                                          }
PROCEDURE DupeCheckEnd;

VAR DupeFile : FILE;
    IORes    : BYTE;

BEGIN
     IF (Config.DoDupeChk) THEN { is op FALSE gezet bij low memory }
     BEGIN
          Assign (DupeFile,Config.SystemDir+DupeCheckFilename);
          {$I-} Reset (DupeFile,1); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               {$I-} ReWrite (DupeFile,1); {$I+} IORes:=IOResult;
          END;

          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'[DupeCheckEnd] Unable to update/create dupe file')
          ELSE BEGIN
               Seek (DupeFile,0);
               {$I-} BlockWrite (DupeFile,DupeMemoryPtr^,Config.DupeChecks*4+4); {$I+}
               IORes:=IOResult;
               IF (IORes <> 0) THEN
                  LogDiskIOError (IORes,'[DupeCheckEnd] Error writing to dupe file');
               Close (DupeFile);
          END;
     END;

     IF (DupeMemoryPtr <> NIL) THEN
        FreeMem (DupeMemoryPtr,Config.DupeChecks*4+4);
END;


{--------------------------------------------------------------------------}
{ DupeCheckAdd                                                             }
{                                                                          }
{ Toevoegen van CRC waardes van berichten die door ons zelf zijn ge-       }
{ genereerd. Bijvoorbeeld berichten die we vertaald hebben uit Usenet      }
{ aangezien er al een aparte DupeCheck routine is voor de Usenet berichten }
{                                                                          }
PROCEDURE DupeCheckAdd (CRC : LONGINT) ;
BEGIN
     IF (Config.DoDupeChk) THEN
     BEGIN
          { circulaire buffer naar de volgende positie }
          { RWI 950313: = veranderd in >= }
          IF (DupeMemoryPtr^[0] >= Config.DupeChecks) THEN
             DupeMemoryPtr^[0]:=1
          ELSE
              Inc (DupeMemoryPtr^[0]);

          { crc waarde opslaan }
          DupeMemoryPtr^[DupeMemoryPtr^[0]]:=CRC;
     END;
END;


{--------------------------------------------------------------------------}
{ DupeCheckExist                                                           }
{                                                                          }
{ De ingevoerde CRC32 waarde over het bericht wordt door deze routine      }
{ vergeleken met de in de dupe tabel aanwezige getallen. Als het getal er  }
{ in voorkomt wordt TRUE terug gegeven. Anders FALSE en wordt het getal    }
{ aan het eind toegevoegd.                                                 }
{                                                                          }
FUNCTION DupeCheckExist (CRC : LONGINT) : BOOLEAN;

VAR Found : BOOLEAN;
    Lp    : WORD;

BEGIN
     { scan de tabel in het geheugen }
     Found:=FALSE;

     {$IFDEF OS2}
     ASM
        MOV EDI,DupeMemoryPtr    { adres van het buffer ophalen }
        ADD EDI,4                { eerste is de opslag pointer, sla die over }

        XOR ECX,ECX              { reset high part }
        MOV CX,Config.DupeChecks { aantal te doorzoeken }

        MOV EAX,CRC

        CLD                      { vooruit zoeken }
      @Cont:
        REPNE SCASD              { zoek naar EAX }
        JCXZ @NotFound           { einde tabel, niet gevonden dus }
                                 { stonden we het ten tijd van de controle niet }

      @Found:
        MOV Found,TRUE           { gevonden! maak de locale var Found TRUE }

      @NotFound:
     END;
     {$ELSE}
     ASM
        LES DI,DupeMemoryPtr { adres van het buffer ophalen }
        ADD DI,4             { eerste is de opslag pointer, sla die over }
        MOV CX,Config.DupeChecks { aantal te doorzoeken }
        SHL CX,1             { *2 omdat we in words zoeken }

        LEA SI,CRC           { hierop controleren }
        SEGSS MOV AX,[SI]    { bx:ax laden met de CRC }
        SEGSS MOV BX,[SI+2]

        CLD                  { vooruit zoeken }
      @Cont:
        REPNE SCASW          { zoek naar AX }
        JCXZ @NotFound       { einde tabel, niet gevonden dus }

        PUSH AX              { wel gevonden, kijk of we aan het begin }
        MOV AX,DI            { van een longint staan, dan is het verkeerd }
        AND AL,3             { omdat SCASW altijd verhoogd controleren we }
        POP AX               { dus of we NU wel aan het begin staan, dan }
                             { stonden we het ten tijd van de controle niet }
        JE @Cont             { niet aan het begin, zoek verder }

        CMP BX,ES:[DI]       { kijk of het tweede deel ook klopt }
        JNE @Cont            { nee, zoek verder }

      @Found:
        MOV Found,TRUE       { gevonden! maak de locale var Found TRUE }

      @NotFound:
     END;
     {$ENDIF}

     DupeCheckExist:=Found;
     IF Found THEN Exit;

     { niet gevonden, bewaar voor verder controle }
     { RWI 950313: = veranderd in >= }
     IF (DupeMemoryPtr^[0] >= Config.DupeChecks) THEN
        DupeMemoryPtr^[0]:=1
     ELSE
         Inc (DupeMemoryPtr^[0]);

     DupeMemoryPtr^[DupeMemoryPtr^[0]]:=CRC;
END;


{ unit initialization }

BEGIN
     DupeMemoryPtr:=NIL;
END.
