{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT MsgUtil;

{ (FIDO) MsgUtil                                                            }
{                                                                           }
{ Deze unit bevat de routines die nodig zijn voor onderhoud van de *.MSG    }
{ berichten base.                                                           }
{                                                                           }
{ Reply linken van berichten                                                }
{ Purgen van berichten op    - aantal                                       }
{                            - leeftijd                                     }
{                                                                           }
{ MD  28-06-93 Major speed upgrade, update nu geen berichten die toch geen  }
{              link hebben.                                                 }
{     03-08-93 Squish Linking hierheen verplaatst                           }
{              Squish Purging toegevoegd                                    }
{     04-08-93 Fido *.MSG purging toegevoegd                                }
{     13-09-93 JAM reindexing toegevoegd                                    }
{     07-10-93 Area,User & Subscription base onderhoud toegevoegt           }
{ RWI 18-10-94 Takeover, re-layout en bug fixing.                           }

INTERFACE

USES Database;

{ progress window coordinates }
CONST SXb  = 5;
      SYb  = 5;
      SXl  = 70;
      SYl  = 8;
      SXb2 = SXb+15;

TYPE LinkStructPtr = ^LinkStruct;
     LinkStruct    = RECORD
                           CRC_Subject : LONGINT;
                           Msg_Number  : LONGINT;
                           Nxt_Struct  : LinkStructPtr;
                     END;

TYPE StatusRecord = RECORD
                          AreaName     : STRING[50];
                          Areas,
                          AreasToDo    : WORD;
                          TotalMsg,
                          DezeArea,
                          DezeToDo,
                          SavedBytes   : LONGINT;
                    END;

VAR Status : StatusRecord;

PROCEDURE LinkOnlySeenAreas;
PROCEDURE UtilLinkAllAreas (Groups : GroupFlagType);
FUNCTION  UtilLinkMsgArea (AreaRecord : AreaBaseRecord) : BOOLEAN; { TRUE = Aborted }

FUNCTION  UtilLinkSquishArea (AreaRecord : AreaBaseRecord) : BOOLEAN;

PROCEDURE UtilPurgeAllAreas (Groups : GroupFlagType);

PROCEDURE UtilPackMsgArea (AreaRecord : AreaBaseRecord);

PROCEDURE UtilRenumberAllMSGAreas (Groups : GroupFlagType);
PROCEDURE UtilRenumberAllJAMAreas (Groups : GroupFlagType);
PROCEDURE UtilRenumberMsgArea (DirectoryName : STRING);

PROCEDURE UtilReIDXAllAreas (Groups : GroupFlagType);

PROCEDURE UtilUpdateProgress;
FUNCTION  UtilPercSaved (OldSize,NewSize : LONGINT) : BYTE;

PROCEDURE SelectiveAreaMaintenance;


IMPLEMENTATION

USES Crt,
     Fido,
     ListSrv,
     DOS,
     Logs,
     Globals,
     Ramon,
     Stats,
     Strings,
     PCBoard,
     Squish,
     UnixTime,
     Binkley,
     Cfg,
     AreaBase,
     UserBase,
     FidoMsg,
     Slice,
     Jam;

VAR LogSavedFirst : BOOLEAN;

{--------------------------------------------------------------------------}
{ LogGroups                                                                }
{                                                                          }
{ Deze routine schrijft een regel in de logfile als het groups filter iets }
{ anders is als GR_ALL.                                                    }
{                                                                          }
PROCEDURE LogGroups (Groups : GroupFlagType);

VAR Result    : STRING[30];

BEGIN
     IF TestGroupListSame (Groups,AllGroups) THEN
        Exit;

     Result:=BuildGroupListDesc (Groups,255);
     WHILE (Result <> '') AND (Pos (' ',Result) > 0) DO
           Delete (Result,Pos (' ',Result),1);

     LogMessage ('Only processing for areas in groups '+Result);
END;


{--------------------------------------------------------------------------}
{ StatusWindow                                                             }
{                                                                          }
{ Creert het link windowtje.                                               }
{                                                                          }
PROCEDURE StatusWindow;
BEGIN
     PushKeysLine;
     WriteKeysLine (' ^Esc Abort');

     WindowPush (SXb,SYb,SXl,SYl);
     BoxDraw (Double,SXb,SYb,SXl,SYl);

     WriteXY (SXb+2,SYb+1,'Area name  :');
     WriteXY (SXb+2,SYb+2,'Area type  :');
     WriteXY (SXb+2,SYb+3,'Area count :');
     WriteXY (SXb+2,SYb+4,'Total Msgs :');
     WriteXY (SXb+2,SYb+5,'This Area  :');
     WriteXY (SXb+2,SYb+6,'Status     :');

     WITH Status DO
     BEGIN
          AreaName:='';
          Areas:=0;
          AreasToDo:=0;
          TotalMsg:=0;
          DezeArea:=0;
          DezeToDo:=0;
          SavedBytes:=0;
     END; { with }
END;


{--------------------------------------------------------------------------}
{ UtilUpdateProgress                                                       }
{                                                                          }
{ Deze routine moet gebruikt worden om de progress tijdens lange processen }
{ te volgen. Het scherm wordt ook geupdate.                                }
{                                                                          }
PROCEDURE UtilUpdateProgress;

VAR TempStr : STRING[50];
    Perc    : BYTE;

BEGIN
     WITH Status DO
     BEGIN
          TempStr:=Word2String (DezeArea);

          IF (DezeToDo > 0) THEN
          BEGIN
               Perc:=Round ((DezeArea/DezeToDo)*100);
               TempStr:=TempStr+'/'+Word2String (DezeToDo)+' ('+Byte2String (Perc)+'%)';
          END;

          WriteXY (SXb2,SYb+5,AddUpWithSpaces (20,TempStr));
     END; { with }
END;


{--------------------------------------------------------------------------}
{ StatusWindowUpdate                                                       }
{                                                                          }
{ Deze routine vult het on screen link window met nieuw gegevens.          }
{                                                                          }
PROCEDURE StatusWindowUpdate;

VAR TempStr : STRING[50];
    Perc    : BYTE;

BEGIN
     { Update van het status windowtje }
     WITH Status DO
     BEGIN
          SetColor (cBoxData);
          WriteXY (SXb2,SYb+1,AddUpWithSpaces (SXl-(SXb2-SXb)-2,AreaName));

          TempStr:=Word2String (Areas);
          IF (AreasToDo > 0) THEN
          BEGIN
               Perc:=Round ((Areas/AreasToDo)*100);
               TempStr:=TempStr+'/'+Word2String (AreasToDo)+' ('+Byte2String (Perc)+'%)';
          END;

          WriteXY (SXb2,SYb+3,AddUpWithSpaces (20,TempStr));
          WriteXY (SXb2,SYb+4,AddUpWithSpaces (5,Word2String (TotalMsg)));

          UtilUpdateProgress; { laten zien }
     END; { with }
END;


{--------------------------------------------------------------------------}
{ LinkOnlySeenAreas                                                        }
{                                                                          }
{ Deze routine ge/misbruikt de Stats informatie om te kijken naar welke    }
{ areas er berichten zijn geschreven. Zo worden alleen die areas gelinkt   }
{ aan het einde van een toss.                                              }
{                                                                          }
{ MD 03-08-93 Squish Linking toegevoegd                                    }
{                                                                          }
PROCEDURE LinkOnlySeenAreas;

VAR CurrAreaSegPtr : AreaSegmentPtr;
    AreaInfo       : AreaBaseRecord;
    Aborted        : BOOLEAN;
    Lp             : BYTE;
    LinkedAreas    : WORD;

BEGIN
     { Zet het link windowtje op het scherm }
     StatusWindow;
     WriteXY (SXb+2,SYb,' Link ');

     { Schrijf een berichtje voor de log    }
     LogMessage ('Started linking all areas with new messages');

     { RWI 960828 voor de mooie weergave eerst even tellen hoeveel werk er is }
     Status.AreasToDo:=0;

     CurrAreaSegPtr:=FirstAreaSegPtr;
     WHILE (CurrAreaSegPtr <> NIL) DO
     BEGIN
          Inc (Status.AreasToDo,CurrAreaSegPtr^.AreasCount);
          CurrAreaSegPtr:=CurrAreaSegPtr^.NextAreaSegPtr;
     END; { while }

     LinkedAreas:=0;
     Status.Areas:=0;
     StatusWindowUpdate;

     Aborted:=FALSE;
     CurrAreaSegPtr:=FirstAreaSegPtr;

     WHILE (CurrAreaSegPtr <> NIL) DO
           WITH CurrAreaSegPtr^ DO
           BEGIN
                IF (AreasCount > 0) THEN
                   FOR Lp:=1 TO AreasCount DO
                   BEGIN
                        Slice_Now;

                        Inc (Status.Areas);
                        StatusWindowUpdate;

                        { een nieuwe potentieel slachtoffer }
                        ReadAreaBaseRecord (Areas[Lp].AreaRecNr,AreaInfo);

                        IF KeyPressed AND (ReadKey = kEsc) THEN
                        BEGIN
                             Aborted:=TRUE;
                             WriteXY (SXb2,SYb+6,'Aborted  ');
                             Break; { uit de for }
                        END;

                        IF (AreaInfo.FidoMsgStyle <> NoneType) AND
                           (AreaInfo.AreaName_F <> '') THEN
                        BEGIN
                             Inc (LinkedAreas);

                             Status.DezeArea:=0;
                             Status.DezeToDo:=0;
                             Status.AreaName:=DeleteBackSpaces (AreaInfo.AreaName_F);
                             StatusWindowUpdate;

                             CASE AreaInfo.FidoMsgStyle OF

                                  SquishType :
                                      Aborted:=UtilLinkSquishArea (AreaInfo);

                                  FidoMsgType :
                                      Aborted:=UtilLinkMsgArea (AreaInfo);

                                  JamType :
                                      Aborted:=JamMsgBase.LinkArea (AreaInfo);

                                  PCBoardType :
                                      LogMessage ('Cannot link PC-Board areas yet');
                             END; { case }

                             Inc (Status.TotalMsg,Status.DezeToDo);
                             StatusWindowUpdate;
                        END; { if }

                        IF Aborted THEN
                           Break; { RWI 960828 }

                   END; { for, if }

                IF Aborted THEN
                   Break; { uit de while }

                CurrAreaSegPtr:=NextAreaSegPtr;
           END; { with, while }

     IF Aborted THEN LogMessage ('Linking aborted')
                ELSE LogMessage ('Linking completed');

     LogExtraMessage ('Linked '+Word2String (LinkedAreas)+
                      ' areas, containing '+Word2String (Status.TotalMsg)+
                      ' messages.');

     WindowPop; { status window }
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilLinkAllAreas                                                         }
{                                                                          }
{ Deze routine doorloopt de Areabase en linkt elke area die een fido       }
{ Area heeft. (Squish/Msg/Whatever)                                        }
{                                                                          }
{ MD 03-08-93 Squish linking toegevoegd                                    }
{ RWI 951127: Groups filter toegevoegd.                                    }
{                                                                          }
PROCEDURE UtilLinkAllAreas (Groups : GroupFlagType);

VAR AreaInfo    : AreaBaseRecord;
    LinkedAreas,
    AantalAreas,
    CountAreas  : AreaBaseRecordNrType;
    Aborted     : BOOLEAN;

BEGIN
     { zet het link windowtje op het scherm }
     StatusWindow;
     WriteXY (SXb+2,SYb,' Link ');

     { schrijf een berichtje voor de log }
     LogMessage ('Started linking messages in areas');
     LogGroups (Groups);

     { haal het totaal aantal gebieden }
     LinkedAreas:=0;
     AantalAreas:=AreaBaseRecCount;
     Status.AreasToDo:=AantalAreas;

     Aborted:=FALSE;

     FOR CountAreas:=1 TO AantalAreas DO
     BEGIN
          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               WriteXY (SXb2,SYb+6,'Aborted  ');
               Aborted:=TRUE;
               Break; { uit de for/next }
          END;

          Inc (Status.Areas);
          StatusWindowUpdate;

          { wandel door de AreaBase }
          ReadAreaBaseRecord (CountAreas,AreaInfo);

          IF (AreaInfo.FidoMsgStyle <> NoneType) AND
             (NOT AreaInfo.Deleted) AND
             (AreaInfo.AreaName_F <> '') AND
             TestIfGroupCommon (Groups,AreaInfo.IsInGroups) THEN
          BEGIN
               Inc (LinkedAreas);

               Status.DezeArea:=0;
               Status.DezeToDo:=0;
               Status.AreaName:=DeleteBackSpaces (AreaInfo.AreaName_F);
               StatusWindowUpdate;

               CASE AreaInfo.FidoMsgStyle OF
                    FidoMsgType :
                        Aborted:=UtilLinkMsgArea (AreaInfo);

                    SquishType :
                        Aborted:=UtilLinkSquishArea (AreaInfo);

                    JamType :
                        Aborted:=JamMsgBase.LinkArea (AreaInfo);

                    PCBoardType :
                        LogMessage ('Cannot link PC-Board areas yet');
               END;

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END; { if }

          IF Aborted THEN
             Break; { uit de for }

     END; { for }

     IF Aborted THEN LogMessage ('Linking aborted')
                ELSE LogMessage ('Linking completed');

     LogExtraMessage ('Linked '+Word2String (Status.TotalMsg)+
                      ' messages in '+Word2String (LinkedAreas)+
                      ' areas.');

     LogClose;
     WindowPop; { status window }
     PopKeysLine;
END;


{-------------------------------------------------------------------------}
{                       Algemene Link List Routines                       }
{-------------------------------------------------------------------------}

{-------------------------------------------------------------------------}
{ AddLinkItem                                                             }
{                                                                         }
{ Deze routine bewaard alle bericht nummers + onderwerpen, en sorteerd    }
{ op onderwerp.                                                           }
{                                                                         }
PROCEDURE AddLinkItem (VAR Anchor : LinkStructPtr; CRC,Number : LONGINT);

VAR Last,
    Loc_Anchor,
    Local      : LinkStructPtr;

BEGIN
     Last:=NIL;
     Loc_Anchor:=Anchor;

     WHILE (Loc_Anchor <> NIL) DO
     BEGIN
          { Als we een item vinden dat in de lijst geplaatst kan worden  }
          { sorteer op bericht nummer, kleine nummers vooraan. Zo hebben }
          { we alle bericht nummers op volgorde liggen.                  }

          IF (Loc_Anchor^.Msg_Number > Number) THEN
          BEGIN
               GetMem (Local,Sizeof (LinkStruct));
               {$IFDEF LogGetMem} LogGetMem (Local,SizeOf (LinkStruct),'GetMem List Local'); {$ENDIF}
               PeekMem;

               WITH Local^ DO
               BEGIN
                    CRC_Subject:=CRC;
                    Msg_Number:=Number;
                    Nxt_Struct:=Loc_Anchor;
               END; { with }

               IF (Last <> NIL) THEN
                  Last^.Nxt_Struct:=Local
               ELSE
                   Anchor:=Local;

               Exit;
          END;

          Last:=Loc_Anchor;
          Loc_Anchor:=Loc_Anchor^.Nxt_Struct;

     END; { while }

     { We zijn heel door de lijst gekomen, blijkbaar moeten we }
     { aan het einde toevoegen.                                }

     GetMem (Local,SizeOf (LinkStruct));
     {$IFDEF LogGetMem} LogGetMem (Local,SizeOf (LinkStruct),'GetMem List Local (2)'); {$ENDIF}
     PeekMem;

     WITH Local^ DO
     BEGIN
          CRC_Subject:=CRC;
          Msg_Number:=Number;
          Nxt_Struct:=NIL;
     END;

     IF (Anchor <> NIL) THEN
        Last^.Nxt_Struct:=Local
     ELSE
         Anchor:=Local;
END;


{--------------------------------------------------------------------------}
{ Get_Subject                                                              }
{                                                                          }
{ Haalt het eerste record uit de lijst, verwijderd deze en geeft met       }
{ het bijbehorende bericht nummer terug.                                   }
{                                                                          }
PROCEDURE Get_Subject (Anchor : LinkStructPtr; VAR CRC : LONGINT);

VAR Local : LinkStructPtr;

BEGIN
     WHILE (Anchor <> NIL) DO
     BEGIN
          IF (Anchor^.CRC_Subject <> 0) THEN
          BEGIN
               CRC:=Anchor^.CRC_Subject;
               Anchor:=Anchor^.Nxt_Struct;
               Exit;
          END;

          Anchor:=Anchor^.Nxt_Struct;

     END; { while }

     CRC:=0;
END;


{--------------------------------------------------------------------------}
{ Get_Next_Subject                                                         }
{                                                                          }
{ Doorzoekt de lijst op zoek naar het eerst volgende record met hetzelfde  }
{ onderwerp. Geef hiervan het berichtnummer terug.                         }
{                                                                          }
FUNCTION Get_Next_Subject (VAR Anchor : LinkStructPtr; CRC : LONGINT) : LONGINT;
BEGIN
     WHILE (Anchor <> NIL) DO
     BEGIN
          IF (Anchor^.CRC_Subject = CRC) THEN
          BEGIN
               { we hebben een record gevonden met hetzelfde onderwerp }
               Get_Next_Subject:=Anchor^.Msg_Number;
               Anchor^.CRC_Subject:=0;
               Exit;
          END;

          Anchor:=Anchor^.Nxt_Struct;

     END; { while }

     Get_Next_Subject:=0;
END;


{--------------------------------------------------------------------------}
{ DeleteList                                                               }
{                                                                          }
{ Verwijdert de lijst uit het geheugen.                                    }
{                                                                          }
PROCEDURE DeleteList (VAR List : LinkStructPtr);

VAR Erase : LinkStructPtr;

BEGIN
     WHILE (List <> NIL) DO
     BEGIN
          Erase:=List;
          List:=List^.Nxt_Struct;
          {$IFDEF LogGetMem} LogGetMem (Erase,SizeOf (LinkStruct),'Free List'); {$ENDIF}
          FreeMem (Erase,SizeOf (LinkStruct));
     END; { while }
END;


{--------------------------------------------------------------------------}
{ UtilLinkMsgArea                                                          }
{                                                                          }
{ Doorloopt een berichten gebied op, leest headers in, sorteert ze         }
{ verbind headers aan elkaar en schrijft ze weer weg.                      }
{                                                                          }
FUNCTION UtilLinkMsgArea (AreaRecord : AreaBaseRecord) : BOOLEAN;

VAR Search        : SearchRec;
    FidoMsg       : FILE;
    FidoHeader    : FidoStoredHeader;
    Aborted       : BOOLEAN; { RWI 960828 }

    CurrentMessage,
    NextMessage,
    VorigMessage,
    VorigNummer   : Integer;
    IORes,
    BerichtNummer,
    Nop           : ValNop;
    Subject       : String;
    Subject_CRC   : Longint;
    Local,
    List          : LinkStructPtr;

    {---------------------------------------------------------------------}
    { UpdateMessage                                                       }
    {                                                                     }
    { Deze routine update in een *.Msg bericht de link pointers.          }
    {                                                                     }
    PROCEDURE UpdateMessage (FileName : STRING; Vorig,Volgend : INTEGER);

    VAR OutFile : FILE;
        IORes   : BYTE;

    BEGIN
         Slice_Now;

         Assign (OutFile,Filename);
         {$I-} Reset( Outfile,1); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
         BEGIN
              LogDiskIOError (IORes,'[Link/UpdateMessage] Unable to open '+FileName);
              Exit;
         END;

         {$I-}
         Seek (Outfile,184);
         BlockWrite (Outfile,Vorig,SizeOf (Vorig));

         Seek (Outfile,188);
         BlockWrite (Outfile,Volgend,SizeOf (Volgend));
         {$I+}

         IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'[Link/UpdateMessage] Unable to update '+FileName);

         Close (OutFile);
    END;

{UtilLinkMsgArea}

VAR Path : STRING;

LABEL GaVerder;

BEGIN
     UtilLinkMsgArea:=FALSE; { not aborted }

     { Vul het status window }
     WriteXY (SXb2,SYb+2,'Fido *.MSG');
     WriteXY (SXb2,SYb+6,'Scanning');

     List:=NIL;

     Status.DezeArea:=0;
     Status.DezeToDo:=0;

     Aborted:=FALSE;

     Path:=DeleteBackSpaces (AreaRecord.FidoMsgPath);
     IF (Path[Length (Path)] <> '\') THEN
        Path:=Path+'\';

     FindFirst (Path+'*.MSG',$3C,Search);
     WHILE (DosError = 0) DO
     BEGIN
          { controleer of het bericht begint met een decimale naam }
          Val (Copy (Search.Name,1,Pos ('.',Search.Name)-1),BerichtNummer,Nop);

          { zo niet, raporteer dit aan de bevoegde instanties }
          IF (Nop <> 0) THEN
          BEGIN
               LogExtraMessage ('Ignoring invalid name '+Search.Name);
               FindNext (Search);
               Continue;
          END;

          { lees nu de header van het bericht maar in }
          Assign (FidoMsg,Path+Search.Name);
          {$I-} Reset (FidoMsg,1);
          BlockRead (FidoMsg,FidoHeader,SizeOf (FidoHeader));
          Close (FidoMsg);
          {$I+}

          IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[UtilLinkArea] Error reading from '+Search.Name);
               {hangt in een oneindige lus..
               Continue; { RWI 960828, ipv Break.. }
               GOTO GaVerder;
          END;

          { kijk of het subject begint met 'RE:' }
          Subject:=StrPas (FidoHeader.Subject);
          IF (UpCaseString (Copy (Subject,1,4)) = 'RE: ') THEN
             Delete (Subject,1,4);

          { codeer het bericht }
          AddLinkItem (List,UpdateCRC32 (0,Subject[1],Length (Subject)),BerichtNummer);

          { weer een bericht in deze area }
          Inc (Status.DezeTodo);

          IF ((Status.DezeToDo MOD 25) = 1) THEN
          BEGIN
               UtilUpdateProgress;

               Slice_Now;

               IF KeyPressed AND (ReadKey = kEsc) THEN
               BEGIN
                    Aborted:=TRUE;
                    Break; { uit de while }
               END;
          END;

     GaVerder:
          FindNext (Search);
     END; { while }

     FindClose (Search);

     UtilLinkMsgArea:=Aborted; { update result code }

     StatusWindowUpdate;

     { geen berichten in deze area gevonden? }
     IF (List = NIL) THEN
        Exit;

     IF (NOT Aborted) THEN
     BEGIN
          { plaats de huidige status op het scherm }
          WriteXY (SXb2,SYb+6,'Linking ');

          Get_Subject (List,Subject_CRC);

          WHILE (NOT Aborted) AND (Subject_CRC <> 0) DO
          BEGIN
               Local:=List;
               VorigMessage:=0;
               CurrentMessage:=Get_Next_Subject (Local,Subject_CRC);
               NextMessage:=0;

               REPEAT
                     NextMessage:=Get_Next_Subject (Local,Subject_CRC);

                     { Update alleen berichten met een link }
                     IF (VorigMessage <> 0) OR (NextMessage <> 0) THEN
                        UpdateMessage (Path+Word2String (CurrentMessage)+'.MSG',
                                       VorigMessage,
                                       NextMessage);

                     VorigMessage:=CurrentMessage;
                     CurrentMessage:=NextMessage;

                     Inc (Status.DezeArea);
                     UtilUpdateProgress;

               UNTIL (Local = NIL);

               Get_Subject (List,Subject_CRC);

               Slice_Now;
               IF KeyPressed AND (ReadKey = kEsc) THEN
               BEGIN
                    Aborted:=TRUE;
                    Break;
               END;

          END; { while }
     END; { if not aborted }

     DeleteList (List);
     UtilLinkMsgArea:=Aborted;
END;


{--------------------------------------------------------------------------}
{ UtilLinkSquishArea                                                       }
{                                                                          }
{ Linkt berichten in een squish area aan elkaar vast...                    }
{ Deze routine maakt gebruik van een Link structuur die in MSGUTIL         }
{ is gecodeerd. Niet OOP, wel hergebruik van code                          }
{                                                                          }
{ Nog meer spannends, deze routine maakt gebruik van GOTO                  }
{                                                                          }
FUNCTION UtilLinkSquishArea (AreaRecord : AreaBaseRecord) : BOOLEAN;

VAR Search        : SearchRec;
    FidoMsg       : FILE;
    FidoHeader    : FidoStoredHeader;
    Aborted       : BOOLEAN;

    CurrentMessage,
    NextMessage,
    VorigMessage,
    VorigNummer   : LONGINT;
    IORes,
    BerichtNummer,
    Nop           : INTEGER;
    Subject       : STRING;
    Subject_CRC   : LONGINT;
    Local,
    List          : LinkStructPtr;

LABEL DirtyExit;

BEGIN
     UtilLinkSquishArea:=FALSE; { not aborted }

     List:=NIL;
     Aborted:=FALSE;

     { SquishInit }
     IF (NOT SquishMsgBase.InitSquishArea (AreaRecord)) THEN
     BEGIN
          LogMessage ('[UtilLinkSquishArea] Failed to initialize '+AreaRecord.AreaName_F);
          GOTO DirtyExit;
     END;

     { Vul het status window }
     WriteXY (SXb2,SYb+2,'Squish     ');
     WriteXY (SXb2,SYb+6,'Scanning');

     { Een nieuwe berichten base heeft ook geen berichten }
     IF (SquishMsgBase.SquishBase.Num_Msg = 0) THEN
        GOTO DirtyExit;

     { laad het eerste frame }
     IF NOT SquishMsgBase.SquishLoadFrameType (SQ_FIRST) THEN
        GOTO DirtyExit;

     { Haal het aantal berichten gewoon uit de header }
     Status.DezeToDo:=SquishMsgBase.SquishBase.Num_Msg;
     Status.DezeArea:=0;

     { door de hele berichten base }
     WHILE (SquishMsgBase.CurrentFrame <> 0{NULLFRAME}) DO
     BEGIN
          Slice_Now;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
               Break;
          END;

          { laad de fido header }
          IF NOT SquishMsgBase.SquishLoadMsgHdr (SquishMsgBase.CurrentFrame) THEN
          BEGIN
               LogMessage ('[UtilLinkSquishArea] Error loading squish header');
               GOTO DirtyExit;
          END;

          { Bekijk de header                     }
          { Kijk of het subject begint met 'RE:' }
          Subject:=Copy (SquishMsgBase.SquishMsgHdr.Subj,1,Pos (#0,SquishMsgBase.SquishMsgHdr.Subj)-1);
          IF (UpCaseString (Copy (Subject,1,4)) = 'RE: ') THEN
             Delete (Subject,1,4);

          { Codeer het bericht                   }
          { En link het in de lijst              }
          { In plaats van een bericht nummer     }
          { is de CurrentFrame positie nu de     }
          { unieke sleutel                       }
          AddLinkItem (List,
                       UpdateCRC32 (0,Subject[1],Length (Subject)),
                       SquishMsgBase.CurrentFrame);

          Inc (Status.DezeArea);
          UtilUpdateProgress;

          SquishMsgBase.SquishLoadFrameType (SQ_NEXT);
     END; { while }

     IF Aborted THEN
        GOTO DirtyExit;

     { zorg dat de getalletjes netjes op het scherm komen }
     Status.DezeArea:=0;
     StatusWindowUpdate;

     { plaats de huidige status op het scherm }
     WriteXY (SXb2,SYb+6,'Linking ');

     { haal het eerste Subject uit de lijst }
     Get_Subject (List,Subject_CRC);

     WHILE (Subject_CRC <> 0) DO
     BEGIN
          Slice_Now;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
               Break;
          END;

          Local:=List;
          VorigMessage:=0;
          CurrentMessage:=Get_Next_Subject (Local,Subject_CRC);
          NextMessage:=0;

          REPEAT
                NextMessage:=Get_Next_Subject (Local,Subject_CRC);

                { Update alleen berichten met een link      }
                { Dit voorkomt onnodig lees en schrijf werk }
                IF (VorigMessage <> 0) OR (NextMessage <> 0) THEN
                BEGIN
                     { laad het bericht }
                     IF (NOT SquishMsgBase.SquishLoadFrame (SquishMsgBase.SquishFrameHdr,CurrentMessage)) THEN
                     BEGIN
                          LogMessage ('[UtilLinkSquishArea] Error updating Squish links');
                          GOTO DirtyExit;
                     END;

                     SquishMsgBase.SquishLoadMsgHdr (CurrentMessage);

                     WITH SquishMsgBase.SquishMsgHdr DO
                     BEGIN
                          { scheelt zoektijd, als er toch geen link is }
                          IF (VorigMessage <> 0) THEN
                             SquishMsgBase.SquishIDXSearchByFrameNumber (VorigMessage,ReplyTo);

                          { dito }
                          IF (NextMessage <> 0) THEN
                             SquishMsgBase.SquishIDXSearchByFrameNumber (NextMessage,Replies[1]);
                     END; { with }

                     SquishMsgBase.SquishSaveMsgHdr (CurrentMessage);
                END;

                VorigMessage:=CurrentMessage;
                CurrentMessage:=NextMessage;

                Inc (Status.DezeArea);
                UtilUpdateProgress;

          UNTIL (Local = NIL);

          Get_Subject (List,Subject_CRC);
     END; { while }

DirtyExit:
     { sluit de Squish Area af }
     SquishMsgBase.CloseSquishArea;

     { verwijder de lijst met Link informatie uit het geheugen }
     { RWI 960828: nu ook bij een Abort }
     DeleteList (List);

     UtilLinkSquishArea:=Aborted;
END;


{-------------------------------------------------------------------------}
{ Purge routines                                                          }
{                                                                         }
{ Deze routine verwijdert berichten op datum.                             }
{ Berichten worden verwijderd op de datum waarop een bericht ontvangen    }
{ is.                                                                     }


{--------------------------------------------------------------------------}
{ UtilPurgeAllAreas                                                        }
{                                                                          }
{ Loop alle areas af, en kijkt of er berichten verwijderd kunnen worden    }
{ uit de message bases.                                                    }
{                                                                          }
PROCEDURE UtilPurgeAllAreas (Groups : GroupFlagType);

VAR AreaInfo    : AreaBaseRecord;
    Dummy       : WordLong;
    PurgedAreas,
    CountAreas,
    AantalAreas : WORD;
    Aborted     : BOOLEAN;
    Lp          : BYTE;

BEGIN
     { zet het windowtje op het scherm }
     StatusWindow;
     WriteXY (SXb+2,SYb,' Purge ');

     { schrijf een berichtje voor de log }
     LogMessage ('Started purging all areas');
     LogGroups (Groups);

     { haal het totaal aantal gebieden }
     AantalAreas:=AreaBaseRecCount;
     Status.AreasToDo:=AantalAreas;
     PurgedAreas:=0;

     GlobalAbort:=FALSE;

     FOR CountAreas:=1 TO AantalAreas DO
     BEGIN
          Slice_Now;

          IF GlobalAbort OR (KeyPressed AND (ReadKey = kEsc)) THEN
          BEGIN
               WriteXY (SXb2,SYb+6,'Aborted  ');
               Break; { uit de for/next }
          END;

          { wandel door de AreaBase }
          ReadAreaBaseRecord (CountAreas,AreaInfo);

          Inc (Status.Areas);
          StatusWindowUpdate;

          IF (AreaInfo.AreaName_F <> '') AND
             (AreaInfo.FidoMsgStyle <> NoneType) AND
             (NOT AreaInfo.Deleted) AND
             TestIfGroupCommon (AreaInfo.IsInGroups,Groups) THEN
          BEGIN
               Inc (PurgedAreas);

               Status.DezeArea:=0;
               Status.AreaName:=DeleteBackSpaces (AreaInfo.AreaName_F);
               StatusWindowUpdate;

               CASE AreaInfo.FidoMsgStyle OF
                    SquishType :
                        SquishMsgBase.SquishPurgeArea (AreaInfo);

                    FidoMsgType :
                        UtilPackMsgArea (AreaInfo);

                    JamType :
                        JamMsgBase.PackArea (AreaInfo);

                    PCBoardType :
                        LogMessage ('Cannot purge PC-Board areas yet');
               END; { case }

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END; { if }

     END; { for }

     LogMessage ('Purging finished');

     LogExtraMessage ('Purged '+Longint2String (Status.SavedBytes)+
                      ' bytes in '+Word2String (PurgedAreas)+
                      ' areas.');

     LogClose;
     WindowPop; { status window }
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilPackMsgArea                                                          }
{                                                                          }
{ Deze routine stoomt door een *.MSG area, op zoek naar berichten die      }
{ te oud zijn, en teveel.                                                  }
{ De berichten worden op arrival datum ( bestands stempel in de dos        }
{ directory ) verwijderd.                                                  }
{                                                                          }
PROCEDURE UtilPackMsgArea (AreaRecord : AreaBaseRecord);

CONST MaxFiles = 20000;

TYPE MsgBuf    = ARRAY[1..1] OF WORD;
     MsgBufPtr = ^MsgBuf;

VAR ZoekBestand     : SearchRec;
    ZoekPath        : STRING;
    ZoekLijst       : MsgBufPtr;
    DeleteFile      : FILE;
    DatumTijd       : DateTime;
    TelBerichten,
    SortCounter,
    SortPosCounter  : WORD;
    Error           : ValNop;
    ChangesInSort   : BOOLEAN;
    BestandTijd,
    TotalFiles,
    DeleteFiles,
    KillDate,
    ZoekNummer,
    AantalBerichten : LONGINT;

    {----------------------------------------------------------------------}
    { DeleteMessage                                                        }
    {                                                                      }
    { Routine om *.MSG berichten uit een directory te kunnen verwijderen.  }
    {                                                                      }
    FUNCTION DeleteMessage (BerichtNummer : WORD) : BOOLEAN;

    VAR IORes : BYTE;

    BEGIN
         DeleteMessage:=FALSE;
         Assign (DeleteFile,ZoekPath+Word2String (BerichtNummer)+'.MSG');
         {$I-} Erase (DeleteFile); {$I+} IORes:=IOResult;
         Inc (DeleteFiles);

         IF (IORes <> 0) THEN
         BEGIN
              LogDiskIOError (IORes,'Error deleting fido '+
                              Word2String (BerichtNummer)+'.MSG message from '+AreaRecord.AreaName_F);
              Exit;
         END;

         DeleteMessage:=TRUE;
     END;


LABEL Verder,
      Einde;

VAR Saved : BYTE;

BEGIN
     { Init }
     TotalFiles:=0;
     DeleteFiles:=0;

     ZoekPath:=DeleteBackSpaces (AreaRecord.FidoMsgPath);
     IF (ZoekPath[Length (ZoekPath)] <> '\') THEN
        ZoekPath:=ZoekPath+'\';

     { Controleer of de directory wel bestaat }
     { RWI 941105: Bugfix. Dit werkt dus niet als het pad al een backslash
                           heeft... laat de search verderop er maar achter
                           komen dat er geen files in staan...
     FindFirst (ZoekPath,$10,ZoekBestand);
     IF (DosError <> 0) THEN
     BEGIN
          LogMessage ('[UtilPackMsgArea] Directory not found: '+ZoekPath);
          Exit;
     END;

     ZoekPath:=ZoekPath+'\';
     }

     { Bereken het tijdstip waarvoor een bericht te oud }
     { word om nog bewaard te worden.                   }
     IF (AreaRecord.FidoMsgAge <> 0) THEN
        KillDate:=GetCurrentUnixTime-SEC_Dag*AreaRecord.FidoMsgAge
     ELSE
         KillDate:=-1;

     { vul het status window }
     WriteXY (SXb2,SYb+2,'Fido *.MSG ');
     WriteXY (SXb2,SYb+6,'Scanning   ');

     { Reserveer geheugen voor maximaal 20,000 words met adressen. }
     { Een dos directory zal meer toch nooit kunnen adresseren.    }
     { But how about HPFS ????                                     }
     IF (MaxAvail < (MaxFiles*SizeOf (WORD))) THEN
     BEGIN
          LogMessage ('[UtilPurgeArea] Not enough memory, stopping scan');
          Exit;
     END;

     GetMem (ZoekLijst,MaxFiles*SizeOf (WORD));
     PeekMem;

     AantalBerichten:=0;

     { Zoek naar *.MSG bestanden }
     FindFirst (ZoekPath+'*.MSG',$3C,ZoekBestand);
     WHILE (DosError = 0) DO
     BEGIN
          { controleer of het bestand een 99999999.MSG naam heeft }
          Val (Copy (ZoekBestand.Name,1,Pos ('.',ZoekBestand.Name)-1),ZoekNummer,Error);
          IF (Error > 0) THEN
             GOTO Verder;

          { tel de grootte bij het totaal op }
          Inc (TotalFiles);
          Inc (Status.DezeTodo);
          IF ((Status.DezeToDo MOD 25) = 1) THEN
          BEGIN
               UtilUpdateProgress;
               Slice_Now;
          END;

          { controleer of het bericht niet toevallig te oud is }
          UnPackTime (ZoekBestand.Time,DatumTijd);
          DosToUnix (DatumTijd,BestandTijd);

          IF (KillDate <> -1) AND (BestandTijd < KillDate) THEN
          BEGIN
               { verwijder het bericht }
               Status.SavedBytes:=Status.SavedBytes+ZoekBestand.Size; { RWI 960714 }
               DeleteMessage (ZoekNummer);
               GOTO Verder;
          END;

          { Zo niet, voeg het dan toe aan de lijst met te verwerken }
          { berichten.                                              }
          Inc (AantalBerichten);
          ZoekLijst^[AantalBerichten]:=ZoekNummer;

Verder:
          FindNext (ZoekBestand);
     END; { while }

     FindClose (ZoekBestand);

     { Controleer of er wel op aantal gepurged mag worden, }
     { en of er uberhaupt wel berichten zijn.              }
     IF (AreaRecord.FidoMsgLimit <> 0) AND
        (AantalBerichten > AreaRecord.FidoMsgLimit) THEN
     BEGIN
          { Sorteer de lijst met bestanden zodanig dat de laagste nummers }
          { voor komen te liggen.                                         }
          WriteXY (SXb2,SYb+6,'Sorting    ');

          FOR SortCounter:=1 TO AantalBerichten DO
          BEGIN
               Status.DezeArea:=SortCounter;
               UtilUpdateProgress;

               ChangesInSort:=FALSE;

               FOR SortPosCounter:=1 TO (AantalBerichten-SortCounter) DO
                   IF (ZoekLijst^[SortPosCounter] > ZoekLijst^[SortPosCounter+1]) THEN
                   BEGIN
                        Slice_Now;
                        ChangesInSort:=TRUE;
                        SwapWords (ZoekLijst^[SortPosCounter],ZoekLijst^[SortPosCounter+1]);
                   END;

               IF (NOT ChangesInSort) THEN
                  Break; { uit de for }
          END;

          { Verwijder nu alle berichten die teveel zijn }
          { Beginnend met de berichten met de laagste   }
          { nummers.                                    }
          WriteXY (SXb2,SYb+6,'Purging    ');

          FOR TelBerichten:=1 TO (AantalBerichten-AreaRecord.FidoMsgLimit) DO
              IF (NOT DeleteMessage (ZoekLijst^[TelBerichten])) THEN
                 GOTO Einde;

     END; { if }

     { en laat een regeltje in de log zien }
     IF (TotalFiles <> 0) THEN
        Saved:=Round ((DeleteFiles/TotalFiles)*100)
        {-((DeleteFiles-TotalFiles)*100) DIV TotalFiles}
     ELSE
         Saved:=0;

     LogExtraMessage ('*.MSG  Old:'+AddUpWithPreSpaces (5,Longint2String (TotalFiles))+
                      ' msgs New:'+AddUpWithPreSpaces (5,Longint2String (TotalFiles-DeleteFiles))+
                      ' msgs Saves: '+AddUpWithPreSpaces (3,Byte2String (Saved))+
                      '% in '+AreaRecord.AreaName_F);

     { dit is belangrijk ! }
Einde:
     FreeMem (ZoekLijst,MaxFiles*SizeOf (WORD));
END;


{============================ RENUM =======================================}


{--------------------------------------------------------------------------}
{ UtilRenumberAllMSGAreas                                                  }
{                                                                          }
{ Hoewel voorlopig alleen Fido *.MSG areas van een nieuwe nummering hoeven }
{ voorzien te worden, kan deze routine natuurlijk makkelijk worden         }
{ uitgebreid. (Waffle?)                                                    }
{                                                                          }
PROCEDURE UtilRenumberAllMSGAreas (Groups : GroupFlagType);

VAR AreaInfo : AreaBaseRecord;
    Aborted  : BOOLEAN;
    Lp       : AreaBaseRecordNrType;

BEGIN
     { zet het windowtje op het scherm }
     StatusWindow;
     WriteXY (SXb+2,SYb,' Renumber *.MSG ');

     { schrijf een berichtje voor de log }
     LogMessage ('Started renumbering all *.MSG areas');
     LogGroups (Groups);

     { kijk of de netmail area een *.MSG Area is }
     IF TestGroupListSame (Groups,AllGroups) AND (Config.FidoNetmailType = FidoMsgType) THEN
     BEGIN
          Inc (Status.Areas);
          Status.DezeArea:=0;
          Status.AreaName:='Primary Netmail';
          StatusWindowUpdate;
          UtilRenumberMsgArea (DeleteBackSpaces (Config.FidoNetmailPath));
          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
               WriteXY (SXb2,SYb+6,'Aborted  ');
          END;
     END;

     { kijk of de private mail area een *.MSG Area is }
     IF (NOT Aborted) AND TestGroupListSame (Groups,AllGroups) AND (Config.PrivmailType = FidoMsgType) THEN
     BEGIN
          Inc (Status.Areas);
          Status.DezeArea:=0;
          Status.AreaName:='Private Scan';
          StatusWindowUpdate;
          UtilRenumberMsgArea (DeleteBackSpaces (Config.PrivmailPath));
          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;
     END;

     Aborted:=FALSE;

     FOR Lp:=1 TO AreaBaseRecCount DO
     BEGIN
          Slice_Now;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
               WriteXY (SXb2,SYb+6,'Aborted  ');
               Break; { uit de for/next }
          END;

          ReadAreaBaseRecord (Lp,AreaInfo);

          IF (NOT AreaInfo.Deleted) AND
             (AreaInfo.FidoMsgStyle = FidoMsgType) AND
             (AreaInfo.AreaName_F <> '') AND
             TestIfGroupCommon (AreaInfo.IsInGroups,Groups) THEN
          BEGIN
               Inc (Status.Areas);
               Status.DezeArea:=0;
               Status.AreaName:=DeleteBackSpaces (AreaInfo.AreaName_F);
               StatusWindowUpdate;

               UtilRenumberMsgArea (DeleteBackSpaces (AreaInfo.FidoMsgPath));

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END; { if }
     END; { for }

     IF Aborted THEN LogMessage ('Renumber aborted')
                ELSE LogMessage ('Renumber completed');

     WITH Status DO
          LogExtraMessage ('Renumbered '+Word2String (Areas)+' areas, containing '+Word2String (TotalMsg)+' messages.');

     LogClose;
     WindowPop; { status window }
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilRenumberMsgArea                                                      }
{                                                                          }
{ Zorgt dat een Fido *.MSG area opnieuw keurig in volgorde wordt geplaatst }
{ Het programma stelt een limiet op 20,000 berichten in een directory      }
{ hoewel dat ver boven de limiet is die Dos aan een directory geeft.       }
{                                                                          }
{ RWI: Deze routine gaat de mist in als de bestandsnamen voorloopnullen    }
{      hebben! (bij het renamen wordt het nummer gereconstrueerd)          }
{                                                                          }
PROCEDURE UtilRenumberMsgArea (DirectoryName : STRING);

CONST MaxFiles = 20000;

TYPE MsgBuf     = ARRAY[1..1] OF WORD;
     MsgBufPtr  = ^MsgBuf;

VAR ZoekBestand     : SearchRec;
    ZoekPath        : STRING;
    ZoekLijst       : MsgBufPtr;
    RenameFile      : FILE;
    Error           : ValNop;
    ZoekNummer,
    SortPosCounter,
    SortCounter,
    AantalBerichten : WORD;
    ChangesInSort   : BOOLEAN;
    IORes           : BYTE;
    LastRead        : WORD;

LABEL CleanUp;

BEGIN
     { controleer of de directory wel bestaat }
     ZoekPath:=DirectoryName;

     { RWI 950121: backslash moet blijven...
     Dec (ZoekPath[0]); { backslash eraf hakken (?) }

     { RWI 941105: Bugfix. Zie purge..
     FindFirst (ZoekPath,$10,ZoekBestand);
     IF (DosError <> 0) THEN
     BEGIN
          LogMessage ('[RenumberMsgArea] Directory not found: '+ZoekPath);
          Exit;
     END;
     ZoekPath:=ZoekPath+'\';
     }

     { probeer geheugen voor de sorteer routine op te vragen }
     IF (MaxAvail < MaxFiles*SizeOf (WORD)) THEN
     BEGIN
          LogMessage ('Not enough free memory for *.MSG renumber');
          Exit;
     END;

     GetMem (ZoekLijst,MaxFiles*SizeOf (WORD));
     PeekMem;

     AantalBerichten:=0;

     { update het status window }
     WriteXY (SXb2,SYb+2,'Fido *.MSG ');
     WriteXY (SXb2,SYb+6,'Scanning   ');

     FindFirst (Copy (ZoekPath,1,Length (ZoekPath)-1),$10,ZoekBestand);
     IF (DosError <> 0) THEN
     BEGIN
          { directory does not exist }
          FindClose (ZoekBestand);
          GOTO CleanUp;
     END;

     FindClose (ZoekBestand);

     { doorloop de directory en registeer elk bericht }
     FindFirst (ZoekPath+'*.MSG',$3C,ZoekBestand);
     WHILE (DosError = 0) DO
     BEGIN
          { controleer of het bestand een 99999999.MSG naam heeft }
          Val (Copy (ZoekBestand.Name,1,Pos ('.',ZoekBestand.Name)-1),ZoekNummer,Error);

          IF (Error = 0) THEN
          BEGIN
               Inc (AantalBerichten);
               ZoekLijst^[AantalBerichten]:=ZoekNummer;
          END;

          FindNext (ZoekBestand);
     END; { while }

     FindClose (ZoekBestand);

     Slice_Now;

     { Sorteer de lijst met bestanden zodanig dat de laagste nummers }
     { voor komen te liggen.                                         }
     WriteXY (SXb2,SYb+6,'Sorting    ');

     { RWI 960324: Sorteer routine getest en goed gevonden.            }
     {             Werking: pik steeds het hoogste getal op een schuif }
     {             die naar het einde van de array.                    }
     FOR SortCounter:=1 TO AantalBerichten DO
     BEGIN
          ChangesInSort:=FALSE;

          FOR SortPosCounter:=1 TO (AantalBerichten-SortCounter) DO
              IF ZoekLijst^[SortPosCounter] > ZoekLijst^[SortPosCounter+1] THEN
              BEGIN
                   ChangesInSort:=TRUE;
                   SwapWords (ZoekLijst^[SortPosCounter],ZoekLijst^[SortPosCounter+1]);
              END;

          IF (NOT ChangesInSort) THEN
             Break; { uit de for }
     END; { for }

     { RWI 960212: kijk of er een lastread file is en lees die in }
     Assign (RenameFile{misbruik},ZoekPath+'LASTREAD');
     {$I-} Reset (RenameFile,1); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
     BEGIN
          { gevonden }
          BlockRead (RenameFile,LastRead,2);
          Close (RenameFile);
     END;

     { het eigenlijk hernummeren van de berichten }
     WriteXY (SXb2,SYb+6,'Updating');

     { update de statistieken }
     Status.DezeArea:=AantalBerichten;

     FOR SortCounter:=1 TO AantalBerichten DO
         IF (SortCounter <> ZoekLijst^[SortCounter]) THEN
         BEGIN
              Assign (RenameFile,ZoekPath+Word2String (ZoekLijst^[SortCounter])+'.MSG');
              {$I-} Rename (RenameFile,ZoekPath+Word2String (SortCounter)+'.MSG'); {$I+} IORes:=IOResult;
              IF (IORes <> 0) THEN
              BEGIN
                   LogDiskIOError (IORes,'[RenumberMSGArea] Error renaming '+Word2String (ZoekLijst^[SortCounter]));
                   GOTO CleanUp;
              END;
         END; { if, for }

     { RWI 960331: als er geen berichten in deze area staan, zet LASTREAD }
     {             dan op 1.                                              }
     IF (AantalBerichten = 0) THEN
     BEGIN
          AantalBerichten:=1;
          ZoekLijst^[1]:=LastRead;
     END;

     { zoek de lastread entry op en pak het nieuwe nummer op }
     FOR SortCounter:=1 TO AantalBerichten DO
         IF (ZoekLijst^[SortCounter] = LastRead) AND (LastRead <> SortCounter) THEN
         BEGIN
              { er is een nieuwe lastread }
              LastRead:=SortCounter;

              Assign (RenameFile,ZoekPath+'LASTREAD');
              {$I-} ReWrite (RenameFile,1); {$I+} IORes:=IOResult;
              IF (IORes = 0) THEN
              BEGIN
                   BlockWrite (RenameFile,LastRead,2);
                   Close (RenameFile);
                   Slice_Now;
              END;

              Break; { uit de for }
         END;

     Assign (RenameFile,ZoekPath+'MSGINDEX.WG');
     {$I-} Erase (RenameFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) AND (IORes <> 2) THEN

     LogDiskIOError (IORes,'Error deleting *.MSG index '+ZoekPath+'MSGINDEX.WG');

CleanUp:
     { geef geheugen weer terug }
     FreeMem (ZoekLijst,MaxFiles*SizeOf (WORD));
END;


{--------------------------------------------------------------------------}
{ UtilRenumberAllJAMArea                                        RWI 941115 }
{                                                                          }
{ Deze hernummert de berichten van alle JAM gebieden.                      }
{                                                                          }
PROCEDURE UtilRenumberAllJAMAreas (Groups : GroupFlagType);

VAR AreaLp  : AreaBaseRecordNrType;
    AreaRec : AreaBaseRecord;
    Aborted : BOOLEAN;

BEGIN
     { zet het windowtje op het scherm }
     StatusWindow;
     WriteXY (SXb+2,SYb,' Renumber ');

     WriteXYC (SXb2,SYb+2,cBoxData,'JAM');
     WriteXY (SXb2,SYb+6,'Renumbering');


     { schrijf een berichtje voor de log }
     LogMessage ('Started renumbering all JAM areas');
     LogGroups (Groups);

     Aborted:=FALSE;

     { netmail }
     IF (Config.FidoNetmailType = JamType) AND TestGroupListSame (Groups,AllGroups) THEN
     BEGIN
          Inc (Status.Areas);
          Status.DezeArea:=0;
          Status.AreaName:='NETMAIL';
          StatusWindowUpdate;

          AreaRec.FidoMsgPath:=Config.FidoNetmailPath;
          AreaRec.AreaName_F:='NETMAIL';

          JamMsgBase.RenumberArea (AreaRec);

          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
               WriteXY (SXb2,SYb+6,'Aborted  ');
          END;
     END;

     { JAM }
     IF (NOT Aborted) AND (Config.PrivmailType = JamType) AND TestGroupListSame (Groups,AllGroups) THEN
     BEGIN
          Inc (Status.Areas);
          Status.DezeArea:=0;
          Status.AreaName:='NETMAIL';
          StatusWindowUpdate;

          AreaRec.FidoMsgPath:=Config.PrivmailPath;
          AreaRec.AreaName_F:='PRIVATE SCAN';

          JamMsgBase.RenumberArea (AreaRec);

          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;
     END;

     Status.AreasToDo:=AreaBaseRecCount;

     FOR AreaLp:=1 TO AreaBaseRecCount DO
     BEGIN
          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               Aborted:=TRUE;
               WriteXY (SXb2,SYb+6,'Aborted  ');
               Break; { uit de for/next }
          END;

          Slice_Now;
          ReadAreaBaseRecord (AreaLp,AreaRec);

          IF (NOT AreaRec.Deleted) AND
             (AreaRec.FidoMsgStyle = JamType) AND
             TestIfGroupCommon (AreaRec.IsInGroups,Groups) THEN
          BEGIN
               Inc (Status.Areas);
               Status.DezeArea:=0;
               Status.AreaName:=AreaRec.AreaName_F;
               StatusWindowUpdate;

               JamMsgBase.RenumberArea (AreaRec);

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END;

     END; { for }

     IF Aborted THEN LogMessage ('Renumber JAM areas aborted')
                ELSE LogMessage ('Renumber JAM areas completed');

     WITH Status DO
          LogExtraMessage ('Renumbered '+Word2String (Areas)+' JAM areas, containing '+Word2String (TotalMsg)+' messages.');

     LogClose;
     WindowPop; { status window }
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilReIdxAllAreas                                                        }
{                                                                          }
{ Creert nieuwe indexen voor alle gebieden. (Squish + Jam )                }
{                                                                          }
PROCEDURE UtilReIDXAllAreas (Groups : GroupFlagType);

VAR AreaInfo     : AreaBaseRecord;
    IndexedAreas,
    AantalAreas,
    CountAreas   : AreaBaseRecordNrType;

BEGIN
     { zet het link windowtje op het scherm }
     StatusWindow;
     WriteXY (SXb+2,SYb,' Index ');

     { schrijf een berichtje voor de log }
     LogMessage ('Started indexing all areas');
     LogGroups (Groups);

     WriteXY (SXb2,SYb+6,'Rebuilding Index ');

     { Haal het totaal aantal gebieden }
     AantalAreas:=AreaBaseRecCount;
     Status.AreasToDo:=AantalAreas;
     IndexedAreas:=0;

     FOR CountAreas:=1 TO AantalAreas DO
     BEGIN
          Slice_Now;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               WriteXY (SXb2,SYb+6,'Aborted  ');
               Break; { uit de for/next }
          END;

          { wandel door de AreaBase }
          ReadAreaBaseRecord (CountAreas,AreaInfo);

          Inc (Status.Areas);
          StatusWindowUpdate;

          IF (AreaInfo.FidoMsgStyle <> NoneType) AND
             (NOT AreaInfo.Deleted) AND
             (AreaInfo.AreaName_F <> '') AND
             TestIfGroupCommon (AreaInfo.IsInGroups,Groups) THEN
          BEGIN
               Inc (IndexedAreas);

               Status.DezeArea:=0;
               Status.AreaName:=AreaInfo.AreaName_F;
               StatusWindowUpdate;

               CASE AreaInfo.FidoMsgStyle OF
                    JamType :
                        BEGIN
                             WriteXY (SXb2,SYb+2,'JAM        ');
                             JamMsgBase.ReIndexArea (AreaInfo);
                        END;

                    SquishType :
                        { not needed..
                        BEGIN
                             WriteXY (SXb2,SYb+2,'Squish     ');
                             SquishMsgBase.SquishReIndex (AreaInfo);
                        END;
                        };

                    WildCatType :
                        { not supported };

                    PCBoardType :
                        LogMessage ('Cannot yet re-index for PC-board');
               END;

               Inc (Status.TotalMsg,Status.DezeArea);
               StatusWindowUpdate;
          END; { if }

     END; { for }

     LogMessage ('Indexing finished');

     LogExtraMessage ('Indexed '+Word2String (Status.TotalMsg)+
                      ' messages in '+Word2String (IndexedAreas)+
                      ' areas.');

     LogClose;
     WindowPop;
     PopKeysLine;
END;


{--------------------------------------------------------------------------}
{ UtilPercSaved                                                            }
{                                                                          }
{ Deze routine rekent uit hoeveel procent er bespaard is en geeft dit      }
{ terug in een byte.                                                       }
{                                                                          }
FUNCTION UtilPercSaved (OldSize,NewSize : LONGINT) : BYTE;
BEGIN
     IF (OldSize <> 0) THEN
        UtilPercSaved:=Round ((OldSize-NewSize)/(OldSize/100))
     ELSE
         UtilPercSaved:=0;
END;


VAR ActionAreas : WORD;

{--------------------------------------------------------------------------}
{ SingleMaintenance                                                        }
{                                                                          }
PROCEDURE SingleMaintenance (AreaRecNr : AreaBaseRecordNrType; MOpt : KeyType);
BEGIN
     IF (AreaRecNr < 64000) THEN
        ReadAreaBaseRecord (AreaRecNr,AreaData)
     ELSE BEGIN
          IF (AreaRecNr = 64000) THEN
          BEGIN
               AreaData.AreaName_F:='SYSTEM Primary Netmail Area';
               AreaData.FidoMsgStyle:=Config.FidoNetmailType;
               AreaData.FidoMsgPath:=Config.FidoNetmailPath;
          END;

          IF (AreaRecNr = 64001) THEN
          BEGIN
               AreaData.AreaName_F:='SYSTEM Dupe Area';
               AreaData.FidoMsgStyle:=Config.FidoDupeAreaType;
               AreaData.FidoMsgPath:=Config.FidoDupePath;
          END;

          IF (AreaRecNr = 64002) THEN
          BEGIN
               AreaData.AreaName_F:='SYSTEM Bad Area';
               AreaData.FidoMsgStyle:=Config.FidoBadAreaType;
               AreaData.FidoMsgPath:=Config.FidoBadPath;
          END;
     END;

     Inc (Status.Areas);
     Status.AreaName:=AreaData.AreaName_F;
     Status.DezeArea:=0;

     CASE AreaData.FidoMsgStyle OF
          FidoMsgType : WriteXY (SXb2,SYb+2,'*.MSG ');
          JamType     : WriteXY (SXb2,SYb+2,'JAM   ');
          SquishType  : WriteXY (SXb2,SYb+2,'Squish');
     END; { case }

     StatusWindowUpdate;

     CASE AreaData.FidoMsgStyle OF
          NoneType :
              { doe niets, eventueel loggen };

          FidoMsgType :
              CASE MOpt OF
                   mOpt01: { link }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Linking    ');
                            LogMessage ('Linking '+AreaData.AreaName_F);
                            UtilLinkMsgArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt02: { purge }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Purging    ');
                            LogMessage ('Purging '+AreaData.AreaName_F);
                            UtilPackMsgArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt03: { renum }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Renumbering');
                            LogMessage ('Renumbering '+AreaData.AreaName_F);
                            UtilRenumberMsgArea (AreaData.FidoMsgPath);
                            Inc (ActionAreas);
                       END;

                   mOpt04: { reindex }
                       { not required }
              END; { case }

          JamType :
              CASE MOpt OF
                   mOpt01: { link }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Linking    ');
                            LogMessage ('Linking '+AreaData.AreaName_F);
                            JamMsgBase.LinkArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt02: { purge }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Purging    ');
                            LogMessage ('Purging '+AreaData.AreaName_F);
                            JamMsgBase.PackArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt03: { renum }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Renumbering');
                            LogMessage ('Renumbering '+AreaData.AreaName_F);
                            JamMsgBase.RenumberArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt04: { reindex }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Reindexing ');
                            LogMessage ('Reindexing '+AreaData.AreaName_F);
                            JamMsgBase.ReIndexArea (AreaData);
                            Inc (ActionAreas);
                       END;
              END; { case }

          SquishType :
              CASE MOpt OF
                   mOpt01: { link }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Linking    ');
                            LogMessage ('Linking '+AreaData.AreaName_F);
                            UtilLinkSquishArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt02: { purge }
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Purging    ');
                            LogMessage ('Purging '+AreaData.AreaName_F);
                            SquishMsgBase.SquishPurgeArea (AreaData);
                            Inc (ActionAreas);
                       END;

                   mOpt03: { renum }
                       { not implemented };

                   mOpt04: { reindex }
                       { not needed };
                       {
                       BEGIN
                            WriteXY (SXb2,SYb+6,'Reindexing ');
                            LogMessage ('Reindexing '+AreaData.AreaName_F);
                            SquishMsgBase.SquishReIndex (AreaData);
                            Inc (ActionAreas);
                       END;
                       }
              END; { case }

          WildCatType :
              {nog niet geimplementeerd};

          PCBoardType :
              {nog niet geimplementeerd};

     END; { msg base style }

     IF (Status.DezeArea > 0) THEN
     BEGIN
          Inc (Status.TotalMsg,Status.DezeArea);
          StatusWindowUpdate;
     END;
END;


{--------------------------------------------------------------------------}
{ AreaMaintenanceGroups                                                    }
{                                                                          }
{ Laat de areas zien die in de geselecteerde groepen zitten. Op de daarna  }
{ gekozen groepen kan onderhoud uitgevoerd worden.                         }
{                                                                          }
PROCEDURE AreaMaintenanceGroups (GroupsFilter : GroupFlagType);

    FUNCTION BaseStr (BaseStyle : FidoMsgStyleType) : STRING;
    BEGIN
         CASE BaseStyle OF
              FidoMsgType : BaseStr:=' (*.MSG)';
              JamType     : BaseStr:=' (JAM)';
              SquishType  : BaseStr:=' (Squish)';
              WildCatType : BaseStr:=' (WildCat)';
              PCBoardType : BaseStr:=' (PC-Board)';
         END;
    END;

VAR Quit      : BOOLEAN;
    Keuze     : WORD;
    Lp        : AreaBaseRecordNrType;
    PercDone  : BYTE;
    MOpt      : KeyType;

BEGIN
     Message ('Reading area names  (0%)  ');

     ListTagKeysLine:=' ^F1 Help ^Esc Abort ^Enter Maintenance ^F5~,^F6~,^F7 (Un)Tag';
     ListDefine (2,3,Video.Cols-3,Video.Rows-4,Default,
                 'Areas with message bases for group(s) '+BuildGroupListDesc (GroupsFilter,35),
                 4303);

     ListLowMemLimit:=10000; { dan blijft er nog genoeg voor een group list over }
     FOR Lp:=1 TO AreaBaseRecCount DO
     BEGIN
          ReadAreaBaseRecord (Lp,AreaData);

          PercDone:=Round ((Lp/AreaBaseRecCount)*100);
          WriteXYC (42,MessageYB,cMessage,
                                   RepChar (PercDone DIV 10,'')+
                                   RepChar (10-(PercDone DIV 10),'')+
                                   ' ('+Byte2String (PercDone)+'%)');

          IF (NOT AreaData.Deleted) AND
             (AreaData.FidoMsgStyle <> NoneType) AND
             (TestIfGroupCommon (AreaData.IsInGroups,GroupsFilter)) THEN
          BEGIN
               ListAddItem (AreaData.AreaName_F+BaseStr (AreaData.FidoMsgStyle),Lp,Bottom{Sorted});
          END;

          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               ListLowMemLimit:=4096; { restore to default }
               ListErase;
               WindowPop; { message }
               Exit;
          END;
     END; { for }

     ListLowMemLimit:=4096; { restore to default }

     WindowPop; { message }

     ListSortNow;

     { voeg de system areas toe }
     IF (Config.FidoBadAreaType <> NoneType) THEN
        ListAddItem ('SYSTEM Bad Area'+BaseStr (Config.FidoBadAreaType),64002,Top);

     IF (Config.FidoDupeAreaType <> NoneType) THEN
        ListAddItem ('SYSTEM Dupe Area'+BaseStr (Config.FidoDupeAreaType),64001,Top);

     ListAddItem ('SYSTEM Primary Netmail Area'+BaseStr (Config.FidoNetmailType),64000,Top);

     Quit:=FALSE;
     REPEAT
           { als de dummy niet meer nodig is, dan weghalen }
           IF (ListItemCount = 0) THEN { dummy + items }
              ListAddItem ('<no areas configured>',65534,Bottom);

           Keuze:=ListSelect (DoTag,[]);

           ListRemoveItem (65534);

           CASE Key OF

                kRet :
                    BEGIN
                         { menu laten zien }
                         MenuDefine (40,10,'Maintenance options');
                         MenuSetHelp (4304);
                         MenuAddItem ('Link');
                         MenuAddItem ('Purge');
                         MenuAddItem ('Renumber');
                         MenuAddItem ('Reindex');
                         MenuShow;
                         MOpt:=MenuSelect;
                         MenuErase;

                         { executie }
                         IF (MOpt <> kEsc) THEN
                         BEGIN
                              ListHideWindow;

                              StatusWindow;
                              ActionAreas:=0;

                              CASE MOpt OF
                                   mOpt01 :
                                       BEGIN
                                            WriteXY (SXb+2,SYb,' Link ');
                                            LogExtraMessage ('Starting selective Link');
                                       END;

                                   mOpt02 :
                                       BEGIN
                                            WriteXY (SXb+2,SYb,' Purge ');
                                            LogExtraMessage ('Starting selective Purge');
                                       END;

                                   mOpt03 :
                                       BEGIN
                                            WriteXY (SXb+2,SYb,' Renumber ');
                                            LogExtraMessage ('Starting selective Renumber');
                                       END;

                                   mOpt04 :
                                       BEGIN
                                            WriteXY (SXb+2,SYb,' Reindex ');
                                            LogExtraMessage ('Starting selective Reindex');
                                       END;
                              END; { case }

                              IF (ListTagCount = 0) THEN
                                 SingleMaintenance (Keuze,MOpt)
                              ELSE
                                  FOR Lp:=1 TO ListTagCount DO
                                      SingleMaintenance (ListGetTaggedItemNr (Lp),MOpt);

                              WindowPop; { status window }
                              PopKeysLine;

                              { results logging }
                              CASE MOpt OF
                                   mOpt01 : { link }
                                       LogExtraMessage ('Linked '+Word2String (Status.TotalMsg)+
                                                        ' messages in '+Word2String (ActionAreas)+
                                                        ' areas.');

                                   mOpt02 : { purge }
                                       LogExtraMessage ('Purged '+Longint2String (Status.SavedBytes)+
                                                        ' bytes in '+Word2String (ActionAreas)+
                                                        ' areas.');

                                   mOpt03 : { renumber }
                                       LogExtraMessage ('Renumbered '+Word2String (Status.TotalMsg)+
                                                        ' messages in '+Word2String (ActionAreas)+
                                                        ' areas.');

                                   mOpt04 : { reindexed }
                                       LogExtraMessage ('Reindexed '+Word2String (Status.TotalMsg)+
                                                        ' messages in '+Word2String (ActionAreas)+
                                                        ' areas.');
                              END; { case }

                              LogClose;

                         END; { if not aborted }

                    END; { kRet }

                kEsc :
                    Quit:=TRUE;

           END; { case }

     UNTIL Quit;

     ListErase;
     ListTagKeysLine:=ORG_ListTagKeysLine;
END;


{--------------------------------------------------------------------------}
{ SelectiveAreaMaintenance                                                 }
{                                                                          }
{ Deze routine laat de groepen en dan areas selecteren, waarna onderhoud   }
{ op die area uitgevoerd kan worden: link, purge, renum, re-index.         }
{                                                                          }
PROCEDURE SelectiveAreaMaintenance;

VAR Groups    : GroupFlagType;
    Lp        : AreaBaseRecordNrType;
    Keuze     : WORD;
    GroupData : GroupDescRecord;
    Quit      : BOOLEAN;

BEGIN
     ListDefine (3,3,Video.Cols-10,Video.Rows-4,Default,'Select group(s)',1100);

     FOR Lp:=1 TO MaxGroups DO
     BEGIN
          ReadGroupDescRecord (Lp,GroupData);
          ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
     END; { for }

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (DoTag,[]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : BEGIN
                            ListHideWindow;

                            ResetGroupFlags (Groups);  { no groups selected yet }

                            IF (ListTagCount = 0) THEN
                               AddGroupToGroupList (Groups,Keuze)
                            ELSE BEGIN
                                 Status.AreasTodo:=ListTagCount;

                                 FOR Lp:=1 TO ListTagCount DO
                                     AddGroupToGroupList (Groups,ListGetTaggedItemNr (Lp));
                            END;

                            AreaMaintenanceGroups (Groups);
                       END;
           END; { case }
     UNTIL Quit;

     ListErase;
END;


END.
