UNIT NewExec;

{ routines om een programma op te starten waarbij het hele geheugen dat door
  het huidige programma in gebruik is, eerst naar disk wordt geschreven of
  naar EMS wordt geswapped.                                                 }

{ History:

 RvdW 21-05-93 Deze PD unit opgepoetst en wat onnodige routines eruit
               gehaald.
 RvdW 04-02-95 Aangepast voor DPMI support. Later toch verplaatst naar
               EXEC\EXEC.PAS ivm path doorzoeken.
 RvdW 26-11-96 Aanpassingen voor OS/2

}

INTERFACE

VAR ExecRes : INTEGER;

PROCEDURE GoExec (XFn,Pars,Msg : STRING);


IMPLEMENTATION

{$IFNDEF DPMI}
{$IFNDEF OS2}
{$DEFINE DoExec}
{$ENDIF}
{$ENDIF}

USES Ramon,
{$IFDEF DoExec}
     Exec,
{$ELSE}
     Dos,
{$ENDIF}
     Crt,
     Logs;

PROCEDURE GoExec (XFn,Pars,Msg : STRING);

VAR OldColor : ColorSet;
    P        : BYTE;
    Tmp      : STRING;

BEGIN
     P:=Pos (' ',XFn);
     IF (P > 0) THEN
     BEGIN
          IF (Pars <> '') THEN
             Pars:=' '+Pars;

          Pars:=Copy (XFn,P+1,255)+Pars;
          XFn:=Copy (XFn,1,P-1);
     END;

     WindowPush (1,1,Video.Cols,Video.Rows);
     OldColor:=GetColor;
     SetColor (cExitPrg);
     FillVideo (0,1,Video.Cols,Video.Rows-1,' ');

     Crt.GotoXY (1,3);

     WriteLn (Msg);
     WriteLn;

{$IFNDEF DoExec}
     Tmp:=FSearch (XFn,GetEnv ('PATH'));

     IF (Tmp = '') AND (Pos ('.',XFn) = 0) THEN
     BEGIN
          Tmp:=FSearch (XFn+'.exe',GetEnv ('PATH'));
          IF (Tmp = '') THEN
             Tmp:=FSearch (XFn+'.com',GetEnv ('PATH'));
     END;

     IF (Tmp <> '') THEN
        XFn:=Tmp;
{$ENDIF}

     WriteLn ('Executing '+XFn+' '+Pars);
     WriteLn;

{$IFDEF DoExec}
     { not DPMI or OS/2, thus normal or overlay }
     ExecRes:=Do_Exec (XFn,Pars,USE_ALL,$FFFF,FALSE);
{$ELSE}
     Exec (XFn,Pars);
     { RAWI 970531: DosError is result from Exec, DosExitCode from program }
     ExecRes:=DosError*256+DosExitCode;
{$ENDIF}

     SetColor (OldColor);
     WindowPop;

     IF (ExecRes <> 0) THEN
     BEGIN
          CASE ExecRes OF
               3 : Tmp:='path not found';

               {$IFDEF DoExec}
               $0200 : Tmp:='program not found';
               {$ENDIF}

               {$IFDEF OS2}
               193 : Tmp:='not an OS/2 executable';
               {$ENDIF}

               ELSE  Tmp:='error $'+Word2HexString (ExecRes);
          END;

          LogMessage ('Executing "'+XFn+' '+Pars+'" failed: '+Tmp);
     END;
END;

END.
