UNIT Pop3;

{ support for inbound POP3 mailbox files }

INTERFACE

PROCEDURE Pop3Toss;


IMPLEMENTATION

USES Ramon,
     Database,
     UserBase,
     AreaBase,
     FBuffer,
     Usenet,
     Globals,
     Logs,
     Start,
     Msgs,
     Cfg;

{--------------------------------------------------------------------------}
{ TossPop3Mailbox                                                          }
{                                                                          }
{ Deze routine kijkt of een mailbox file bestaat. Zoja, dan wordt ie       }
{ verwerkt en verwijderd (hernoemd?).                                      }
{                                                                          }
PROCEDURE TossPop3Mailbox (MailboxFile, Recipient, Separator, EnvelopeHdr : STRING);

    PROCEDURE Pop3Process;
    BEGIN
         Msg.Ready_U:=Mail;

         IF (Msg.XqtTo_U = '') THEN
         BEGIN
              IF (EnvelopeHdr <> '') THEN
                 LogMessage ('POP3 envelope header not found!')
              ELSE
                  Msg.XqtTo_U:=Recipient;

              IF (Msg.XqtTo_U = '') THEN
              BEGIN
                   Msg.XqtTo_U:='postmaster@'+Config.Domains[1];
                   LogMessage ('Sending to '+Msg.XqtTo_U);
              END;
         END;

         GoProcess;

         MsgsEmpty;
         Msg.XqtTo_U:=''; { wordt niet automatisch leeg gemaakt }
    END;

VAR Mailbox   : FBufferType;
    IsHeader  : BOOLEAN;
    PrevHad13 : BOOLEAN;
    PrevEmpty : BOOLEAN;
    Regel     : STRING;
    IORes     : BYTE;
    IgnoreCR  : BOOLEAN;

BEGIN
     IF (MailboxFile = '') OR (NOT CheckMinDiskFree) THEN
        Exit;

     IF (NOT FBufferOpen (MailBox,MailboxFile,5000,5000)) THEN
     BEGIN
          FBufferClose (MailBox);
          Exit;
     END;

     LogMessage ('Processing '+MailboxFile);

     UpdateAction ('Processing POP3 mailbox');
     UpdateReadFile (MailboxFile,FileSize (MailBox.Bestand));

     UpdateInfoNr (INFO_Pop3In_Jobs,1);

     EnvelopeHdr:=UpCaseString (EnvelopeHdr);

     IgnoreCR:=(Separator[1] = '*');
     IF IgnoreCR THEN
        Delete (Separator,1,1);

     MsgsEmpty;
     Msg.XqtTo_U:='';

     PrevHad13:=FALSE;
     PrevEmpty:=FALSE;
     IsHeader:=TRUE;

     WHILE FBReadLnLF (MailBox,Regel) DO
     BEGIN
          IF IsHeader THEN
          BEGIN
               { header }
               IF (PrevHad13) AND (Regel = #13) THEN
                  IsHeader:=FALSE
               ELSE BEGIN
                    IF (EnvelopeHdr <> '') AND
                       (UpCaseString (Copy (Regel,1,Length (EnvelopeHdr))) = EnvelopeHdr) THEN
                    BEGIN
                         LogMessage ('Found POP3 envelope header: '+Regel);

                         Delete (Regel,1,Length (EnvelopeHdr));
                         IF (Regel[Length (Regel)] = #13) THEN
                            Delete (Regel,Length (Regel),1);
                         Regel:=DeleteFrontAndBackSpaces (Regel);

                         Msg.XqtTo_U:=Regel;
                    END ELSE
                    BEGIN
                         MsgsAddLineToNoEOL (Header_U,Regel);
                         PrevHad13:=Regel[Length (Regel)] = #13;
                    END;
               END;
          END ELSE
          BEGIN
               { body }
               IF (IgnoreCR OR PrevEmpty) AND
                  (Copy (Regel,1,Length (Separator)) = Separator) THEN
               BEGIN
                    Pop3Process;
                    IsHeader:=TRUE;
                    MsgsAddLineToNoEOL (Header_U,Regel);
               END ELSE
               BEGIN
                    MsgsAddLineToNoEOL (Body,Regel);
                    PrevEmpty:=(Regel = #13);
               END;
          END;
     END; { while }

     { verwerk het laatste bericht ook! }
     Pop3Process;

     UpdateInfoNr (INFO_Pop3In_Bytes,FileSize (MailBox.Bestand));

     FBufferClose (MailBox);

     {$I-} Erase (MailBox.Bestand); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Error deleting '+Mailbox.Filename);
END;


{--------------------------------------------------------------------------}
{ Pop3Toss                                                                 }
{                                                                          }
{ Deze routine wordt aangeroepen om alle ontvangen POP3 mailbox files te   }
{ vinden en te verwerken.                                                  }
{                                                                          }
PROCEDURE Pop3Toss;

VAR Lp : UserBaseRecordNrType;

BEGIN
     LogMessage ('POP3 toss started on '+DateStamp);

     FOR Lp:=1 TO UserBaseRecCount DO
         IF (NOT GlobalAbort) THEN
         BEGIN
              ReadUserBaseRecord (Lp,PacketUserData);

              WITH PacketUserData DO
              BEGIN
                   IF (NOT Deleted) AND (System = _P) THEN
                   BEGIN
                        UserDataRecNr:=Lp; { voor MsgsExport }
                        AreaCreatorUserBaseRecNr:=Lp;
                        UUCPName:=UpCaseString (UUCPName);

                        Separator:=DeleteFrontAndBackSpaces (Separator);
                        IF (Separator = '') THEN
                           Separator:='From';

                        IF (UpCaseString (Separator) = 'FROM') OR
                           (UpCaseString (Separator) = '*FROM')
                        THEN
                            Separator:=Separator+' ';

                        TossPop3Mailbox (Pop3File,Recipient,Separator,EnvelopeHdr);
                   END; { if }
              END; { with }

         END; { if, for }

     LogMessage ('POP3 toss finished');
END;

END.
