UNIT SMTP;

{ History:

 RWI 960714: Started this unit.

}

INTERFACE

PROCEDURE SmtpToss;


IMPLEMENTATION

USES Dos,
     Ramon,
     Globals,
     Database,
     Logs,
     UserBase,
     AreaBase,
     Start,
     FBuffer,
     Msgs,
     Usenet,
     Fido;


{--------------------------------------------------------------------------}
{ ProcessWrkFile                                                           }
{                                                                          }
{ Deze routine verwerkt e'e'n .WRK file. De bijbehorende .TXT file wordt   }
{ opgezocht en beide worden verwerkt.                                      }
{                                                                          }
FUNCTION ProcessWrkFile (Path,Name : STRING) : BOOLEAN;

VAR TxtName   : STRING[13];
    WrkFile   : FBufferType;
    TxtSize   : LONGINT;

    {----------------------------------------------------------------------}
    { ProcessTxtFile                                                       }
    {                                                                      }
    PROCEDURE ProcessTxtFile;

    VAR TxtFile   : FBufferType;
        Regel,
        FromRegel : STRING;
        PrevHad13 : BOOLEAN;

    BEGIN
         TxtSize:=0; { in case of errors }

         IF (NOT FBufferOpen (TxtFile,Path+TxtName,5000,5000)) THEN
         BEGIN
              LogMessage ('  Failed to open '+TxtName);
              FBufferClose (TxtFile);
              Exit;
         END;

         LogMessage ('  Processing (mail) '+TxtName);

         { klaarmaken om de body in te lezen }
         AddWhereTo:=Header_U;
         PrevHad13:=FALSE;

         { Toevoegingen :                                          }
         {  - Pluk de From regel van de netmail af                 }
         {    en voeg ons systeem via een bangpath toe (Waffle)    }
         {  - Voeg reclame , en via informatie aan het bericht toe }

         FBReadLnLF (TxtFile,FromRegel);

         {#1# hier kan de controle komen voor afzender systeem aanwezigheid }
         { hier kan ook de bounce prevention komen (dit is mail he?) }
         { RWI 9601213: Check op domain adres toegevoegd }
         IF (Pos ('@',FromRegel) = 0) AND (Copy (FromRegel,1,5) = 'From ') THEN
         BEGIN
              Insert (UseGetSystemFromName+'!',FromRegel,6);
              AddTossedRegel (FromRegel,PrevHad13);
              FromRegel:='';
         END;

         { Received: by dijkline.wlink.nl (0.01 beta/WaterGate) }
         {           via UUCP; Sat, 10 Jul 93 00:06:50 +0100    }
         {           for martijnd@htsa.aha.nl                   }

         Regel:='Received: by '+UseGetSystemFromName+' ('+Copy (FidoTear,5,255)+')'+#13;
         AddTossedRegel (Regel,PrevHad13);
         Regel:='          via SMTP; '+UsenetArpaNetDate+#13;
         AddTossedRegel (Regel,PrevHad13);
         Regel:='          for '+Msg.XqtTo_U+#13;
         AddTossedRegel (Regel,PrevHad13);

         IF (FromRegel <> '') THEN
            AddTossedRegel (FromRegel,PrevHad13);

         { lees de .txt file in }
         WHILE FBReadLnLF (TxtFile,Regel) AND (Regel <> #0) DO
               AddTossedRegel (Regel,PrevHad13);

         Msg.Ready_U:=Mail; { RWI 960224: is nog niet ingevuld.. }
         GoProcess;

         TxtSize:=FileSize (TxtFile.Bestand);

         FBufferClose (TxtFile);  { geeft cache vrij }
    END;

{ProcessWrkFile}

VAR Regel  : STRING;
    Eraser : FILE;
    IORes  : BYTE;
    Did1   : BOOLEAN;

BEGIN
     LogMessage ('  Processing (smtp) '+Name);

     { kijk of de .lck file er staat, zoja kappen }
     IF TestIfExist (Path+Copy (Name,1,Pos ('.WRK',UpCaseString (Name)))+'LCK') THEN
     BEGIN
          LogExtraMessage ('  Locked; skipping');
          Exit;
     END;

     { zelf een .lck file zetten? }

     { open de .wrk file }
     IF (NOT FBufferOpen (WrkFile,Path+Name,256,256)) THEN
     BEGIN
          LogMessage ('  Failed to open '+Name);
          FBufferClose (WrkFile);
          { .lck file verwijderen! }
          Exit;
     END;

     { open de .txt file. Bestaat ie niet -> afkappen }
     TxtName:=Copy (Name,1,Pos ('.WRK',UpCaseString (Name)))+'TXT';
     IF (NOT TestIfExist (Path+TxtName)) THEN
     BEGIN
          LogExtraMessage ('  Cannot find '+TxtName);
          FBufferClose (WrkFile);
          { .lck file verwijderen! }
          Exit;
     END;

     { was not reset before - caused error in statistics }
     TxtSize:=0;
     Did1:=FALSE;

     { lees de .wrk file in }
     WHILE FBReadLnLF (WrkFile,Regel) AND (Regel <> #0) DO
     BEGIN
          IF (UpCaseString (Copy (Regel,1,3)) = 'TO:') THEN
          BEGIN
               Delete (Regel,1,3);
               IF (Regel[Length (Regel)] = #13) THEN
                  Delete (Regel,Length (Regel),1);

               Regel:=DeleteFrontAndBackSpaces (Regel); { RAWI 970816 }

               { verwerk de hele .TXT file voor deze recipient }
               MsgsEmpty;
               Msg.XqtTo_U:=Regel;
               ProcessTxtFile;

               Did1:=TRUE;
          END;
     END;

     FBufferClose (WrkFile);

     IF (NOT Did1) THEN
        LogMessage ('No addresses found in .WRK file!');

     UpdateInfoNr (INFO_SmtpIn_Bytes,TxtSize);

     MsgsEmpty; { geheugen weer vrijgeven }

     { beide verwijderen }
     Assign (Eraser,Path+Name);
     {$I-} Erase (Eraser); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Error deleting '+Path+Name);

     Assign (Eraser,Path+TxtName);
     {$I-} Erase (Eraser); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Error deleting '+Path+TxtName);

     { verwijder .lck file? }
     { niet gezet, wel?... }
END;


{--------------------------------------------------------------------------}
{ ScanSmtpIn                                                               }
{                                                                          }
{ Deze routine doorzoekt het SMTP-In pad voor PacketUserData. Als het pad  }
{ bestaat worden alle .WRK files gezocht en een voor een aangeboden voor   }
{ verwerking door ProcessWrkFile.                                          }
{                                                                          }
PROCEDURE ScanSmtpIn;

VAR Search : SearchRec;
    IORes  : BYTE;
    Path   : STRING;

BEGIN
     { alle .WRK files aflopen }
     Path:=CorrectPath (PacketUserData.SmtpInPath);

     FindFirst (Path+'*.WRK',Archive,Search);

     IF (DosError <> 0) AND (DosError <> 18{no more files}) THEN
        LogDiskIOError (DosError,'Cannot find SMTP-In path '+Path)
     ELSE BEGIN
          IF (DosError = 0) THEN
             LogMessage ('Checking SMTP-In for '+PacketUserData.UUCPName);

          WHILE (DosError = 0) AND (NOT GlobalAbort) DO
          BEGIN
               IF (NOT CheckMinDiskFree) THEN
                  Break; { need to call FindClose }

               IF KeyPressed THEN
               BEGIN
                    GlobalAbort:=TRUE;
                    ReadKey; { weglezen }
                    Break;
               END;

               UpdateReadFile (Path+Search.Name,Search.Size);
               UpdateInfoNr (INFO_SmtpIn_Jobs,1);

               ProcessWrkFile (Path,Search.Name);

               FindNext (Search);
          END; { while }
     END;

     FindClose (Search);
END;


{--------------------------------------------------------------------------}
{ SmtpToss                                                                 }
{                                                                          }
{ Deze routine scant de userbase voor SMTP users en scant daarna de        }
{ SMTP-In directory van die users.                                         }
{                                                                          }
PROCEDURE SmtpToss;

VAR Lp : UserBaseRecordNrType;

BEGIN
     LogMessage ('SMTP toss started on '+DateStamp);

     FOR Lp:=1 TO UserBaseRecCount DO
         IF (NOT GlobalAbort) THEN
         BEGIN
              ReadUserBaseRecord (Lp,PacketUserData);

              IF (NOT PacketUserData.Deleted) AND (PacketUserData.System = _S) THEN
              BEGIN
                   UserDataRecNr:=Lp; { voor MsgsExport }
                   AreaCreatorUserBaseRecNr:=Lp;
                   PacketUserData.UUCPName:=UpCaseString (PacketUserData.UUCPName);

                   UpdateAction ('Checking SMTP-In for "'+PacketUserData.UUCPName+'"');

                   ScanSmtpIn; { for PacketUserData }

              END; { if }
         END; { if, for }

     LogMessage ('SMTP toss finished');
END;


END.
