{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Squish;

{--------------------------------------------------------------------------}
{ Ondersteuning van de Squish Message Base                                 }
{                                                                          }
{ - Ongelimiteerd groot (longint's)                                        }
{ - Weinig bestanden (2-3 per area)                                        }
{ - Hierdoor ook oneindig aantal areas (zolang je ze maar niet in 1 sub    }
{   propt )                                                                }
{                                                                          }
{ Notitie : Op dit moment ondersteunen we nog geen Shared Message Base     }
{           gedoe. Misschien belangrijk later.                             }
{           - Ondertussen gedeeltelijk (NIET GETEST!) toegevoegt           }
{                                                                          }
{ MD 23-07-93 Structures gebasseerd op code gevonden in de PDN             }
{ MD 25-07-93 Toevoegen van SquishScanArea                                 }
{             routines samengevoegd in een unit.                           }
{ MD 26-07-93 Eindelijk uitgevonden hoe de Squish datum in elkaar zit      }
{    01-08-93 Verschillende bugfixs, de bericht header wordt nu afgesloten }
{             met een 0. Ontbrekende SquishArea's worden nu automatisch    }
{             aangemaakt als dat mogelijk is. Ook worden de Index entry's  }
{             nu correct naar disk geschreven.                             }
{    03-08-93 Vrijwel het hele spulletje global gemaakt, omdat dit         }
{             vrij low-level routines zijn (en ik ze nodig had in een      }
{             andere unit)                                                 }
{             Bugfix in freeframe, de free list werd niet goed door        }
{             gelinkt.                                                     }
{    10-08-93 Bugfix in de index routines, geheugen werd aangevraagt       }
{             voordat de area goed afgesloten was.                         }
{    08-09-93 Squish lees routine maakt nu ook gebruik van                 }
{             FidoAddToMessage                                             }
{             SquishIndexMem werd niet altijd terug gegeven, wat bij lange }
{             toss sessies tot geheugen gebrek leidde.                     }
{    16-09-93 Oude bug gefixed, Squish heeft ook een \NULL aan het einde   }
{             van een bericht nodig.                                       }
{    18-09-93 Bug Fix? Verkeerd aantal bytes dat gemoved werd in           }
{             DeleteFrom index.                                            }
{    01-10-93 Hehe... oude bug gefixed die High_Water mark niet goed       }
{             instelde.                                                    }
{    10-10-93 Bugfix in de deletefromindex routine, hier ging vaak de      }
{             purge routine op zijn bek.                                   }
{    01-11-93 Kleine bugfix, de bad mail area verliest nu niet meer zijn   }
{             laatste letter.                                              }
{    04-12-93 Fixje ivm Date die een positie te ver stond                  }
{             Gaaaaaaaaaar.... ik schijn geen last meer te hebben van de   }
{             index bug. (Lag dus niet aan de index, maar aan de UID)      }
{    05-04-94 SquishSaveMessage verkleint zijn buffer nu in stappen by     }
{             geheugengebrek.                                              }
{ RAWI 970226: Rewrite. Wat was die oude code memory hungry!!              }
{                                                                          }

INTERFACE

USES DataBase,
     Fido,
     MsgUtil,
     FBuffer;

TYPE SearchType    = (FIRST_ENTRY,NEXT_ENTRY);
     UMSGID_TYPE   = LONGINT;
     RECPOS_TYPE   = LONGINT;

     _Address  = RECORD
                       Zone,
                       Net,
                       Node,
                       Point : WORD;
                 END;

     FrameType = (SQ_FIRST,
                  SQ_LAST,
                  SQ_PREV,
                  SQ_NEXT);

CONST NULLFRAME       = 0;
      SQMSG_FROM_SIZE = 36;
      SQMSG_TO_SIZE   = 36;
      SQMSG_SUBJ_SIZE = 72;
      MAX_REPLY       = 10;      { max number of stored replies to one msg }
      SQNEWENTRYS     = 200;     { reserveer ruimte voor nieuwe berichten }
      MAXWORD         = 65528;
      SQUISH_D_EXT    = '.SQD';
      SQUISH_I_EXT    = '.SQI';

      SquishBaseMaximumLockTrys = 100;

(* This is the first RECORD in the *.SQD file *)

TYPE _SQBASETYPE = RECORD
                         Len        : WORD;                 { LENGTH OF THIS STRUCTURE! }
                         Rsvd1      : WORD;                 { Reserved word }
                         Num_msg,                           { number of msgs }
                         High_msg,                          { highest msg -  always equal to num_msg }
                         Skip_msg   : LONGINT;              { # of msgs to keep in beginning of area }
                         High_water : UMSGID_TYPE;          { High water marker (umsgid) }
                         Uid        : UMSGID_TYPE;          { Last usmgid }
                         Base       : ARRAY[1..80] OF CHAR; { Base name for SquishFile }
                         Begin_frame,                       { Offset of first frame in file }
                         Last_frame,                        { Offset to last frame in file }
                         First_free,                        { Offset of first FREE frame in file }
                         Last_free,                         { Ofs of the last free frame }
                         End_frame  : RECPOS_TYPE;          { Pointer to end of file }
                         Max_msg    : LONGINT;              { Maximum number of messages }
                         Keep_days  : WORD;                 { Max age of messages }
                         sz_sqhdr   : WORD;                 { Size of fram header }
                         Rsvd2      : ARRAY[1..124] OF BYTE;{ Reserved area }
                   END;

{ After the BASE record, follows a frame record for EACH message. The   }
{ begin_frame in the base should point to the first frame header, and   }
{ the next_frame in the frame header should point to the next one, etc. }

TYPE _SQFHDRTYPE = RECORD
                         Id           : LONGINT;     { sqhdr.id must always equal SQHDRID }
                         Next_frame,                 { pointer to next msg in base }
                         Prev_frame   : RECPOS_TYPE; { pointer to prior msg in base }
                         Frame_length,               { length of this frame (not counting header) }
                         Msg_length,                 { length of msg in frame. may be less than
                                                       frame_length if this frame has been recycled. }
                         CLen         : LONGINT;     { Length of the control information. }
                         Frame_type   : WORD;        { Either FRAME_MESSAGE or FRAME_FREE. The API
                                                       has been designed to allow things such
                                                       as FRAME_LZSS or FRAME_LZH to be hacked on
                                                       later, without changing the application. }
                         rsvd         : WORD;        { Reserved }
                   END;

{ But right after each frame header, follows the squish message header, }
{ then the control info, then the text.                                 }

TYPE _SQMHDRTYPE = RECORD
                         Attr         : LONGINT;
                         FromWhom     : ARRAY[1..SQMSG_FROM_SIZE] OF CHAR;
                         ToWhom       : ARRAY[1..SQMSG_TO_SIZE] OF CHAR;
                         Subj         : ARRAY[1..SQMSG_SUBJ_SIZE] OF CHAR;
                         Orig,
                         Dest         : _ADDRESS;   { Origination and destination addresses }
                         Date_written,              { When user wrote the msg (UTC) }
                         Date_arrived : LONGINT;    { When msg arrived on-line (UTC) }
                         Utc_ofs      : WORD;       { Minutes offset from UTC of message writer }
                         Replyto      : UMSGID_TYPE;
                         Replies      : ARRAY[1..MAX_REPLY] OF UMSGID_TYPE;
                         Azdate       : ARRAY[1..20] OF CHAR;  { ASCII date }
                   END;

{ Each SQD file has a SQI FILES.  The message number YOU see (the user) }
{ in MAX is really the counter starting from 1 of each record in SQI.   }
{ But the TRUE UNIQUE Message ID is in umsgid. The ofs value will       }
{ point to the frame header in SQD.  These files are small and you      }
{ may read them into a array SqiPtrArrayType using the functions below. }

TYPE _SQIDXTYPE = RECORD
                        Ofs    : RECPOS_TYPE;  { Offset of frame header }
                        Umsgid : UMSGID_TYPE;  { Unique message identifier }
                        Hash   : LONGINT;      { 'To' name hash value }
                  END;

     SqiPtrArraytype = ARRAY[1..1] OF _SQIDXTYPE;
     SqiPtrType      = ^SqiPtrArrayType;

{ RAWI 970529: About the .SQL file: it is an array of UMSGIDs, indexed   }
{              by a field in the user base. It can be found in the index }
{              file, which leads to the message body.                    }
{              It seems that setting high_water to 0 invalidates the     }
{              contents of the .SQL file.                                }
{              No packing required.                                      }

TYPE SquishMBase = OBJECT
                         { Variabelen definties }
                         SquishBase     : _SQBASETYPE;
                         SquishFrameHdr : _SQFHDRTYPE;
                         SquishMsgHdr   : _SQMHDRTYPE;
                         SquishAreaName : STRING[79];
                         SquishIndexPtr : SQIPtrType;  { Lijst met entries }

                         CurrentFrame   : LONGINT;
                         LastAreaName   : AreaNameString;

                         SquishNewIndexNumb,
                         SquishIndexNumb,                { Aantal entry's in de Index }
                         SquishIndexSize   : LONGINT;    { Grootte van de index file  }
                         SquishNewIndexPtr : Sqiptrtype; { Lijst met entry's          }

                         SquishBaseF       : FBufferType;
                         SquishIndexF      : FILE;

                         LastWritePos      : LONGINT;
                         PurgeLR_IndexTel  : WORD;

                         CONSTRUCTOR InitBase;
                         DESTRUCTOR  CloseBase;

                         { Functie definities }

                         FUNCTION  InitSquishArea (AreaData : AreaBaseRecord) : BOOLEAN;
                         PROCEDURE CloseSquishArea;

                         PROCEDURE SquishSaveMessage;
                         PROCEDURE ScanSquishArea (AreaData : AreaBaseRecord; IsPrimaryNetmailArea : BOOLEAN);
                         PROCEDURE SquishPurgeArea (AreaData : AreaBaseRecord);
                         FUNCTION  SquishDeleteMessage : BOOLEAN;

                         { Secundairy routines }
                         FUNCTION  SquishDecodeDate (Invoer : LONGINT) : LONGINT;
                         FUNCTION  SquishDateToUnix (Invoer : LONGINT) : LONGINT;
                         FUNCTION  SquishNameToHash (Name : STRING) : LONGINT;
                         FUNCTION  SquishUpdateHeader : BOOLEAN;
                         FUNCTION  SquishCreateArea (AreaRecord : AreaBaseRecord) : BOOLEAN;
                         FUNCTION  SquishDeleteFromIndex : BOOLEAN;
                         PROCEDURE SquishAddToIndex (HashValue : LONGINT; MsgId : LONGINT);
                         FUNCTION  SquishLoadHeader : BOOLEAN;

                         FUNCTION  SquishLockBase : BOOLEAN;
                         FUNCTION  SquishUnlockBase : BOOLEAN;

                         FUNCTION  SquishTranslateDate (Source : FidoDateType) : LONGINT;
                         PROCEDURE Squish2FidoAdres (Source : _Address; VAR Target : FidoAddrType);
                         PROCEDURE SquishFido2SquishAdres (Source : FidoAddrType; VAR TarGet : _Address);

                         { Index zoek functies }
                         FUNCTION  SquishIDXSearchByTOName (Name : STRING; Search_Entry : SearchType) : BOOLEAN;
                         FUNCTION  SquishIDXSearchByMSGID (MSGID : UMSGID_Type) : BOOLEAN;
                         FUNCTION  SquishIDXSearchByFrameNumber (FramePos : LONGINT; VAR MsgId : UMSGID_Type) : LONGINT;

                         FUNCTION  SquishLoadFrame (VAR Frame : _SqfHdrType; FrameNr : LONGINT) : BOOLEAN;
                         FUNCTION  SquishSaveFrame (VAR Frame : _SqfHdrType; FrameNr : LONGINT) : BOOLEAN;
                         FUNCTION  SquishLoadFrameType (Frame : FrameType) : BOOLEAN;
                         FUNCTION  SquishLoadMsgHdr (BelongingFrame : LONGINT) : BOOLEAN;
                         FUNCTION  SquishSaveMsgHdr (BelongingFrame : LONGINT) : BOOLEAN;
                         FUNCTION  SquishUnlinkFrame : BOOLEAN;
                         FUNCTION  SquishFreeFrame : BOOLEAN;
                         FUNCTION  SquishFindFreeFrame (NeededSize : LONGINT) : BOOLEAN;
                         FUNCTION  SquishNewFrame (NeededSize : LONGINT) : BOOLEAN;
                         FUNCTION  SquishSaveIndex : BOOLEAN;
                         FUNCTION  SquishLoadIndex : BOOLEAN;
                   END;

VAR SquishMsgBase : SquishMBase;


IMPLEMENTATION

USES Globals,
     Ramon,
     Logs,
     Slice,
     Msgs,
     Decode,
     Dos,
     UserBase,
     Start,
     Cfg,
     AreaBase,
     SwapMem,
     Stats,
     UnixTime;

CONST SQHDRID    = $AFAE4453;  { squish headers must have this number }
      LINKNEXT   = 0;
      LINKPREV   = 1;
      FRAME_msg  = 0;          { it's a live message }
      FRAME_free = 1;          { the message is dead, avail for new msg }
      FRAME_rle  = 2;          { type of compression, not implemented }
      FRAME_lzw  = 3;          { type of compression, not implemented }

{--------------------------------------------------------------------------}
{ Squish2FidoAdres                                                         }
{                                                                          }
{ Converteerd een squish type fido adres naar ons intern type.             }
{                                                                          }
PROCEDURE SquishMBase.Squish2FidoAdres (Source : _Address; VAR Target : FidoAddrType);
BEGIN
     WITH Target DO
     BEGIN
          { kan dit niet rapper met een Move() ofzo? }
          Zone:=Source.Zone;
          Net:=Source.Net;
          Node:=Source.Node;
          Point:=Source.Point;
          Domain:='';
     END; { with }
END;


{---------------------------------------------------------------------------}
{ SquishMBase.SquishFido2SquishAdres                                        }
{                                                                           }
{ Deze routine converteer een squish fido adres naar ons type.              }
{                                                                           }
PROCEDURE SquishMBase.SquishFido2SquishAdres (Source : FidoAddrType; VAR TarGet : _Address);
BEGIN
     WITH Target DO
     BEGIN
          { kan dit niet rapper met een Move() ofzo? }
          Zone:=Source.Zone;
          Net:=Source.Net;
          Node:=Source.Node;
          Point:=Source.Point;
     END; { with }
END;


{--------------------------------------------------------------------------}
{ SquishMBase.SquishDecodeDate                                             }
{                                                                          }
{ Decodeer de tijd variabele in de MsgHdr.                                 }
{                                                                          }
FUNCTION SquishMBase.SquishDecodeDate (Invoer : LONGINT) : LONGINT;
BEGIN
     SquishDecodeDate:=(Invoer SHR 16)+((Invoer AND $FFFF) SHL 16);
END;


{--------------------------------------------------------------------------}
{ SquishDateToUnix                                                         }
{                                                                          }
{ Deze routine vertaalt het interne Squish datum formaat naar een tijd in  }
{ seconden, zoals voor Unix.                                               }
{                                                                          }
FUNCTION SquishMBase.SquishDateToUnix (Invoer : LONGINT) : LONGINT;

VAR DosDT    : DateTime;
    UnixSecs : LONGINT;

BEGIN
     UnpackTime (SquishDecodeDate (Invoer),DosDT);
     DosToUnix (DosDT,UnixSecs);

     SquishDateToUnix:=UnixSecs;
END;


{--------------------------------------------------------------------------}
{ SquishTranslateDate                                                      }
{                                                                          }
{ Vertaald de datum van Fido naar Squish formaat.                          }
{ 01 jan 93  19:15:50  -> ?????????                                        }
{                                                                          }
FUNCTION SquishMBase.SquishTranslateDate (Source : FidoDateType) : LONGINT;

VAR DatumTijd  : DateTime;
    PackedTime : LONGINT;
    Months     : INTEGER;
    Nop        : ValNop;

BEGIN
     WITH DatumTijd DO
     BEGIN
          Val (Copy (Source,1,2),Day,Nop);
          Val (Copy (Source,8,2),Year,Nop);
          Val (Copy (Source,12,2),Hour,Nop);
          Val (Copy (Source,15,2),Min,Nop);
          Val (Copy (Source,18,2),Sec,Nop);
     END; { with }

     FOR Months:=1 TO 12 DO
         IF (Month[Months] = Copy (Source,4,3)) THEN
            Break;

     IF (DatumTijd.Year > 79) THEN
        Inc (DatumTijd.Year,1900)
     ELSE
         Inc (DatumTijd.Year,2000);

     DatumTijd.Month:=Months;
     PackTime (DatumTijd,PackedTime);

     SquishTransLateDate:=SquishDecodeDate (PackedTime);
END;


{--------------------------------------------------------------------------}
{ SquishNameToHash                                                         }
{                                                                          }
{ Geeft een HASH value van de gegeven naam terug.                          }
{                                                                          }
FUNCTION SquishMBase.SquishNameToHash (Name : STRING) : LONGINT;

VAR G,Hash : LONGINT;
    P      : BYTE;

BEGIN
     Hash:=0;
     FOR P:=1 TO Length (Name) DO
     BEGIN
          Hash:=(Hash SHL 4)+Ord (LoCase (Name[p]));
          G:=Hash AND $F0000000;
          IF (G <> 0) THEN
          BEGIN
               Hash:=Hash OR (G SHR 24);
               Hash:=Hash OR G;
          END;
     END; { for }

     SquishNameToHash:=Hash AND $7FFFFFFF;
END;


{-------------------------------------------------------------------------}
{ SquishUpdateHeader                                                      }
{                                                                         }
{ Schrijft de Squish header naar disk.                                    }
{                                                                         }
FUNCTION SquishMBase.SquishUpdateHeader : BOOLEAN;

VAR Pos : LONGINT;

BEGIN
     SquishUpdateHeader:=FALSE;

     Pos:=0;
     IF FBSeekWrite (SquishBaseF,Pos,SquishBase,SizeOf (SquishBase)) THEN
        SquishUpdateHeader:=TRUE
     ELSE BEGIN
          LogExtraMessage ('[Squish] Failed to update header');
          SquishUpdateHeader:=FALSE;
     END;
END;


{-------------------------------------------------------------------------}
{ SquishCreateArea                                                        }
{                                                                         }
{ Deze routine wordt pas aangeroepen als er een bericht voor die area is, }
{ zodat we minimaal 1 bericht in de base kunnen stoppen.                  }
{                                                                         }
FUNCTION SquishMBase.SquishCreateArea (AreaRecord : AreaBaseRecord) : BOOLEAN;

VAR IORes   : BYTE;
    NewFile : FILE;
    Size    : WORD;

BEGIN
     SquishCreateArea:=FALSE;

     { Probeer de SQUISAREA.SQD file te creeren }
     Assign (NewFile,AreaRecord.FidoMsgPath+SQUISH_D_EXT);
     {$I-} ReWrite (NewFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[Squish] Error creating '+AreaRecord.FidoMsgPath+SQUISH_D_EXT);
          Exit;
     END;

     Close (NewFile);

     CalcMaxAllowedMem (Size,1024,8192);

     IF (NOT FBufferOpen (SquishBaseF,AreaRecord.FidoMsgPath+SQUISH_D_EXT,Size,0)) THEN
     BEGIN
          LogExtraMessage ('[Squish] Failed to open just created file '+AreaRecord.FidoMsgPath+SQUISH_D_EXT);
          FBufferClose (SquishBaseF);
          Exit;
     END;

     { Vul de SquishMessageAreaHeader }
     WITH SquishBase DO
     BEGIN
          Len:=SizeOf (_SQBASETYPE);
          rsvd1:=0;            { Reserved }
          Num_Msg:=0;          { 1 bericht in de base }
          High_Msg:=0;         { High_Msg == Num_Msg }
          Skip_Msg:=0;         { Laat altijd 1 bericht staan }
          High_Water:=0;       { UMSGID_TYPE }
          uid:=1;              { UMSGID_TYPE }
          Move (AreaRecord.FidoMsgPath[1],Base,Length (AreaRecord.FidoMsgPath));
          Base[Length (AreaRecord.FidoMsgPath)+1]:=#0;
          {StrPCopy( Base , DeleteBackSpaces( AreaRecord.AreaName );}
          Begin_frame:=0;      { eerste frame komt achter }
          Last_frame:=0;       { de Base header  }
          First_free:=0;
          Last_free:=0;
          End_frame:=SizeOf (SquishBase);   { EOF positie, nog niet aanwezig }
          Max_Msg:=AreaRecord.FidoMsgLimit;
          Keep_Days:=AreaRecord.FidoMsgAge;
          sz_sqhdr:=SizeOf (_SQFHDRTYPE);
     END;

     { Reserveer ruimte voor het maximaal aantal berichten }
     { *Index*                                             }
     SquishNewIndexNumb:=0;
     SquishIndexNumb:=0;
     SquishIndexSize:=0;
     SquishNewIndexPtr:=NIL;
     PeekMem;

     { Schrijf de header naar disk }
     SquishUpdateHeader;
     FBufferClose (SquishBaseF);

     { Creer een NULL index file }
     Assign (SquishIndexF,AreaRecord.FidoMsgPath+SQUISH_I_EXT);

     {$I-} ReWrite (SquishIndexF); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
     BEGIN
          {$I-} Close (SquishIndexF); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[Squish] Error creating index '+AreaRecord.FidoMsgPath+SQUISH_I_EXT);
          Exit;
     END;

     PeekFiles;

     SquishCreateArea:=TRUE;
END;


{--------------------------------------------------------------------------}
{ SquishSaveIndex                                                          }
{                                                                          }
{ Herbouwdt de index op schijf, door de oude waardes terug te schrijven en }
{ de nieuwe eraan vast te plakken.                                         }
{                                                                          }
FUNCTION SquishMBase.SquishSaveIndex : BOOLEAN;

VAR IORes : BYTE;

BEGIN
     SquishSaveIndex:=FALSE;

     { RWI 960425: niet onnodig met de file klooien }
     IF (SquishIndexPtr = NIL) AND (SquishNewIndexPtr = NIL) THEN
        Exit;

     Assign (SquishIndexF,SquishAreaName+SQUISH_I_EXT);
     {$I-} ReWrite (SquishIndexF,1); {$I+} IORes:=IOResult;
     PeekFiles;

     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[Squish] Error creating new index '+SquishAreaName+SQUISH_I_EXT);
          Exit;
     END;

     { Creer nieuwe index door oude en nieuwe lijst te mergen op disk }
     IORes:=0;

     IF (SquishIndexPtr <> NIL) THEN
     BEGIN
          {$I-} BlockWrite (SquishIndexF,SquishIndexPtr^[1],SquishIndexNumb*SizeOf (_SQIDXTYPE)); {$I+} IORes:=IOResult;
     END;

     IF (SquishNewIndexPtr <> NIL) AND (IORes = 0) THEN
     BEGIN
          {$I-} BlockWrite (SquishIndexF,SquishNewIndexPtr^[1],SquishNewIndexNumb*SizeOf (_SQIDXTYPE)); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[Squish] Error saving index '+SquishAreaName);

     { Geef het geheugen dat door de lijsten werd gebruikt weer terug }
     { Belangrijk ! Gebruik SquishIndexSize voor geheugenbeheer omdat }
     { SquishIndexNumb kan veranderen !                               }

     FreeMem (SquishIndexPtr,SquishIndexSize);
     FreeMem (SquishNewIndexPtr,SQNewEntrys*SizeOf (_SQIDXTYPE));

     { RWI 951108: op NIL zetten toegevoegd, zodat we hierboven erop kunnen controleren }
     SquishIndexPtr:=NIL;
     SquishNewIndexPtr:=NIL;

     { Sluit de index file }
     Close (SquishIndexF);
     PeekFiles;
END;


{--------------------------------------------------------------------------}
{ SquishLoadIndex                                                          }
{                                                                          }
{ Maakt geheugen vrij voor de Squish Index file, en laadt deze in.         }
{                                                                          }
FUNCTION SquishMBase.SquishLoadIndex : BOOLEAN;

VAR IORes : BYTE;

LABEL Abort;

BEGIN
     SquishLoadIndex:=FALSE; { assume ERROR }

     { RWI 951108: gewoon even zeker zijn dat ze geen troep bevatten }
     {             voor het geval hieronder iets mis gaat vOOr de    }
     {             geheugen allocatie.                               }
     SquishIndexPtr:=NIL;
     SquishNewIndexPtr:=NIL;

     SquishNewIndexNumb:=0;
     SquishIndexNumb:=0;
     SquishIndexSize:=0;

     { Open de SQI file }
     Assign (SquishIndexF,SquishAreaName+SQUISH_I_EXT);
     {$I-} Reset (SquishIndexF,1); {$I+} IORes:=IOResult;
     PeekFiles;

     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[Squish] Unable to open Squish Index file '+SquishAreaName+SQUISH_I_EXT);
          Exit;
     END;

     { Reserveer ruimte voor het maximaal aantal berichten }
     SquishIndexNumb:=FileSize (SquishIndexF) DIV SizeOf (_SQIDXTYPE);
     SquishIndexSize:=SquishIndexNumb*SizeOf (_SQIDXTYPE);

     IF (SquishIndexSize > 65520) THEN
     BEGIN
          LogMessage ('[Squish] Large Index file not supported for '+SquishAreaName);
          GOTO Abort;
     END;

     IF (MaxAvail < SquishIndexSize) THEN
     BEGIN
          LogMessage ('[Squish] Unable to open Squish index file because of low memory');
          GOTO Abort;
     END;

     GetMem (SquishIndexPtr,SquishIndexSize);
     {$IFDEF LogGetMem} LogGetMem (SquishIndexPtr,SquishIndexSize,'SquishIndexPtr'); {$ENDIF}
     GetMem (SquishNewIndexPtr,SQNewEntrys*SizeOf (_SQIDXTYPE));
     {$IFDEF LogGetMem} LogGetMem (SquishNewIndexPtr,SQNewEntrys*SizeOf (_SQIDXTYPE),'SquishNewIndexPtr'); {$ENDIF}
     PeekMem;

     {$I-} BlockRead (SquishIndexF,SquishIndexPtr^[1],SquishIndexSize); {$I+}
     IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[Squish] Error loading Squish Index file ('+SquishAreaName+')');
          GOTO Abort;
     END;

     { Major BUG FIX !!!!                                                  }
     {                                                                     }
     { Als GoldEd een bericht uit een squish area delete, doet hij dit     }
     { door netjes het frame te unlinken, en de indexfile van 0000 op de   }
     { juiste plaats te voorzien. Controleer nu eerst of het einde van de  }
     { index wel klopt door 0000 records aan het einde te verwijderen. Wij }
     { voegden dus berichten toe aan het einde, en die nullen bleven       }
     { altijd maar staan. Waarna alle andere programma's vrolijk op hun    }
     { bek gingen.                                                         }

     IF (SquishIndexNumb > 0) THEN
        WHILE (SquishIndexPtr^[SquishIndexNumb].Ofs = 0) DO
              Dec (SquishIndexNumb);

     SquishLoadIndex:=TRUE; { succes }

     { tabel in het geheugen, geef de handle weer vrij }

Abort:
     Close (SquishIndexF);
END;


{--------------------------------------------------------------------------}
{ SquishDeleteFromIndex                                                    }
{                                                                          }
{ Delete het bericht waarop de CurrentFrame staat uit de index.            }
{                                                                          }
{ MD 24-07 Bug fix, door verkeerde groote record werden te weinig bytes    }
{          verplaatst.                                                     }
{                                                                          }
FUNCTION SquishMBase.SquishDeleteFromIndex : BOOLEAN;

VAR Tel : LONGINT;

BEGIN
     SquishDeleteFromIndex:=FALSE;

     { Doorloop de index tabel opzoek naar het huidige frame }
     FOR Tel:=1 TO SquishIndexNumb DO
         IF (SquishIndexPtr^[Tel].Ofs = CurrentFrame) THEN
         BEGIN
              SquishDeleteFromIndex:=TRUE;
              { Schuif de tabel een stap naar binnen }

              { Move(SquishIndexPtr^[Tel+1],SquishIndexPtr^[Tel],(SquishIndexNumb-1)*Sizeof(_sqidxtype)); }
              Move (SquishIndexPtr^[Tel+1],SquishIndexPtr^[Tel],(SquishIndexNumb-Tel)*Sizeof(_sqidxtype));
              Dec (SquishIndexNumb);
              Exit;
         END;

     { Zijn er mogenlijk nieuwe entry's die verwijderd kunnen worden ? }
     IF (SquishNewIndexNumb > 0) THEN
        FOR Tel:=1 TO SquishNewIndexNumb DO
            IF (SquishNewIndexPtr^[Tel].Ofs = CurrentFrame) THEN
            BEGIN
                 SquishDeleteFromIndex:=TRUE;
                 { Schuif de tabel een stap naar binnen }
                 { Move(SquishNewIndexPtr^[Tel+1],SquishNewIndexPtr^[Tel],(SquishNewIndexNumb--1)*Sizeof(_sqidxtype)); }
                 Move (SquishNewIndexPtr^[Tel+1],SquishNewIndexPtr^[Tel],(SquishNewIndexNumb-Tel)*Sizeof(_sqidxtype));
                 Dec (SquishNewIndexNumb);
                 Exit;
            END;
END;


{--------------------------------------------------------------------------}
{ SquishAddToIndex                                                         }
{                                                                          }
{ Voegt een nieuwe entry toe aan de index, hiervoor zijn een hash van de   }
{ TO name van het bericht en een uniek msgnumber voor nodig.               }
{                                                                          }
PROCEDURE SquishMBase.SquishAddToIndex (HashValue : LONGINT; MsgId : LONGINT);
BEGIN
     { Als er teveel entry's zijn, bewaar de tabel dan op disk }
     { en laadt de nieuwe tabel dan weer in.                   }

     IF (SquishNewIndexNumb = SQNEWENTRYS) THEN
     BEGIN
          SquishSaveIndex;
          SquishLoadIndex;
     END;

     IF (SquishNewIndexPtr = NIL) THEN
     BEGIN
          LogMessage ('[Squish] Index not loaded; cannot add new index');
          Exit;
     END;

     { Bugfix? }
     Inc (SquishNewIndexNumb);

     WITH SquishNewIndexPtr^[SquishNewIndexNumb] DO
     BEGIN
          Ofs:=CurrentFrame;
          UMsgId:=MsgId;
          Hash:=HashValue;
     END; { with }
END;


{--------------------------------------------------------------------------}
{ LoadSquishHeaders                                                        }
{                                                                          }
{ Laadt de Base header van een Squish area in het geheugen.                }
{                                                                          }
FUNCTION SquishMBase.SquishLoadHeader : BOOLEAN;

VAR Size : WORD;

BEGIN
     SquishLoadHeader:=FALSE;

     CalcMaxAllowedMem (Size,1024,8192);

     IF (NOT FBufferOpen (SquishBaseF,SquishAreaName+SQUISH_D_EXT,Size,0)) THEN
     BEGIN
          LogExtraMessage ('[LoadSquishHeader] Unable to open header for '+SquishAreaName);
          FBufferClose (SquishBaseF);
          Exit;
     END;

     IF (NOT FBBlockRead (SquishBaseF,SquishBase,SizeOf (SquishBase))) THEN
     BEGIN
          LogExtraMessage ('[LoadSquishHeader] Unable to read header for '+SquishAreaName);
          FBufferClose (SquishBaseF);
          Exit;
     END;

     SquishLoadHeader:=TRUE;
END;


{--------------------------------------------------------------------------}
{ CloseSquishArea                                                          }
{                                                                          }
{ Sluit de Squish area af door de index weg te gooien, de header te        }
{ updaten en de bestanden af te sluiten.                                   }
{                                                                          }
PROCEDURE SquishMBase.CloseSquishArea;
BEGIN
     IF (SquishAreaName <> '') THEN
     BEGIN
          SquishSaveIndex;

          { Update de header }
          SquishUpdateHeader;

          { sluit de files }
          FBufferClose (SquishBaseF);
     END;

     SquishAreaName:='';
END;


{--------------------------------------------------------------------------}
{ InitSquishArea                                                           }
{                                                                          }
{ Leest de header, laadt de index en zet de frame pointer op het eerste    }
{ frame.                                                                   }
{                                                                          }
FUNCTION SquishMBase.InitSquishArea (AreaData : AreaBaseRecord) : BOOLEAN;

VAR ZoekFile : SearchRec;

BEGIN
     InitSquishArea:=FALSE;

     { Kijk of de area al geladen is, dan kunnen we gewoon doorstarten }
     IF (SquishAreaName <> AreaData.FidoMsgPath) THEN
     BEGIN
          IF (SquishAreaName <> '') THEN
             CloseSquishArea;

          { controleer of het bestand wel bestaat }
          FindFirst (AreaData.FidoMsgPath+SQUISH_D_EXT,$3C,ZoekFile);

          IF (DosError = 3) THEN
          BEGIN
               LogMessage ('[Squish] Path not found: '+AreaData.FidoMsgPath);
               SquishAreaName:='';
               FindClose (ZoekFile);
               Exit;
          END;

          IF (DosError IN [2,18]) THEN
          BEGIN
               LogMessage ('Creating Squish base '+AreaData.Areaname_F);
               SquishAreaName:=AreaData.FidoMsgPath;
               IF (NOT SquishCreateArea (AreaData)) THEN
               BEGIN
                    SquishAreaName:='';
                    FindClose (ZoekFile);
                    Exit;
               END;
          END;

          FindClose (ZoekFile);

          { De file bestaat dus wel , probeer hem maar gewoon te openen }
          SquishAreaName:=AreaData.FidoMsgPath;

          IF (NOT SquishLoadHeader) THEN
          BEGIN
               SquishAreaName:=''; { Zorg dat we 'm niet zometeen niet afsluiten }
               Exit;
          END;

          IF (NOT SquishLoadIndex) THEN
          BEGIN
               FBufferClose (SquishBaseF); { RAWI980521: was left open! }
               SquishAreaName:=''; { Zorg dat we 'm niet zometeen niet afsluiten }
               Exit;
          END;
     END;

     FBSeek (SquishBaseF,0);
     CurrentFrame:=NULLFRAME; {SquishBase.Begin_Frame}
     InitSquishArea:=TRUE;
END;


{--------------------------------------------------------------------------}
{ SquishLoadFrame                                                          }
{                                                                          }
{ Laadt het frame aangegeven door de CurrentFrame pointer.                 }
{                                                                          }
{ MD 03-08-93 Toevoegen van controle op nullframe                          }
{                                                                          }
FUNCTION SquishMBase.SquishLoadFrame (VAR Frame : _SqfHdrType; FrameNr : LONGINT) : BOOLEAN;
BEGIN
     SquishLoadFrame:=FALSE;

     IF (FrameNr = NULLFRAME) THEN
        Exit;

     IF (NOT FBSeek (SquishBaseF,FrameNr)) OR
        (NOT FBBlockRead (SquishBaseF,Frame,SizeOf (Frame))) THEN
     BEGIN
          LogExtraMessage ('[Squish] Error loading frame from '+SquishAreaName+SQUISH_D_EXT);
          Exit;
     END;

     { Controleer de integriteit van het frame             }
     { Dit is belangrijk, als het frame niet klopt moet de }
     { areabase opnieuw opgebouwd worden.                  }
     IF (Frame.ID <> SQHDRID) THEN
     BEGIN
          LogMessage ('[Squish] Corrupted frame found! Please rebuild '+SquishAreaName);
          Exit;
     END;

     SquishLoadFrame:=TRUE;
END;


{--------------------------------------------------------------------------}
{ SquishSaveFrame                                                          }
{                                                                          }
{ Bewaard het huidige frame op de positie aangegeven door CurrentFrame.    }
{                                                                          }
FUNCTION SquishMBase.SquishSaveFrame (VAR Frame : _SqfHdrType; FrameNr : LONGINT) : BOOLEAN;
BEGIN
     SquishSaveFrame:=FALSE;

     IF (Frame.Id <> SQHDRID) THEN
     BEGIN
          LogMessage ('[Squish] Not saving corrupted frame!');
          Exit;
     END;

     IF FBSeekWrite (SquishBaseF,FrameNr,Frame,SizeOf (_SqfHdrType)) THEN
        SquishSaveFrame:=TRUE
     ELSE
         LogExtraMessage ('[Squish] Error saving frame');
END;


{--------------------------------------------------------------------------}
{ SquishLoadFrameType                                                      }
{                                                                          }
{ Deze routine kan een Squish frame naar keuze inladen:                    }
{                                                                          }
{ SQ_FIRST: Eerste gebruikte frame                                         }
{ SQ_LAST: Laatste gebruikte frame                                         }
{ SQ_PREV: Vorige frame in chain                                           }
{ SQ_NEXT: Volgende frame in chain                                         }
{                                                                          }
FUNCTION SquishMBase.SquishLoadFrameType (Frame : FrameType) : BOOLEAN;
BEGIN
     CASE Frame OF
          SQ_FIRST : CurrentFrame:=SquishBase.Begin_Frame;
          SQ_LAST  : CurrentFrame:=SquishBase.Last_Frame;
          SQ_PREV  : CurrentFrame:=SquishFrameHdr.Prev_Frame;
          SQ_NEXT  : CurrentFrame:=SquishFrameHdr.Next_Frame;
     END;

     SquishLoadFrameType:=SquishLoadFrame (SquishFrameHdr,CurrentFrame);
END;


{--------------------------------------------------------------------------}
{ SquishLoadMsgHdr                                                         }
{                                                                          }
{ Laadt de fido header van het huidige bericht.                            }
{                                                                          }
FUNCTION SquishMBase.SquishLoadMsgHdr (BelongingFrame : LONGINT) : BOOLEAN;
BEGIN
     IF FBSeek (SquishBaseF,BelongingFrame+SizeOf (_SQFHDRTYPE)) AND
        FBBlockRead (SquishBaseF,SquishMsgHdr,SizeOf (_SQMHDRTYPE))
     THEN
         SquishLoadMsgHdr:=TRUE
     ELSE BEGIN
          LogExtraMessage ('[Squish] Error loading msg header (1)');
          SquishLoadMsgHdr:=FALSE;
     END;
END;


{ -------------------------------------------------------------------------}
{ SquishSaveMsgHeader                                                      }
{                                                                          }
{ Update/Creert de huidige bericht informatie                              }
{                                                                          }
FUNCTION SquishMBase.SquishSaveMsgHdr (BelongingFrame : LONGINT) : BOOLEAN;

VAR IORes : BYTE;

BEGIN
     LastWritePos:=BelongingFrame+SizeOf (_SQFHDRTYPE);

     IF FBSeekWrite (SquishBaseF,LastWritePos,SquishMsgHdr,SizeOf (_SQMHDRTYPE)) THEN
        SquishSaveMsgHdr:=TRUE
     ELSE BEGIN
          LogExtraMessage ('[Squish] Error saving msg header');
          SquishSaveMsgHdr:=FALSE;
     END;

     { FBSeekWrite has updated LastWritePos now }
END;


{--------------------------------------------------------------------------}
{ SquishUnlinkFrame                                                        }
{                                                                          }
{ Verwijder een frame uit de link door de voorgaande en volgende frames    }
{ aan elkaar te linken.                                                    }
{                                                                          }
FUNCTION SquishMBase.SquishUnlinkFrame : BOOLEAN;

VAR PrevFrame,
    NextFrame : _SqfHdrType;

BEGIN
     SquishUnlinkFrame:=TRUE;

     IF (SquishFrameHdr.Prev_Frame <> NULLFRAME) THEN
        IF SquishLoadFrame (PrevFrame,SquishFrameHdr.Prev_Frame) THEN
        BEGIN
             PrevFrame.Next_Frame:=SquishFrameHdr.Next_Frame;
             SquishUnlinkFrame:=SquishSaveFrame (PrevFrame,SquishFrameHdr.Prev_Frame);
        END;

     IF (SquishFrameHdr.Next_Frame <> NULLFRAME) THEN
        IF SquishLoadFrame (NextFrame,SquishFrameHdr.Next_Frame) THEN
        BEGIN
             NextFrame.Prev_Frame:=SquishFrameHdr.Prev_Frame;
             SquishUnlinkFrame:=SquishSaveFrame (NextFrame,SquishFrameHdr.Next_Frame);
        END;
END;


{--------------------------------------------------------------------------}
{ SquishFreeFrame                                                          }
{                                                                          }
{ Probeert het huidige frame op non-actief te stellen.                     }
{ Dit komt dus neer op het deleten van een bericht.                        }
{ Let erop dat ook de index bijgewerkt moet worden.                        }
{                                                                          }
FUNCTION SquishMBase.SquishFreeFrame : Boolean;

VAR LastFrame : _SqfHdrType;

BEGIN
     { Verwijder het frame uit de lijst }
     IF (NOT SquishUnlinkFrame) THEN
     BEGIN
          LogMessage ('[SquishFreeFrame] Error unlinking frame');
          Exit;
     END;

     { kijk of de header geupdate moet worden }
     IF (SquishBase.Begin_Frame = CurrentFrame) THEN
        SquishBase.Begin_Frame:=SquishFrameHdr.Next_Frame;

     IF (SquishBase.Last_Frame = CurrentFrame) THEN
        SquishBase.Last_Frame:=SquishFrameHdr.Prev_Frame;

     { Ok , en nu gebeurd het dus ..... }
     SquishFrameHdr.Frame_Type:=FRAME_FREE;

     { Als er nog geen gedelete berichten zijn kunnen we 'm direct aan }
     { het begin toevoegen.                                            }
     IF (SquishBase.First_Free = NULLFRAME) THEN
     BEGIN
          SquishBase.First_Free:=CurrentFrame;
          SquishBase.Last_Free:=CurrentFrame;
          SquishFrameHdr.Prev_Frame:=NULLFRAME;
          SquishFrameHdr.Next_Frame:=NULLFRAME;
     END ELSE
     BEGIN
          { Lees anders het laatste frame in en plak ons daaraan }
          IF SquishLoadFrame (LastFrame,SquishBase.Last_Free) THEN
          BEGIN
               { link het voormalig laatste frame door naar het huidige }
               LastFrame.Next_Frame:=CurrentFrame;
               SquishSaveFrame (LastFrame,SquishBase.Last_Free);

               { en update het huidige frame }
               SquishFrameHdr.Prev_Frame:=SquishBase.Last_Free;
               SquishFrameHdr.Next_Frame:=NULLFRAME;
               SquishBase.Last_Free:=CurrentFrame;
          END;
     END;

     { en bewaar het huidige frame met nieuwe links op disk }
     SquishSaveFrame (SquishFrameHdr,CurrentFrame);
END;


{--------------------------------------------------------------------------}
{ SquishFindFreeFrame                                                      }
{                                                                          }
{ Zoekt een frame dat niet meer in gebruik is van geschikte lengte, of als }
{ dat niet meer mogenlijk is , wijst naar het einde van het veld.          }
{                                                                          }
FUNCTION SquishMBase.SquishFindFreeFrame (NeededSize : LONGINT) : BOOLEAN;

VAR FreeEntry : LONGINT;

BEGIN
     { Init }
     SquishFindFreeFrame:=TRUE;

     { doorloopt de gelinkte lijst met alle vrije records }
     CurrentFrame:=SquishBase.First_Free;

     WHILE (CurrentFrame <> NULLFRAME) DO
     BEGIN
          { Een leeg frame gevonden, laadt het }
          IF (NOT SquishLoadFrame (SquishFrameHdr,CurrentFrame)) THEN
          BEGIN
               LogMessage ('[Squish] Error loading free frame');
               Exit;
          END;

          { Kijk of het gevonden frame groot genoeg is }
          IF (NeededSize < SquishFrameHdr.Frame_Length) THEN
             Break
          ELSE
              CurrentFrame:=SquishFrameHdr.Next_Frame;
     END; { while }

     { Niet gevonden, dan maar aan het einde toevoegen }
     IF (CurrentFrame = NULLFRAME) THEN
     BEGIN
          CurrentFrame:=SquishBase.End_Frame;
          Exit;
     END;

     { wel gevonden }
     SquishUnlinkFrame;

     { update Base header als dat nodig is }
     IF (SquishFrameHdr.Prev_Frame = NULLFRAME) THEN
        SquishBase.First_Free:=SquishFrameHdr.Next_Frame;

     IF (SquishFrameHdr.Next_Frame = NULLFRAME) THEN
        SquishBase.Last_Free:=SquishFrameHdr.Prev_Frame;

     SquishFindFreeFrame:=TRUE;
END;


{--------------------------------------------------------------------------}
{ SquishNewFrame                                                           }
{                                                                          }
{ Zoekt een leeg frame van de benodigde grootte , en plakt daar een nieuw  }
{ frame aan vast, of plak een nieuwe frame aan het einde van de de base    }
{                                                                          }
{ Let op! SquishBase.End_Frame moet evt na het schrijven van het bericht   }
{ worden geupdate !                                                        }
{                                                                          }
FUNCTION SquishMBase.SquishNewFrame (NeededSize : LONGINT) : BOOLEAN;

VAR TempFrame : _SQFHdrType;

BEGIN
     SquishNewFrame:=FALSE;

     IF (NOT SquishFindFreeFrame (NeededSize)) THEN
     BEGIN
          LogMessage ('[SquishNewFrame] Error while searching for a free frame');
          Exit;
     END;

     { CurrentFrame staat nu op de plaats waar we een nieuw record kunnen }
     { gaan schrijven.                                                    }

     IF (SquishBase.Last_Frame <> NULLFRAME) THEN
     BEGIN
          IF SquishLoadFrame (TempFrame,SquishBase.Last_Frame) THEN
          BEGIN
               TempFrame.Next_Frame:=CurrentFrame;
               SquishNewFrame:=SquishSaveFrame (TempFrame,SquishBase.Last_Frame);
          END;
     END ELSE
         SquishBase.Begin_Frame:=CurrentFrame;

     { zorg dat het huidige frame aan het einde van de lijst wordt toegevoegd }
     SquishFrameHdr.Id:=SQHDRID;
     SquishFrameHdr.Frame_Type:=FRAME_msg;
     SquishFrameHdr.Prev_Frame:=SquishBase.Last_Frame;
     SquishFrameHdr.Next_Frame:=NULLFRAME;

     SquishBase.Last_Frame:=CurrentFrame;

     { als dit een nieuwe frame is }
     IF (CurrentFrame = SquishBase.End_Frame) THEN
        SquishFrameHdr.Frame_Length:=NeededSize;

     SquishNewFrame:=SquishSaveFrame (SquishFrameHdr,CurrentFrame);
END;


{--------------------------------------------------------------------------}
{ Index Routines                                                           }
{--------------------------------------------------------------------------}


{--------------------------------------------------------------------------}
{ SquishIDXSearchByTOName                                                  }
{                                                                          }
{ Zoekt in de Index op berichten voor TO(username)                         }
{                                                                          }
{ First_Entry - Zoekt naar het eerst voorkomende frame en laadt dit.       }
{ Next_Entry  - Zoekt vanaf CurrentFrame en laadt als gevonden             }
{                                                                          }
{ De functie geeft een Boolean terug , TRUE als gevonden, FALSE if not     }
{                                                                          }
FUNCTION SquishMBase.SquishIDXSearchByTOName (Name : STRING; Search_Entry : SearchType) : BOOLEAN;

VAR Hash,
    Start,
    Tel   : LONGINT;

BEGIN
     { Init }
     SquishIDXSearchByTOName:=FALSE;

     { Converteer de Naam naar de gewenste HASH waarde }
     Hash:=SquishNameToHash (Name);

     IF (Search_Entry = FIRST_ENTRY) THEN
        Start:=1
     ELSE
         Start:=CurrentFrame;

     FOR Tel:=Start TO SquishIndexNumb DO
     BEGIN
          {WriteLn (Long2HexString (SquishIndexPtr^[Tel].Ofs));}

          IF (SquishIndexPtr^[Tel].Hash = Hash) THEN
          BEGIN
               { Gevonden ! Laadt het juiste Frame }
               CurrentFrame:=SquishIndexPtr^[Tel].Ofs ;
               SquishIDXSearchByTOName:=SquishLoadFrame (SquishFrameHdr,CurrentFrame);
               Break;
          END;
     END;
END;


{--------------------------------------------------------------------------}
{ SquishIDXSearchByMSGID                                                   }
{                                                                          }
{ Zoekt naar berichten via de MSGID sleutel in de Index.                   }
{                                                                          }
FUNCTION SquishMBase.SquishIDXSearchByMSGID (MSGID : UMSGID_Type) : BOOLEAN;

VAR Tel : LONGINT;

BEGIN
     SquishIDXSearchByMSGID:=FALSE;

     PurgeLR_IndexTel:=0; { niet gevonden }

     FOR Tel:=1 TO SquishIndexNumb DO
         IF (SquishIndexPtr^[Tel].UMsgId = MSGID) THEN
         BEGIN
              { gevonden ! Laadt het juiste Frame }
              CurrentFrame:=SquishIndexPtr^[Tel].Ofs;
              PurgeLR_IndexTel:=Tel;
              SquishIDXSearchByMsgId:=SquishLoadFrame (SquishFrameHdr,CurrentFrame);
              Break;
         END;
END;


{--------------------------------------------------------------------------}
{ SquishIDXSearchByFrameNumber                                             }
{                                                                          }
{ Zoekt in de index naar het gegeven bericht nummer, en geeft de locatie   }
{ in de index terug.                                                       }
{                                                                          }
FUNCTION SquishMBase.SquishIDXSearchByFrameNumber (FramePos : LONGINT; VAR MsgId : UMSGID_Type) : LONGINT;

VAR Tel : LONGINT;

BEGIN
     MsgID:=0;
     SquishIDXSearchByFrameNumber:=0;
     FOR Tel:=1 TO SquishIndexNumb DO
         IF (SquishIndexPtr^[Tel].Ofs = FramePos) THEN
         BEGIN
              SquishIDXSearchByFrameNumber:=Tel;
              MsgId:=SquishIndexPtr^[Tel].UMsgId;
              Break;
         END;
END;


{--------------------------------------------------------------------------}
{ SecondLevel Routines                                                     }
{--------------------------------------------------------------------------}


FUNCTION SquishMBase.SquishDeleteMessage : BOOLEAN;
BEGIN
     { Routine verwijderd huidig bericht uit de SquishBase }
     SquishDeleteFromIndex;
     SquishDeleteMessage:=SquishFreeFrame;

     { Update de header met het nieuwe aantal berichten  }
     Dec (SquishBase.Num_Msg);
     Dec (SquishBase.High_Msg);
END;


(*
{--------------------------------------------------------------------------}
{ SquishReadLn                                                             }
{                                                                          }
{ Geeft een tekstregel uit 'Source', de functie geeft False als er geen    }
{ regels meer over zijn.                                                   }
{                                                                          }
FUNCTION SquishReadLn (VAR Cache : SquishCacheBufType; VAR Regel : STRING) : BOOLEAN;

    { deze routine gaat er vanuit dat er niets meer opgeslagen is }
    PROCEDURE ReadNow;
    BEGIN
          { lees vanaf waar we de vorige keer gestopt zijn }
          Seek (SquishBaseF,Cache.Buffer,Cache.ReadPos);

          BlockRead (SquishBaseF,Cache.Buffer

          { bewaar de positie voor de volgende keer }
          Cache.ReadPos:=FilePos (SquishBaseF);
    END;


VAR Loc : LONGINT;

BEGIN
     { inladen als er niets meer over is }
     IF (Cache.InBuf = 0) THEN
     BEGIN
     END;

     Loc:=Source.GetPos;

     IF (Source.Buffer^[Loc] = #0) THEN
     BEGIN
          Regel:=#0;
          SquishReadLn:=FALSE; { einde }
          Exit;
     END;

     IF (Source.Buffer^[Loc] = #1) THEN
     BEGIN
          { header regel. Die loopt tot de volgende #1 of tot een #0 }

          REPEAT
                Inc (Loc); { eerste keer gaat ie zo over de #1 heen }
          UNTIL (Loc > Source.BufLen) OR
                ((Loc-Source.GetPos) = 254) OR
                (Source.Buffer^[Loc] IN [#0,#1]);
     END ELSE
     BEGIN
          { nu gaat het om een 'gewone' regel die beeindigd wordt door een }
          { #13 of een #0 }
          REPEAT
                Inc (Loc);
          UNTIL (Loc > Source.BufLen) OR
                ((Loc-Source.GetPos) = 254) OR
                (Source.Buffer^[Loc] IN [#0,#13]);

          IF (Source.Buffer^[Loc] = #13) THEN
             Inc (Loc); { afsluitende CR meenemen }
     END;

     Move (Source.Buffer^[Source.GetPos],Regel[1],Loc-Source.GetPos);
     Regel[0]:=Chr (Loc-Source.GetPos);
     Source.GetPos:=Loc;
     SquishReadLn:=NOT (Source.GetPos >= Source.BufLen);
END;
*)


{--------------------------------------------------------------------------}
{ SquishScanArea                                                           }
{                                                                          }
{ Leest een bericht uit de squish base, en kijkt of het geexporteerd kan   }
{ worden. Zoja, start de hele malle molen om berichten te kunnen           }
{ exporteren.                                                              }
{                                                                          }
{ De routine krijgt het te scannen area record meegeleverd.                }
{                                                                          }
PROCEDURE SquishMBase.ScanSquishArea (AreaData : AreaBaseRecord; IsPrimaryNetmailArea : BOOLEAN);

VAR LocalFido       : FidoAddrType;
    Einde           : BOOLEAN;
    DatumTijd       : DateTime;
    UserName        : STRING[MaxLenFromUser_F];
    LastRegel,
    Regel           : STRING;
    WhereTo         : WhereToType;
    SquishNextFrame : LONGINT;
    Nop             : UMSGID_Type;
    FirstExport     : BOOLEAN;
    P               : BYTE;
    CurrentFrameBU  : LONGINT;

LABEL Verder,
      CloseIt;

BEGIN
     FirstExport:=TRUE;

     { open de Squish message area }
     IF (NOT InitSquishArea (AreaData)) THEN
        Exit;

     UpdateReadFile (AreaData.FidoMsgPath,0);

     { Als dit een nieuwe area is hoeven we 'm natuurlijk ook niet te }
     { scannen. Kijk of er uberhaupt wel berichten in de area staan.  }
     IF (SquishBase.Num_Msg = 0) THEN
     BEGIN
          IF (SquishAreaName <> '') THEN
             GOTO CloseIt;
     END;

     { houdt de stats bij van de lokale gebieden }
     UserDataRecNr:=NILRecordNr;

     { doorloop de area vanaf het bericht waarop de highwater marker stond }
     REPEAT
           { Laadt het juiste frame }
           IF (CurrentFrame = NULLFRAME{Set by InitSquishArea}) THEN
           BEGIN
                { Start scannen van de area op de highwater mark }
                { Dit scheelt het doorlopen van de totale area   }
                IF (NOT ForceCleanScan) AND (SquishBase.High_Water > 0) THEN
                BEGIN
                     IF (NOT SquishIDXSearchByMsgID (SquishBase.High_Water)) THEN
                        SquishLoadFrameType (SQ_FIRST);
                END ELSE
                    { Geen geldige HighWaterMark }
                    SquishLoadFrameType (SQ_FIRST);
           END ELSE
               SquishLoadFrameType (SQ_NEXT);

           { Bewaar de frame header voor het geval dat we het bericht }
           { deleten.                                                 }
           SquishNextFrame:=SquishFrameHdr.Next_Frame;
           CurrentFrameBU:=CurrentFrame;

           { laad de fidoheader }
           IF (NOT SquishLoadMsgHdr (CurrentFrame)) THEN
              GOTO CloseIt; { RWI 960417 }

           { Controleer of het bericht al verstuurd is }
           { Of dat het niet bij ons vandaan kwam      }
           IF ((SquishMsgHdr.Attr AND MSGLOCAL) = 0) OR
              ((SquishMsgHdr.Attr AND MSGSENT) <> 0) OR
              ((SquishMsgHdr.Attr AND MSGHOLD) <> 0) OR
              ((SquishMsgHdr.Attr AND MSGFRQ) <> 0)
           THEN
               Continue;

           MsgsEmpty;

           { converteer de Squish header naar de standaard fido header }
           WITH Msg,SquishMsgHdr DO
           BEGIN
                Attr_F:=Attr;

                { RWI 961011: controle op #0 ivm met volledige gebruikte pchars ingevoerd }
                Move (FromWhom,FromUser_F[1],SQMSG_FROM_SIZE);
                FromUser_F[0]:=Char (SQMSG_FROM_SIZE);
                FOR P:=1 TO SQMSG_FROM_SiZE DO
                    IF (FromWhom[P] = #0) THEN
                    BEGIN
                         FromUser_F[0]:=Char (P-1);
                         Break;
                    END;

                Move (ToWhom,ToUser_F[1],SQMSG_TO_SIZE);
                ToUser_F[0]:=Char (SQMSG_TO_SIZE);
                FOR P:=1 TO SQMSG_TO_SIZE DO
                    IF (ToWhom[P] = #0) THEN
                    BEGIN
                         ToUser_F[0]:=Char (P-1);
                         Break;
                    END;

                Move (Subj,Subj_F[1],SQMSG_SUBJ_SIZE);
                Subj_F[0]:=Char (SQMSG_SUBJ_SIZE);
                FOR P:=1 TO SQMSG_SUBJ_SIZE DO
                    IF (Subj[P] = #0) THEN
                    BEGIN
                         Subj_F[0]:=Char (P-1);
                         Break;
                    END;

                Squish2FidoAdres (Dest,ToAddr_F);
                Squish2FidoAdres (Orig,FromAddr_F);

                UnpackTime (SquishDecodeDate (Date_Written),DatumTijd);
                WITH DatumTijd DO
                     Date_F:=FidoTime2Str (Day,Month,Year,Hour,Min,Sec);
           END;

           CASE AreaData.AreaType OF
                Area_Echo :
                    BEGIN
                         Msg.Area_F:=AreaData.AreaName_F;
                         { Stop de AREA: kludge in de eerste regel van het bericht }
                         MsgsAddLineTo (Header_F,'AREA:'+Msg.Area_F);
                         Msg.Ready_F:=Local_Echomail;
                    END;

                Area_Netmail:
                    Msg.Ready_F:=Local_Netmail;

                Area_EMail:
                    BEGIN
                         Msg.FromAddr_F:=Config.NodeNrs[AreaData.OriginAKA];

                         IF (Msg.ToUser_F = '') THEN
                            Msg.ToUser_F:=Config.GatewayUser
                         ELSE
                             IF (UpCaseString (Msg.ToUser_F) <> Config.GatewayUser) THEN
                             BEGIN
                                  IF (Pos ('@',Msg.ToUser_F) = 0) AND (Pos ('!',Msg.ToUser_F) = 0) THEN
                                  BEGIN
                                       IF Config.LogDebug THEN
                                          LogMessage ('Squish['+AreaData.AreaName_F+'] No e-mail address in To: ("'+
                                                      Msg.ToUser_F+'")');

                                       { make MSGORPHAN.. }

                                       Continue;  { geen e-mail! }
                                  END;

                                  MsgsAddFirstLineTo (Body,'To: '+Msg.ToUser_F);
                                  Msg.ToUser_F:=Config.GatewayUser;
                             END;
                             { else assume To: in body }

                         { zoek het bijpassende system node nummer voor in de To: }
                         FidoMatch (Msg.FromAddr_F,Msg.ToAddr_F);
                         Msg.Ready_F:=Local_Netmail;
                    END;
           END; { case }

           { Loop door de header heen en plaats die letterlijk in  }
           { de fido header                                        }
           { Dit is makkelijk: alle header kludges moeten hier al  }
           { staan... (hoop ik)                                    }

           { Baal! Ook Squish negeerd vrolijk het point veld in de   }
           { FidoHeader... dit betekend dat er alsnog naar TOPT/FMPT }
           { INTL/MSGID gezocht moet worden..                        }

           { Als dit een netmail bericht is , en we draaien in Frontdoor }
           { mode mag het bericht alleen verstuurd worden als het        }
           {   a) voor ons bestemd is en                                 }
           {   b) voor postmaster is!                                    }
           { zorg er ook voor dat lokale netmail berichten onaangeroerd  }
           { blijven.                                                    }

           { --- Inlezen van het header gedeelte van het bericht }
           PrevKludgeID:=klNone;
           REPEAT
                 FBReadSquishHdrLn (SquishBaseF,Regel);

                 IF (Regel <> #0) THEN
                    FidoAddLineToMessage (Regel+#13,LastRegel);

           UNTIL (Regel = #0);

           { FidoAddLastLine (TRUE,LastRegel); }

           { alle kludges hebben we nu doorlopen dus we hebben nu }
           { complete adressen.                                   }
           IF (NOT FidoCheckNetmail (IsPrimaryNetmailArea)) THEN
              Continue;

           { --- Init boolean variabelen }
           Found_SeenBy:=FALSE;
           Found_Path:=FALSE;
           Found_Origin:=FALSE;
           Found_Tear:=FALSE;

           { lees het bericht regel voor regel in de buffer }
           REPEAT
                 Einde:=FBReadLnCR (SquishBaseF,Regel);
                 IF (Regel = #0) THEN
                    Break;

                 WHILE (Pos (#$8D,Regel) > 0) DO
                       Delete (Regel,Pos (#$8D,Regel),1);

                 { RWI 950916: De tear-line kwam door als #13'--- timEd' }
                 {             en werd door de #13 dus niet goed als     }
                 {             kludge geidentificeerd.                   }
                 IF (Regel[1] = #13) THEN
                 BEGIN
                      FidoAddLineToMessage (#13,LastRegel);
                      IF (Length (Regel) > 1) THEN
                      BEGIN
                           Delete (Regel,1,1);
                           FidoAddLineToMessage (Regel,LastRegel);
                      END;
                 END ELSE
                     FidoAddLineToMessage (Regel,LastRegel);

           UNTIL (NOT Einde);

           FidoAddLastLine (LastRegel);

           { ignore LOcKed messages }
           IF ((Msg.ExtAttr_F AND EXTMSGLOK) <> 0) THEN
              Continue;

           IF (NOT Found_Tear) THEN
              MsgsAddLineTo (Footer_F,FidoTear);

           { Zorg dat er een tearline wordt toegevoegd, een origin line }
           { zodat we een 'echt' fido bericht krijgen.                  }

           IF FirstExport THEN
           BEGIN
                FirstExport:=FALSE;
                LogMessage ('Exporting from '+AreaData.AreaName_F+' (Squish)');
           END;

           IF (Msg.Ready_F = Local_Netmail) THEN
           BEGIN
                IF Config.LogExportedMsgs AND (AreaData.AreaType <> Area_Email) THEN
                   LogMessage ('  Exporting netmail for "'+Msg.ToUser_F+'"%'+Fido2Str (Msg.ToAddr_F));
           END ELSE
           BEGIN
                UpdateAreaStats (GetAreaBaseRecordNrByAreaName_F (AreaData.AreaName_F),Msg.MsgSize);
                UpdateUserStats (NILRecordNr{=Local},EchoFrom,Msg.MsgSize);

                IF Config.LogExportedMsgs THEN
                   LogMessage ('  Exporting echomail for "'+Msg.ToUser_F+'"');
           END;

           IF (Msg.Ready_F = Local_Echomail) THEN
              FidoFinishEchomailExport;

           { Let op! Na het aanroepen van MsgsExport mag een bericht nooit }
           { lokaal meer geimporteerd worden aangezien we dan rotzooi in   }
           { de CurrentFrame variabele krijgen.                            }

           { Probeer de base te locken, aangezien we moeten schrijven }
           IF (NOT SquishLockBase) THEN
           BEGIN
                LogMessage ('[Squish] Unable to lock '+AreaData.AreaName_F);
                GOTO CloseIt;
           END;

           { let op: als we de msgbase niet locken, dan gaat het mis als   }
           { een reply in de msgbase geschreven wordt (van AreaFix bijv.)  }
           { en is onze SquishMsgHdr niet meer valid. Twee oplossingen:    }
           { eerst wegvlaggen en daarna exporteren (yeah! Maar dan wel     }
           { overal zo gaan doen), of de hele boel lokaal maken (boeoe!),  }
           { of de messagebase sluiten en weer openen (bleh! traag..).     }

           { RWI 960417: werd NA MsgsExport geteld, maar is dan niet meer }
           {             valid! (overschreven door reply bericht).        }
           {Inc (FidoProcessStatus.BytesCount,Msg.MsgSize);}
           {FidoProcessStatusShow;}

           UpdateInfoNr (INFO_SquishScan_Msgs,1);

           IF (Msg.Ready_F IN [Netmail,Local_Netmail]) THEN
              UpdateInfoNr (INFO_SquishScan_Net,1)
           ELSE
               UpdateInfoNr (INFO_SquishScan_Echo,1);

           { -- Exporteer het bericht    }
           MsgsExport;

           {--- Update de message header }
           IF (Msg.WasGated{mail only!} AND Config.KillGatedNetmail) AND
              {voor de zekerheid:}(AreaData.AreaType IN [Area_Netmail,Area_EMail])
           THEN
               SquishDeleteMessage
           ELSE
               { RWI 961006: deleted check }
               {IF NOT ((Config.FidoSystem = stFrontdoor) AND (AreaData.AreaType = Area_Netmail)) THEN}
                  { RWI 960417: was Msg.Attr_F ipv SquishMsgHdr.Attr }
                  IF ((SquishMsgHdr.Attr AND MSGKILL) <> 0) THEN
                     SquishDeleteMessage
                  ELSE BEGIN
                       SquishMsgHdr.Attr:=SquishMsgHdr.Attr OR MSGSENT;
                       { RWI 960206: verwijder de Uns flag.
                                     Welk bit is dat nou weer? $@#!!
                       SquishMsgHdr.Attr:=SquishMsgHdr.Attr AND (
                       }

                       SquishSaveMsgHdr (CurrentFrameBU);
                  END;

           SquishUnlockBase;

Verder:
           { Doorgaan tot aan het einde van de lijst }
     UNTIL (SquishNextFrame = NULLFRAME);

     { Update HighWater Mark }
     SquishBase.High_Water:=SquishIDXSearchByFrameNumber (CurrentFrame,Nop);

CloseIt:
     CloseSquishArea;
     MsgsEmpty;
END;


{--------------------------------------------------------------------------}
{ SquishSaveMessage                                                        }
{                                                                          }
{ Schrijft een bericht naar disk                                           }
{ Omdat Squish berichten een afwijkend header hebben ( geen CR/LF etc )    }
{ zal de header opnieuw opgebouwd moeten worden.                           }
{                                                                          }
PROCEDURE SquishMBase.SquishSaveMessage;

CONST HeaderSize = 10000; { RWI 960321: was 25000!! }

TYPE BigBuf = ARRAY[0..65528] OF BYTE;

{ deze variabelen moeten eigenlijk NA de sub procedures gezet worden! }
VAR SplitCurrent,
    SplitParts       : BYTE;
    SplitParts_R     : REAL;
    TotalSize,
    AllowedSize,
    NeededSize,
    FidoBodyLen,
    RealBodySize,
    RealFooterSize,
    RealHeaderSize   : LONGINT;
    CreatingNewFrame : BOOLEAN;
    NewArea          : BOOLEAN;
    Body,
    SM_Header        : ^BigBuf;
    BSize            : WORD;
    BufferSize       : WORD;
    ReachedEOMsg     : BOOLEAN;
    SubjectLine,
    SplitLine        : STRING;

    { Een Squish bericht heeft een eigen type header een zonder CR/LF's, }
    { regels gescheiden door #1 (CTRL-A) tekens.                         }

    { Voeg hieraan toe, de Fido Footer }

    {----------------------------------------------------------------------}
    { BuildSquishHeader                                                    }
    {                                                                      }
    PROCEDURE BuildSquishHeader;

    VAR HSize       : WORD;
        EenRegelPtr : EenRegelRecordPtr;
        RegelLength : BYTE;
        Regel       : STRING;
        SkipOne     : BOOLEAN;

    BEGIN
         HSize:=0;
         { voeg alleen een header toe, als er wel een header is }
         IF (Msg.HeaderTop_F <> NIL) THEN
         BEGIN
              { ga naar de eerste regel }
              EenRegelPtr:=Msg.HeaderTop_F^.FirstRegelRecordPtr;
              MsgsNewSeek (EenRegelPtr);

              { Strip de AREA: kludge }
              SkipOne:=(AreaData.AreaType = Area_Echo);

              WHILE (EenRegelPtr <> NIL) AND (HSize < HeaderSize) DO
              BEGIN
                   { alleen de regels die beginnen met #1 !}
                   CASE EenRegelPtr^.Waar OF
                        wMem :
                            BEGIN
                                 IF SkipOne THEN
                                    SkipOne:=FALSE { AREA: kludge }
                                 ELSE BEGIN
                                      IF (EenRegelPtr^.RegelPtr^[1] = #1) THEN
                                      BEGIN
                                           RegelLength:=Length (EenRegelPtr^.RegelPtr^);
                                           Move (EenRegelPtr^.RegelPtr^[1],SM_Header^[HSize],RegelLength);
                                           Inc (HSize,RegelLength); { Geen CR ! }
                                           IF (SM_Header^[HSize-1] = 13) THEN
                                              Dec (HSize);
                                      END;
                                 END; { skipone }

                                 { altijd meteen naar de volgende regel }
                                 EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                 MsgsNewSeek (EenRegelPtr);
                            END;

                        wSwapped :
                            BEGIN
                                 { lees de lengte van de regel in }
                                 BlockRead (SwapFile,RegelLength,1);

                                 { einde van het blok bereikt? }
                                 IF (RegelLength = 0) THEN
                                 BEGIN
                                      EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                      MsgsNewSeek (EenRegelPtr);
                                      Continue; { met de while }
                                 END;

                                 BlockRead (SwapFile,Regel[1],RegelLength);
                                 Regel[0]:=Char (RegelLength); { hoeft niet, handig voor debuggen though }

                                 IF SkipOne THEN
                                    SkipOne:=FALSE { AREA: kludge }
                                 ELSE BEGIN
                                      { alleen #1 regels verwerken }
                                      IF (Regel[1] = #1) THEN
                                      BEGIN
                                           Move (Regel[1],SM_Header^[HSize],RegelLength);
                                           Inc (HSize,RegelLength); { Geen CR ! }
                                           IF (SM_Header^[HSize-1] = 13) THEN
                                              Dec (HSize);
                                      END;
                                 END; { skipone }
                            END; { wSwapped }
                   END; { case }
              END; { while not end of regels }

              { Zorg voor een FSC-SplitLine aan het einde van de Squish Header }
              IF (SplitLine <> '') THEN
              BEGIN
                   Move (SplitLine[1],SM_Header^[HSize],Length (SplitLine));
                   Inc (HSize,Length (SplitLine)+1);
                   SM_Header^[HSize-1]:=13;
              END;

              { Sluit de header van het bericht af met een 0 }
              SM_Header^[HSize]:=0;
              Inc (HSize);
         END; { er is een header }

         RealHeaderSize:=HSize;

         { Voeg alleen een footer toe, als er er wel een footer is }
         IF (Msg.FooterTop_F <> NIL) THEN
         BEGIN
              EenRegelPtr:=Msg.FooterTop_F^.FirstRegelRecordPtr;
              MsgsNewSeek (EenRegelPtr);

              WHILE (EenRegelPtr <> NIL) AND (HSize < HeaderSize) DO
              BEGIN
                   CASE EenRegelPtr^.Waar OF
                        wMem:
                            BEGIN
                                 { kijk of we SeenBy lijnen moeten overslaan }
                                 IF NOT (Config.StripSeenBy AND (Copy (EenRegelPtr^.RegelPtr^,1,7) = 'SEEN-BY')) THEN
                                 BEGIN
                                      RegelLength:=Length (EenRegelPtr^.RegelPtr^);
                                      Move (EenRegelPtr^.RegelPtr^[1],SM_Header^[HSize],RegelLength);
                                      Inc (HSize,RegelLength);
                                 END;

                                 EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                 MsgsNewSeek (EenRegelPtr);
                            END;

                        wSwapped :
                            BEGIN
                                 { lees de lengte van deze regel in }
                                 BlockRead (SwapFile,RegelLength,1);

                                 { hebben we het einde van een blok bereikt? }
                                 IF (RegelLength = 0) THEN
                                 BEGIN
                                      EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                      MsgsNewSeek (EenRegelPtr);
                                      Continue;
                                 END;

                                 BlockRead (SwapFile,Regel[1],RegelLength);
                                 Regel[0]:=Char (RegelLength);

                                 { seen-by overslaan indien nodig }
                                 IF NOT (Config.StripSeenBy AND (Copy (Regel,1,7) = 'SEEN-BY')) THEN
                                 BEGIN
                                      Move (Regel[1],SM_Header^[HSize],RegelLength);
                                      Inc (HSize,RegelLength);
                                 END;
                            END; { wSwapped }
                   END; { case }

              END; { while }

              { sluit de header van het bericht af met een 0 }
              SM_Header^[HSize]:=0;
              Inc (HSize);

              RealFooterSize:=HSize-RealHeaderSize;
         END ELSE { er is een footer }
             RealFooterSize:=0;
    END; { BuildSquishHeader }

{ SquishSaveMessage }

VAR SwapPos     : LONGINT;
    EenRegelPtr : EenRegelRecordPtr;
    RegelLength : BYTE;
    Regel       : STRING;
    DidRemember : BOOLEAN;
    Remembered  : STRING;
    PerBodyLen  : LONGINT;

LABEL Abort;

BEGIN
     { Opent/Creert/Negeert Squish area }
     IF (NOT InitSquishArea (AreaData)) THEN
     BEGIN
          LogMessage ('[SquishSaveMessage] Failed to open '+AreaData.AreaName_F);
          Exit;
     END;

     IF (NOT SquishLockBase) THEN
     BEGIN
          LogMessage ('[SquishSaveMessage] Unable to lock '+AreaData.AreaName_F);
          Exit;
     END;

     UpdateWriteFile (AreaData.FidoMsgPath,0);

     { controleer of de heap nog genoeg ruimte heeft }
     IF (MaxAvail < HeaderSize) THEN
     BEGIN
          LogMessage ('[SquishSaveMessage] Not enough memory (1)');
          SquishUnlockBase; { RWI 960321: added }
          Exit;
     END;

     GetMem (SM_Header,HeaderSize);
     {$IFDEF LogGetMem} LogGetMem (SM_Header,HeaderSize,'SM_Header'); {$ENDIF}

     IF (NOT CalcMaxAllowedMem (BufferSize,4096,16384)) THEN
     BEGIN
          LogMessage ('[SquishSaveMessage] Not enough memory (2)');
          FreeMem (SM_Header,HeaderSize);
          SquishUnlockBase; { RWI 960321: added }
          Exit;
     END;

     GetMem (Body,BufferSize);
     {$IFDEF LogGetMem} LogGetMem (Body,BufferSize,'Body'); {$ENDIF}
     PeekMem;

     { Kijkt of we de limiet gaan overschrijven }
     IF (Msg.BodyTop <> NIL) THEN
        FidoBodyLen:=Msg.BodyTop^.TotalRegelLength
     ELSE
         FidoBodyLen:=0;

     { bereken het aantal delen waarin het bericht gesplitst gaat worden }
     SplitCurrent:=0;
     SplitParts:=0;
     SplitLine:='';

     IF (Config.MaxSquishMsgLen > 0) THEN
     BEGIN
          PerBodyLen:=Config.MaxSquishMsgLen-SizeOf (_SQMHDRTYPE);

          IF (Msg.HeaderTop_F <> NIL) THEN
             Dec (PerBodyLen,Msg.HeaderTop_F^.TotalRegelLength);

          IF (Msg.FooterTop_F <> NIL) THEN
             Dec (PerBodyLen,Msg.FooterTop_F^.TotalRegelLength);

          SplitParts_R:=FidoBodyLen / PerBodyLen;
          SplitParts:=Trunc (SplitParts_R);
          IF (SplitParts < SplitParts_R) THEN
             Inc (SplitParts);
     END;

     IF (Msg.BodyTop <> NIL) THEN
        EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr
     ELSE
         EenRegelPtr:=NIL;
     MsgsNewSeek (EenRegelPtr);

     { initialiseer SwapPos }
     IF SwapIsOpen THEN
        SwapPos:=FilePos (SwapFile);

     DidRemember:=FALSE;

     { de repeat structuur zorgt ervoor dat een leeg bericht ook in de }
     { squish base beland.                                             }
     REPEAT { lus om tot het einde van het bericht door te gaan }
           WITH SquishBase DO
           BEGIN
                IF (AreaData.FidoMsgLimit > 0) AND ((Num_Msg+1) > AreaData.FidoMsgLimit) THEN
                BEGIN
                     SquishLoadFrameType (SQ_FIRST);
                     SquishDeleteMessage;
                END;

                { Nu kunnen we veilig een bericht toevoegen }
                Inc (Num_Msg);
                Inc (High_Msg);
           END; { with }

           WITH SquishMsgHdr DO
           BEGIN
                Attr:=Msg.Attr_F;

                FillChar (FromWhom,SQMSG_FROM_SIZE,0);
                FillChar (ToWhom,SQMSG_TO_SIZE,0);
                FillChar (Subj,SQMSG_SUBJ_SIZE,0);

                Move (Msg.FromUser_F[1],FromWhom,Length (Msg.FromUser_F));
                IF (Length (Msg.FromUser_F) < 35) THEN
                   FromWhom[Length (Msg.FromUser_F)+1]:=#0;

                Move (Msg.ToUser_F[1],ToWhom,Length (Msg.ToUser_F));
                IF (Length (Msg.ToUser_F) < 35) THEN
                   ToWhom[Length (Msg.ToUser_F)+1]:=#0;

                IF (SplitParts > 1) THEN
                BEGIN
                     Inc (SplitCurrent);
                     SubjectLine:='('+Byte2String (SplitCurrent)+
                                  '/'+Byte2String (SplitParts)+
                                  ') '+Msg.Subj_F;
                     SplitLine:= FidoCreateSplitLine (SplitCurrent,SplitParts);
                END ELSE
                    SubjectLine:=Msg.Subj_F;

                Move (SubjectLine[1],Subj,Length (SubjectLine));
                IF (Length (SubjectLine) < 72) THEN
                   Subj[Length (SubjectLine)+1]:=#0;

                SquishFido2SquishAdres (Msg.FromAddr_F,Orig);
                SquishFido2SquishAdres (Msg.ToAddr_F,Dest);
                Date_Written:=SquishTransLateDate (Msg.Date_F);
                Date_Arrived:=SquishTransLateDate (FidoCurrTime2Str); { Foei! }

                Utc_ofs:=0;
                Replyto:=0;
                Replies[1]:=0;

                FillChar (AzDate,20,0);
                Move (Msg.Date_F[1],AzDate,Length (Msg.Date_F));
           END; { with }

           { fill in SM_Header and calc RealHeaderSize and RealFooterSize }
           BuildSquishHeader;

           { calculate the size of the needed frame }
           NeededSize:=SizeOf (_SQMHDRTYPE)+FidoBodyLen+RealFooterSize+RealHeaderSize;

           IF (Config.MaxSquishMsgLen > 0) AND (NeededSize > Config.MaxSquishMsgLen) THEN
              NeededSize:=SizeOf (_SQMHDRTYPE)+Config.MaxSquishMsgLen;

           { Zoek een nieuw/2e hands frame voor dit bericht. }
           IF (NOT SquishNewFrame (NeededSize)) THEN
           BEGIN
                LogMessage('[SquishSaveMessage] Unable to allocate new frame');
                GOTO Abort;
           END;

           { Als we een heel nieuw frame creeren is het belangrijk dat we }
           { bij een foute voorspelling van de lengte ook de eigenlijke   }
           { frame lengte aanpassen.                                      }
           CreatingNewFrame:=(CurrentFrame = SquishBase.End_Frame);

           { calculate how many body bytes can be stored in each part }
           AllowedSize:=NeededSize-SizeOf (_SQMHDRTYPE)-RealFooterSize-RealHeaderSize;

           { Vul de bericht header met zinvolle informatie }
           WITH SquishFrameHdr DO
           BEGIN
                Id:=SQHDRID;
                CLen:=RealHeaderSize;
                Msg_Length:=NeededSize;
           END; { with }

           { Bewaar het frame      }
           { Bewaar de fido header }
           IF NOT (SquishSaveFrame (SquishFrameHdr,CurrentFrame) AND
                   SquishSaveMsgHdr (CurrentFrame)) THEN
           BEGIN
                LogMessage('[SquishSaveMessage] Unable to write headers');
                GOTO Abort;
           END;

           { LastSavePos wijst naar waar we verder kunnen schrijven }
           FBSeekWrite (SquishBaseF,LastWritePos,SM_Header^[0],RealHeaderSize);

           { Aangezien een bericht groter kan zijn dan 64Kb, het maximum }
           { dat we kunnen alloceren, maar de berichten niet gesplitst   }
           { op disk hoeven te worden gezet, lees steeds een brok van    }
           { maximaal 64Kb body in en schrijf dat weg.                   }

           TotalSize:=0;
           BSize:=0;

           { herstel de verwerk positie in de swapfile, voor het geval }
           { die veranderd is door het wegschrijven van de header.     }
           IF SwapIsOpen THEN
              Seek (SwapFile,SwapPos);

           { doorLoop de loop netzolang totdat we alle regels gehad hebben }
           WHILE (EenRegelPtr <> NIL) DO
           BEGIN
                IF DidRemember THEN
                BEGIN
                     Regel:=Remembered;
                     DidRemember:=FALSE;
                END ELSE
                    ExtractFile (EenRegelPtr,Regel);

                RegelLength:=Length (Regel);
                IF (TotalSize+RegelLength > AllowedSize) THEN
                BEGIN
                     DidRemember:=TRUE;
                     Remembered:=Regel;
                     Break;            { from the while }
                END;

                Move (Regel[1],Body^[BSize],RegelLength);
                Inc (BSize,RegelLength);
                Inc (TotalSize,RegelLength);

                IF (BSize >= BufferSize-255) THEN
                BEGIN
                     FBSeekWrite (SquishBaseF,LastWritePos,Body^[0],BSize);
                     BSize:=0;
                END;
           END; { while }

           { bij een swap blok is het belangrijk dat we bijhouden      }
           { waar we stonden. Bij gespleten berichten is het namelijk  }
           { mogelijk dat de header opnieuw gelezen gaat worden en ook }
           { die kan op disk staan. We bewaren hier dus de positie in  }
           { de swapfile (not matter what) en herstellen die aan het   }
           { begin van de while (als we daar weer komen).              }
           IF SwapIsOpen THEN
              SwapPos:=FilePos (SwapFile);

           { Haal het al verwerkte gedeelte van het bericht af }
           Dec (FidoBodyLen,TotalSize);

           { Schrijf een eventueel restant weg naar disk }
           IF (BSize > 0) THEN
              FBSeekWrite (SquishBaseF,LastWritePos,Body^[0],BSize);

           { Schrijf de footer weg naar disk }
           FBSeekWrite (SquishBaseF,LastWritePos,SM_Header^[RealHeaderSize],RealFooterSize);

           { Als de voorspelling over de bericht lengte niet klopte, werk }
           { die dan bij. Dit komt eigenlijk alleen bij gespleten         }
           { berichten voor.                                              }
           IF (NeededSize <> (TotalSize+RealFooterSize+RealHeaderSize+SizeOf (_SQMHDRTYPE))) THEN
           BEGIN
                WITH SquishFrameHDR DO
                BEGIN
                     msg_length:=TotalSize+RealFooterSize+RealHeaderSize+SizeOf (_SQMHDRTYPE);
                     IF CreatingNewFrame THEN
                        frame_length:=msg_length;
                END;

                { Bewaar het frame      }
                { Bewaar de fido header }
                IF (NOT SquishSaveFrame (SquishFrameHdr,CurrentFrame)) THEN
                BEGIN
                     LogMessage ('[SquishSaveMessage] Unable to write header (2)');
                     GOTO Abort;
                END;
           END; { if }

           { Update header pointer }
           SquishBase.End_Frame:=FileSize (SquishBaseF.Bestand);

           { Voeg bericht toe aan de index }
           SquishAddToIndex (SquishNameToHash (Msg.ToUser_F),SquishBase.uid);
           Inc (SquishBase.Uid);

           UpdateInfoNr (INFO_SquishSave_Msgs,1);

     UNTIL (EenRegelPtr = NIL); { einde van bericht bereikt }

Abort:

     { Geef geheugen vrij }
     FreeMem (Body,BufferSize);
     FreeMem (SM_Header,HeaderSize);

     SquishUnlockBase;
END;


{--------------------------------------------------------------------------}
{ SquishMBase.SquishLockBase                                               }
{                                                                          }
{ Probeert een lock af te dwingen van de Squish base file.                 }
{                                                                          }
FUNCTION SquishMBase.SquishLockBase : BOOLEAN;

VAR LockTry : WORD;

BEGIN
     { simpel, no fuss }
     SquishLockBase:=TRUE; { assume it worked }

     IF LockFile (SquishBaseF.Bestand) THEN
        Exit;

     { Problem! }
     Message ('Squish! Found '+SquishAreaname+' locked, retrying');

     FOR LockTry:=1 TO SquishBaseMaximumLockTrys DO
     BEGIN
          IF LockFile (SquishBaseF.Bestand) THEN
             Break;

          { Hook naar desqview, om onze tijd op te geven als we een }
          { base proberen te locken.                                }
          Slice_Now;
     END;

     WindowPop; { Haal bericht weg }

     { Als het niet gelukt is , geef dat dan ff door }
     IF (LockTry >= SquishBaseMaximumLockTrys) THEN
        SquishLockBase:=FALSE;
END;


{--------------------------------------------------------------------------}
{ SquishMBase.UnlockBase                                                   }
{                                                                          }
{ Geeft de Squish Base weer vrij voor andere programma's.                  }
{                                                                          }
FUNCTION SquishMBase.SquishUnlockBase : BOOLEAN;
BEGIN
     SquishUnlockBase:=UnlockFile (SquishBaseF.Bestand);
END;


{--------------------------------------------------------------------------}
{ SquishMBase.InitBase                                                     }
{                                                                          }
{ Global init van de Squish Area routines.                                 }
{                                                                          }
CONSTRUCTOR SquishMBase.InitBase;
BEGIN
     SquishAreaName:='';
END;


{---------------------------------------------------------------------------}
{ SquishMBase.CloseBase                                                     }
{                                                                           }
DESTRUCTOR SquishMBase.CloseBase;
BEGIN
     CloseSquishArea;
END;


(*
{--------------------------------------------------------------------------}
{ SquishMBase.SquishReIndex                                                }
{                                                                          }
{ Standaard functie die probeert een Squish file van een nieuwe index te   }
{ voorzien, door deze op te bouwen uit informatie in de msgbase.           }
{                                                                          }
PROCEDURE SquishMBase.SquishReIndex (AreaData : AreaBaseRecord);

VAR NewIndex        : FILE;
    SquishNewIndex  : _sqidxtype;
    SquishNextFrame : LONGINT;
    IORes           : BYTE;

LABEL Einde;

BEGIN
     SquishAreaName:=AreaData.FidoMsgPath;

     { als area file niet bestaat, exit }
     IF NOT TestIfExist (SquishAreaName+SQUISH_D_EXT) THEN
        Exit;

     IF (NOT SquishLoadHeader) THEN
        Exit;

     { probeer of we de index file kunnen openen voor output }
     Assign (NewIndex,SquishAreaName+SQUISH_I_EXT);
     {$I-} ReWrite (NewIndex,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[Squish] Error creating new index file for '+SquishAreaName);
          Exit;
     END;

     PeekFiles;

     { Laten we bij het begin beginnen }
     CurrentFrame:=NULLFRAME;

     IF (NOT SquishLoadFrameType (SQ_FIRST)) THEN
        GOTO Einde;

     { bewaar de frame header, voor het geval dat we het bericht deleten }
     REPEAT
           SquishNextFrame:=SquishFrameHdr.Next_Frame;

           { laad de fidoheader }
           IF (NOT SquishLoadMsgHdr (CurrentFrame)) THEN
              GOTO Einde; { zorg dat lege gebieden geen file handles opslurpen }

           WITH SquishNewIndex DO
           BEGIN
                Ofs:=CurrentFrame;
                UMsgId:=SquishBase.uid;  { Nieuwe unieke nummers }
                Hash:=SquishNameToHash (SquishMsgHdr.towhom);
           END;

           Inc (SquishBase.uid);

           { Probeer de index naar disk te schrijven }
           {$I-} BlockWrite (NewIndex,SquishNewIndex,SizeOf (SquishNewIndex)); {$I+}
           IORes:=IOResult;
           IF (IORes <> 0) THEN
           BEGIN
                LogDiskIOError (IORes,'[Squish] Error while adding to index file of '+SquishAreaName);
                Exit;
           END;

           SquishLoadFrameType (SQ_NEXT);
           Inc (Status.DezeArea);  { Aantal berichten gereindexd }

           { doorgaan tot aan het einde van de lijst }
     UNTIL (SquishNextFrame = NULLFRAME);

     { zorg dat de nieuwe header op disk staat }
     SquishUpdateHeader;

Einde:
     Close (NewIndex);
     FBufferClose (SquishBaseF);
     PeekFiles;

     SquishAreaName:=''; { RWI 960521: stond vOOr Einde: label }
END;
*)


{--------------------------------------------------------------------------}
{ SquishPurgeArea                                                          }
{                                                                          }
{ Deze routine ruimte de rommel op in een area.                            }
{                                                                          }
PROCEDURE SquishMBase.SquishPurgeArea (AreaData : AreaBaseRecord);

VAR MsgCount : LONGINT;

    {----------------------------------------------------------------------}
    { KillByAge                                                            }
    {                                                                      }
    { Out: MsgCount. 0..n = nr of msgs. -2: abort.
    {                                                                      }
    FUNCTION KillByAge (Age : LONGINT) : BOOLEAN;

    VAR KillTime  : LONGINT;
        NextFrame : LONGINT;
        MsgTime   : LONGINT;

    BEGIN
         KillByAge:=FALSE; { error }

         KillTime:=GetCurrentUnixTime-Age*SEC_Dag;

         WriteXY (SXb2,SYb+6,'Purge by age      ');

         IF (NOT SquishLoadFrameType (SQ_FIRST)) THEN
            Exit;

         MsgCount:=0; { aantal berichten in de base }

         REPEAT
               NextFrame:=SquishFrameHdr.Next_Frame;

               IF (SquishFrameHdr.Frame_Type = FRAME_msg) THEN
               BEGIN
                    Inc (MsgCount);

                    IF (Age <> 0) THEN
                    BEGIN
                         IF (NOT SquishLoadMsgHdr (CurrentFrame)) THEN
                            Exit;

                         MsgTime:=SquishDateToUnix (SquishMsgHdr.Date_Written);

                         IF (MsgTime <> 0) AND (MsgTime < KillTime) THEN
                         BEGIN
                              { BOOM, you're dead! }

                              { mark this frame as "free", but don't unlink it }
                              { nor link it into the free chain yet.           }
                              SquishFrameHdr.Frame_type:=FRAME_free;

                              { update these fields in a "relative" way because we don't }
                              { know if these are offset-based or always 0-based.        }
                              Dec (SquishBase.Num_msg);
                              Dec (SquishBase.High_msg);
                              Dec (MsgCount);

                              { weer naar disk schrijven }
                              IF (NOT SquishSaveFrame (SquishFrameHdr,CurrentFrame)) THEN
                                 Exit;
                         END;
                    END;
               END;

               IF (NextFrame <> 0) THEN
                  IF (NOT SquishLoadFrameType (SQ_NEXT)) THEN
                     Exit;

         UNTIL (NextFrame = 0);

         { update header in case of newly deleted messages }
         SquishUpdateHeader;

         KillByAge:=TRUE; { OK }
    END;

    {----------------------------------------------------------------------}
    { KillByLimit                                                          }
    {                                                                      }
    { Als er nog meer berichten verwijderd moeten worden, dan zorgt deze   }
    { routine daarvoor. De eerste frames worden verwijderd, want misschien }
    { niet een goed idee is omdat daar ook de jongste berichten kunnen     }
    { staan. We moeten eigenlijk (net als JAM) een lijst bijhouden van de  }
    { oudste berichten en die killen.                                      }
    { Nog eens over nagedacht: als een frame hergebruikte wordt, dan wordt }
    { ie uit de "vrije" chain gehaald en aan het EINDE van de "gebruikte"  }
    { chain toegevoegd. Verwijderen vanaf het begin is dus juist.          }
    {                                                                      }
    FUNCTION KillByLimit (Limit : LONGINT) : BOOLEAN;

    VAR NextFrame : LONGINT;

    BEGIN
         KillByLimit:=FALSE; { abort }

         IF (Limit <> 0) AND (MsgCount > Limit) THEN
         BEGIN
              WriteXY (SXb2,SYb+6,'Purge by limit    ');

              IF (NOT SquishLoadFrameType (SQ_FIRST)) THEN
                 Exit;

              REPEAT
                    NextFrame:=SquishFrameHdr.Next_Frame;

                    IF (SquishFrameHdr.Frame_Type = FRAME_msg) THEN
                    BEGIN
                         { BOOM, you're dead! }

                         { mark this frame as "free", but don't unlink it }
                         { nor link it into the free chain yet.           }
                         SquishFrameHdr.Frame_type:=FRAME_free;

                         { update these fields in a "relative" way because we don't }
                         { know if these are offset-based or always 0-based.        }
                         Dec (SquishBase.Num_msg);
                         Dec (SquishBase.High_msg);
                         Dec (MsgCount);

                         { weer naar disk schrijven }
                         IF (NOT SquishSaveFrame (SquishFrameHdr,CurrentFrame)) THEN
                            Exit;
                    END;

                    IF (NextFrame <> 0) THEN
                       IF (NOT SquishLoadFrameType (SQ_NEXT)) THEN
                          Exit;

              UNTIL (NextFrame = 0) OR (MsgCount <= Limit);

              { update header in case of newly deleted messages }
              SquishUpdateHeader;
         END;

         KillByLimit:=TRUE; { OK }
    END;

    {----------------------------------------------------------------------}
    { CheckLastReads                                                       }
    {                                                                      }
    { Controleren of de .SQL umsgids bevat die in de .SQI file staan die   }
    { naar een frame wijzen die verwijderd moet worden. Zoja, dan verlagen }
    { naar het vorige "valid" bericht nummer. Rekening houden dat ALLE     }
    { berichten verwijderen kunnen zijn.                                   }
    {                                                                      }
    PROCEDURE CheckLastReads (LRFile : STRING);

    VAR SQLFile   : FILE;
        IORes     : BYTE;
        LRRec     : LONGINT;
        BytesRead : WordLong;

    BEGIN
         WriteXY (SXb2,SYb+6,'Purge check LR    ');

         Assign (SQLFile,LRFile);
         {$I-} Reset (SQLFile,1); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
         BEGIN
              { SQL hoeft niet in gebruik te zijn }
              IF (IORes <> 2{file not found}) THEN
                 LogDiskIOError (IORes,'[SquishPurge] Error opening last-read file '+LRFile);
              Exit;
         END;

         WHILE (FilePos (SQLFile) < FileSize (SQLFile)) DO
         BEGIN
              {$I-} BlockRead (SQLFile,LRRec,4,BytesRead); {$I+} IORes:=IOResult;
              IF (IORes <> 0) THEN
              BEGIN
                   LogDiskIOError (IORes,'[SquishPurge] Error reading from last-read file '+LRFile);
                   Close (SQLFile);
                   Exit;
              END;

              IF (LRRec = 0{niet in gebruik}) THEN
                 Continue;

              { LRRec bevat nu een umsgid dat valid moet zijn }

              IF (NOT SquishIDXSearchByMSGID (LRRec)) OR
                 (SquishFrameHdr.Frame_Type <> FRAME_msg) THEN
              BEGIN
                   { we moeten deze entry aanpassen }
                   { PurgeLR_IndexTel bevat de positie (1..n) in het }
                   { index array. We gaan nu gewoon steeds 1 positie }
                   { terug in de index totdat we er een vinden die   }
                   { niet gemarkeerd is om verwijderd te worden.     }

                   IF (PurgeLR_IndexTel = 0) THEN
                      LogMessage ('Squish LR['+Longint2String (FilePos (SQLFile)-4)+'] not found in index')
                   ELSE
                       WHILE (PurgeLR_IndexTel > 1) DO
                       BEGIN
                            Dec (PurgeLR_IndexTel);

                            CurrentFrame:=SquishIndexPtr^[PurgeLR_IndexTel].Ofs;

                            { als het frame niet geladen kan worden, dan }
                            { gewoon verder zoeken.                      }
                            IF SquishLoadFrame (SquishFrameHdr,CurrentFrame) AND
                               (SquishFrameHdr.Frame_Type = FRAME_msg) THEN
                            BEGIN
                                 { deze wijst naar een bericht. Zet de LR }
                                 { op dit bericht.                        }
                                 LRRec:=SquishIndexPtr^[PurgeLR_IndexTel].UMsgID;

                                 { write gebeurt buiten deze loop }
                                 Break; { binnenste while }
                            END;
                       END; { while }

                   { als we de LR niet konden updaten, dan op 0 zetten }
                   IF (PurgeLR_IndexTel = 0) THEN
                      LRRec:=0;

                   LogMessage ('Squish LR['+Longint2String (FilePos (SQLFile)-4)+'] adjusted to '+Longint2String (LRRec));

                   { (always) update LR record on disk }
                   Seek (SQLFile,FilePos (SQLFile)-4);
                   BlockWrite (SQLFile,LRRec,4);
              END;
         END; { while }

         Close (SQLFile);
    END;

VAR NewSQI : FILE;
    OldSQI : FILE;
    OldSQD : FILE;

    {----------------------------------------------------------------------}
    { CopyIndexEntry                                                       }
    {                                                                      }
    { Deze routine zoekt in de oude index OldSQI naar een index entry die  }
    { wijst naar OldPos. Die wordt aangepast zodat ie naar NewPos wijst    }
    { en daarna naar de NewSQI geschreven. Dit gebeurd op zo'n manier dat  }
    { een te groote index file ook nog verwerkt kan worden.                }
    {                                                                      }
    PROCEDURE CopyIndexEntry (OldPos,NewPos : LONGINT);

    CONST MAX_INDEXES = 25;

    VAR Indexes    : ARRAY[1..MAX_INDEXES] OF _SQIDXTYPE; { 300 bytes }
        Lp,
        IndexCount : 0..MAX_INDEXES;
        BytesRead  : WordLong;
        IORes      : BYTE;

    BEGIN
         Seek (OldSQI,0);
         REPEAT
              {$I-} BlockRead (OldSQI,Indexes,MAX_INDEXES*SizeOf (_SQIDXTYPE),BytesRead); {$I+} IORes:=IOResult;
              IF (IORes <> 0) THEN
              BEGIN
                   LogDiskIOError (IORes,'[SquishPurge] Error loading from old index');
                   Exit;
              END;

              IndexCount:=BytesRead DIV SizeOf (_SQIDXTYPE);

              FOR Lp:=1 TO IndexCount DO
                  IF (Indexes[Lp].Ofs = OldPos) THEN
                  BEGIN
                       Indexes[Lp].Ofs:=NewPos;

                       { important: keep umsgid and hash }

                       Seek (NewSQI,FileSize (NewSQI));
                       {$I-} BlockWrite (NewSQI,Indexes[Lp],SizeOf (_SQIDXTYPE)); {$I+} IORes:=IOResult;
                       IF (IORes <> 0) THEN
                          LogDiskIOError (IORes,'[SquishPurge] Error adding to new index');

                       Exit;
                  END;

         UNTIL (BytesRead = 0);

         LogMessage ('[SquishPurge] Frame not in old index, correcting');

         WITH Indexes[1] DO
         BEGIN
              Ofs:=NewPos;
              UMsgID:=SquishBase.UId;
              Inc (SquishBase.Uid);

              { RAWI 970704: added seek }
              Seek (OldSQD,OldPos+SizeOf (_SQFHDRTYPE));
              BlockRead (OldSQD,SquishMsgHdr,SizeOf (_SQMHDRTYPE));
              Hash:=SquishNameToHash (SquishMsgHdr.towhom);

              { restore position of OldSQD }
              Seek (OldSQD,OldPos+SizeOf (_SQIDXTYPE));
         END; { with }

         Seek (NewSQI,FileSize (NewSQI));
         {$I-} BlockWrite (NewSQI,Indexes[1],SizeOf (_SQIDXTYPE)); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'[SquishPurge] Error adding to new index');
    END;

VAR NewSQD    : FILE;
    IORes     : BYTE;

    OldIndex,
    OldFrame  : LONGINT;
    NewFrame  : LONGINT;
    PrevFrame : LONGINT;
    PrevFHdr  : _SQFHDRTYPE;

    CopyLen   : WORD;
    CopyPtr   : POINTER;
    CopyLeft  : LONGINT;
    CopyNow   : WORD;

    Abort     : BOOLEAN;

    OldSize,
    NewSize   : LONGINT;

    Aborted   : BOOLEAN;

LABEL EndKill;

BEGIN
     { Vul het status window }
     WriteXY (SXb2,SYb+2,'Squish     ');
     WriteXY (SXb2,SYb+6,'Purge             ');

     Status.DezeTodo:=0; { geen % }
     Status.DezeArea:=0;

     IF (NOT InitSquishArea (AreaData)) THEN
        Exit;

     Abort:=TRUE;

     IF (NOT SquishLockBase) THEN
        GOTO EndKill;

     IF (NOT KillByAge (AreaData.FidoMsgAge)) THEN
        GOTO EndKill;

     IF (NOT KillByLimit (AreaData.FidoMsgLimit)) THEN
        GOTO EndKill;

     CheckLastReads (AreaData.FidoMsgPath+'.SQL');

     Abort:=FALSE;

 EndKill:

     SquishUnlockBase;
     CloseSquishArea;

     IF Abort THEN
        Exit;

     WriteXY (SXb2,SYb+6,'Purge deleted msgs');

     MsgCount:=-1;

     { nu de .SQD, .SQI file opnieuw opbouwen }

     Assign (OldSQD,AreaData.FidoMsgPath+SQUISH_D_EXT);
     {$I-} Reset (OldSQD,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[SquishPurge] Failed to open '+AreaData.FidoMsgPath+SQUISH_D_EXT);
          Exit;
     END;

     IF (NOT LockFile (OldSQD)) THEN
     BEGIN
          LogMessage ('[SquishPurge] Failed to lock '+AreaData.FidoMsgPath+SQUISH_D_EXT);
          Close (OldSQD);
          Exit;
     END;

     Assign (OldSQI,AreaData.FidoMsgPath+SQUISH_I_EXT);
     {$I-} Reset (OldSQI,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[SquishPurge] Failed to open '+AreaData.FidoMsgPath+SQUISH_I_EXT);
          UnlockFile (OldSQD);
          Close (OldSQD);
          Exit;
     END;

     Assign (NewSQD,AreaData.FidoMsgPath+'.S$D');
     {$I-} ReWrite (NewSQD,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[SquishPurge] Failed to create temporary .S$D file');
          UnlockFile (OldSQD);
          Close (OldSQD);
          Close (OldSQI);
          Exit;
     END;

     Assign (NewSQI,AreaData.FidoMsgPath+'.S$I');
     {$I-} ReWrite (NewSQI,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[SquishPurge] Failed to create temporary .S$I file');
          UnlockFile (OldSQD);
          Close (OldSQD);
          Close (OldSQI);
          Close (NewSQD);
          Erase (NewSQD);
          Exit;
     END;

     { alle gebruikte frames kopieren }
     Seek (OldSQD,0);
     BlockRead (OldSQD,SquishBase,SizeOf (_SQBASETYPE));

     { the first frame does not have to start right after the header,   }
     { so we simply follow the chain of known frame and ignore the rest }
     OldFrame:=SquishBase.Begin_Frame;

     { als MsgCount niet uitgerekend is, neem dan de telling uit de header }
     IF (MsgCount = -1) THEN
        MsgCount:=SquishBase.Num_msg;

     { maak de lege berichten chain leeg }
     SquishBase.First_free:=0;
     SquishBase.Last_free:=0;

     { reset de andere tellers; we updaten die straks }
     SquishBase.Begin_frame:=0;
     SquishBase.Last_frame:=0;
     SquishBase.End_frame:=0;

     { RAWI 970528: veroorzaakt een hoop problemen als je deze reset!
     SquishBase.High_Water:=0;   voorkom High_Water > Num_Msg
     }

     { schrijf deze header alvast naar de nieuwe base }
     BlockWrite (NewSQD,SquishBase,SizeOf (_SQBASETYPE));

     { nu alle frames met FRAME_msg status kopieren }
     PrevFrame:=0;

     CalcMaxAllowedMem (CopyLen,1024,8192);
     GetMem (CopyPtr,CopyLen);
     {$IFDEF LogGetMem} LogGetMem (CopyPtr,CopyLen,'CopyPtr'); {$ENDIF}

     OldSize:=FileSize (OldSQD);
     Status.DezeTodo:=SquishBase.Num_msg;

     WHILE (OldFrame <> 0) DO
     BEGIN
          OldIndex:=OldFrame;

          { lees een oude frame header in }
          Seek (OldSQD,OldFrame);
          BlockRead (OldSQD,SquishFrameHdr,SizeOf (_SQFHDRTYPE));

          { prepare for next read }
          OldFrame:=SquishFrameHdr.Next_Frame;

          { keep the none-deleted frames }
          IF (SquishFrameHdr.Frame_type = FRAME_free) THEN
             Continue; { with the while }

          { tel aantal gekopieerde berichten }
          Inc (Status.DezeArea);

          { voorkom over-time-slicing en te veel screen updates }
          IF ((Status.DezeArea MOD 12) = 1) THEN
          BEGIN
               UtilUpdateProgress;
               Slice_Now;
          END;

          NewFrame:=FilePos (NewSQD);

          { link vanuit het previous frame updaten }
          IF (PrevFrame <> 0) THEN
          BEGIN
               Seek (NewSQD,PrevFrame);
               BlockRead (NewSQD,PrevFHdr,SizeOf (_SQFHDRTYPE));

               PrevFHdr.Next_Frame:=NewFrame;

               Seek (NewSQD,PrevFrame);
               BlockWrite (NewSQD,PrevFHdr,SizeOf (_SQFHDRTYPE));
          END;

          SquishFrameHdr.Prev_Frame:=PrevFrame;
          SquishFrameHdr.Next_Frame:=0; { wordt nog ingevuld }

          Seek (NewSQD,NewFrame);
          BlockWrite (NewSQD,SquishFrameHdr,SizeOf (_SQFHDRTYPE));

          PrevFrame:=NewFrame; { for next update }

          { en de inhoud van het frame kopieren }
          CopyLeft:=SquishFrameHdr.Frame_length;
          WHILE (CopyLeft > 0) DO
          BEGIN
               IF (CopyLeft > CopyLen) THEN
                  CopyNow:=CopyLen
               ELSE
                   CopyNow:=CopyLeft;

               {$I-} BlockRead (OldSQD,CopyPtr^,CopyNow); {$I+} IORes:=IOResult;
               { Ignore read errors. Simply create the new frame }

               { This can happen with new frames at the end of a .SQD, }
               { but without a complete body (aborted write, etc.).    }

               BlockWrite (NewSQD,CopyPtr^,CopyNow);

               CopyLeft:=CopyLeft-CopyNow;
          END; { while }

          { OldFrame staat al klaar }
          CopyIndexEntry (OldIndex,NewFrame);
     END; { while }

     { afsluiten }
     FreeMem (CopyPtr,CopyLen);

     NewSize:=FileSize (NewSQD);

     { update header }
     IF (PrevFrame <> 0) THEN
     BEGIN
          SquishBase.Begin_frame:=SizeOf (_SQBASETYPE);
          SquishBase.Last_frame:=PrevFrame;
     END;

     SquishBase.End_frame:=FileSize (NewSQD);

     { little prevention }
     IF (SquishBase.Num_msg < 0) THEN
        SquishBase.Num_msg:=0;

     SquishBase.High_msg:=SquishBase.Num_msg;

     Seek (NewSQD,0);
     BlockWrite (NewSQD,SquishBase,SizeOf (_SQBASETYPE));
     Close (NewSQD);

     UnLockFile (OldSQD);
     Close (OldSQD);

     Close (OldSQI);
     Close (NewSQI);

     { nu de nieuwe message base files op hun plaats zetten }

     Aborted:=FALSE;

     { delete old files }

     {$I-} Erase (OldSQD); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[SquishPurge] Failed to delete old '+AreaData.FidoMsgPath+SQUISH_D_EXT);

     {$I-} Erase (OldSQI); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[SquishPurge] Failed to delete old '+AreaData.FidoMsgPath+SQUISH_I_EXT);

     { rename new files }

     {$I-} Rename (NewSQD,AreaData.FidoMsgPath+SQUISH_D_EXT); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[SquishPurge] Failed to rename .S$D to '+AreaData.FidoMsgPath+SQUISH_D_EXT);

     {$I-} Rename (NewSQI,AreaData.FidoMsgPath+SQUISH_I_EXT); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[SquishPurge] Failed to rename .S$I to '+AreaData.FidoMsgPath+SQUISH_I_EXT);

     { update statistics }

     Status.SavedBytes:=Status.SavedBytes+(OldSize-NewSize);

     LogExtraMessage ('Squish Old: '+AddUpWithPreSpaces (8,Longint2String (OldSize))+
                      'b New: '+AddUpWithPreSpaces (8,Longint2String (NewSize)) +
                      'b Saves: '+AddUpWithPreSpaces (3,Byte2String (UtilPercSaved (OldSize,NewSize)))+
                      '% in '+AreaData.AreaName_F);
END;

{ Unit Initialization }
BEGIN
     SquishMsgBase.InitBase;
END.
