UNIT Start;

{

 This unit contains all the code to start a

  - Scanning the message bases
  - Toss inbound fido archives / packets
  - Process received UUCP files
  - Process received BAG files
  - Process received SMTP files

  Which jobs to start is entered through a number of flags. The
  menu options start one of the jobs and the command line can
  start multiple of them.

}

{ History:

 RWI 960714: started this unit

}

INTERFACE

CONST WORK_FIDOSCAN = $001;
      WORK_FIDOTOSS = $002;
      WORK_UUCPTOSS = $004;
      WORK_BAGTOSS  = $008;
      WORK_SMTPTOSS = $010;
      WORK_POP3TOSS = $020;

{ add new statistics counter for e-mail? }

TYPE INFO_Set = (                   { done? }
      INFO_UucpIn_Jobs,             { yes }
      INFO_UucpIn_Msgs,             { yes }
      INFO_UucpIn_Bytes,            { yes }
      INFO_UucpIn_Mail,             { yes }
      INFO_UucpIn_News,             { yes }

      INFO_SmtpIn_Jobs,             { yes }
      INFO_SmtpIn_Msgs,             { yes }
      INFO_SmtpIn_Bytes,            { yes }
      INFO_SmtpIn_Mail,             { yes }

      INFO_BagIn_Jobs,              { yes }
      INFO_BagIn_Msgs,              { yes }
      INFO_BagIn_Bytes,             { yes }
      INFO_BagIn_Mail,              { yes }
      INFO_BagIn_News,              { yes }

      INFO_Pop3In_Jobs,             { yes }
      INFO_Pop3In_Msgs,             { yes }
      INFO_Pop3In_Bytes,            { yes }
      INFO_Pop3In_Mail,             { yes }

      INFO_PktIn_Jobs,              { yes }
      INFO_PktIn_Msgs,              { yes }
      INFO_PktIn_Bytes,             { yes }
      INFO_PktIn_Net,               { yes }
      INFO_PktIn_Echo,              { yes }

      INFO_MsgScan_Msgs,            { yes }
      INFO_MsgScan_Bytes,           { yes }
      INFO_MsgScan_Net,             { yes }
      INFO_MsgScan_Echo,            { yes }

      INFO_JamScan_Msgs,            { yes }
      INFO_JamScan_Bytes,
      INFO_JamScan_Net,             { yes }
      INFO_JamScan_Echo,            { yes }

      INFO_SquishScan_Msgs,         { yes }
      INFO_SquishScan_Bytes,
      INFO_SquishScan_Net,          { yes }
      INFO_SquishScan_Echo,         { yes }

      INFO_WildCatScan_Msgs,        { yes }
      INFO_WildCatScan_Bytes,       { yes }
      INFO_WildCatScan_Net,         { yes }
      INFO_WildCatScan_Echo,        { yes }

      INFO_UucpOut_Jobs,            { yes }
      INFO_UucpOut_Msgs,            { yes }
      INFO_UucpOut_Bytes,           { yes }
      INFO_UucpOut_Mail,            { yes }
      INFO_UucpOut_News,            { yes }

      INFO_SmtpOut_Jobs,            { yes }
      INFO_SmtpOut_Msgs,            { yes }
      INFO_SmtpOut_Bytes,           { yes }
      INFO_SmtpOut_Mail,            { yes }

      INFO_PktOut_Jobs,             { yes }
      INFO_PktOut_Msgs,             { yes }
      INFO_PktOut_Bytes,            { yes }
      INFO_PktOut_Net,              { yes }
      INFO_PktOut_Echo,             { yes }

      INFO_MsgSave_Msgs,            { yes }
      INFO_MsgSave_Bytes,           { yes }
      INFO_MsgSave_Net,             { yes }
      INFO_MsgSave_Echo,            { yes }

      INFO_JamSave_Msgs,            { yes }
      INFO_JamSave_Bytes,           { yes (body & header, not index) }
      INFO_JamSave_Net,             { yes }
      INFO_JamSave_Echo,            { yes }

      INFO_SquishSave_Msgs,         { yes }
      INFO_SquishSave_Bytes,
      INFO_SquishSave_Net,          { yes }
      INFO_SquishSave_Echo,         { yes }

      INFO_WildCatSave_Msgs,        { yes }
      INFO_WildCatSave_Bytes,       { yes }
      INFO_WildCatSave_Net,         { yes }
      INFO_WildCatSave_Echo,        { yes }

      INFO_DupBad_Msgs,             { dupe:yes  bad:yes }
      INFO_DupBad_Bytes,
      INFO_DupBad_Net,
      INFO_DupBad_Echo

      );

PROCEDURE UpdateAction (Action : STRING);
PROCEDURE UpdateReadFile (Name : STRING; Size : LONGINT);
PROCEDURE UpdateWriteFile (Name : STRING; Size : LONGINT);
PROCEDURE UpdateInfoNr (InfoFlag : INFO_Set; Number : LONGINT);

PROCEDURE ScanForFileAttaches;
PROCEDURE StartWork (WorkToDo : BYTE; WaitKey : BOOLEAN);
FUNCTION  CheckMinDiskFree : BOOLEAN;


IMPLEMENTATION

USES Ramon,
     Dos,
     Crt,
     Globals,
     Logs,
     DupeChk,
     Fido,
     Cfg,
     Database,
     AreaBase,
     Msgs,
     FidoMsg,
     AreaMgr,
     MakeOut,
     Squish,
     PCBoard,
     Jam,
     MsgUtil,
     Smtp,
     {$IFDEF OS2}
     Os2Base,   { dosbeep }
     {$ENDIF}
     ListSrv,
     Usenet,
     Pop3,
     FidoPack,
     SeenBy,
     FD;

CONST Xb = 2;
      Yb = 2;
      Xn = 58;

      ProgressX : ARRAY[INFO_Set] OF XYType = (
        { Input: }     { Jobs ,Msgs ,Bytes,Mail ,News }
                { UUCP } Xb+10,Xb+15,Xb+20,Xb+28,Xb+33,
                { SMTP } Xb+10,Xb+15,Xb+20,Xb+28,
                 { BAG } Xb+10,Xb+15,Xb+20,Xb+28,Xb+33,
                { POP3 } Xb+10,Xb+15,Xb+20,Xb+28,
                 { PKT } Xb+10,Xb+15,Xb+20,Xb+28,Xb+33,
                 { MSG }       Xb+15,Xb+20,Xb+28,Xb+33,
                 { JAM }       Xb+15,Xb+20,Xb+28,Xb+33,
              { Squish }       Xb+15,Xb+20,Xb+28,Xb+33,
              { Squish }       Xb+15,Xb+20,Xb+28,Xb+33,

        { Output: }    { Jobs ,Msgs ,Bytes,Mail ,News }
                { UUCP } Xb+47,Xb+52,Xb+57,Xb+65,Xb+70,
                { SMTP } Xb+47,Xb+52,Xb+57,Xb+65,
                 { PKT } Xb+47,Xb+52,Xb+57,Xb+65,Xb+70,
                 { MSG }       Xb+52,Xb+57,Xb+65,Xb+70,
                 { JAM }       Xb+52,Xb+57,Xb+65,Xb+70,
              { Squish }       Xb+52,Xb+57,Xb+65,Xb+70,
             { WildCat }       Xb+52,Xb+57,Xb+65,Xb+70,
             { Dup/Bad }       Xb+52,Xb+57,Xb+65,Xb+70
                                              );

      ProgressY : ARRAY[Info_Set] OF XYType = (
        { Input: }     { Jobs ,Msgs ,Bytes,Mail ,News }
                { UUCP } Yb+5 ,Yb+5 ,Yb+5 ,Yb+5 ,Yb+5,
                { SMTP } Yb+6 ,Yb+6 ,Yb+6 ,Yb+6 ,
                 { BAG } Yb+7 ,Yb+7 ,Yb+7 ,Yb+7 ,Yb+7,
                { POP3 } Yb+8 ,Yb+8 ,Yb+8 ,Yb+8 ,
                 { PKT } Yb+10,Yb+10,Yb+10,Yb+10,Yb+10,
                 { MSG }       Yb+11,Yb+11,Yb+11,Yb+11,
                 { JAM }       Yb+12,Yb+12,Yb+12,Yb+12,
              { Squish }       Yb+13,Yb+13,Yb+13,Yb+13,
             { WildCat }       Yb+14,Yb+14,Yb+14,Yb+14,

        { Output: }    { Jobs ,Msgs ,Bytes,Mail ,News }
                { UUCP } Yb+5 ,Yb+5 ,Yb+5 ,Yb+5 ,Yb+5,
                { SMTP } Yb+6 ,Yb+6 ,Yb+6 ,Yb+6 ,
                 { PKT } Yb+10,Yb+10,Yb+10,Yb+10,Yb+10,
                 { MSG }       Yb+11,Yb+11,Yb+11,Yb+11,
                 { JAM }       Yb+12,Yb+12,Yb+12,Yb+12,
              { Squish }       Yb+13,Yb+13,Yb+13,Yb+13,
             { WildCat }       Yb+14,Yb+14,Yb+14,Yb+14,
             { Dup/Bad }       Yb+9 ,Yb+9 ,Yb+9 ,Yb+9
                                              );

VAR ProgressCounts               : ARRAY[INFO_Set] OF LONGINT;
    Start_ScannedForFileAttaches : BOOLEAN;


{--------------------------------------------------------------------------}
{ UpdateAction                                                             }
{                                                                          }
PROCEDURE UpdateAction (Action : STRING);
BEGIN
{$IFDEF WtrGate}
     WriteXYC (Xb+16,Yb+1,cBoxData,AddUpWithSpaces (Xn,Action));

     { wis ook de file }
     IF (Action = '') THEN
     BEGIN
          WriteXYC (Xb+16,Yb+2,cBoxData,Spaces (Xn));
          WriteXYC (Xb+16,Yb+3,cBoxData,Spaces (Xn));
     END;
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ UpdateReadFile                                                           }
{                                                                          }
PROCEDURE UpdateReadFile (Name : STRING; Size : LONGINT);
BEGIN
{$IFDEF WtrGate}
     IF (Size > 0) THEN
        Name:=Name+' ('+Longint2String (Size)+')';

     WriteXYC (Xb+16,Yb+2,cBoxData,AddUpWithSpaces (Xn,Name));
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ UpdateWriteFile                                                          }
{                                                                          }
PROCEDURE UpdateWriteFile (Name : STRING; Size : LONGINT);
BEGIN
{$IFDEF WtrGate}
     IF (Size > 0) THEN
        Name:=Name+' ('+Longint2String (Size)+')';

     WriteXYC (Xb+16,Yb+3,cBoxData,AddUpWithSpaces (Xn,Name));
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ UpdateInfoNr                                                             }
{                                                                          }
{ Deze routine wordt overal vandaan aangeroepen om informatie op het       }
{ voortgangs scherm te zetten.                                             }
{                                                                          }
PROCEDURE UpdateInfoNr (InfoFlag : INFO_Set; Number : LONGINT);

VAR Hulp : STRING[40];

BEGIN
{$IFDEF WtrGate}
     Inc (ProgressCounts[InfoFlag],Number);

     IF (ProgressCounts[InfoFlag] >= 10000000) THEN
        Hulp:=Longint2String (ProgressCounts[InfoFlag] DIV 1024)+'K '
     ELSE
         Hulp:=Longint2String (ProgressCounts[InfoFlag]);

     WriteXYC (ProgressX[InfoFlag],ProgressY[InfoFlag],cBoxData,Hulp);
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ DrawInfoScreen                                                           }
{                                                                          }
{ Deze routine tekent het informatie scherm voor de huidige actie die      }
{ bezig is zoals scan, toss, pack, etc.                                    }
{                                                                          }
PROCEDURE DrawInfoScreen;

CONST Xl = 76;
      Yl = 16;

VAR Lp : INFO_Set;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     WriteXY (Xb+27,Yb,'[Progress Monitor]');

     WriteXY (Xb+2,Yb+1,'Current task:');
     WriteXY (Xb+2,Yb+2,'Reading file:');
     WriteXY (Xb+2,Yb+3,'Writing file:');

     (*
   +============================= Progress Monitor ===========================+
+1 | Current task:                                                            |
 2 | Reading file:                                                            |
 3 | Writing file:                                                            |
 4 |         Jobs Msgs Bytes   Mail News          Jobs Msgs Bytes   Mail News |
 5 | UUCP    0    0    0       0    0     UUCP    0    0    0       0    0    |
 6 | SMTP    0    0    0       0    0     SMTP    0    0    0       0    0    |
 7 | BAG     0    0    0       0    0                                         |
 8 | POP3    0    0    0       0    0                  Msgs Bytes   Net  Echo |
 9 |              Msgs Bytes   Net  Echo  Dup/Bad      0    0       0    0    |
10 | PKT     0    0    0       0    0     PKT     0    0    0       0    0    |
11 | MSG          0    0       0    0     MSG          0    0       0    0    |
12 | JAM          0    0       0    0     JAM          0    0       0    0    |
13 | Squish       0    0       0    0     Squish       0    0       0    0    |
14 | WildCat      0    0       0    0     WildCat      0    0       0    0    |
   +================ IN ================================= OUT ================+
     +2      +10  +15  +20     +28  +33   +39     +47  +52  +57     +65  +70
     *)

     WriteXY (Xb+10,Yb+4,'Jobs Msgs Bytes   Mail News');

     WriteXY (Xb+2,Yb+5,'UUCP');
     WriteXY (Xb+2,Yb+6,'SMTP');
     WriteXY (Xb+2,Yb+7,'BAG');
     WriteXY (Xb+2,Yb+8,'POP3');

     WriteXY (Xb+15,Yb+9,'Msgs Bytes   Net  Echo');

     WriteXY (Xb+2,Yb+10,'PKT');
     WriteXY (Xb+2,Yb+11,'MSG');
     WriteXY (Xb+2,Yb+12,'JAM');
     WriteXY (Xb+2,Yb+13,'Squish');
     WriteXY (Xb+2,Yb+14,'WildCat');

     WriteXY (Xb+18,Yb+15,'[IN]');

     WriteXY (Xb+47,Yb+4,'Jobs Msgs Bytes   Mail News');

     WriteXY (Xb+39,Yb+5,'UUCP');
     WriteXY (Xb+39,Yb+6,'SMTP');

     WriteXY (Xb+52,Yb+8,'Msgs Bytes   Net  Echo');

     WriteXY (Xb+39,Yb+9 ,'Dup/Bad');
     WriteXY (Xb+39,Yb+10,'PKT');
     WriteXY (Xb+39,Yb+11,'MSG');
     WriteXY (Xb+39,Yb+12,'JAM');
     WriteXY (Xb+39,Yb+13,'Squish');
     WriteXY (Xb+39,Yb+14,'WildCat');

     WriteXY (Xb+55,Yb+15,'[OUT]');

     UpdateAction ('Initializing');

     FOR Lp:=INFO_UucpIn_Jobs TO INFO_DupBad_Echo DO
     BEGIN
          ProgressCounts[Lp]:=0;
          UpdateInfoNr (Lp,0);
     END;
END;


{--------------------------------------------------------------------------}
{ SetFlagFile                                                              }
{                                                                          }
{ Deze routine creert een 0-byte flag file zoals FDRESCAN.NOW.             }
{                                                                          }
PROCEDURE SetFlagFile (Path : STRING);

VAR FlagFile : FILE;
    IORes    : BYTE;

BEGIN
     Path:=DeleteFrontAndBackSpaces (Path);
     IF (Path = '') THEN
        Exit;

     Assign (FlagFile,Path);
     {$I-} ReWrite (FlagFile,0); {$I+} IORes:=IOResult;

     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Cannot create rescan flag file '+Path)
     ELSE BEGIN
          {$I-} Close (FlagFile); {$I+}
          IORes:=IOResult;
     END;
END;


{--------------------------------------------------------------------------}
{ WriteInfoToLogfile                                                       }
{                                                                          }
{ Deze routine schrijft een overzicht van alle INFO nummers naar de        }
{ logfile.                                                                 }
{                                                                          }
PROCEDURE WriteInfoToLogfile;

    PROCEDURE Write4 (Title : STRING; M,B,E,N : INFO_Set);
    BEGIN
         IF (ProgressCounts[M] > 0) THEN
            LogExtraMessage ('  '+Title+': '+
                             Longint2String (ProgressCounts[M])+' msgs/'+
                             Longint2String (ProgressCounts[B])+' bytes ('+
                             Longint2String (ProgressCounts[E])+' net, '+
                             Longint2String (ProgressCounts[N])+' echo)');
    END;

VAR NoInput,
    NoOutput : BOOLEAN;

BEGIN
     NoInput:=(ProgressCounts[INFO_UucpIn_Jobs] = 0) AND
              (ProgressCounts[INFO_SmtpIn_Jobs] = 0) AND
              (ProgressCounts[INFO_BagIn_Jobs] = 0) AND
              (ProgressCounts[INFO_Pop3In_Jobs] = 0) AND
              (ProgressCounts[INFO_PktIn_Jobs] = 0) AND
              (ProgressCounts[INFO_MsgScan_Bytes] = 0) AND
              (ProgressCounts[INFO_JamScan_Bytes] = 0) AND
              (ProgressCounts[INFO_SquishScan_Msgs] = 0);

     NoOutput:=(ProgressCounts[INFO_UucpOut_Jobs] = 0) AND
               (ProgressCounts[INFO_SmtpOut_Jobs] = 0) AND
               (ProgressCounts[INFO_PktOut_Bytes] = 0) AND
               (ProgressCounts[INFO_MsgSave_Bytes] = 0) AND
               (ProgressCounts[INFO_JamSave_Bytes] = 0) AND
               (ProgressCounts[INFO_SquishSave_Msgs] = 0) AND
               (ProgressCounts[INFO_DupBad_Bytes] = 0);

     IF NoInput AND NoOutput THEN
     BEGIN
          LogMessage ('Totals of this run: no input or output');
          Exit;
     END;

     IF NoInput THEN
        LogExtraMessage ('Input: nothing')
     ELSE
         LogExtraMessage ('Input:');

     IF (ProgressCounts[INFO_UucpIn_Jobs] > 0) THEN
        LogExtraMessage ('  UUCP: '+Longint2String (ProgressCounts[INFO_UucpIn_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_UucpIn_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_UucpIn_Msgs])+' msgs ('+
                                    Longint2String (ProgressCounts[INFO_UucpIn_Mail])+' mail, '+
                                    Longint2String (ProgressCounts[INFO_UucpIn_News])+' news)');

     IF (ProgressCounts[INFO_SmtpIn_Jobs] > 0) THEN
        LogExtraMessage ('  SMTP: '+Longint2String (ProgressCounts[INFO_SmtpIn_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_SmtpIn_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_SmtpIn_Msgs])+' mail msgs');

     IF (ProgressCounts[INFO_BagIn_Jobs] > 0) THEN
        LogExtraMessage ('  BAG: '+Longint2String (ProgressCounts[INFO_BagIn_Jobs])+' jobs/'+
                                   Longint2String (ProgressCounts[INFO_BagIn_Bytes])+' bytes/'+
                                   Longint2String (ProgressCounts[INFO_BagIn_Msgs])+' msgs ('+
                                   Longint2String (ProgressCounts[INFO_BagIn_Mail])+' mail, '+
                                   Longint2String (ProgressCounts[INFO_BagIn_News])+' news)');

     IF (ProgressCounts[INFO_Pop3In_Jobs] > 0) THEN
        LogExtraMessage ('  POP3: '+Longint2String (ProgressCounts[INFO_Pop3In_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_Pop3In_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_Pop3In_Msgs])+' mail msgs');

     IF (ProgressCounts[INFO_PktIn_Jobs] > 0) THEN
        LogExtraMessage ('  PKT: '+Longint2String (ProgressCounts[INFO_PktIn_Jobs])+' packets/'+
                                   Longint2String (ProgressCounts[INFO_PktIn_Bytes])+' bytes/'+
                                   Longint2String (ProgressCounts[INFO_PktIn_Msgs])+' msgs ('+
                                   Longint2String (ProgressCounts[INFO_PktIn_Net])+' netmail, '+
                                   Longint2String (ProgressCounts[INFO_PktIn_Echo])+' echomail)');

     Write4 ('MSG',INFO_MsgScan_Msgs,INFO_MsgScan_Bytes,INFO_MsgScan_Net,INFO_MsgScan_Echo);
     Write4 ('JAM',INFO_JamScan_Msgs,INFO_JamScan_Bytes,INFO_JamScan_Net,INFO_JamScan_Echo);
     Write4 ('Squish',INFO_SquishScan_Msgs,INFO_SquishScan_Bytes,INFO_SquishScan_Net,INFO_SquishScan_Echo);
     Write4 ('WildCat',INFO_WildCatScan_Msgs,INFO_WildCatScan_Bytes,INFO_WildCatScan_Net,INFO_WildCatScan_Echo);

     IF NoOutput THEN
        LogExtraMessage ('Output: nothing')
     ELSE
         LogExtraMessage ('Output:');

     IF (ProgressCounts[INFO_UucpOut_Jobs] > 0) THEN
        LogExtraMessage ('  UUCP: '+Longint2String (ProgressCounts[INFO_UucpOut_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_UucpOut_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_UucpOut_Msgs])+' msgs ('+
                                    Longint2String (ProgressCounts[INFO_UucpOut_Mail])+' mail, '+
                                    Longint2String (ProgressCounts[INFO_UucpOut_News])+' news)');

     IF (ProgressCounts[INFO_SmtpOut_Jobs] > 0) THEN
        LogExtraMessage ('  SMTP: '+Longint2String (ProgressCounts[INFO_SmtpOut_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_SmtpOut_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_SmtpOut_Msgs])+' mail msgs');

     IF (ProgressCounts[INFO_PktOut_Jobs] > 0) THEN
        LogExtraMessage ('  PKT: '+Longint2String (ProgressCounts[INFO_PktOut_Jobs])+' packets/'+
                                   Longint2String (ProgressCounts[INFO_PktOut_Bytes])+' bytes/'+
                                   Longint2String (ProgressCounts[INFO_PktOut_Msgs])+' msgs ('+
                                   Longint2String (ProgressCounts[INFO_PktOut_Net])+' netmail, '+
                                   Longint2String (ProgressCounts[INFO_PktOut_Echo])+' echomail)');

     Write4 ('MSG',INFO_MsgSave_Msgs,INFO_MsgSave_Bytes,INFO_MsgSave_Net,INFO_MsgSave_Echo);
     Write4 ('JAM',INFO_JamSave_Msgs,INFO_JamSave_Bytes,INFO_JamSave_Net,INFO_JamSave_Echo);
     Write4 ('Squish',INFO_SquishSave_Msgs,INFO_SquishSave_Bytes,INFO_SquishSave_Net,INFO_SquishSave_Echo);
     Write4 ('WildCat',INFO_WildCatSave_Msgs,INFO_WildCatSave_Bytes,INFO_WildCatSave_Net,INFO_WildCatSave_Echo);
     Write4 ('Dup/Bad',INFO_DupBad_Msgs,INFO_DupBad_Bytes,INFO_DupBad_Net,INFO_DupBad_Echo);
END;


{--------------------------------------------------------------------------}
{ ScanForFileAttaches                                                      }
{                                                                          }
PROCEDURE ScanForFileAttaches;

CONST Report = 'Scanning netmail for file attaches';

BEGIN
     IF (Config.FidoSystem = stFrontdoor) AND
        (Config.FidoNetmailType = FidoMsgType) AND
        (NOT Start_ScannedForFileAttaches) THEN
     BEGIN
          Start_ScannedForFileAttaches:=TRUE;

          UpdateAction (Report);
          LogMessage (Report);

          { Zorg ervoor dat voor Frontdoor systemen nu ook de lijst met }
          { nodes in het geheugen word gebouwdt waarvoor al een attach  }
          { file bestaat.                                               }
          AreaData.AreaName_F:='';
          AreaData.FidoMsgPath:=Config.FidoNetmailPath;
          AreaData.AreaType:=Area_Netmail;

          SystemMode:=smFDSCAN;
          ScanFidoMsgArea (AreaData,TRUE);
          SystemMode:=smNORMAL;

          UpdateAction ('');
     END;
END;


{--------------------------------------------------------------------------}
{ StartWork                                                                }
{                                                                          }
{ This is the big routine that starts the toss, scan, pack and more work.  }
{                                                                          }
PROCEDURE StartWork (WorkToDo : BYTE; WaitKey : BOOLEAN);

VAR Orig_WorkToDo : BYTE;

    PROCEDURE DoSomeWork;
    BEGIN
         { scan }
         IF ((WorkToDo AND WORK_FIDOSCAN) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_FIDOSCAN;
              FidoScan;
              Start_ScannedForFileAttaches:=TRUE;
              Exit;
         END;

         { uucp }
         IF ((WorkToDo AND WORK_UUCPTOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_UUCPTOSS;
              UucpToss;
              Exit;
         END;

         { bag }
         IF ((WorkToDo AND WORK_BAGTOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_BAGTOSS;
              BagToss;
              Exit;
         END;

         { smtp }
         IF ((WorkToDo AND WORK_SMTPTOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_SMTPTOSS;
              SmtpToss;
              Exit;
         END;

         { pop3 }
         IF ((WorkToDo AND WORK_POP3TOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_POP3TOSS;
              Pop3Toss;
              Exit;
         END;

         { toss }
         IF ((WorkToDo AND WORK_FIDOTOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_FIDOTOSS;
              FidoToss;
              Exit;
         END;

    END;


    PROCEDURE CheckSemaphore (WorkCode : BYTE; Semafore : STRING);

    VAR DelFile : FILE;
        IORes   : BYTE;

    BEGIN
         IF GlobalAbort THEN
            Exit;

         IF (TestIfExist (Config.SystemDir+Semafore+'.NOW')) THEN
         BEGIN
              LogMessage ('Found semaphore file '+Semafore+'.NOW');

              IF ((WorkToDo AND WorkCode) > 0) THEN
                 LogExtraMessage (Semafore+' already scheduled')
              ELSE
                  LogExtraMessage ('Added '+Semafore+' to work list');

              WorkToDo:=WorkToDo OR WorkCode;
              Orig_WorkToDo:=Orig_WorkToDo OR WorkCode;

              { verwijder de semaphore }
              Semafore:=Config.SystemDir+Semafore+'.NOW';

              Assign (DelFile,Semafore);
              {$I-} Erase (DelFile); {$I+} IORes:=IOResult;
              IF (IORes <> 0) THEN
              BEGIN
                   LogDiskIOError (IORes,'Error deleting semaphore '+Semafore);
                   GlobalAbort:=TRUE;  { prevent endless loop }
              END;
         END;
    END;

    PROCEDURE CheckSemaphores;
    BEGIN
         CheckSemaphore (WORK_FIDOSCAN,'SCAN');
         CheckSemaphore (WORK_FIDOTOSS,'TOSS');
         CheckSemaphore (WORK_UUCPTOSS,'UUCP');
         CheckSemaphore (WORK_SMTPTOSS,'SMTP');
         CheckSemaphore (WORK_BAGTOSS ,'BAG');
         CheckSemaphore (WORK_POP3TOSS,'POP3');
    END;

VAR WorkList : STRING;

LABEL AbortWork;

BEGIN
     DrawInfoScreen;

     Orig_WorkToDo:=WorkToDo;

     WorkList:='';
     IF (WorkToDo AND WORK_FIDOSCAN) > 0 THEN WorkList:=WorkList+'SCAN, ';
     IF (WorkToDo AND WORK_FIDOTOSS) > 0 THEN WorkList:=WorkList+'TOSS, ';
     IF (WorkToDo AND WORK_UUCPTOSS) > 0 THEN WorkList:=WorkList+'UUCP, ';
     IF (WorkToDo AND WORK_BAGTOSS)  > 0 THEN WorkList:=WorkList+'BAG, ';
     IF (WorkToDo AND WORK_SMTPTOSS) > 0 THEN WorkList:=WorkList+'SMTP, ';
     IF (WorkToDo AND WORK_POP3TOSS) > 0 THEN WorkList:=WorkList+'POP3, ';

     WorkList:=Copy (WorkList,1,Length (WorkList)-2);

     LogMessage ('Requested '+WorkList+' on '+DateStamp);

     LogExtraMessage ('Initial memory: '+Longint2String (MemAvail));
     PeekMem;

     PushKeysLine;
     WriteKeysLine (' ^Esc Abort           Aborting might not be immediate!');

     IF (MemAvail < 50000) THEN
     BEGIN
          LogMessage ('Not enough free memory; aborting');
          GOTO AbortWork;
     END;

     IF (regKeyNumber < $FFFE) THEN
        FidoCreateRegTearLine
     ELSE
         Config.ReplaceTear:=TRUE; { override for un-reg users }

     { left-over initializations }
     FidoMsgInitMsgCount;
     SystemMode:=smNORMAL;

     NewAreasCreated:=0;
     GoSetFDRescan:=FALSE;
     GoSetFMRescan:=FALSE;

     GlobalAbort:=FALSE;

     Start_ScannedForFileAttaches:=FALSE;
     CheckSemaphores; { if scan, then first }

     WHILE (NOT GlobalAbort) AND (WorkToDo <> 0) DO
     BEGIN
          DoSomeWork;
          CheckSemaphores;
     END;

     { check mailing lists for re-confirmation requirements }
     IF (NOT GlobalAbort) THEN
        ListReconfirmCheck;

     { link, if anything except scan }
     IF (NOT GlobalAbort) AND Config.AutoLink AND ((Orig_WorkToDo AND (255-WORK_FIDOSCAN)) > 0) THEN
        LinkOnlySeenAreas;

     { send report to admin }
     Log_SendReport;

     { inform users about new areas }

     { forward area requests }
     ExportAreafixForwardRequests;
     ExportNewsfixForwardRequests;

     { close outbound files }
     WriteEnding0sToAllPkts;
     CloseAllOpenHandles;

     { pack }
     IF (NOT GlobalAbort) THEN
     BEGIN
          Fido_Pack;           { pak de .QQQ files in }
          CloseAllOpenHandles; { MailTunnel e-mails }
     END;

     { close message bases }
     PCBoardMsgBase.CloseBase;
     SquishMsgBase.CloseSquishArea;
     JamMsgBase.CloseBase;

     FidoMsgClearMsgCount;
     FrontDoor_Done;

     { set the rescan files }
     IF GoSetFDRescan THEN
        SetFlagFile (Config.RescanFlagFile);

     IF GoSetFMRescan THEN
        SetFlagFile (Config.RescanFlagFile2);

     IF GlobalAbort THEN
        LogMessage ('Aborted')
     ELSE
         LogMessage ('Completed all requests');

AbortWork:

     UpdateAction ('');

     PopKeysLine;

     LogClose;
     PeekFiles;

     IF WaitKey THEN
     BEGIN
          WriteKeysLine (Spaces (22)+'` Press any key to continue `');

          {$IFDEF OS2}
          DosBeep (500,100);
          DosBeep (700,100);
          DosBeep (900,50);
          {$ELSE}
          Sound (500); NewDelay (100);
          Sound (700); NewDelay (100);
          Sound (900); NewDelay (50);
          NoSound;
          {$ENDIF}

          Ramon.ReadKey;
     END;

     WriteInfoToLogfile;
     LogClose;

     WindowPop; { Info Screen }
END;


{--------------------------------------------------------------------------}
{ CheckMinDiskFree                                                         }
{                                                                          }
{ Deze routine kijkt of er nog genoeg vrije ruimte op ieder van de disks   }
{ is. Zoniet, dan wordt FALSE terug gegeven.                               }
{                                                                          }
FUNCTION CheckMinDiskFree : BOOLEAN;

VAR Lp : BYTE;
    D  : BYTE;
    F,
    M  : LONGINT;

BEGIN
     IF (Config.MinimumDiskFree = 0) OR (Config.DiskFreeDrives = '') THEN
        Exit;

     M:=Config.MinimumDiskFree*Longint(1024)*Longint(1024);

     FOR Lp:=1 TO Length (Config.DiskFreeDrives) DO
     BEGIN
          D:=Ord (Config.DiskFreeDrives[Lp])-Ord ('A')+1;
          F:=DiskFree (D);

          IF (F >= 0) AND (F < M) THEN
          BEGIN
               LogMessage ('Low disk space on drive '+Config.DiskFreeDrives[Lp]+
                           ': ('+Longint2String (Trunc (F/1024/1024))+'Mb); aborting');
               GlobalAbort:=TRUE;
               CheckMinDiskFree:=FALSE; { problemen! }
               Exit;
          END;
     END;

     CheckMinDiskFree:=TRUE; { geen problemen }
END;

{ unit end }
END.
