{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT UserBase;

{ Routines om de UserBase te editten vanuit WtrConf }

{ History:

RvdW 20-02-93 Deze unit afgesplitst uit wtrconf.pas
     26-03-93 DeleteUserBaseRecord aangepast zodat ook alle subscribed
              areas eerst unsubscribed werden, zowel vanuit de UserData
              als de AreaData. Waarschijnlijk werden hierdoor de msgs
              meerdere keren weggeschreven.
     27-03-93 Aliases toegevoegd aan de Usenet nodes.
              DefGroups in EmptyUserDataRecord toegevoegd.
     31-03-93 Globale var. FromUserData toegevoegd ivm wijzigingen door MD
              in FIDO.PAS
              Fido systemen hebben nu ook een UUCPName en Domain adressen.
     03-04-93 Leuk bugje bij het aanmaken van een nieuwe user opgelost. Als
              een nieuwe user werd aangemaakt en op areas aangesloten, dan
              wilde de subscribe routines het UserBase record naar disk
              schrijven ahv het EditRecNr. Maar die was nog niet ingevuld
              en het record bestond nog niet op disk...
     08-09-93 Toevoegen van $IFDEF WtrConf
     18-02-94 Toevoegen van ondersteuning GZip
}

INTERFACE

USES Database;

{$IFDEF WtrConf}
PROCEDURE EmptyUserDataRecord;
PROCEDURE EditSystems (Links : BOOLEAN);
FUNCTION  EditUserBaseRecord (RecNr : UserBaseRecordNrType) : BOOLEAN;
{$ENDIF}


VAR UserData      : UserBaseRecord;
    PacketUserData: UserBaseRecord;
    UserDataRecNr : UserBaseRecordNrType;


IMPLEMENTATION

USES Ramon,
     Globals,
     Cfg,
     Logs,
     Fido,
     Tdb;

{$IFDEF WtrConf}
VAR EditRecNr          : UserBaseRecordNrType;
    FidoAddrDesc       : STRING[MaxLenFidoAddrString]; { 12345:12345/12345.12345 }
    MaxPKTLenStr       : STRING[8];
    ExportAkaStr       : STRING[MaxLenFidoAddrString];
    SystemAkaStr       : STRING[MaxLenFidoAddrString];
    FakeAkaStr         : STRING[17];
    MaxLenExportAkaStr : BYTE;
    MailGradeStr,
    NewsGradeStr       : STRING[1];


{--------------------------------------------------------------------------}
{ FixUserDataRecord                                                        }
{                                                                          }
{ Deze routine maakt de velden van het UserData record op lengte. Alleen   }
{ het System veld moet ingevuld zijn om te kunnen weten welke velden aan-  }
{ gepakt moeten worden.                                                    }
{                                                                          }
PROCEDURE FixUserDataRecord;

VAR DomainLp : 1..MaxDomains;
    ComprLp  : CompressionType;

BEGIN
     WITH UserData DO
     BEGIN
          Organization:=AddUpWithSpaces (MaxLenOrganization,Organization);
          GroupListDesc:=AddUpWithSpaces (54,BuildGroupListDesc (Groups,54));
          AreaFixPwd:=AddUpWithSpaces (MaxLenAreaFixPwd,AreaFixPwd);
          UUCPName:=AddUpWithSpaces (MaxLenUUCPName,UUCPName);

          FOR DomainLp:=1 TO MaxDomains DO
              Domains[DomainLp]:=AddUpWithSpaces (MaxLenDomain,Domains[DomainLp]);

          CASE System OF
               _F :
                   BEGIN
                        FidoAddrDesc:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Address));

                        SysOp:=AddUpWithSpaces (MaxLenSysOpName,SysOp);
                        PacketPwd:=AddUpWithSpaces (8,PacketPwd);

                        MaxPKTLenStr:=AddUpWithSpaces (8,Longint2String (MaxPKTLength));

                        IF (ExportAka = 0) THEN
                           ExportAkaStr:='Automatic'
                        ELSE
                            ExportAkaStr:=Fido2Str (Config.NodeNrs[ExportAka]);

                        MaxLenExportAkaStr:=MaxLenFidoAddrString;
                        ExportAkaStr:=AddUpWithSpaces (MaxLenExportAkaStr,ExportAkaStr);
                   END;

               _B :
                   BEGIN
                        BAGBackLink:=AddUpWithSpaces (MaxLenUUCPName,BAGBackLink);
                        BagPath:=AddUpWithSpaces (MaxLenPath,BagPath);
                   END;

               _S :
                   BEGIN
                        SmtpInPath:=AddUpWithSpaces (MaxLenPath,SmtpInPath);
                        SmtpOutPath:=AddUpWithSpaces (MaxLenPath,SmtpOutPath);
                   END;

               _P :
                   BEGIN
                        Pop3File:=AddUpWithSpaces (MaxLenPath,Pop3File);
                        Recipient:=AddUpWithSpaces (MaxLenDomain,Recipient);
                        Separator:=AddUpWithSpaces (15,Separator);
                        EnvelopeHdr:=AddUpWithSpaces (25,EnvelopeHdr);
                   END;

               _BBS :
                   BEGIN
                        Inbound:=AddUpWithSpaces (MaxLenPath,Inbound);
                        Outbound:=AddUpWithSpaces (MaxLenPath,Outbound);
                        SystemAkaStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[SystemAka]));
                        FakeAkaStr:=AddUpWithSpaces (17,Word2String (FakeZone)+':'+
                                                        Word2String (FakeNet)+'/'+
                                                        Word2String (FakeNode));
                        InboundExt:=AddUpWithSpaces (3,InboundExt);
                   END;
          END; { case }
     END; { with }
END;


{--------------------------------------------------------------------------}
{ EmptyUserDataRecord                                                      }
{                                                                          }
{ Deze routine initialiseert alle velden van het UserData record en roept  }
{ daarna FixUserDataRecord aan om de velden op lengte te laten maken.      }
{ Alleen het System veld laat ie met rust, dat moet al ingevuld zijn en    }
{ alleen de velden van dat systeem worden geinitialiseerd.                 }
{                                                                          }
PROCEDURE EmptyUserDataRecord;

VAR DomainLp : 1..MaxDomains;

BEGIN
     WITH UserData DO
     BEGIN
          Deleted:=FALSE;
          Organization:='';
          Passive:=FALSE;
          AreaFixPwd:='';
          AllowFrom:=FALSE;
          AllowCreate:=FALSE;
          AreaList:=NILRecordNr;
          UUCPName:='';
          WorldReg:=FALSE;
          AllowSubDomains:=FALSE;
          FOR DomainLp:=1 TO MaxDomains DO
              Domains[DomainLp]:='';

          Groups:=Config.DefGroups_U;

          CASE System OF
               _F :
                   BEGIN
                        Groups:=Config.DefGroups_F;
                        Address.Zone:=0;
                        Address.Net:=0;
                        Address.Node:=0;
                        Address.Point:=0;
                        Address.Domain:='';
                        SysOp:='';
                        PacketPwd:='';
                        Compression:=Config.DefaultCompressor;
                        SendFormat:=NORMAL;
                        MaxPKTLength:=0;
                        { RWI 951111: nieuwe velden }
                        LastArchDow:=0;
                        LastArchNr:=0;
                        ExportAka:=0;
                        DecodeFiles:=FALSE;
                   END;

               _U :
                   BEGIN
                        Compress:=USE_COMPRESS;
                        CunBatch:=TRUE;
                        MailGrade:='A';
                        NewsGrade:='Z';
                        GigoT:=FALSE;
                   END;

               _B :
                   BEGIN
                        BAGBackLink:='';
                        BagPath:='';
                   END;

               _S :
                   BEGIN
                        SmtpInPath:='';
                        SmtpOutPath:='';
                   END;

               _P :
                   BEGIN
                        Pop3File:='';
                        Recipient:='example@yourdomain';
                        Separator:='From ';
                        EnvelopeHdr:='X-Envelope-To:';
                   END;

               _BBS :
                   BEGIN
                        Groups:=Config.DefGroups_F;
                        Inbound:='';
                        Outbound:='';
                        FakeZone:=0;
                        FakeNet:=0;
                        FakeNode:=0;
                        SystemAKA:=1;
                        InboundExt:='PKT';
                        KeepSBP:=FALSE;
                        Reserved1:=0;
                   END;

          END; { case }
     END; { with }

     FixUserDataRecord;
END;


{--------------------------------------------------------------------------}
{ EditUserDataGroupsList                                                   }
{                                                                          }
{ Met deze routine kan de Groups variabele in het UserData veld aangepast  }
{ worden. Ook wordt de GroupListDesc aangepast bij het verlaten van deze   }
{ routine.                                                                 }
{                                                                          }
PROCEDURE EditUserDataGroupsList; FAR;
BEGIN
     EditGroupsList (UserData.Groups,
                     'User is allowed in these groups',
                     '<user is not allowed in any group>',
                     1302,1303);
END;


{--------------------------------------------------------------------------}
{ EditUserDataSubscrToList                                                 }
{                                                                          }
{ Met deze routine kunnen de aangesloten areas voor een User bekeken word- }
{ en eventueel uitgebreid.                                                 }
{                                                                          }
PROCEDURE EditUserDataSubscrToList; FAR;

VAR Rebuild,
    First,
    Quit2,
    Quit     : BOOLEAN;
    Search   : SubscrSearchRecord;
    Keuze,
    Keuze2,
    Lp       : WORD;
    Lp2      : AreaBaseRecordNrType;
    AreaData : AreaBaseRecord;

    {----------------------------------------------------------------------}
    { AddAreaToList                                                        }
    {                                                                      }
    { Deze routine voegt de omschrijving van de area toe aan de lijst.     }
    {                                                                      }
    PROCEDURE AddAreaToList (Index : WORD);
    BEGIN
         IF (UserData.System = _F) AND (AreaData.AreaName_F <> '') THEN
            ListAddItem (AreaData.AreaName_F,Index,Bottom{Sorted})
         ELSE
             ListAddItem (AreaData.AreaName_U,Index,Bottom{Sorted});

         (*
         { dit moet aangepast worden zodat de naam van de betreffende }
         { area gekozen wordt aan de hand van het user type.          }
         IF (AreaData.AreaName_F = '') THEN
            ListAddItem (AreaData.AreaName_U,Index,Bottom{Sorted})
         ELSE
            ListAddItem (AreaData.AreaName_F,Index,Bottom{Sorted});
         *)
    END;

    PROCEDURE AddAreaToPrevList (Index : WORD);
    BEGIN
         IF (UserData.System = _F) AND (AreaData.AreaName_F <> '') THEN
            ListAddItemToPrevList (AreaData.AreaName_F,Index,Sorted)
         ELSE
             ListAddItemToPrevList (AreaData.AreaName_U,Index,Sorted);
         (*
         { dit moet aangepast worden zodat de naam van de betreffende }
         { area gekozen wordt aan de hand van het user type.          }
         IF (AreaData.AreaName_F = '') THEN
            ListAddItemToPrevList (AreaData.AreaName_U,Index,Sorted)
         ELSE
             ListAddItemToPrevList (AreaData.AreaName_F,Index,Sorted);
         *)
    END;

VAR AreasExpect,
    AreasCount,
    HulpCount   : WORD;
    PercDone    : BYTE;

BEGIN
     ListDefine (3,3,39,Video.Rows-4,Default,'Areas subscribed to',1222);

     Message ('Reading areas user is subscribed to  (0%)  ');

     AreasExpect:=CountSubscribedAreas (UserData.AreaList);
     AreasCount:=0;

     GetFirstAreaUserIsSubscribedTo (UserData.AreaList,Search);
     WHILE (Search.Found) DO
     BEGIN
          ReadAreaBaseRecord (Search.AreaBaseRecordNr,AreaData);
          AddAreaToList (Search.AreaBaseRecordNr);
          Inc (AreasCount);
          GetNextAreaUserIsSubscribedTo (Search);

          PercDone:=Round ((AreasCount/AreasExpect)*100);
          WriteXYC (50,MessageYB,cMessage,
                                   RepChar (PercDone DIV 10,'')+
                                   RepChar (10-(PercDone DIV 10),'')+
                                   ' ('+Byte2String (PercDone)+'%)');

          { kijk of de user wil aborten }
          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               WindowPop;
               ListErase;
               Exit;
          END;
     END; { while }

     WindowPop; { message }

     ListSortNow;

     Quit:=FALSE;
     REPEAT
           IF (ListItemCount = 0) THEN
              ListAddItem ('<not subscribed to any area>',65534,Bottom);

           Keuze:=ListSelect (DoTag,[kIns,kDel]);

           ListRemoveItem (65534);

           CASE Key OF
                kIns : BEGIN
                            ListDefine (77,3,39,Video.Rows-4,TopRight,'Allowed areas not subscribed to',1223);

                            Message ('Reading areas user is not subscribed to  (0%)  ');

                            Quit2:=FALSE;

                            AreasExpect:=AreaBaseRecCount;

                            FOR Lp2:=1 TO AreasExpect DO
                            BEGIN
                                 ReadAreaBaseRecord (Lp2,AreaData);

                                 { RWI 950727: ListItemNrInPrevList gemaakt en onderstaande }
                                 {             vervangen.                                   }
                                 { (NOT TestIfAreaIsInUserRec_AreaList (UserData.AreaList,Lp2))}

                                 IF (NOT AreaData.Deleted) AND
                                    TestIfGroupCommon (AreaData.IsInGroups,UserData.Groups) AND
                { RWI 960929 }      (AreaData.AreaType IN [Area_Echo,Area_Local]) AND
                                    (NOT ListItemNrInPrevList (Lp2))
                                 THEN
                                     AddAreaToList (Lp2);

                                 PercDone:=Round ((Lp2/AreasExpect)*100);
                                 WriteXYC (52,MessageYB,cMessage,
                                                          RepChar (PercDone DIV 10,'')+
                                                          RepChar (10-(PercDone DIV 10),'')+
                                                          ' ('+Byte2String (PercDone)+'%)');

                                 { kijk of de user wil aborten }
                                 IF KeyPressed AND (ReadKey = kEsc) THEN
                                 BEGIN
                                      Quit2:=TRUE;
                                      Break; { uit de for }
                                 END;
                            END;

                            WindowPop; { message }

                            IF Quit2 THEN
                            BEGIN
                                 ListErase;
                                 Continue; { met de buitenste repeat/until }
                            END;

                            ListSortNow;

                            IF (ListItemCount = 0) THEN
                               ListAddItem ('<already subscribed to all areas>',65534,Bottom);

                            Quit2:=FALSE;
                            REPEAT
                                  Keuze2:=ListSelect (DoTag,[]);

                                  CASE Key OF
                                       kEsc : Quit2:=TRUE;

                                       kRet : BEGIN
                                                   IF (ListTagCount = 0) THEN
                                                   BEGIN
                                                        AddAreaToUserSubscrToList (UserData,Keuze2);

                                                        ReadAreaBaseRecord (Keuze2,AreaData);
                                                        AddUserToAreaSubscrList (AreaData,EditRecNr);
                                                        WriteAreaBaseRecord (Keuze2,AreaData);

                                                        AddAreaToPrevList (Keuze2);
                                                   END ELSE
                                                   BEGIN
                                                        Message ('Connecting areas  (0%)  ');

                                                        FOR Lp:=1 TO ListTagCount DO
                                                        BEGIN
                                                             Keuze2:=ListGetTaggedItemNr (Lp);

                                                             AddAreaToUserSubscrToList (UserData,Keuze2);
                                                             ReadAreaBaseRecord (Keuze2,AreaData);
                                                             AddUserToAreaSubscrList (AreaData,EditRecNr);
                                                             WriteAreaBaseRecord (Keuze2,AreaData);

                                                             AddAreaToPrevList (Keuze2);

                                                             PercDone:=Round ((Lp/ListTagCount)*100);
                                                             WriteXYC (41,MessageYB,cMessage,
                                                                                      RepChar (PercDone DIV 10,'')+
                                                                                      RepChar (10-(PercDone DIV 10),'')+
                                                                                      ' ('+Byte2String (PercDone)+'%)');

                                                             IF KeyPressed AND (ReadKey = kEsc) THEN
                                                                Break; { uit de for }
                                                        END; { for }

                                                        WindowPop; { message }
                                                   END;

                                                   WriteUserBaseRecord (EditRecNr,UserData);

                                                   Quit2:=TRUE;
                                              END;
                                  END; { case }
                            UNTIL Quit2;

                            ListErase;
                       END;

                kDel : BEGIN
                            IF (ListTagCount = 0) THEN
                            BEGIN
                                 IF (Keuze < 65000) AND (AreYouSureWithHelp ('Unsubscribe this area?',1224) = mOpt01) THEN
                                 BEGIN
                                      RemoveAreaFromUserSubscrToList (UserData,Keuze);

                                      ReadAreaBaseRecord (Keuze,AreaData);
                                      RemoveUserFromAreaSubscrList (AreaData,EditRecNr);
                                      WriteAreaBaseRecord (Keuze,AreaData);

                                      WriteUserBaseRecord (EditRecNr,UserData);

                                      ListRemoveItem (Keuze);
                                 END;
                            END ELSE
                                IF (AreYouSureWithHelp ('Unsubscribe these areas?',1224) = mOpt01) THEN
                                BEGIN
                                     Message ('Unsubscribing areas  (0%)  ');

                                     HulpCount:=ListTagCount;
                                     WHILE (ListTagCount > 0) DO
                                     BEGIN
                                          Keuze:=ListGetTaggedItemNr (1);

                                          RemoveAreaFromUserSubscrToList (UserData,Keuze);

                                          ReadAreaBaseRecord (Keuze,AreaData);
                                          RemoveUserFromAreaSubscrList (AreaData,EditRecNr);
                                          WriteAreaBaseRecord (Keuze,AreaData);

                                          WriteUserBaseRecord (EditRecNr,UserData);

                                          ListRemoveItem (Keuze);

                                          PercDone:=Round (((HulpCount-ListTagCount)/HulpCount)*100);
                                          WriteXYC (42,MessageYB,cMessage,
                                                                   RepChar (PercDone DIV 10,'')+
                                                                   RepChar (10-(PercDone DIV 10),'')+
                                                                   ' ('+Byte2String (PercDone)+'%)');

                                          IF KeyPressed AND (ReadKey = kEsc) THEN
                                             Break; { uit de while }

                                     END; { while }

                                     WindowPop; { message }
                                END;
                       END; { kDel }

                kEsc : Quit:=TRUE;
           END; { case }
     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ CheckUserDataFidoAddr                                                    }
{                                                                          }
{ Met deze routine kan het fido address in UserData gewijzigd worden.      }
{                                                                          }
FUNCTION CheckUserDataFidoAddr (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     FidoSplit (DeleteBackSpaces (BufferPtr^),UserData.Address);
     BufferPtr^:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (UserData.Address));
     CheckUserDataFidoAddr:=TRUE;
END;


{--------------------------------------------------------------------------}
{ EditUserDataExportAka                                                    }
{                                                                          }
{ Met deze routine kan de ExportAka gekozen worden.                        }
{                                                                          }
PROCEDURE EditUserDataExportAka; FAR;

VAR AkaLp : 1..MaxAKAs;
    Keuze : WORD;

BEGIN
     ListDefine (40,7,30,Video.Rows-15,Default,'Export AKA selection',1063);

     FOR AkaLp:=1 TO MaxAKAs DO
         IF (Fido2Str (Config.NodeNrs[AkaLp]) <> '0') THEN
            ListAddItem (Fido2Str (Config.NodeNrs[AkaLp]),AkaLp,Sorted);

     ListAddItem ('Automatic',0,Top);
     ListSetCursorOnItem (UserData.ExportAKA);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
        UserData.ExportAKA:=Keuze;

     IF (UserData.ExportAKA = 0) THEN
        ExportAkaStr:='Automatic'
     ELSE
         ExportAkaStr:=Fido2Str (Config.NodeNrs[UserData.ExportAka]);

     ExportAkaStr:=AddUpWithSpaces (MaxLenExportAkaStr,ExportAkaStr);

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditUserDataSystemAka                                                    }
{                                                                          }
{ Met deze routine kan de SystemAka voor een BBS Interface link gekozen    }
{ worden.                                                                  }
{                                                                          }
PROCEDURE EditUserDataSystemAka; FAR;

VAR AkaLp : 1..MaxAKAs;
    Keuze : WORD;

BEGIN
     ListDefine (40,7,30,Video.Rows-15,Default,'System AKA selection',1064);

     FOR AkaLp:=1 TO MaxAKAs DO
         IF (Fido2Str (Config.NodeNrs[AkaLp]) <> '0') THEN
            ListAddItem (Fido2Str (Config.NodeNrs[AkaLp]),AkaLp,Sorted);

     ListSetCursorOnItem (UserData.SystemAka);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
        UserData.SystemAka :=Keuze;

     SystemAkaStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[UserData.SystemAka]));

     ListErase;
END;


{--------------------------------------------------------------------------}
{ CheckGrayCunBatch                                                        }
{                                                                          }
{ Deze routine wordt aangeroepen als de UUCP compressie vorm veranderd     }
{ is. Als de compressie nu op NONE staat, dan wordt het CunBatch veld      }
{ grijs gemaakt.                                                           }
{                                                                          }
PROCEDURE CheckGrayCunBatch; FAR;
BEGIN
     IF (UserData.Compress = USE_NONE) THEN
        FieldDisableField (LastFieldNr+1)
     ELSE
         FieldEnableField (LastFieldNr+1);

     FieldUpdateOneField (LastFieldNr+1);
END;


{--------------------------------------------------------------------------}
{ CheckFirstDomain                                                         }
{                                                                          }
{ Deze routine checkt het eerste domain adres dat ingevoerd wordt. Hier    }
{ mag namelijk geen routing informatie in staan, zoals een punt aan het    }
{ begin. Ook apestaartjes op de eerste positie zijn verkeerd.              }
{                                                                          }
FUNCTION CheckFirstDomain (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     IF (BufferPtr^ = '') THEN
     BEGIN
          CheckFirstDomain:=TRUE;  { no problemo }
          Exit;
     END;

     IF (BufferPtr^[1] = '@') THEN
     BEGIN
          Error ('A domain name never starts with a @ sign.');
          CheckFirstDomain:=FALSE;
          Exit;
     END;

     IF (BufferPtr^[1] = '.') THEN
     BEGIN
          Error2Lines ('The first domain must not start with a dot!',
                       'Press Escape and F1 for more information.');
          CheckFirstDomain:=FALSE;
          Exit;
     END;

     CheckFirstDomain:=TRUE; { no problemos }
END;


{--------------------------------------------------------------------------}
{ CheckOtherDomain                                                         }
{                                                                          }
FUNCTION CheckOtherDomain (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     CheckOtherDomain:=TRUE;  { assume no problems }

     IF (BufferPtr^ = '') THEN
        Exit;

     IF (BufferPtr^[1] = '@') THEN
     BEGIN
          Error ('A domain name never starts with a @ sign.');
          CheckOtherDomain:=FALSE;
          Exit;
     END;

     { return result is TRUE }
END;


{--------------------------------------------------------------------------}
{ CheckRecipient                                                           }
{                                                                          }
FUNCTION CheckRecipient (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     IF (Pos (' ',DeleteFrontAndBackSpaces (BufferPtr^)) > 0) THEN
     BEGIN
          Error ('An e-mail address does not contain spaces');
          CheckRecipient:=FALSE;
     END ELSE
         CheckRecipient:=TRUE;
END;


{--------------------------------------------------------------------------}
{ BagFileMgr                                                               }
{                                                                          }
{ Deze routine roept de file manager aan voor BAG files. Als er een zoek   }
{ patroon aan het einde staat, dan wordt die eraf gekapt, waarna er naar   }
{ directories kan worden gezocht en de zoekstring/file er weer aangeplakt  }
{ wordt.                                                                   }
{                                                                          }
PROCEDURE BagFileMgr (BufferPtr : StringPtr); FAR;

VAR ZoekStr : STRING;

BEGIN
     BufferPtr^:=DeleteFrontAndBackSpaces (BufferPtr^);

     ZoekStr:='';

     IF (BufferPtr^ <> '') AND (Pos ('\',BufferPtr^) = 0) THEN
        Error ('Not matching expected format D:\DIR\*.EXT')
     ELSE BEGIN
          WHILE (BufferPtr^ <> '') AND (BufferPtr^[Length (BufferPtr^)] <> '\') DO
          BEGIN
               ZoekStr:=BufferPtr^[Length (BufferPtr^)]+ZoekStr;
               Delete (BufferPtr^,Length (BufferPtr^),1);
          END;
     END;

     BufferPtr^:=FileManager (BufferPtr^,'','*.*');

     IF (BufferPtr^[Length (BufferPtr^)] = '\') THEN
        BufferPtr^:=BufferPtr^+ZoekStr;

     BufferPtr^:=AddUpWithSpaces (MaxLenPath,BufferPtr^);
END;


{--------------------------------------------------------------------------}
{ Pop3FileMgr                                                              }
{                                                                          }
{ Deze routine roept de file manager aan voor POP3 file selectie.          }
{                                                                          }
PROCEDURE Pop3FileMgr (BufferPtr : StringPtr); FAR;

VAR ZoekStr : STRING;

BEGIN
     BufferPtr^:=DeleteFrontAndBackSpaces (BufferPtr^);
     BufferPtr^:=FileManager (BufferPtr^,'','*.*');
     BufferPtr^:=AddUpWithSpaces (MaxLenPath,BufferPtr^);
END;


{--------------------------------------------------------------------------}
{ CheckFakeAka                                                             }
{                                                                          }
{ Deze routine interpreteert en controleerd het ingevoerde fake aka veld   }
{ en slaat de nieuwe input op in de velden.                                }
{                                                                          }
FUNCTION CheckFakeAka (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR HulpAka : FidoAddrType;

BEGIN
     FidoSplit (DeleteFrontAndBackSpaces (BufferPtr^),HulpAka);

     WITH UserData DO
     BEGIN
          FakeZone:=HulpAka.Zone;
          FakeNet:=HulpAka.Net;
          FakeNode:=HulpAka.Node;

          BufferPtr^:=AddUpWithSpaces (17,Word2String (FakeZone)+':'+
                                          Word2String (FakeNet)+'/'+
                                          Word2String (FakeNode));
     END; { with }

     CheckFakeAka:=TRUE; { no problemos }
END;


{--------------------------------------------------------------------------}
{ DrawUserBaseRecordScreen                                                 }
{                                                                          }
{ Deze routine tekent het scherm waarin de User Database gegevens verwerkt }
{ kunnen worden. Ook de Fields worden hier gedefinieerd. Wel moet in       }
{ UserData.System het systeem type te vinden zijn omdat dit andere velden  }
{ oplevert. De Fields worden gelinkt aan de globale UserData variabele.    }
{                                                                          }
PROCEDURE DrawUserBaseRecordScreen;

VAR DomainLp     : 1..MaxDomains;
    SystemDesc   : STRING[20];
    FieldY       : XYType;
    Xb,Yb,Xl,Yl  : XYType;

BEGIN
     Xb:=2;
     Xl:=76;

     CASE UserData.System OF
          _F :
              BEGIN
                   SystemDesc:='FTN style user';

                   Yb:=3;

                   IF (Video.Rows > 25) THEN
                      Yl:=24
                   ELSE BEGIN
                        Yl:=21;

                        MaxLenExportAkaStr:=20;
                        ExportAkaStr:=Copy (ExportAkaStr,1,MaxLenExportAkaStr);
                   END;
              END;

          _U :
              BEGIN
                   SystemDesc:='UUCP style user';

                   Yb:=2;
                   Yl:=22;

                   IF (Video.Rows > 25) THEN
                      Inc (Yb);

                   IF NOT (UserData.MailGrade IN ['A'..'Z']) THEN
                      UserData.MailGrade:='A';

                   IF NOT (UserData.NewsGrade IN ['A'..'Z']) THEN
                      UserData.NewsGrade:='Z';

                   MailGradeStr:=UserData.MailGrade;
                   NewsGradeStr:=UserData.NewsGrade;
              END;

          _B :
              BEGIN
                   SystemDesc:='BAG supplier link';

                   Yb:=5;
                   Yl:=9;
              END;

          _S :
              BEGIN
                   SystemDesc:='SMTP mailer link ';

                   Yb:=5;
                   Yl:=13;
              END;

          _P :
              BEGIN
                   SystemDesc:='POP3 mailbox link';

                   Yb:=5;
                   Yl:=7;
              END;

          _BBS :
              BEGIN
                   SystemDesc:='BBS Interface link';

                   Yb:=5;
                   Yl:=11;
              END;

     END; { case }

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);
     WriteXY (Xb+2,Yb,'['+SystemDesc+']');

     FieldInit;

     SetLines (Single);
     FieldY:=Yb;

     IF (UserData.System = _F) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Address');
          FieldAutoDefineCheckOne (Xb+20,FieldY,@FidoAddrDesc,
                                   RepChar (MaxLenFidoAddrString,'$'),CheckUserDataFidoAddr);
          FieldSetHelp (0,1215);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SysOp');
          FieldAutoDefineOne (Xb+20,FieldY,@UserData.Sysop,RepChar (MaxLenSysopName,'$'));
          FieldSetHelp (0,1216);
     END;

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Organization');
     FieldAutoDefineLongOne (Xb+20,FieldY,54,@UserData.Organization,RepChar (MaxLenOrganization,'$'));

     IF (UserData.System IN [_F,_BBS]) THEN
        FieldSetHelp (0,1203)
     ELSE
         FieldSetHelp (0,1199);

     IF NOT (UserData.System IN [_S,_P]) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Allowed groups');
          FieldAutoDefineList (Xb+20,FieldY,@GroupListDesc,EditUserDataGroupsList);
          FieldSetHelp (0,1204);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Subscribed to');
          FieldAutoDefineList (Xb+20,FieldY,@DotDotDot,EditUserDataSubscrToList);
          FieldSetHelp (0,1205);
     END;

     IF (UserData.System = _F) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'AreaFix password');
          FieldAutoDefineOne (Xb+20,FieldY,@UserData.AreaFixPwd,RepChar (MaxLenAreaFixPwd,'$'));
          FieldSetHelp (0,1218);

          IF (Yl > 23) THEN
          BEGIN
               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'AreaFix special');
               FieldAutoDefineToggles (Xb+20,FieldY,UserData.AllowFrom,'no|yes',0);
               FieldSetHelp (0,1208);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Create new areas');
               FieldAutoDefineToggles (Xb+20,FieldY,UserData.AllowCreate,'no|yes',0);
               FieldSetHelp (0,1209);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Passive');
               FieldAutoDefineToggles (Xb+20,FieldY,UserData.Passive,'no|yes',0);
               FieldSetHelp (0,1206);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'PKT password');
               FieldAutoDefineOne (Xb+20,FieldY,@UserData.PacketPwd,RepChar (8,'$'));
               FieldSetHelp (0,1217);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Export AKA');
               FieldAutoDefineList (Xb+20,FieldY,@ExportAkaStr,EditUserDataExportAka);
               FieldSetHelp (0,1063);
          END ELSE
          BEGIN
               WriteXY (Xb+42,FieldY,VR+' AreaFix special');
               FieldAutoDefineToggles (Xb+61,FieldY,UserData.AllowFrom,'no|yes',0);
               FieldSetHelp (0,1208);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'PKT password');
               FieldAutoDefineOne (Xb+20,FieldY,@UserData.PacketPwd,RepChar (8,'$'));
               FieldSetHelp (0,1217);

               WriteXY (Xb+42,FieldY,VR+' Passive');
               FieldAutoDefineToggles (Xb+61,FieldY,UserData.Passive,'no|yes',0);
               FieldSetHelp (0,1206);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Export AKA');
               FieldAutoDefineList (Xb+20,FieldY,@ExportAkaStr,EditUserDataExportAka);
               FieldSetHelp (0,1063);

               WriteXY (Xb+42,FieldY,VR+' Create new areas');
               FieldAutoDefineToggles (Xb+61,FieldY,UserData.AllowCreate,'no|yes',0);
               FieldSetHelp (0,1209);
          END;

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Max. PKT length');
          FieldAutoDefineOne (Xb+20,FieldY,@MaxPKTLenStr,RepChar (8,'%'));
          FieldSetHelp (0,1221);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Compression');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.Compression,'arc|arj|lzh|pak|zip|zoo|rar|op1||pkt',0);
          FieldSetHelp (0,1219);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Send format');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.SendFormat,'normal|hold|crash|direct',0);
          FieldSetHelp (0,1220);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Decode files');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.DecodeFiles,'no|yes',0);
          FieldSetHelp (0,1230);

          FieldDisableField (0);
     END;

     IF (UserData.System = _U) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Passive');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.Passive,'no|yes',0);
          FieldSetHelp (0,1206);
     END;

     IF (UserData.System IN [_U,_B]) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Create new areas');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.AllowCreate,'no|yes',0);
          FieldSetHelp (0,1209);
     END;

     IF (UserData.System = _S) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SMTP-In path');
          FieldAutoDefineFileMgr (Xb+20,FieldY,54,@UserData.SmtpInPath,PathFileMgr);
          FieldSetHelp (0,1228);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SMTP-Out path');
          FieldAutoDefineFileMgr (Xb+20,FieldY,54,@UserData.SmtpOutPath,PathFileMgr);
          FieldSetHelp (0,1229);
     END;

     IF (UserData.System = _B) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Search path');
          FieldAutoDefineFileMgr (Xb+20,FieldY,54,@UserData.BagPath,BagFileMgr);
          FieldSetHelp (0,1231);
     END;

     IF (UserData.System IN [_U,_B,_S]) THEN
     BEGIN
          Inc (FieldY);
          FieldAutoDefineOne (Xb+20,FieldY,@UserData.UUCPName,RepChar (MaxLenUUCPName,'$'));

          CASE UserData.System OF
               _U : BEGIN
                         WriteXY (Xb+2,FieldY,'UUCP name');
                         FieldSetHelp (0,1212);
                    END;

               _S : BEGIN
                         WriteXY (Xb+2,FieldY,'System name');
                         FieldSetHelp (0,1232)
                    END;

               _B : BEGIN
                         WriteXY (Xb+2,FieldY,'Spool subdir');
                         FieldSetHelp (0,1233);
                    END;
          END; { case }
     END;

     IF (UserData.System = _U) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'NewsFix password');
          FieldAutoDefineOne (Xb+20,FieldY,@UserData.AreaFixPwd,RepChar (MaxLenAreaFixPwd,'$'));
          FieldSetHelp (0,1207);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'NewsFix special');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.AllowFrom,'no|yes',0);
          FieldSetHelp (0,1208);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Compress');
          FieldAutoDefineTogglesCall (Xb+20,FieldY,UserData.Compress,'none|compress|gzip',0,CheckGrayCunBatch);
          FieldSetHelp (0,1210);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Add batch header');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.CunBatch,'no|yes',0);
          FieldSetHelp (0,1211);

          IF (UserData.Compress = USE_NONE) THEN
             FieldDisableField (0);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Mail grade');
          FieldAutoDefineOne (Xb+20,FieldY,@MailGradeStr,'@');
          FieldSetHelp (0,1083);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'News grade');
          FieldAutoDefineOne (Xb+20,FieldY,@NewsGradeStr,'@');
          FieldSetHelp (0,1083);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'GigoT specials');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.GigoT,'no|yes',0);
          FieldSetHelp (0,1234);
     END;

     IF (UserData.System = _B) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Return system');
          FieldAutoDefineOne (Xb+20,FieldY,@UserData.BAGBackLink,RepChar (MaxLenUUCPName,'$'));
          FieldSetHelp (0,1225);
     END;

     { the following two or three fields can be left out for bag suppliers... }
     { RWI 960714: did just that }

     IF (UserData.System IN [_F,_U,_S]) THEN
     BEGIN
          {
          IF (UserData.System <> _F) OR (Yl > 23) THEN
          BEGIN
               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'World registered');
               FieldAutoDefineToggles (Xb+20,FieldY,UserData.WorldReg,'no|yes',0);
               FieldSetHelp (0,1213);
          END;
          }

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Allow sub-domains');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.AllowSubDomains,'no|yes',0);
          FieldSetHelp (0,1226);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Domain addresses');
          FieldAutoDefineCheckOne (Xb+20,FieldY,@UserData.Domains[1],RepChar (MaxLenDomain,'$'),CheckFirstDomain);
          FieldSetHelp (0,1214);

          Inc (FieldY);
          FOR DomainLp:=2 TO MaxDomains{=6} DO
          BEGIN
               FieldAutoDefineCheckOne (Xb+20,FieldY,@UserData.Domains[DomainLp],RepChar (MaxLenDomain,'$'),CheckOtherDomain);
               FieldSetHelp (0,1214);
               Inc (FieldY);
          END; { for }
     END;

     IF (UserData.System = _P) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Mailbox path');
          FieldAutoDefineFileMgr (Xb+20,FieldY,54,@UserData.Pop3File,Pop3FileMgr);
          FieldSetHelp (0,4600);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Message separator');
          FieldAutoDefineOne (Xb+20,FieldY,@UserData.Separator,RepChar (15,'$'));
          FieldSetHelp (0,4602);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Envelope header');
          FieldAutoDefineOne (Xb+20,FieldY,@UserData.EnvelopeHdr,RepChar (25,'$'));
          FieldSetHelp (0,4603);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Single recipient');
          FieldAutoDefineCheckOne (Xb+20,FieldY,@UserData.Recipient,RepChar (MaxLenDomain,'$'),CheckRecipient);
          FieldSetHelp (0,4601);
     END;

     IF (UserData.System = _BBS) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'System AKA');
          FieldAutoDefineList (Xb+20,FieldY,@SystemAkaStr,EditUserDataSystemAka);
          FieldSetHelp (0,1064);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Fake AKA');
          FieldAutoDefineCheckOne (Xb+20,FieldY,@FakeAkaStr,RepChar (17,'$'),CheckFakeAka);
          FieldSetHelp (0,1065);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SEEN-BY and PATH');
          FieldAutoDefineToggles (Xb+20,FieldY,UserData.KeepSBP,'strip|keep',0);
          FieldSetHelp (0,1069);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Inbound');
          FieldAutoDefineFileMgr (Xb+20,FieldY,54,@UserData.Inbound,PathFileMgr);
          FieldSetHelp (0,1066);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Packet extension');
          FieldAutoDefineOne (Xb+20,FieldY,@UserData.InboundExt,'$$$');
          FieldSetHelp (0,1068);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Outbound');
          FieldAutoDefineFileMgr (Xb+20,FieldY,54,@UserData.Outbound,PathFileMgr);
          FieldSetHelp (0,1067);
     END;

     { set cursor on subscribed to field }
     IF (UserData.System = _F) THEN
     BEGIN
          IF (DeleteBackSpaces (FidoAddrDesc) <> '0') THEN
             FieldSetFirst (5); { subscribed to }
     END ELSE
         IF NOT (UserData.System IN [_S,_P]) THEN
            FieldSetFirst (3);

     IF (UserData.System = _U) THEN
     BEGIN
          UserData.MailGrade:=MailGradeStr[1];
          UserData.NewsGrade:=NewsGradeStr[1];
     END;
END;


{--------------------------------------------------------------------------}
{ CleanEdittedUserRecord                                                   }
{                                                                          }
{ Deze routine wordt aangeroepen na het editten van een bestaand als een   }
{ nieuw record. Hier worden alles velden van spaties ontdaan en tussen-    }
{ buffers omgezet in nummers.                                              }
{                                                                          }
{ RWI 960811: aangemaakt ivm inconsistenties tussen new user en edit user. }
{                                                                          }
PROCEDURE CleanEdittedUserRecord;

VAR DomTel : 1..MaxDomains;
    Fout   : ValNop;

BEGIN
     WITH UserData DO
     BEGIN
          { bij deze deletebackspaces eerst controleren bij }
          { welk type deze hoort ivm velden die over elkaar }
          { heen liggen voor fido en uucp!!                 }

          { globaal }
          Organization:=DeleteFrontAndBackSpaces (Organization);
          AreaFixPwd:=DeleteFrontAndBackSpaces (AreaFixPwd);
          UUCPName:=DeleteFrontAndBackSpaces (UUCPName);

          FOR DomTel:=1 TO MaxDomains DO
              Domains[DomTel]:=DeleteFrontAndBackSpaces (Domains[DomTel]);

          CASE System OF
               _F :
                   BEGIN
                        PacketPwd:=DeleteFrontAndBackSpaces (PacketPwd);
                        Sysop:=DeleteFrontAndBackSpaces (Sysop);
                        Val (DeleteBackSpaces (MaxPKTLenStr),MaxPktLength,Fout);
                   END;

               _U :
                   BEGIN
                        MailGrade:=MailGradeStr[1];
                        IF NOT (MailGrade IN ['A'..'Z']) THEN
                           MailGrade:='A';

                        NewsGrade:=NewsGradeStr[1];
                        IF NOT (NewsGrade IN ['A'..'Z']) THEN
                           NewsGrade:='A';
                   END;

               _B :
                   BEGIN
                        BAGBackLink:=DeleteFrontAndBackSpaces (BAGBackLink);
                        BagPath:=DeleteFrontAndBackSpaces (BagPath);
                   END;

               _S :
                   BEGIN
                        SmtpInPath:=DeleteFrontAndBackSpaces (SmtpInPath);
                        SmtpOutPath:=DeleteFrontAndBackSpaces (SmtpOutPath);
                   END;

               _P :
                   BEGIN
                        Pop3File:=DeleteFrontAndBackSpaces (Pop3File);
                        Recipient:=DeleteFrontAndBackSpaces (Recipient);
                        Separator:=DeleteFrontAndBackSpaces (Separator);
                        IF (UpCaseString (Separator) = 'FROM') THEN
                           Separator:=Separator+' ';
                        EnvelopeHdr:=DeleteFrontAndBackSpaces (EnvelopeHdr);
                   END;

               _BBS:
                   BEGIN
                        Inbound:=DeleteFrontAndBackSpaces (Inbound);
                        Outbound:=DeleteFrontAndBackSpaces (Outbound);
                        InboundExt:=DeleteFrontAndBackSpaces (InboundExt);
                   END;

           END; { case }
     END; { with }
END;


{--------------------------------------------------------------------------}
{ EditUserBaseRecord                                                       }
{                                                                          }
{ Met deze routine kan de inhoud van het opgegeven record uit de UserBase  }
{ gewijzigd worden. Als de naam gewijzigd is, dan wordt TRUE terug gegeven }
{                                                                          }
FUNCTION EditUserBaseRecord (RecNr : UserBaseRecordNrType) : BOOLEAN;

TYPE Cmp = ARRAY[1..SizeOf (UserBaseRecord)] OF BYTE;

VAR Quit        : BOOLEAN;
    OldUserData : UserBaseRecord;
    Lp          : WORD;

BEGIN
     EditUserBaseRecord:=FALSE;

     EditRecNr:=RecNr; { voor andere routines }
     ReadUserBaseRecord (EditRecNr,UserData);

     OldUserData:=UserData;

     FixUserDataRecord;
     DrawUserBaseRecordScreen;
     FieldUpdateScreen;

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           IF (Key IN [kEsc,kF10]) THEN
           BEGIN
                { Verwijder onnodige spaties uit de UserData records }
                CleanEdittedUserRecord;
                WriteUserBaseRecord (EditRecNr,UserData);
                Quit:=TRUE;
           END;

     UNTIL Quit;

     WindowPop; { UserBaseRecordScreen }

     IF (UserData.System = _F) THEN
     BEGIN
          IF (NOT FidoCompare (UserData.Address,OldUserData.Address)) OR
             (OldUserData.Sysop <> UserData.Sysop)
          THEN
              EditUserBaseRecord:=TRUE; { er is iets gewijzigd }
     END ELSE
         FOR Lp:=1 TO SizeOf (UserBaseRecord) DO
             IF (Cmp (OldUserData)[Lp] <> Cmp (UserData)[Lp]) THEN
             BEGIN
                  EditUserBaseRecord:=TRUE; { er is iets gewijzigd }
                  Break;
             END;
END;


{--------------------------------------------------------------------------}
{ DeleteUserBaseRecord                                                     }
{                                                                          }
{ Met deze routine kan een UserBase record verwijderd worden. Er wordt     }
{ niet om een bevestiging gevraagd hier, omdat er ivm tags meerdere calls  }
{ kunnen zijn. Dat moet de aanroeper dus maar doen. Nadat het record       }
{ verwijderd is wordt HasChangedUser op TRUE gezet, zodat de select lijst  }
{ geupdate kan worden.                                                     }
{                                                                          }
PROCEDURE DeleteUserBaseRecord (RecNr : UserBaseRecordNrType);

VAR UserData : UserBaseRecord;
    AreaData : AreaBaseRecord;
    Search   : SubscrSearchRecord;

BEGIN
     ReadUserBaseRecord (RecNr,UserData);

     REPEAT
           GetFirstAreaUserIsSubscribedTo (UserData.AreaList,Search);

           IF Search.Found THEN
           BEGIN
                RemoveAreaFromUserSubscrToList (UserData,Search.AreaBaseRecordNr);
                ReadAreaBaseRecord (Search.AreaBaseRecordNr,AreaData);
                RemoveUserFromAreaSubscrList (AreaData,RecNr);
                WriteAreaBaseRecord (Search.AreaBaseRecordNr,AreaData);
           END;

     UNTIL (NOT Search.Found);

     UserData.Deleted:=TRUE;
     WriteUserBaseRecord (RecNr,UserData);
END;


{--------------------------------------------------------------------------}
{ CreateNewUserBaseRecord                                                  }
{                                                                          }
{ Met deze routine kan een nieuwe User Database record aangemaakt worden.  }
{ Als er een nieuw user record aangemaakt is wordt TRUE terug gegeven.     }
{                                                                          }
FUNCTION CreateNewUserBaseRecord (Links : BOOLEAN) : UserBaseRecordNrType;

VAR Quit : BOOLEAN;

BEGIN
     CreateNewUserBaseRecord:=0; { gen record aangemaakt }

     IF Links THEN
     BEGIN
          MenuDefine (27,10,'New link type');
          MenuSetHelp (1198);
          MenuAddItem ('BAG supplier link');
          MenuAddItem ('SMTP mailer link');
          MenuAddItem ('POP3 mailbox link');
          MenuAddItem ('BBS Interface link');
          MenuShow;

          CASE MenuSelect OF
               mOpt01 : UserData.System:=_B;  { BAG  }
               mOpt02 : UserData.System:=_S;  { SMTP }
               mOpt03 : UserData.System:=_P;  { POP3 }
               mOpt04 : UserData.System:=_BBS; { BBS Interface }
          END;

     END ELSE
     BEGIN
          MenuDefine (27,10,'New user type');
          MenuSetHelp (1201);
          MenuAddItem ('FTN style user');
          MenuAddItem ('UUCP style user');
          MenuShow;

          CASE MenuSelect OF
               mOpt01 : UserData.System:=_F; { FTN  }
               mOpt02 : UserData.System:=_U; { UUCP }
          END;

     END;

     MenuErase;

     IF (Key = kEsc) THEN
        Exit;

     EmptyUserDataRecord;
{ RvdW 03-04-93 EditRecNr hier al invullen en record naar disk schrijven,
                anders gaat het mis bij het subscriben, want die wil ook
                het UserBase record naar disk schrijven, maar dan is
                EditRecNr nog niet ingevuld.                               }
     EditRecNr:=UserBaseRecCount+1;
     WriteUserBaseRecord (EditRecNr,UserData);
     CreateNewUserBaseRecord:=EditRecNr;

     DrawUserBaseRecordScreen;

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           IF (Key IN [kEsc,kF10]) THEN
           BEGIN
                CleanEdittedUserRecord;
                WriteUserBaseRecord (EditRecNr,UserData);
                Quit:=TRUE;
           END;

     UNTIL Quit;

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ FidoListConvertFunc                                                      }
{                                                                          }
FUNCTION FidoListConvertFunc (Item : STRING) : STRING; FAR;

VAR Addr : FidoAddrType;
    P    : BYTE;

BEGIN
     P:=Pos (' ',Item);
     IF (Item[1] IN ['0'..'9']) AND (Pos ('/',Item) > 0) AND (P > 0) THEN
     BEGIN
          FidoSplit (Copy (Item,1,P-1),Addr);

          IF NOT ((Addr.Zone=0) AND (Addr.Net=0) AND (Addr.Node=0) AND (Addr.Point=0)) THEN
             Item:=AddUpWithPre0s (5,Word2String (Addr.Zone))+':'+
                   AddUpWithPre0s (5,Word2String (Addr.Net))+'/'+
                   AddUpWithPre0s (5,Word2String (Addr.Node))+'.'+
                   AddUpWithPre0s (5,Word2String (Addr.Point))+
                   Copy (Item,P,255);
     END;

     FidoListConvertFunc:=Item;
END;


{--------------------------------------------------------------------------}
{ EditSystems                                                              }
{                                                                          }
{ Van hieruit kunnen de user configs aangepast worden.                     }
{                                                                          }
PROCEDURE EditSystems (Links : BOOLEAN);

VAR Quit    : BOOLEAN;
    Lp      : UserBaseRecordNrType;
    Keuze   : WORD;

    {----------------------------------------------------------------------}
    { AddUserToList                                                        }
    {                                                                      }
    { Deze routine voegt de omschrijving van de user gesorteerd toe aan de }
    { lijst. UserData moet de gegevens bevatten.                           }
    {                                                                      }
    PROCEDURE AddUserToList (Index : WORD);

    VAR Temp1,
        Temp2 : STRING[100];

    BEGIN
         CASE UserData.System OF
              _F: BEGIN
                       Temp1:=Fido2Str (UserData.Address);
                       Temp2:=DeleteBackSpaces (UserData.SysOp);

                       IF (Length (Temp1)+Length (Temp2) > 67) THEN
                          Temp2:=Copy (Temp2,1,64-Length (Temp1))+'...';

                       ListAddItem (Temp1+' ('+Temp2+') ',Index,Convert);
                  END;

              _U :
                  ListAddItem (UserData.UUCPName+' ('+UserData.Organization+') ',Index,Sorted);

              _B :
                  ListAddItem (UserData.Organization+' (BAG supplier link) ',Index,Sorted);

              _S :
                  ListAddItem (UserData.Organization+' (SMTP mailer link) ',Index,Sorted);

              _P :
                  ListAddItem (UserData.Organization+' (POP3 mailbox link) ',Index,Sorted);

              _BBS :
                  ListAddItem (Word2String (UserData.FakeZone)+':'+
                               Word2String (UserData.FakeNet)+'/'+
                               Word2String (UserData.FakeNode)+
                               ' ('+UserData.Organization+') ',Index,Sorted);
         END; { case }
    END;

{ EditSystems }

VAR Systems : SET OF SystemType;

BEGIN
     IF Links THEN
     BEGIN
          Systems:=[_B,_S,_P,_BBS];
          ListDefine (3,3,60,Video.Rows-4,Default,'Configured Links',1197);
     END ELSE
     BEGIN
          Systems:=[_F,_U];
          ListDefine (3,3,60,Video.Rows-4,Default,'Configured Users',1200);
     END;

     ListSetConvertRoutine (FidoListConvertFunc);

     FOR Lp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (Lp,UserData);

          IF (NOT UserData.Deleted) AND (UserData.System IN Systems) THEN
             AddUserToList (Lp);
     END; { lp }

     Quit:=FALSE;
     REPEAT
           IF (ListItemCount = 0) THEN
              IF Links THEN
                 ListAddItem ('<no links configured>',65534,Bottom)
              ELSE
                  ListAddItem ('<no users configured>',65534,Bottom);

           Keuze:=ListSelect (DoTag,[kIns,kDel]);

           ListRemoveItem (65534);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : IF (ListTagCount = 0) THEN
                          IF EditUserBaseRecord (Keuze) THEN
                          BEGIN
                               { update de lijst }
                               ListRemoveItem (Keuze);
                               ReadUserBaseRecord (Keuze,UserData);
                               AddUserToList (Keuze);
                               ListSetCursorOnItem (Keuze);
                          END;

                kDel : BEGIN
                            IF (ListTagCount = 0) THEN
                            BEGIN
                                 IF (Keuze < 65000) AND (AreYouSureWithHelp ('Delete this user?',1202) = mOpt01) THEN
                                 BEGIN
                                      Message ('Unsubscribing areas; Deleting user');
                                      DeleteUserBaseRecord (Keuze);
                                      WindowPop; { message }
                                      ListRemoveItem (Keuze);
                                 END;
                            END ELSE
                                IF (AreYouSureWithHelp ('Delete all tagged users?',1202) = mOpt01) THEN
                                BEGIN
                                     Message ('Deleting users, please wait...');

                                     WHILE (ListTagCount > 0) DO
                                     BEGIN
                                          Keuze:=ListGettaggedItemNr (1);
                                          DeleteUserBaseRecord (Keuze);
                                          ListRemoveItem (Keuze);
                                     END; { while }

                                     WindowPop; { message }
                                END;
                       END; { kDel }

                kIns : BEGIN
                            Keuze:=CreateNewUserBaseRecord (_S IN Systems);

                            IF (Keuze <> 0) THEN
                            BEGIN
                                 ReadUserBaseRecord (Keuze,UserData);
                                 AddUserToList (Keuze);
                                 ListSetCursorOnItem (Keuze);
                            END;
                       END; { kIns }
           END; { case }

     UNTIL Quit;

     ListErase;
END;
{$ENDIF (WtrConf)}

END.

